// lm4f120h4qr.h
// A unified header file for the various registers in the LM4F120H5QR microcontroller.  
// This header file was written with a view to creating simple projects on the stellaris launchpad
// which is now also known as the Tiva™ C Series LaunchPad Evaluation Kit 
// Register definitions and other data from the Stellaris LM4F120H5QR Microcontroller
// datasheet (Reference DS-LM4F120H5QR-SPMS294G)
// Not organized in any particular way, just as I found them useful
// No guarantees or claims of suitability,reliability or safety of any kind are implied or given
// Also include macros for enabling and disabling global interrupts and setting and clearing bits.
// Written by Frank Duignan
// Latest version available from:
// http://eleceng.dit.ie/frank/arm/BareMetalTILM4F/tilm4f120hqr.h
// Changelog: 
// 6/9/2013: development started
// 20/9/2013: First release
// 6/6/2014: Fixed some typos in the GPIO areas
// Define some bitmasks
#define BIT0 (1 << 0)
#define BIT1 (1 << 1)
#define BIT2 (1 << 2)
#define BIT3 (1 << 3)
#define BIT4 (1 << 4)
#define BIT5 (1 << 5)
#define BIT6 (1 << 6)
#define BIT7 (1 << 7)
#define BIT8 (1 << 8)
#define BIT9 (1 << 9)
#define BIT10 (1 << 10)
#define BIT11 (1 << 11)
#define BIT12 (1 << 12)
#define BIT13 (1 << 13)
#define BIT14 (1 << 14)
#define BIT15 (1 << 15)
#define BIT16 (1 << 16)
#define BIT17 (1 << 17)
#define BIT18 (1 << 18)
#define BIT19 (1 << 19)
#define BIT20 (1 << 20)
#define BIT21 (1 << 21)
#define BIT22 (1 << 22)
#define BIT23 (1 << 23)
#define BIT24 (1 << 24)
#define BIT25 (1 << 25)
#define BIT26 (1 << 26)
#define BIT27 (1 << 27)
#define BIT28 (1 << 28)
#define BIT29 (1 << 29)
#define BIT30 (1 << 30)
#define BIT31 (1 << 31)

// clear/set macros 
#define CLEAR_BIT(addr,mask) ((addr) &= ~(mask))
#define SET_BIT(addr,mask) ((addr) |= (mask))
#define XOR_BIT(addr,mask) ((addr) ^= (mask))

// Macros to reduce typing later on
#define  REGISTER_32(ADDRESS) (*((volatile unsigned int *)(ADDRESS)))
#define  REGISTER_16(ADDRESS) (*((volatile unsigned int *)(ADDRESS)))
#define  REGISTER_8(ADDRESS) (*((volatile unsigned char *)(ADDRESS)))

// Macros to enable/disable global interrupts
#define enable_interrupts() asm(" cpsie i ")
#define disable_interrupts() asm(" cpsid i ")

#define WDT0_BASE 		0x40000000
#define WDT1_BASE 		0x40001000
// legacy base addresses for GPIO ports on the APB bus. This file 'favours' the AHB variations of these - see below
#define GPIOA_APB_BASE	0x40004000
#define GPIOB_APB_BASE 	0x40005000
#define GPIOC_APB_BASE 	0x40006000
#define GPIOD_APB_BASE 	0x40007000
#define SSI0_BASE 		0x40008000
#define SSI1_BASE 		0x40009000
#define SSI2_BASE 		0x4000a000
#define SSI3_BASE 		0x4000b000
#define UART0_BASE 		0x4000c000
#define UART1_BASE	 	0x4000d000
#define UART2_BASE	 	0x4000e000
#define UART3_BASE	 	0x4000f000
#define UART4_BASE 		0x40010000
#define UART5_BASE 		0x40011000
#define UART6_BASE 		0x40012000
#define UART7_BASE 		0x40013000
#define I2C0_BASE		0x40020000
#define I2C1_BASE		0x40021000
#define I2C2_BASE		0x40022000
#define I2C3_BASE		0x40023000
// AHB aperture variants preferred - see below
#define GPIOE_APB_BASE	0x40024000
#define GPIOF_APB_BASE	0x40025000
#define TIM0_32_BASE 	0x40030000
#define TIM1_32_BASE 	0x40031000
#define TIM2_32_BASE 	0x40032000
#define TIM3_32_BASE 	0x40033000
#define TIM4_32_BASE 	0x40034000
#define TIM5_32_BASE 	0x40035000
#define TIM0_64_BASE 	0x40036000
#define TIM1_64_BASE 	0x40037000
#define ADC0_BASE		0x40038000
#define ADC1_BASE 		0x40039000
#define ACMP_BASE		0x4003c000
#define CAN0_BASE		0x40040000
#define TIM2_64_BASE 	0x4003c000
#define TIM3_64_BASE 	0x4003d000
#define TIM4_64_BASE 	0x4003e000
#define TIM5_64_BASE 	0x4003f000

#define USB_BASE		0x40050000
#define GPIOA_BASE		0x40058000
#define GPIOB_BASE		0x40059000
#define GPIOC_BASE		0x4005a000
#define GPIOD_BASE		0x4005b000
#define GPIOE_BASE		0x4005c000
#define GPIOF_BASE		0x4005d000

#define EEPROM_BASE 	0x400af000
#define SYSEX_BASE		0x400f9000
#define HIB_BASE		0x400fc000
#define FLASH_BASE 		0x400fd000
#define SYSCTL_BASE		0x400fe000
#define UDMA_BASE		0x400ff000

#define BIT_BAND_BASE	0x42000000

#define ITM_BASE		0xe0000000
#define DWT_BASE		0xe0001000
#define FPB_BASE		0xe0002000
#define SYS_BASE		0xe000e000
#define TPIU_BASE		0xe0040000
#define ETM_BASE		0xe0041000

// Offsets for Watchdog timers
#define WDTLOAD	  	 	0x0000
#define WDTVALUE	  	0x0004
#define WDTCTL		  	0x0008
#define WDTICR			0x000c
#define WDTRIS			0x0010
#define WDTMIS			0x0014
#define WDTTEST			0x0418
#define WDTLOCK			0x0c00
#define WDTPeriphID4 	0x0fd0
#define WDTPeriphID5 	0x0fd4
#define WDTPeriphID6 	0x0fd8
#define WDTPeriphID7 	0x0fdc
#define WDTPeriphID0	0x0fe0
#define WDTPeriphID1 	0x0fe4
#define WDTPeriphID2 	0x0fe8
#define WDTPeriphID3 	0x0fec
#define WDTPCellID0 	0x0ff0
#define WDTPCellID1 	0x0ff4
#define WDTPCellID2 	0x0ff8
#define WDTPCellID3 	0x0ffc

// Watchdog timer 0
#define WDT0LOAD	  	REGISTER_32(WDT0_BASE + WDTLOAD)
#define WDT0VALUE	  	REGISTER_32(WDT0_BASE + WDTVALUE)
#define WDT0CTL		  	REGISTER_32(WDT0_BASE + WDTCTL)
#define WDT0ICR			REGISTER_32(WDT0_BASE + WDTICR)
#define WDT0RIS			REGISTER_32(WDT0_BASE + WDTRIS)
#define WDT0MIS			REGISTER_32(WDT0_BASE + WDTMIS)
#define WDT0TEST		REGISTER_32(WDT0_BASE + WDTTEST)
#define WDT0LOCK		REGISTER_32(WDT0_BASE + WDTLOCK)
#define WDT0PeriphID4 	REGISTER_32(WDT0_BASE + WDTPeriphID4)
#define WDT0PeriphID5 	REGISTER_32(WDT0_BASE + WDTPeriphID5)
#define WDT0PeriphID6 	REGISTER_32(WDT0_BASE + WDTPeriphID6)
#define WDT0PeriphID7 	REGISTER_32(WDT0_BASE + WDTPeriphID7)
#define WDT0PeriphID0	REGISTER_32(WDT0_BASE + WDTPeriphID0)
#define WDT0PeriphID1 	REGISTER_32(WDT0_BASE + WDTPeriphID1)
#define WDT0PeriphID2 	REGISTER_32(WDT0_BASE + WDTPeriphID2)
#define WDT0PeriphID3 	REGISTER_32(WDT0_BASE + WDTPeriphID3)
#define WDT0PCellID0 	REGISTER_32(WDT0_BASE + WDTPCellID0)
#define WDT0PCellID1 	REGISTER_32(WDT0_BASE + WDTPCellID1)
#define WDT0PCellID2 	REGISTER_32(WDT0_BASE + WDTPCellID2)
#define WDT0PCellID3 	REGISTER_32(WDT0_BASE + WDTPCellID3)

// Watchdog timer 1
#define WDT1LOAD	  	REGISTER_32(WDT1_BASE + WDTLOAD)
#define WDT1VALUE	  	REGISTER_32(WDT1_BASE + WDTVALUE)
#define WDT1CTL		  	REGISTER_32(WDT1_BASE + WDTCTL)
#define WDT1ICR			REGISTER_32(WDT1_BASE + WDTICR)
#define WDT1RIS			REGISTER_32(WDT1_BASE + WDTRIS)
#define WDT1MIS			REGISTER_32(WDT1_BASE + WDTMIS)
#define WDT1TEST		REGISTER_32(WDT1_BASE + WDTTEST)
#define WDT1LOCK		REGISTER_32(WDT1_BASE + WDTLOCK)
#define WDT1PeriphID4 	REGISTER_32(WDT1_BASE + WDTPeriphID4)
#define WDT1PeriphID5 	REGISTER_32(WDT1_BASE + WDTPeriphID5)
#define WDT1PeriphID6 	REGISTER_32(WDT1_BASE + WDTPeriphID6)
#define WDT1PeriphID7 	REGISTER_32(WDT1_BASE + WDTPeriphID7)
#define WDT1PeriphID0	REGISTER_32(WDT1_BASE + WDTPeriphID0)
#define WDT1PeriphID1 	REGISTER_32(WDT1_BASE + WDTPeriphID1)
#define WDT1PeriphID2 	REGISTER_32(WDT1_BASE + WDTPeriphID2)
#define WDT1PeriphID3 	REGISTER_32(WDT1_BASE + WDTPeriphID3)
#define WDT1PCellID0 	REGISTER_32(WDT1_BASE + WDTPCellID0)
#define WDT1PCellID1 	REGISTER_32(WDT1_BASE + WDTPCellID1)
#define WDT1PCellID2 	REGISTER_32(WDT1_BASE + WDTPCellID2)
#define WDT1PCellID3 	REGISTER_32(WDT1_BASE + WDTPCellID3)

// GPIOS: Offsets
#define GPIODATA		0x03fc
#define GPIODIR			0x0400
#define GPIOIS			0x0404
#define GPIOIBE			0x0408
#define GPIOIEV			0x040c
#define GPIOIM			0x0410
#define GPIORIS			0x0414
#define GPIOMIS			0x0418
#define GPIOICR			0x041c
#define GPIOAFSEL		0x0420
#define GPIODR2R		0x0500
#define GPIODR4R		0x0504
#define GPIODR8R		0x0508
#define GPIOODR			0x050c
#define GPIOPUR			0x0510
#define GPIOPDR			0x0514
#define GPIOSLR			0x0518
#define GPIODEN			0x051c
#define GPIOLOCK		0x0520
#define GPIOCR			0x0524
#define GPIOAMSEL		0x0528
#define GPIOPCTL		0x052c
#define GPIOADCCTL		0x0530
#define GPIODMACTL		0x0534
#define GPIOPeriphID4	0x05d0
#define GPIOPeriphID5	0x05d4
#define GPIOPeriphID6	0x05d8
#define GPIOPeriphID7	0x05dc
#define GPIOPeriphID0	0x05e0
#define GPIOPeriphID1	0x05e4
#define GPIOPeriphID2	0x05e8
#define GPIOPeriphID3	0x05ec
#define GPIOPCellID0	0x05f0
#define GPIOPCellID1	0x05f4
#define GPIOPCellID2	0x05f8
#define GPIOPCellID3	0x05fc


// GPIO_A: Using the AHB aperture GPIOs (faster)
#define GPIOA_DATA		REGISTER_32(GPIOA_BASE + GPIODATA)
#define GPIOA_DIR		REGISTER_32(GPIOA_BASE + GPIODIR)
#define GPIOA_IS		REGISTER_32(GPIOA_BASE + GPIOIS)
#define GPIOA_IBE		REGISTER_32(GPIOA_BASE + GPIOIBE)
#define GPIOA_IEV		REGISTER_32(GPIOA_BASE + GPIOIEV)
#define GPIOA_IM		REGISTER_32(GPIOA_BASE + GPIOIM)
#define GPIOA_RIS		REGISTER_32(GPIOA_BASE + GPIORIS)
#define GPIOA_MIS		REGISTER_32(GPIOA_BASE + GPIOMIS)
#define GPIOA_ICR		REGISTER_32(GPIOA_BASE + GPIOICR)
#define GPIOA_AFSEL		REGISTER_32(GPIOA_BASE + GPIOAFSEL)
#define GPIOA_DR2R		REGISTER_32(GPIOA_BASE + GPIODR2R)
#define GPIOA_DR4R		REGISTER_32(GPIOA_BASE + GPIODR4R)
#define GPIOA_DR8R		REGISTER_32(GPIOA_BASE + GPIODR8R)
#define GPIOA_ODR		REGISTER_32(GPIOA_BASE + GPIOODR)
#define GPIOA_PUR		REGISTER_32(GPIOA_BASE + GPIOPUR)
#define GPIOA_PDR		REGISTER_32(GPIOA_BASE + GPIOPDR)
#define GPIOA_SLR		REGISTER_32(GPIOA_BASE + GPIOSLR)
#define GPIOA_DEN		REGISTER_32(GPIOA_BASE + GPIODEN)
#define GPIOA_LOCK		REGISTER_32(GPIOA_BASE + GPIOLOCK)
#define GPIOA_CR		REGISTER_32(GPIOA_BASE + GPIOCR)
#define GPIOA_AMSEL		REGISTER_32(GPIOA_BASE + GPIOAMSEL)
#define GPIOA_PCTL		REGISTER_32(GPIOA_BASE + GPIOPCTL)
#define GPIOA_ADCCTL	REGISTER_32(GPIOA_BASE + GPIOADCCTL)
#define GPIOA_DMACTL	REGISTER_32(GPIOA_BASE + GPIODMACTL)
#define GPIOA_PeriphID4	REGISTER_32(GPIOA_BASE + GPIOPeriphID4)
#define GPIOA_PeriphID5	REGISTER_32(GPIOA_BASE + GPIOPeriphID5)
#define GPIOA_PeriphID6	REGISTER_32(GPIOA_BASE + GPIOPeriphID6)
#define GPIOA_PeriphID7	REGISTER_32(GPIOA_BASE + GPIOPeriphID7)
#define GPIOA_PeriphID0	REGISTER_32(GPIOA_BASE + GPIOPeriphID0)
#define GPIOA_PeriphID1	REGISTER_32(GPIOA_BASE + GPIOPeriphID1)
#define GPIOA_PeriphID2	REGISTER_32(GPIOA_BASE + GPIOPeriphID2)
#define GPIOA_PeriphID3	REGISTER_32(GPIOA_BASE + GPIOPeriphID3)
#define GPIOA_PCellID0	REGISTER_32(GPIOA_BASE + GPIOPCellID0)
#define GPIOA_PCellID1	REGISTER_32(GPIOA_BASE + GPIOPCellID1)
#define GPIOA_PCellID2	REGISTER_32(GPIOA_BASE + GPIOPCellID2)
#define GPIOA_PCellID3	REGISTER_32(GPIOA_BASE + GPIOPCellID3)

// GPIOB

#define GPIOB_DATA		REGISTER_32(GPIOB_BASE + GPIODATA)
#define GPIOB_DIR		REGISTER_32(GPIOB_BASE + GPIODIR)
#define GPIOB_IS		REGISTER_32(GPIOB_BASE + GPIOIS)
#define GPIOB_IBE		REGISTER_32(GPIOB_BASE + GPIOIBE)
#define GPIOB_IEV		REGISTER_32(GPIOB_BASE + GPIOIEV)
#define GPIOB_IM		REGISTER_32(GPIOB_BASE + GPIOIM)
#define GPIOB_RIS		REGISTER_32(GPIOB_BASE + GPIORIS)
#define GPIOB_MIS		REGISTER_32(GPIOB_BASE + GPIOMIS)
#define GPIOB_ICR		REGISTER_32(GPIOB_BASE + GPIOICR)
#define GPIOB_AFSEL		REGISTER_32(GPIOB_BASE + GPIOAFSEL)
#define GPIOB_DR2R		REGISTER_32(GPIOB_BASE + GPIODR2R)
#define GPIOB_DR4R		REGISTER_32(GPIOB_BASE + GPIODR4R)
#define GPIOB_DR8R		REGISTER_32(GPIOB_BASE + GPIODR8R)
#define GPIOB_ODR		REGISTER_32(GPIOB_BASE + GPIOODR)
#define GPIOB_PUR		REGISTER_32(GPIOB_BASE + GPIOPUR)
#define GPIOB_PDR		REGISTER_32(GPIOB_BASE + GPIOPDR)
#define GPIOB_SLR		REGISTER_32(GPIOB_BASE + GPIOSLR)
#define GPIOB_DEN		REGISTER_32(GPIOB_BASE + GPIODEN)
#define GPIOB_LOCK		REGISTER_32(GPIOB_BASE + GPIOLOCK)
#define GPIOB_CR		REGISTER_32(GPIOB_BASE + GPIOCR)
#define GPIOB_AMSEL		REGISTER_32(GPIOB_BASE + GPIOBMSEL)
#define GPIOB_PCTL		REGISTER_32(GPIOB_BASE + GPIOPCTL)
#define GPIOB_ADCCTL	REGISTER_32(GPIOB_BASE + GPIOBDCCTL)
#define GPIOB_DMACTL	REGISTER_32(GPIOB_BASE + GPIODMACTL)
#define GPIOB_PeriphID4	REGISTER_32(GPIOB_BASE + GPIOPeriphID4)
#define GPIOB_PeriphID5	REGISTER_32(GPIOB_BASE + GPIOPeriphID5)
#define GPIOB_PeriphID6	REGISTER_32(GPIOB_BASE + GPIOPeriphID6)
#define GPIOB_PeriphID7	REGISTER_32(GPIOB_BASE + GPIOPeriphID7)
#define GPIOB_PeriphID0	REGISTER_32(GPIOB_BASE + GPIOPeriphID0)
#define GPIOB_PeriphID1	REGISTER_32(GPIOB_BASE + GPIOPeriphID1)
#define GPIOB_PeriphID2	REGISTER_32(GPIOB_BASE + GPIOPeriphID2)
#define GPIOB_PeriphID3	REGISTER_32(GPIOB_BASE + GPIOPeriphID3)
#define GPIOB_PCellID0	REGISTER_32(GPIOB_BASE + GPIOPCellID0)
#define GPIOB_PCellID1	REGISTER_32(GPIOB_BASE + GPIOPCellID1)
#define GPIOB_PCellID2	REGISTER_32(GPIOB_BASE + GPIOPCellID2)
#define GPIOB_PCellID3	REGISTER_32(GPIOB_BASE + GPIOPCellID3)

// GPIOC 

#define GPIOC_DATA		REGISTER_32(GPIOC_BASE + GPIODATA)
#define GPIOC_DIR		REGISTER_32(GPIOC_BASE + GPIODIR)
#define GPIOC_IS		REGISTER_32(GPIOC_BASE + GPIOIS)
#define GPIOC_IBE		REGISTER_32(GPIOC_BASE + GPIOIBE)
#define GPIOC_IEV		REGISTER_32(GPIOC_BASE + GPIOIEV)
#define GPIOC_IM		REGISTER_32(GPIOC_BASE + GPIOIM)
#define GPIOC_RIS		REGISTER_32(GPIOC_BASE + GPIORIS)
#define GPIOC_MIS		REGISTER_32(GPIOC_BASE + GPIOMIS)
#define GPIOC_ICR		REGISTER_32(GPIOC_BASE + GPIOICR)
#define GPIOC_AFSEL		REGISTER_32(GPIOC_BASE + GPIOAFSEL)
#define GPIOC_DR2R		REGISTER_32(GPIOC_BASE + GPIODR2R)
#define GPIOC_DR4R		REGISTER_32(GPIOC_BASE + GPIODR4R)
#define GPIOC_DR8R		REGISTER_32(GPIOC_BASE + GPIODR8R)
#define GPIOC_ODR		REGISTER_32(GPIOC_BASE + GPIOODR)
#define GPIOC_PUR		REGISTER_32(GPIOC_BASE + GPIOPUR)
#define GPIOC_PDR		REGISTER_32(GPIOC_BASE + GPIOPDR)
#define GPIOC_SLR		REGISTER_32(GPIOC_BASE + GPIOSLR)
#define GPIOC_DEN		REGISTER_32(GPIOC_BASE + GPIODEN)
#define GPIOC_LOCK		REGISTER_32(GPIOC_BASE + GPIOLOCK)
#define GPIOC_CR		REGISTER_32(GPIOC_BASE + GPIOCR)
#define GPIOC_AMSEL		REGISTER_32(GPIOC_BASE + GPIOCMSEL)
#define GPIOC_PCTL		REGISTER_32(GPIOC_BASE + GPIOPCTL)
#define GPIOC_ADCCTL	REGISTER_32(GPIOC_BASE + GPIOCDCCTL)
#define GPIOC_DMACTL	REGISTER_32(GPIOC_BASE + GPIODMACTL)
#define GPIOC_PeriphID4	REGISTER_32(GPIOC_BASE + GPIOPeriphID4)
#define GPIOC_PeriphID5	REGISTER_32(GPIOC_BASE + GPIOPeriphID5)
#define GPIOC_PeriphID6	REGISTER_32(GPIOC_BASE + GPIOPeriphID6)
#define GPIOC_PeriphID7	REGISTER_32(GPIOC_BASE + GPIOPeriphID7)
#define GPIOC_PeriphID0	REGISTER_32(GPIOC_BASE + GPIOPeriphID0)
#define GPIOC_PeriphID1	REGISTER_32(GPIOC_BASE + GPIOPeriphID1)
#define GPIOC_PeriphID2	REGISTER_32(GPIOC_BASE + GPIOPeriphID2)
#define GPIOC_PeriphID3	REGISTER_32(GPIOC_BASE + GPIOPeriphID3)
#define GPIOC_PCellID0	REGISTER_32(GPIOC_BASE + GPIOPCellID0)
#define GPIOC_PCellID1	REGISTER_32(GPIOC_BASE + GPIOPCellID1)
#define GPIOC_PCellID2	REGISTER_32(GPIOC_BASE + GPIOPCellID2)
#define GPIOC_PCellID3	REGISTER_32(GPIOC_BASE + GPIOPCellID3)

// GPIOD

#define GPIOD_DATA		REGISTER_32(GPIOD_BASE + GPIODATA)
#define GPIOD_DIR		REGISTER_32(GPIOD_BASE + GPIODIR)
#define GPIOD_IS		REGISTER_32(GPIOD_BASE + GPIOIS)
#define GPIOD_IBE		REGISTER_32(GPIOD_BASE + GPIOIBE)
#define GPIOD_IEV		REGISTER_32(GPIOD_BASE + GPIOIEV)
#define GPIOD_IM		REGISTER_32(GPIOD_BASE + GPIOIM)
#define GPIOD_RIS		REGISTER_32(GPIOD_BASE + GPIORIS)
#define GPIOD_MIS		REGISTER_32(GPIOD_BASE + GPIOMIS)
#define GPIOD_ICR		REGISTER_32(GPIOD_BASE + GPIOICR)
#define GPIOD_AFSEL		REGISTER_32(GPIOD_BASE + GPIOAFSEL)
#define GPIOD_DR2R		REGISTER_32(GPIOD_BASE + GPIODR2R)
#define GPIOD_DR4R		REGISTER_32(GPIOD_BASE + GPIODR4R)
#define GPIOD_DR8R		REGISTER_32(GPIOD_BASE + GPIODR8R)
#define GPIOD_ODR		REGISTER_32(GPIOD_BASE + GPIOODR)
#define GPIOD_PUR		REGISTER_32(GPIOD_BASE + GPIOPUR)
#define GPIOD_PDR		REGISTER_32(GPIOD_BASE + GPIOPDR)
#define GPIOD_SLR		REGISTER_32(GPIOD_BASE + GPIOSLR)
#define GPIOD_DEN		REGISTER_32(GPIOD_BASE + GPIODEN)
#define GPIOD_LOCK		REGISTER_32(GPIOD_BASE + GPIOLOCK)
#define GPIOD_CR		REGISTER_32(GPIOD_BASE + GPIOCR)
#define GPIOD_AMSEL		REGISTER_32(GPIOD_BASE + GPIODMSEL)
#define GPIOD_PCTL		REGISTER_32(GPIOD_BASE + GPIOPCTL)
#define GPIOD_ADCCTL	REGISTER_32(GPIOD_BASE + GPIODDCCTL)
#define GPIOD_DMACTL	REGISTER_32(GPIOD_BASE + GPIODMACTL)
#define GPIOD_PeriphID4	REGISTER_32(GPIOD_BASE + GPIOPeriphID4)
#define GPIOD_PeriphID5	REGISTER_32(GPIOD_BASE + GPIOPeriphID5)
#define GPIOD_PeriphID6	REGISTER_32(GPIOD_BASE + GPIOPeriphID6)
#define GPIOD_PeriphID7	REGISTER_32(GPIOD_BASE + GPIOPeriphID7)
#define GPIOD_PeriphID0	REGISTER_32(GPIOD_BASE + GPIOPeriphID0)
#define GPIOD_PeriphID1	REGISTER_32(GPIOD_BASE + GPIOPeriphID1)
#define GPIOD_PeriphID2	REGISTER_32(GPIOD_BASE + GPIOPeriphID2)
#define GPIOD_PeriphID3	REGISTER_32(GPIOD_BASE + GPIOPeriphID3)
#define GPIOD_PCellID0	REGISTER_32(GPIOD_BASE + GPIOPCellID0)
#define GPIOD_PCellID1	REGISTER_32(GPIOD_BASE + GPIOPCellID1)
#define GPIOD_PCellID2	REGISTER_32(GPIOD_BASE + GPIOPCellID2)
#define GPIOD_PCellID3	REGISTER_32(GPIOD_BASE + GPIOPCellID3)

// GPIOE

#define GPIOE_DATA		REGISTER_32(GPIOE_BASE + GPIODATA)
#define GPIOE_DIR		REGISTER_32(GPIOE_BASE + GPIODIR)
#define GPIOE_IS		REGISTER_32(GPIOE_BASE + GPIOIS)
#define GPIOE_IBE		REGISTER_32(GPIOE_BASE + GPIOIBE)
#define GPIOE_IEV		REGISTER_32(GPIOE_BASE + GPIOIEV)
#define GPIOE_IM		REGISTER_32(GPIOE_BASE + GPIOIM)
#define GPIOE_RIS		REGISTER_32(GPIOE_BASE + GPIORIS)
#define GPIOE_MIS		REGISTER_32(GPIOE_BASE + GPIOMIS)
#define GPIOE_ICR		REGISTER_32(GPIOE_BASE + GPIOICR)
#define GPIOE_AFSEL		REGISTER_32(GPIOE_BASE + GPIOAFSEL)
#define GPIOE_DR2R		REGISTER_32(GPIOE_BASE + GPIODR2R)
#define GPIOE_DR4R		REGISTER_32(GPIOE_BASE + GPIODR4R)
#define GPIOE_DR8R		REGISTER_32(GPIOE_BASE + GPIODR8R)
#define GPIOE_ODR		REGISTER_32(GPIOE_BASE + GPIOODR)
#define GPIOE_PUR		REGISTER_32(GPIOE_BASE + GPIOPUR)
#define GPIOE_PDR		REGISTER_32(GPIOE_BASE + GPIOPDR)
#define GPIOE_SLR		REGISTER_32(GPIOE_BASE + GPIOSLR)
#define GPIOE_DEN		REGISTER_32(GPIOE_BASE + GPIODEN)
#define GPIOE_LOCK		REGISTER_32(GPIOE_BASE + GPIOLOCK)
#define GPIOE_CR		REGISTER_32(GPIOE_BASE + GPIOCR)
#define GPIOE_AMSEL		REGISTER_32(GPIOE_BASE + GPIODMSEL)
#define GPIOE_PCTL		REGISTER_32(GPIOE_BASE + GPIOPCTL)
#define GPIOE_ADCCTL	REGISTER_32(GPIOE_BASE + GPIODDCCTL)
#define GPIOE_DMACTL	REGISTER_32(GPIOE_BASE + GPIODMACTL)
#define GPIOE_PeriphID4	REGISTER_32(GPIOE_BASE + GPIOPeriphID4)
#define GPIOE_PeriphID5	REGISTER_32(GPIOE_BASE + GPIOPeriphID5)
#define GPIOE_PeriphID6	REGISTER_32(GPIOE_BASE + GPIOPeriphID6)
#define GPIOE_PeriphID7	REGISTER_32(GPIOE_BASE + GPIOPeriphID7)
#define GPIOE_PeriphID0	REGISTER_32(GPIOE_BASE + GPIOPeriphID0)
#define GPIOE_PeriphID1	REGISTER_32(GPIOE_BASE + GPIOPeriphID1)
#define GPIOE_PeriphID2	REGISTER_32(GPIOE_BASE + GPIOPeriphID2)
#define GPIOE_PeriphID3	REGISTER_32(GPIOE_BASE + GPIOPeriphID3)
#define GPIOE_PCellID0	REGISTER_32(GPIOE_BASE + GPIOPCellID0)
#define GPIOE_PCellID1	REGISTER_32(GPIOE_BASE + GPIOPCellID1)
#define GPIOE_PCellID2	REGISTER_32(GPIOE_BASE + GPIOPCellID2)
#define GPIOE_PCellID3	REGISTER_32(GPIOE_BASE + GPIOPCellID3)

// GPIOF

#define GPIOF_DATA		REGISTER_32(GPIOF_BASE + GPIODATA)
#define GPIOF_DIR		REGISTER_32(GPIOF_BASE + GPIODIR)
#define GPIOF_IS		REGISTER_32(GPIOF_BASE + GPIOIS)
#define GPIOF_IBE		REGISTER_32(GPIOF_BASE + GPIOIBE)
#define GPIOF_IEV		REGISTER_32(GPIOF_BASE + GPIOIEV)
#define GPIOF_IM		REGISTER_32(GPIOF_BASE + GPIOIM)
#define GPIOF_RIS		REGISTER_32(GPIOF_BASE + GPIORIS)
#define GPIOF_MIS		REGISTER_32(GPIOF_BASE + GPIOMIS)
#define GPIOF_ICR		REGISTER_32(GPIOF_BASE + GPIOICR)
#define GPIOF_AFSEL		REGISTER_32(GPIOF_BASE + GPIOAFSEL)
#define GPIOF_DR2R		REGISTER_32(GPIOF_BASE + GPIODR2R)
#define GPIOF_DR4R		REGISTER_32(GPIOF_BASE + GPIODR4R)
#define GPIOF_DR8R		REGISTER_32(GPIOF_BASE + GPIODR8R)
#define GPIOF_ODR		REGISTER_32(GPIOF_BASE + GPIOODR)
#define GPIOF_PUR		REGISTER_32(GPIOF_BASE + GPIOPUR)
#define GPIOF_PDR		REGISTER_32(GPIOF_BASE + GPIOPDR)
#define GPIOF_SLR		REGISTER_32(GPIOF_BASE + GPIOSLR)
#define GPIOF_DEN		REGISTER_32(GPIOF_BASE + GPIODEN)
#define GPIOF_LOCK		REGISTER_32(GPIOF_BASE + GPIOLOCK)
#define GPIOF_CR		REGISTER_32(GPIOF_BASE + GPIOCR)
#define GPIOF_AMSEL		REGISTER_32(GPIOF_BASE + GPIODMSEL)
#define GPIOF_PCTL		REGISTER_32(GPIOF_BASE + GPIOPCTL)
#define GPIOF_ADCCTL	REGISTER_32(GPIOF_BASE + GPIODDCCTL)
#define GPIOF_DMACTL	REGISTER_32(GPIOF_BASE + GPIODMACTL)
#define GPIOF_PeriphID4	REGISTER_32(GPIOF_BASE + GPIOPeriphID4)
#define GPIOF_PeriphID5	REGISTER_32(GPIOF_BASE + GPIOPeriphID5)
#define GPIOF_PeriphID6	REGISTER_32(GPIOF_BASE + GPIOPeriphID6)
#define GPIOF_PeriphID7	REGISTER_32(GPIOF_BASE + GPIOPeriphID7)
#define GPIOF_PeriphID0	REGISTER_32(GPIOF_BASE + GPIOPeriphID0)
#define GPIOF_PeriphID1	REGISTER_32(GPIOF_BASE + GPIOPeriphID1)
#define GPIOF_PeriphID2	REGISTER_32(GPIOF_BASE + GPIOPeriphID2)
#define GPIOF_PeriphID3	REGISTER_32(GPIOF_BASE + GPIOPeriphID3)
#define GPIOF_PCellID0	REGISTER_32(GPIOF_BASE + GPIOPCellID0)
#define GPIOF_PCellID1	REGISTER_32(GPIOF_BASE + GPIOPCellID1)
#define GPIOF_PCellID2	REGISTER_32(GPIOF_BASE + GPIOPCellID2)
#define GPIOF_PCellID3	REGISTER_32(GPIOF_BASE + GPIOPCellID3)

// Synchonous Serial Interface (SSI)
// SSI Offsets
#define SSICR0			0x0000
#define SSICR1			0x0004
#define SSIDR			0x0008
#define SSISR			0x000c
#define SSICPSR			0x0010
#define SSIIM			0x0014
#define SSIRIS			0x0018
#define SSIMIS			0x001c
#define SSIICR			0x0020
#define SSIDMACTL		0x0024
#define SSICC			0x0fc8
#define SSIPeriphID4	0x0fd0
#define SSIPeriphID5	0x0fd4
#define SSIPeriphID6	0x0fd8
#define SSIPeriphID7	0x0fdc
#define SSIPeriphID0	0x0fe0
#define SSIPeriphID1	0x0fe4
#define SSIPeriphID2	0x0fe8
#define SSIPeriphID3	0x0fec
#define SSIPCellID0		0x0ff0
#define SSIPCellID1		0x0ff4
#define SSIPCellID2		0x0ff8
#define SSIPCellID3		0x0ffc



// SSI0
#define SSI0_CR0			REGISTER_32(SSI0_BASE + SSICR0)
#define SSI0_CR1			REGISTER_32(SSI0_BASE + SSICR1)
#define SSI0_DR				REGISTER_32(SSI0_BASE + SSIDR)
#define SSI0_SR				REGISTER_32(SSI0_BASE + SSISR)
#define SSI0_CPSR			REGISTER_32(SSI0_BASE + SSICPSR)
#define SSI0_IM				REGISTER_32(SSI0_BASE + SSIIM)
#define SSI0_RIS			REGISTER_32(SSI0_BASE + SSIRIS)
#define SSI0_MIS			REGISTER_32(SSI0_BASE + SSIMIS)
#define SSI0_ICR			REGISTER_32(SSI0_BASE + SSIICR)
#define SSI0_DMACTL			REGISTER_32(SSI0_BASE + SSIDMACTL)
#define SSI0_CC				REGISTER_32(SSI0_BASE + SSICC)
#define SSI0_PeriphID4		REGISTER_32(SSI0_BASE + SSIPeriphID4)
#define SSI0_PeriphID5		REGISTER_32(SSI0_BASE + SSIPeriphID5)
#define SSI0_PeriphID6		REGISTER_32(SSI0_BASE + SSIPeriphID6)
#define SSI0_PeriphID7		REGISTER_32(SSI0_BASE + SSIPeriphID7)
#define SSI0_PeriphID0		REGISTER_32(SSI0_BASE + SSIPeriphID0)
#define SSI0_PeriphID1		REGISTER_32(SSI0_BASE + SSIPeriphID1)
#define SSI0_PeriphID2		REGISTER_32(SSI0_BASE + SSIPeriphID2)
#define SSI0_PeriphID3		REGISTER_32(SSI0_BASE + SSIPeriphID3)
#define SSI0_PCellID0		REGISTER_32(SSI0_BASE + SSIPCellID0)
#define SSI0_PCellID1		REGISTER_32(SSI0_BASE + SSIPCellID1)
#define SSI0_PCellID2		REGISTER_32(SSI0_BASE + SSIPCellID2)
#define SSI0_PCellID3		REGISTER_32(SSI0_BASE + SSIPCellID3)

// SSI1
#define SSI1_CR0			REGISTER_32(SSI1_BASE + SSICR0)
#define SSI1_CR1			REGISTER_32(SSI1_BASE + SSICR1)
#define SSI1_DR				REGISTER_32(SSI1_BASE + SSIDR)
#define SSI1_SR				REGISTER_32(SSI1_BASE + SSISR)
#define SSI1_CPSR			REGISTER_32(SSI1_BASE + SSICPSR)
#define SSI1_IM				REGISTER_32(SSI1_BASE + SSIIM)
#define SSI1_RIS			REGISTER_32(SSI1_BASE + SSIRIS)
#define SSI1_MIS			REGISTER_32(SSI1_BASE + SSIMIS)
#define SSI1_ICR			REGISTER_32(SSI1_BASE + SSIICR)
#define SSI1_DMACTL			REGISTER_32(SSI1_BASE + SSIDMACTL)
#define SSI1_CC				REGISTER_32(SSI1_BASE + SSICC)
#define SSI1_PeriphID4		REGISTER_32(SSI1_BASE + SSIPeriphID4)
#define SSI1_PeriphID5		REGISTER_32(SSI1_BASE + SSIPeriphID5)
#define SSI1_PeriphID6		REGISTER_32(SSI1_BASE + SSIPeriphID6)
#define SSI1_PeriphID7		REGISTER_32(SSI1_BASE + SSIPeriphID7)
#define SSI1_PeriphID0		REGISTER_32(SSI1_BASE + SSIPeriphID0)
#define SSI1_PeriphID1		REGISTER_32(SSI1_BASE + SSIPeriphID1)
#define SSI1_PeriphID2		REGISTER_32(SSI1_BASE + SSIPeriphID2)
#define SSI1_PeriphID3		REGISTER_32(SSI1_BASE + SSIPeriphID3)
#define SSI1_PCellID0		REGISTER_32(SSI1_BASE + SSIPCellID0)
#define SSI1_PCellID1		REGISTER_32(SSI1_BASE + SSIPCellID1)
#define SSI1_PCellID2		REGISTER_32(SSI1_BASE + SSIPCellID2)
#define SSI1_PCellID3		REGISTER_32(SSI1_BASE + SSIPCellID3)

// SSI2
#define SSI2_CR0			REGISTER_32(SSI2_BASE + SSICR0)
#define SSI2_CR1			REGISTER_32(SSI2_BASE + SSICR1)
#define SSI2_DR				REGISTER_32(SSI2_BASE + SSIDR)
#define SSI2_SR				REGISTER_32(SSI2_BASE + SSISR)
#define SSI2_CPSR			REGISTER_32(SSI2_BASE + SSICPSR)
#define SSI2_IM				REGISTER_32(SSI2_BASE + SSIIM)
#define SSI2_RIS			REGISTER_32(SSI2_BASE + SSIRIS)
#define SSI2_MIS			REGISTER_32(SSI2_BASE + SSIMIS)
#define SSI2_ICR			REGISTER_32(SSI2_BASE + SSIICR)
#define SSI2_DMACTL			REGISTER_32(SSI2_BASE + SSIDMACTL)
#define SSI2_CC				REGISTER_32(SSI2_BASE + SSICC)
#define SSI2_PeriphID4		REGISTER_32(SSI2_BASE + SSIPeriphID4)
#define SSI2_PeriphID5		REGISTER_32(SSI2_BASE + SSIPeriphID5)
#define SSI2_PeriphID6		REGISTER_32(SSI2_BASE + SSIPeriphID6)
#define SSI2_PeriphID7		REGISTER_32(SSI2_BASE + SSIPeriphID7)
#define SSI2_PeriphID0		REGISTER_32(SSI2_BASE + SSIPeriphID0)
#define SSI2_PeriphID1		REGISTER_32(SSI2_BASE + SSIPeriphID1)
#define SSI2_PeriphID2		REGISTER_32(SSI2_BASE + SSIPeriphID2)
#define SSI2_PeriphID3		REGISTER_32(SSI2_BASE + SSIPeriphID3)
#define SSI2_PCellID0		REGISTER_32(SSI2_BASE + SSIPCellID0)
#define SSI2_PCellID1		REGISTER_32(SSI2_BASE + SSIPCellID1)
#define SSI2_PCellID2		REGISTER_32(SSI2_BASE + SSIPCellID2)
#define SSI2_PCellID3		REGISTER_32(SSI2_BASE + SSIPCellID3)

// UARTS
// UART OFFSETS

#define UARTDR			0x0000
#define UARTRSR			0x0004
#define UARTECR			0x0004
#define UARTFR			0x0018
#define UARTILPR		0x0020
#define UARTIBRD		0X0024
#define UARTFBRD		0x0028
#define UARTLCRH		0x002c
#define UARTCTL			0x0030
#define UARTIFLS		0x0034
#define UARTIM			0x0038
#define UARTRIS			0x003c
#define UARTMIS			0x0040
#define UARTICR			0x0044
#define UARTDMACTL		0x0048
#define UART9BITADDR	0x00a4
#define UART9BITAMASK	0x00a8
#define UARTPP			0x0fc0
#define UARTCC			0x0fc8
#define UARTPeriphID4	0x0fd0
#define UARTPeriphID5	0x0fd4
#define UARTPeriphID6	0x0fd8
#define UARTPeriphID7	0x0fdc
#define UARTPeriphID0	0x0fe0
#define UARTPeriphID1	0x0fe4
#define UARTPeriphID2	0x0fe8
#define UARTPeriphID3	0x0fec
#define UARTPCellID0	0x0ff0
#define UARTPCellID1	0x0ff4
#define UARTPCellID2	0x0ff8
#define UARTPCellID3	0x0ffc


// UART 0
#define UART0_DR			REGISTER_32(UART0_BASE+UARTDR)
#define UART0_RSR			REGISTER_32(UART0_BASE+UARTRSR)
#define UART0_ECR			REGISTER_32(UART0_BASE+UARTECR)
#define UART0_FR			REGISTER_32(UART0_BASE+UARTFR)
#define UART0_ILPR			REGISTER_32(UART0_BASE+UARTILPR)
#define UART0_IBRD			REGISTER_32(UART0_BASE+UARTIBRD)
#define UART0_FBRD			REGISTER_32(UART0_BASE+UARTFBRD)
#define UART0_LCRH			REGISTER_32(UART0_BASE+UARTLCRH)
#define UART0_CTL			REGISTER_32(UART0_BASE+UARTCTL)
#define UART0_IFLS			REGISTER_32(UART0_BASE+UARTIFLS)
#define UART0_IM			REGISTER_32(UART0_BASE+UARTIM)
#define UART0_RIS			REGISTER_32(UART0_BASE+UARTRIS)
#define UART0_MIS			REGISTER_32(UART0_BASE+UARTMIS)
#define UART0_ICR			REGISTER_32(UART0_BASE+UARTICR)
#define UART0_DMACTL		REGISTER_32(UART0_BASE+UARTDMACTL)
#define UART0_9BITADDR		REGISTER_32(UART0_BASE+UART9BITADDR)
#define UART0_9BITAMASK		REGISTER_32(UART0_BASE+UART9BITAMASK)
#define UART0_PP			REGISTER_32(UART0_BASE+UARTPP)
#define UART0_CC			REGISTER_32(UART0_BASE+UARTCC)
#define UART0_PeriphID4		REGISTER_32(UART0_BASE+UARTPeriphID4)
#define UART0_PeriphID5		REGISTER_32(UART0_BASE+UARTPeriphID3)
#define UART0_PeriphID6		REGISTER_32(UART0_BASE+UARTPeriphID2)
#define UART0_PeriphID7		REGISTER_32(UART0_BASE+UARTPeriphID1)
#define UART0_PeriphID0		REGISTER_32(UART0_BASE+UARTPeriphID0)
#define UART0_PeriphID1		REGISTER_32(UART0_BASE+UARTPeriphID1)
#define UART0_PeriphID2		REGISTER_32(UART0_BASE+UARTPeriphID2)
#define UART0_PeriphID3		REGISTER_32(UART0_BASE+UARTPeriphID3)
#define UART0_PCellID0		REGISTER_32(UART0_BASE+UARTPCellID0)
#define UART0_PCellID1		REGISTER_32(UART0_BASE+UARTPCellID1)
#define UART0_PCellID2		REGISTER_32(UART0_BASE+UARTPCellID2)
#define UART0_PCellID3		REGISTER_32(UART0_BASE+UARTPCellID3)

// UART 1
#define UART1_DR			REGISTER_32(UART1_BASE+UARTDR)
#define UART1_RSR			REGISTER_32(UART1_BASE+UARTRSR)
#define UART1_ECR			REGISTER_32(UART1_BASE+UARTECR)
#define UART1_FR			REGISTER_32(UART1_BASE+UARTFR)
#define UART1_ILPR			REGISTER_32(UART1_BASE+UARTILPR)
#define UART1_IBRD			REGISTER_32(UART1_BASE+UARTIBRD)
#define UART1_FBRD			REGISTER_32(UART1_BASE+UARTFBRD)
#define UART1_LCRH			REGISTER_32(UART1_BASE+UARTLCRH)
#define UART1_CTL			REGISTER_32(UART1_BASE+UARTCTL)
#define UART1_IFLS			REGISTER_32(UART1_BASE+UARTIFLS)
#define UART1_IM			REGISTER_32(UART1_BASE+UARTIM)
#define UART1_RIS			REGISTER_32(UART1_BASE+UARTRIS)
#define UART1_MIS			REGISTER_32(UART1_BASE+UARTMIS)
#define UART1_ICR			REGISTER_32(UART1_BASE+UARTICR)
#define UART1_DMACTL		REGISTER_32(UART1_BASE+UARTDMACTL)
#define UART1_9BITADDR		REGISTER_32(UART1_BASE+UART9BITADDR)
#define UART1_9BITAMASK		REGISTER_32(UART1_BASE+UART9BITAMASK)
#define UART1_PP			REGISTER_32(UART1_BASE+UARTPP)
#define UART1_CC			REGISTER_32(UART1_BASE+UARTCC)
#define UART1_PeriphID4		REGISTER_32(UART1_BASE+UARTPeriphID4)
#define UART1_PeriphID5		REGISTER_32(UART1_BASE+UARTPeriphID3)
#define UART1_PeriphID6		REGISTER_32(UART1_BASE+UARTPeriphID2)
#define UART1_PeriphID7		REGISTER_32(UART1_BASE+UARTPeriphID1)
#define UART1_PeriphID0		REGISTER_32(UART1_BASE+UARTPeriphID0)
#define UART1_PeriphID1		REGISTER_32(UART1_BASE+UARTPeriphID1)
#define UART1_PeriphID2		REGISTER_32(UART1_BASE+UARTPeriphID2)
#define UART1_PeriphID3		REGISTER_32(UART1_BASE+UARTPeriphID3)
#define UART1_PCellID0		REGISTER_32(UART1_BASE+UARTPCellID0)
#define UART1_PCellID1		REGISTER_32(UART1_BASE+UARTPCellID1)
#define UART1_PCellID2		REGISTER_32(UART1_BASE+UARTPCellID2)
#define UART1_PCellID3		REGISTER_32(UART1_BASE+UARTPCellID3)

// UART 2
#define UART2_DR			REGISTER_32(UART2_BASE+UARTDR)
#define UART2_RSR			REGISTER_32(UART2_BASE+UARTRSR)
#define UART2_ECR			REGISTER_32(UART2_BASE+UARTECR)
#define UART2_FR			REGISTER_32(UART2_BASE+UARTFR)
#define UART2_ILPR			REGISTER_32(UART2_BASE+UARTILPR)
#define UART2_IBRD			REGISTER_32(UART2_BASE+UARTIBRD)
#define UART2_FBRD			REGISTER_32(UART2_BASE+UARTFBRD)
#define UART2_LCRH			REGISTER_32(UART2_BASE+UARTLCRH)
#define UART2_CTL			REGISTER_32(UART2_BASE+UARTCTL)
#define UART2_IFLS			REGISTER_32(UART2_BASE+UARTIFLS)
#define UART2_IM			REGISTER_32(UART2_BASE+UARTIM)
#define UART2_RIS			REGISTER_32(UART2_BASE+UARTRIS)
#define UART2_MIS			REGISTER_32(UART2_BASE+UARTMIS)
#define UART2_ICR			REGISTER_32(UART2_BASE+UARTICR)
#define UART2_DMACTL		REGISTER_32(UART2_BASE+UARTDMACTL)
#define UART2_9BITADDR		REGISTER_32(UART2_BASE+UART9BITADDR)
#define UART2_9BITAMASK		REGISTER_32(UART2_BASE+UART9BITAMASK)
#define UART2_PP			REGISTER_32(UART2_BASE+UARTPP)
#define UART2_CC			REGISTER_32(UART2_BASE+UARTCC)
#define UART2_PeriphID4		REGISTER_32(UART2_BASE+UARTPeriphID4)
#define UART2_PeriphID5		REGISTER_32(UART2_BASE+UARTPeriphID3)
#define UART2_PeriphID6		REGISTER_32(UART2_BASE+UARTPeriphID2)
#define UART2_PeriphID7		REGISTER_32(UART2_BASE+UARTPeriphID1)
#define UART2_PeriphID0		REGISTER_32(UART2_BASE+UARTPeriphID0)
#define UART2_PeriphID1		REGISTER_32(UART2_BASE+UARTPeriphID1)
#define UART2_PeriphID2		REGISTER_32(UART2_BASE+UARTPeriphID2)
#define UART2_PeriphID3		REGISTER_32(UART2_BASE+UARTPeriphID3)
#define UART2_PCellID0		REGISTER_32(UART2_BASE+UARTPCellID0)
#define UART2_PCellID1		REGISTER_32(UART2_BASE+UARTPCellID1)
#define UART2_PCellID2		REGISTER_32(UART2_BASE+UARTPCellID2)
#define UART2_PCellID3		REGISTER_32(UART2_BASE+UARTPCellID3)

// UART 3
#define UART3_DR			REGISTER_32(UART3_BASE+UARTDR)
#define UART3_RSR			REGISTER_32(UART3_BASE+UARTRSR)
#define UART3_ECR			REGISTER_32(UART3_BASE+UARTECR)
#define UART3_FR			REGISTER_32(UART3_BASE+UARTFR)
#define UART3_ILPR			REGISTER_32(UART3_BASE+UARTILPR)
#define UART3_IBRD			REGISTER_32(UART3_BASE+UARTIBRD)
#define UART3_FBRD			REGISTER_32(UART3_BASE+UARTFBRD)
#define UART3_LCRH			REGISTER_32(UART3_BASE+UARTLCRH)
#define UART3_CTL			REGISTER_32(UART3_BASE+UARTCTL)
#define UART3_IFLS			REGISTER_32(UART3_BASE+UARTIFLS)
#define UART3_IM			REGISTER_32(UART3_BASE+UARTIM)
#define UART3_RIS			REGISTER_32(UART3_BASE+UARTRIS)
#define UART3_MIS			REGISTER_32(UART3_BASE+UARTMIS)
#define UART3_ICR			REGISTER_32(UART3_BASE+UARTICR)
#define UART3_DMACTL		REGISTER_32(UART3_BASE+UARTDMACTL)
#define UART3_9BITADDR		REGISTER_32(UART3_BASE+UART9BITADDR)
#define UART3_9BITAMASK		REGISTER_32(UART3_BASE+UART9BITAMASK)
#define UART3_PP			REGISTER_32(UART3_BASE+UARTPP)
#define UART3_CC			REGISTER_32(UART3_BASE+UARTCC)
#define UART3_PeriphID4		REGISTER_32(UART3_BASE+UARTPeriphID4)
#define UART3_PeriphID5		REGISTER_32(UART3_BASE+UARTPeriphID3)
#define UART3_PeriphID6		REGISTER_32(UART3_BASE+UARTPeriphID2)
#define UART3_PeriphID7		REGISTER_32(UART3_BASE+UARTPeriphID1)
#define UART3_PeriphID0		REGISTER_32(UART3_BASE+UARTPeriphID0)
#define UART3_PeriphID1		REGISTER_32(UART3_BASE+UARTPeriphID1)
#define UART3_PeriphID2		REGISTER_32(UART3_BASE+UARTPeriphID2)
#define UART3_PeriphID3		REGISTER_32(UART3_BASE+UARTPeriphID3)
#define UART3_PCellID0		REGISTER_32(UART3_BASE+UARTPCellID0)
#define UART3_PCellID1		REGISTER_32(UART3_BASE+UARTPCellID1)
#define UART3_PCellID2		REGISTER_32(UART3_BASE+UARTPCellID2)
#define UART3_PCellID3		REGISTER_32(UART3_BASE+UARTPCellID3)

// UART 4
#define UART4_DR			REGISTER_32(UART4_BASE+UARTDR)
#define UART4_RSR			REGISTER_32(UART4_BASE+UARTRSR)
#define UART4_ECR			REGISTER_32(UART4_BASE+UARTECR)
#define UART4_FR			REGISTER_32(UART4_BASE+UARTFR)
#define UART4_ILPR			REGISTER_32(UART4_BASE+UARTILPR)
#define UART4_IBRD			REGISTER_32(UART4_BASE+UARTIBRD)
#define UART4_FBRD			REGISTER_32(UART4_BASE+UARTFBRD)
#define UART4_LCRH			REGISTER_32(UART4_BASE+UARTLCRH)
#define UART4_CTL			REGISTER_32(UART4_BASE+UARTCTL)
#define UART4_IFLS			REGISTER_32(UART4_BASE+UARTIFLS)
#define UART4_IM			REGISTER_32(UART4_BASE+UARTIM)
#define UART4_RIS			REGISTER_32(UART4_BASE+UARTRIS)
#define UART4_MIS			REGISTER_32(UART4_BASE+UARTMIS)
#define UART4_ICR			REGISTER_32(UART4_BASE+UARTICR)
#define UART4_DMACTL		REGISTER_32(UART4_BASE+UARTDMACTL)
#define UART4_9BITADDR		REGISTER_32(UART4_BASE+UART9BITADDR)
#define UART4_9BITAMASK		REGISTER_32(UART4_BASE+UART9BITAMASK)
#define UART4_PP			REGISTER_32(UART4_BASE+UARTPP)
#define UART4_CC			REGISTER_32(UART4_BASE+UARTCC)
#define UART4_PeriphID4		REGISTER_32(UART4_BASE+UARTPeriphID4)
#define UART4_PeriphID5		REGISTER_32(UART4_BASE+UARTPeriphID3)
#define UART4_PeriphID6		REGISTER_32(UART4_BASE+UARTPeriphID2)
#define UART4_PeriphID7		REGISTER_32(UART4_BASE+UARTPeriphID1)
#define UART4_PeriphID0		REGISTER_32(UART4_BASE+UARTPeriphID0)
#define UART4_PeriphID1		REGISTER_32(UART4_BASE+UARTPeriphID1)
#define UART4_PeriphID2		REGISTER_32(UART4_BASE+UARTPeriphID2)
#define UART4_PeriphID3		REGISTER_32(UART4_BASE+UARTPeriphID3)
#define UART4_PCellID0		REGISTER_32(UART4_BASE+UARTPCellID0)
#define UART4_PCellID1		REGISTER_32(UART4_BASE+UARTPCellID1)
#define UART4_PCellID2		REGISTER_32(UART4_BASE+UARTPCellID2)
#define UART4_PCellID3		REGISTER_32(UART4_BASE+UARTPCellID3)

// UART 5

#define UART5_DR			REGISTER_32(UART5_BASE+UARTDR)
#define UART5_RSR			REGISTER_32(UART5_BASE+UARTRSR)
#define UART5_ECR			REGISTER_32(UART5_BASE+UARTECR)
#define UART5_FR			REGISTER_32(UART5_BASE+UARTFR)
#define UART5_ILPR			REGISTER_32(UART5_BASE+UARTILPR)
#define UART5_IBRD			REGISTER_32(UART5_BASE+UARTIBRD)
#define UART5_FBRD			REGISTER_32(UART5_BASE+UARTFBRD)
#define UART5_LCRH			REGISTER_32(UART5_BASE+UARTLCRH)
#define UART5_CTL			REGISTER_32(UART5_BASE+UARTCTL)
#define UART5_IFLS			REGISTER_32(UART5_BASE+UARTIFLS)
#define UART5_IM			REGISTER_32(UART5_BASE+UARTIM)
#define UART5_RIS			REGISTER_32(UART5_BASE+UARTRIS)
#define UART5_MIS			REGISTER_32(UART5_BASE+UARTMIS)
#define UART5_ICR			REGISTER_32(UART5_BASE+UARTICR)
#define UART5_DMACTL		REGISTER_32(UART5_BASE+UARTDMACTL)
#define UART5_9BITADDR		REGISTER_32(UART5_BASE+UART9BITADDR)
#define UART5_9BITAMASK		REGISTER_32(UART5_BASE+UART9BITAMASK)
#define UART5_PP			REGISTER_32(UART5_BASE+UARTPP)
#define UART5_CC			REGISTER_32(UART5_BASE+UARTCC)
#define UART5_PeriphID4		REGISTER_32(UART5_BASE+UARTPeriphID4)
#define UART5_PeriphID5		REGISTER_32(UART5_BASE+UARTPeriphID3)
#define UART5_PeriphID6		REGISTER_32(UART5_BASE+UARTPeriphID2)
#define UART5_PeriphID7		REGISTER_32(UART5_BASE+UARTPeriphID1)
#define UART5_PeriphID0		REGISTER_32(UART5_BASE+UARTPeriphID0)
#define UART5_PeriphID1		REGISTER_32(UART5_BASE+UARTPeriphID1)
#define UART5_PeriphID2		REGISTER_32(UART5_BASE+UARTPeriphID2)
#define UART5_PeriphID3		REGISTER_32(UART5_BASE+UARTPeriphID3)
#define UART5_PCellID0		REGISTER_32(UART5_BASE+UARTPCellID0)
#define UART5_PCellID1		REGISTER_32(UART5_BASE+UARTPCellID1)
#define UART5_PCellID2		REGISTER_32(UART5_BASE+UARTPCellID2)
#define UART5_PCellID3		REGISTER_32(UART5_BASE+UARTPCellID3)

// UART 6

#define UART6_DR			REGISTER_32(UART6_BASE+UARTDR)
#define UART6_RSR			REGISTER_32(UART6_BASE+UARTRSR)
#define UART6_ECR			REGISTER_32(UART6_BASE+UARTECR)
#define UART6_FR			REGISTER_32(UART6_BASE+UARTFR)
#define UART6_ILPR			REGISTER_32(UART6_BASE+UARTILPR)
#define UART6_IBRD			REGISTER_32(UART6_BASE+UARTIBRD)
#define UART6_FBRD			REGISTER_32(UART6_BASE+UARTFBRD)
#define UART6_LCRH			REGISTER_32(UART6_BASE+UARTLCRH)
#define UART6_CTL			REGISTER_32(UART6_BASE+UARTCTL)
#define UART6_IFLS			REGISTER_32(UART6_BASE+UARTIFLS)
#define UART6_IM			REGISTER_32(UART6_BASE+UARTIM)
#define UART6_RIS			REGISTER_32(UART6_BASE+UARTRIS)
#define UART6_MIS			REGISTER_32(UART6_BASE+UARTMIS)
#define UART6_ICR			REGISTER_32(UART6_BASE+UARTICR)
#define UART6_DMACTL		REGISTER_32(UART6_BASE+UARTDMACTL)
#define UART6_9BITADDR		REGISTER_32(UART6_BASE+UART9BITADDR)
#define UART6_9BITAMASK		REGISTER_32(UART6_BASE+UART9BITAMASK)
#define UART6_PP			REGISTER_32(UART6_BASE+UARTPP)
#define UART6_CC			REGISTER_32(UART6_BASE+UARTCC)
#define UART6_PeriphID4		REGISTER_32(UART6_BASE+UARTPeriphID4)
#define UART6_PeriphID5		REGISTER_32(UART6_BASE+UARTPeriphID3)
#define UART6_PeriphID6		REGISTER_32(UART6_BASE+UARTPeriphID2)
#define UART6_PeriphID7		REGISTER_32(UART6_BASE+UARTPeriphID1)
#define UART6_PeriphID0		REGISTER_32(UART6_BASE+UARTPeriphID0)
#define UART6_PeriphID1		REGISTER_32(UART6_BASE+UARTPeriphID1)
#define UART6_PeriphID2		REGISTER_32(UART6_BASE+UARTPeriphID2)
#define UART6_PeriphID3		REGISTER_32(UART6_BASE+UARTPeriphID3)
#define UART6_PCellID0		REGISTER_32(UART6_BASE+UARTPCellID0)
#define UART6_PCellID1		REGISTER_32(UART6_BASE+UARTPCellID1)
#define UART6_PCellID2		REGISTER_32(UART6_BASE+UARTPCellID2)
#define UART6_PCellID3		REGISTER_32(UART6_BASE+UARTPCellID3)

// UART 7

#define UART7_DR			REGISTER_32(UART7_BASE+UARTDR)
#define UART7_RSR			REGISTER_32(UART7_BASE+UARTRSR)
#define UART7_ECR			REGISTER_32(UART7_BASE+UARTECR)
#define UART7_FR			REGISTER_32(UART7_BASE+UARTFR)
#define UART7_ILPR			REGISTER_32(UART7_BASE+UARTILPR)
#define UART7_IBRD			REGISTER_32(UART7_BASE+UARTIBRD)
#define UART7_FBRD			REGISTER_32(UART7_BASE+UARTFBRD)
#define UART7_LCRH			REGISTER_32(UART7_BASE+UARTLCRH)
#define UART7_CTL			REGISTER_32(UART7_BASE+UARTCTL)
#define UART7_IFLS			REGISTER_32(UART7_BASE+UARTIFLS)
#define UART7_IM			REGISTER_32(UART7_BASE+UARTIM)
#define UART7_RIS			REGISTER_32(UART7_BASE+UARTRIS)
#define UART7_MIS			REGISTER_32(UART7_BASE+UARTMIS)
#define UART7_ICR			REGISTER_32(UART7_BASE+UARTICR)
#define UART7_DMACTL		REGISTER_32(UART7_BASE+UARTDMACTL)
#define UART7_9BITADDR		REGISTER_32(UART7_BASE+UART9BITADDR)
#define UART7_9BITAMASK		REGISTER_32(UART7_BASE+UART9BITAMASK)
#define UART7_PP			REGISTER_32(UART7_BASE+UARTPP)
#define UART7_CC			REGISTER_32(UART7_BASE+UARTCC)
#define UART7_PeriphID4		REGISTER_32(UART7_BASE+UARTPeriphID4)
#define UART7_PeriphID5		REGISTER_32(UART7_BASE+UARTPeriphID3)
#define UART7_PeriphID6		REGISTER_32(UART7_BASE+UARTPeriphID2)
#define UART7_PeriphID7		REGISTER_32(UART7_BASE+UARTPeriphID1)
#define UART7_PeriphID0		REGISTER_32(UART7_BASE+UARTPeriphID0)
#define UART7_PeriphID1		REGISTER_32(UART7_BASE+UARTPeriphID1)
#define UART7_PeriphID2		REGISTER_32(UART7_BASE+UARTPeriphID2)
#define UART7_PeriphID3		REGISTER_32(UART7_BASE+UARTPeriphID3)
#define UART7_PCellID0		REGISTER_32(UART7_BASE+UARTPCellID0)
#define UART7_PCellID1		REGISTER_32(UART7_BASE+UARTPCellID1)
#define UART7_PCellID2		REGISTER_32(UART7_BASE+UARTPCellID2)
#define UART7_PCellID3		REGISTER_32(UART7_BASE+UARTPCellID3)

// I2C
// I2C Offsets

#define I2CMSA				0x0000
#define I2CMCS				0x0004
#define I2CMDR				0x0008
#define I2CMTPR				0x000c
#define I2CMIMR				0x0010
#define I2CMRIS				0x0014
#define I2CMMIS				0x0018
#define I2CMICR				0x001c
#define I2CMCR				0x0020
#define I2CMCLKOCNT			0x0024
#define I2CMBMON			0x002c
#define I2CMCR2				0x0038
#define I2CSOAR				0x0800
#define I2CSCSR				0x0804
#define I2CSDR				0x0808
#define I2CSIMR				0x080c
#define I2CSRIS				0x0810
#define I2CSMIS				0x0814
#define I2CSICR				0x0818
#define I2CSOAR2			0x081c
#define I2CSACKCTL			0x0820
#define I2CPP				0x0fc0
#define I2CPC				0x0fc4

// I2C0

#define I2C0_MSA				REGISTER_32(I2C0_BASE+I2CMSA)
#define I2C0_MCS				REGISTER_32(I2C0_BASE+I2CMCS)
#define I2C0_MDR				REGISTER_32(I2C0_BASE+I2CMDR)
#define I2C0_MTPR				REGISTER_32(I2C0_BASE+I2CMTPR)
#define I2C0_MIMR				REGISTER_32(I2C0_BASE+I2CMIMR)
#define I2C0_MRIS				REGISTER_32(I2C0_BASE+I2CMRIS)
#define I2C0_MMIS				REGISTER_32(I2C0_BASE+I2CMMIS)
#define I2C0_MICR				REGISTER_32(I2C0_BASE+I2CMICR)
#define I2C0_MCR				REGISTER_32(I2C0_BASE+I2CMCR)
#define I2C0_MCLKOCNT			REGISTER_32(I2C0_BASE+I2CMCLKOCNT)
#define I2C0_MBMON				REGISTER_32(I2C0_BASE+I2CMBMON)
#define I2C0_MCR2				REGISTER_32(I2C0_BASE+I2CMCR2)
#define I2C0_SOAR				REGISTER_32(I2C0_BASE+I2CSOAR)
#define I2C0_SCSR				REGISTER_32(I2C0_BASE+I2CSCSR)
#define I2C0_SDR				REGISTER_32(I2C0_BASE+I2CSDR)
#define I2C0_SIMR				REGISTER_32(I2C0_BASE+I2CSIMR)
#define I2C0_SRIS				REGISTER_32(I2C0_BASE+I2CSRIS)
#define I2C0_SMIS				REGISTER_32(I2C0_BASE+I2CSMIS)
#define I2C0_SICR				REGISTER_32(I2C0_BASE+I2CSICR)
#define I2C0_SOAR2				REGISTER_32(I2C0_BASE+I2CSOAR2)
#define I2C0_SACKCTL			REGISTER_32(I2C0_BASE+I2CSACKCTL)
#define I2C0_PP					REGISTER_32(I2C0_BASE+I2CPP)
#define I2C0_PC					REGISTER_32(I2C0_BASE+I2CPC)


//I2C1
#define I2C1_MSA				REGISTER_32(I2C1_BASE+I2CMSA)
#define I2C1_MCS				REGISTER_32(I2C1_BASE+I2CMCS)
#define I2C1_MDR				REGISTER_32(I2C1_BASE+I2CMDR)
#define I2C1_MTPR				REGISTER_32(I2C1_BASE+I2CMTPR)
#define I2C1_MIMR				REGISTER_32(I2C1_BASE+I2CMIMR)
#define I2C1_MRIS				REGISTER_32(I2C1_BASE+I2CMRIS)
#define I2C1_MMIS				REGISTER_32(I2C1_BASE+I2CMMIS)
#define I2C1_MICR				REGISTER_32(I2C1_BASE+I2CMICR)
#define I2C1_MCR				REGISTER_32(I2C1_BASE+I2CMCR)
#define I2C1_MCLKOCNT			REGISTER_32(I2C1_BASE+I2CMCLKOCNT)
#define I2C1_MBMON				REGISTER_32(I2C1_BASE+I2CMBMON)
#define I2C1_MCR2				REGISTER_32(I2C1_BASE+I2CMCR2)
#define I2C1_SOAR				REGISTER_32(I2C1_BASE+I2CSOAR)
#define I2C1_SCSR				REGISTER_32(I2C1_BASE+I2CSCSR)
#define I2C1_SDR				REGISTER_32(I2C1_BASE+I2CSDR)
#define I2C1_SIMR				REGISTER_32(I2C1_BASE+I2CSIMR)
#define I2C1_SRIS				REGISTER_32(I2C1_BASE+I2CSRIS)
#define I2C1_SMIS				REGISTER_32(I2C1_BASE+I2CSMIS)
#define I2C1_SICR				REGISTER_32(I2C1_BASE+I2CSICR)
#define I2C1_SOAR2				REGISTER_32(I2C1_BASE+I2CSOAR2)
#define I2C1_SACKCTL			REGISTER_32(I2C1_BASE+I2CSACKCTL)
#define I2C1_PP					REGISTER_32(I2C1_BASE+I2CPP)
#define I2C1_PC					REGISTER_32(I2C1_BASE+I2CPC)

// I2C2
#define I2C2_MSA				REGISTER_32(I2C2_BASE+I2CMSA)
#define I2C2_MCS				REGISTER_32(I2C2_BASE+I2CMCS)
#define I2C2_MDR				REGISTER_32(I2C2_BASE+I2CMDR)
#define I2C2_MTPR				REGISTER_32(I2C2_BASE+I2CMTPR)
#define I2C2_MIMR				REGISTER_32(I2C2_BASE+I2CMIMR)
#define I2C2_MRIS				REGISTER_32(I2C2_BASE+I2CMRIS)
#define I2C2_MMIS				REGISTER_32(I2C2_BASE+I2CMMIS)
#define I2C2_MICR				REGISTER_32(I2C2_BASE+I2CMICR)
#define I2C2_MCR				REGISTER_32(I2C2_BASE+I2CMCR)
#define I2C2_MCLKOCNT			REGISTER_32(I2C2_BASE+I2CMCLKOCNT)
#define I2C2_MBMON				REGISTER_32(I2C2_BASE+I2CMBMON)
#define I2C2_MCR2				REGISTER_32(I2C2_BASE+I2CMCR2)
#define I2C2_SOAR				REGISTER_32(I2C2_BASE+I2CSOAR)
#define I2C2_SCSR				REGISTER_32(I2C2_BASE+I2CSCSR)
#define I2C2_SDR				REGISTER_32(I2C2_BASE+I2CSDR)
#define I2C2_SIMR				REGISTER_32(I2C2_BASE+I2CSIMR)
#define I2C2_SRIS				REGISTER_32(I2C2_BASE+I2CSRIS)
#define I2C2_SMIS				REGISTER_32(I2C2_BASE+I2CSMIS)
#define I2C2_SICR				REGISTER_32(I2C2_BASE+I2CSICR)
#define I2C2_SOAR2				REGISTER_32(I2C2_BASE+I2CSOAR2)
#define I2C2_SACKCTL			REGISTER_32(I2C2_BASE+I2CSACKCTL)
#define I2C2_PP					REGISTER_32(I2C2_BASE+I2CPP)
#define I2C2_PC					REGISTER_32(I2C2_BASE+I2CPC)

// I2C3
#define I2C3_MSA				REGISTER_32(I2C3_BASE+I2CMSA)
#define I2C3_MCS				REGISTER_32(I2C3_BASE+I2CMCS)
#define I2C3_MDR				REGISTER_32(I2C3_BASE+I2CMDR)
#define I2C3_MTPR				REGISTER_32(I2C3_BASE+I2CMTPR)
#define I2C3_MIMR				REGISTER_32(I2C3_BASE+I2CMIMR)
#define I2C3_MRIS				REGISTER_32(I2C3_BASE+I2CMRIS)
#define I2C3_MMIS				REGISTER_32(I2C3_BASE+I2CMMIS)
#define I2C3_MICR				REGISTER_32(I2C3_BASE+I2CMICR)
#define I2C3_MCR				REGISTER_32(I2C3_BASE+I2CMCR)
#define I2C3_MCLKOCNT			REGISTER_32(I2C3_BASE+I2CMCLKOCNT)
#define I2C3_MBMON				REGISTER_32(I2C3_BASE+I2CMBMON)
#define I2C3_MCR2				REGISTER_32(I2C3_BASE+I2CMCR2)
#define I2C3_SOAR				REGISTER_32(I2C3_BASE+I2CSOAR)
#define I2C3_SCSR				REGISTER_32(I2C3_BASE+I2CSCSR)
#define I2C3_SDR				REGISTER_32(I2C3_BASE+I2CSDR)
#define I2C3_SIMR				REGISTER_32(I2C3_BASE+I2CSIMR)
#define I2C3_SRIS				REGISTER_32(I2C3_BASE+I2CSRIS)
#define I2C3_SMIS				REGISTER_32(I2C3_BASE+I2CSMIS)
#define I2C3_SICR				REGISTER_32(I2C3_BASE+I2CSICR)
#define I2C3_SOAR2				REGISTER_32(I2C3_BASE+I2CSOAR2)
#define I2C3_SACKCTL			REGISTER_32(I2C3_BASE+I2CSACKCTL)
#define I2C3_PP					REGISTER_32(I2C3_BASE+I2CPP)
#define I2C3_PC					REGISTER_32(I2C3_BASE+I2CPC)

// Timers

// Timer offsets
#define GPTMCFG					0x0000
#define GPTMTAMR				0x0004
#define GPTMTBMR				0x0008
#define GPTMCTL					0x000c
#define GPTMSYNC				0x0010
#define GPTMIMR					0x0018
#define GPTMRIS					0x001c
#define GPTMMIS					0x0020
#define GPTMMICR				0x0024
#define GPTMTAILR				0x0028
#define GPTMTBILR				0x002c
#define GPTMAMATCHR				0x0030
#define GPTMBMATCHR				0x0034
#define GPTMTAPR				0x0038
#define GPTMTBPR				0x003c
#define GPTMTAPMR				0x0040
#define GPTMTBPMR				0x0044
#define GPTMTAR					0x0048
#define GPTMTBR					0x004c
#define GPTMTAV					0x0050
#define GPTMTBV					0x0054
#define GPTMRTCPD				0x0058
#define GPTMTAPS				0x005c
#define GPTMTBPS				0x0060
#define GPTMTAPV				0x0064
#define GPTMTBPV				0x0068
#define GPTMPP					0x0fc0

// T0_32
#define GPTM0_32_CFG			REGISTER_32(TIM0_32_BASE+GPTMCFG)
#define GPTM0_32_TAMR			REGISTER_32(TIM0_32_BASE+GPTMTAMR)
#define GPTM0_32_TBMR			REGISTER_32(TIM0_32_BASE+GPTMTBMR)
#define GPTM0_32_CTL			REGISTER_32(TIM0_32_BASE+GPTMCTL)
#define GPTM0_32_SYNC			REGISTER_32(TIM0_32_BASE+GPTMSYNC)
#define GPTM0_32_IMR			REGISTER_32(TIM0_32_BASE+GPTMIMR)
#define GPTM0_32_RIS			REGISTER_32(TIM0_32_BASE+GPTMRIS)
#define GPTM0_32_MIS			REGISTER_32(TIM0_32_BASE+GPTMMIS)
#define GPTM0_32_MICR			REGISTER_32(TIM0_32_BASE+GPTMMICR)
#define GPTM0_32_TAILR			REGISTER_32(TIM0_32_BASE+GPTMTAILR)
#define GPTM0_32_TBILR			REGISTER_32(TIM0_32_BASE+GPTMTBILR)
#define GPTM0_32_TAMATCHR		REGISTER_32(TIM0_32_BASE+GPTMAMATCHR)
#define GPTM0_32_TBMATCHR		REGISTER_32(TIM0_32_BASE+GPTMBMATCHR)
#define GPTM0_32_TAPR			REGISTER_32(TIM0_32_BASE+GPTMTAPR)
#define GPTM0_32_TBPR			REGISTER_32(TIM0_32_BASE+GPTMTBPR)
#define GPTM0_32_TAPMR			REGISTER_32(TIM0_32_BASE+GPTMTAPMR)
#define GPTM0_32_TBPMR			REGISTER_32(TIM0_32_BASE+GPTMTBPMR)
#define GPTM0_32_TAR			REGISTER_32(TIM0_32_BASE+GPTMTAR)
#define GPTM0_32_TBR			REGISTER_32(TIM0_32_BASE+GPTMTBR)
#define GPTM0_32_TAV			REGISTER_32(TIM0_32_BASE+GPTMTAV)
#define GPTM0_32_TBV			REGISTER_32(TIM0_32_BASE+GPTMTBV)
#define GPTM0_32_RTCPD			REGISTER_32(TIM0_32_BASE+GPTMRTCPD)
#define GPTM0_32_TAPS			REGISTER_32(TIM0_32_BASE+GPTMTAPS)
#define GPTM0_32_TBPS			REGISTER_32(TIM0_32_BASE+GPTMTBPS)
#define GPTM0_32_TAPV			REGISTER_32(TIM0_32_BASE+GPTMTAPV)
#define GPTM0_32_TBPV			REGISTER_32(TIM0_32_BASE+GPTMTBPV)
#define GPTM0_32_PP				REGISTER_32(TIM0_32_BASE+GPTMPP)

// T1_32
#define GPTM1_32_CFG			REGISTER_32(TIM1_32_BASE+GPTMCFG)
#define GPTM1_32_TAMR			REGISTER_32(TIM1_32_BASE+GPTMTAMR)
#define GPTM1_32_TBMR			REGISTER_32(TIM1_32_BASE+GPTMTBMR)
#define GPTM1_32_CTL			REGISTER_32(TIM1_32_BASE+GPTMCTL)
#define GPTM1_32_SYNC			REGISTER_32(TIM1_32_BASE+GPTMSYNC)
#define GPTM1_32_IMR			REGISTER_32(TIM1_32_BASE+GPTMIMR)
#define GPTM1_32_RIS			REGISTER_32(TIM1_32_BASE+GPTMRIS)
#define GPTM1_32_MIS			REGISTER_32(TIM1_32_BASE+GPTMMIS)
#define GPTM1_32_MICR			REGISTER_32(TIM1_32_BASE+GPTMMICR)
#define GPTM1_32_TAILR			REGISTER_32(TIM1_32_BASE+GPTMTAILR)
#define GPTM1_32_TBILR			REGISTER_32(TIM1_32_BASE+GPTMTBILR)
#define GPTM1_32_TAMATCHR		REGISTER_32(TIM1_32_BASE+GPTMAMATCHR)
#define GPTM1_32_TBMATCHR		REGISTER_32(TIM1_32_BASE+GPTMBMATCHR)
#define GPTM1_32_TAPR			REGISTER_32(TIM1_32_BASE+GPTMTAPR)
#define GPTM1_32_TBPR			REGISTER_32(TIM1_32_BASE+GPTMTBPR)
#define GPTM1_32_TAPMR			REGISTER_32(TIM1_32_BASE+GPTMTAPMR)
#define GPTM1_32_TBPMR			REGISTER_32(TIM1_32_BASE+GPTMTBPMR)
#define GPTM1_32_TAR			REGISTER_32(TIM1_32_BASE+GPTMTAR)
#define GPTM1_32_TBR			REGISTER_32(TIM1_32_BASE+GPTMTBR)
#define GPTM1_32_TAV			REGISTER_32(TIM1_32_BASE+GPTMTAV)
#define GPTM1_32_TBV			REGISTER_32(TIM1_32_BASE+GPTMTBV)
#define GPTM1_32_RTCPD			REGISTER_32(TIM1_32_BASE+GPTMRTCPD)
#define GPTM1_32_TAPS			REGISTER_32(TIM1_32_BASE+GPTMTAPS)
#define GPTM1_32_TBPS			REGISTER_32(TIM1_32_BASE+GPTMTBPS)
#define GPTM1_32_TAPV			REGISTER_32(TIM1_32_BASE+GPTMTAPV)
#define GPTM1_32_TBPV			REGISTER_32(TIM1_32_BASE+GPTMTBPV)
#define GPTM1_32_PP				REGISTER_32(TIM1_32_BASE+GPTMPP)

//T2_32
#define GPTM2_32_CFG			REGISTER_32(TIM2_32_BASE+GPTMCFG)
#define GPTM2_32_TAMR			REGISTER_32(TIM2_32_BASE+GPTMTAMR)
#define GPTM2_32_TBMR			REGISTER_32(TIM2_32_BASE+GPTMTBMR)
#define GPTM2_32_CTL			REGISTER_32(TIM2_32_BASE+GPTMCTL)
#define GPTM2_32_SYNC			REGISTER_32(TIM2_32_BASE+GPTMSYNC)
#define GPTM2_32_IMR			REGISTER_32(TIM2_32_BASE+GPTMIMR)
#define GPTM2_32_RIS			REGISTER_32(TIM2_32_BASE+GPTMRIS)
#define GPTM2_32_MIS			REGISTER_32(TIM2_32_BASE+GPTMMIS)
#define GPTM2_32_MICR			REGISTER_32(TIM2_32_BASE+GPTMMICR)
#define GPTM2_32_TAILR			REGISTER_32(TIM2_32_BASE+GPTMTAILR)
#define GPTM2_32_TBILR			REGISTER_32(TIM2_32_BASE+GPTMTBILR)
#define GPTM2_32_TAMATCHR		REGISTER_32(TIM2_32_BASE+GPTMAMATCHR)
#define GPTM2_32_TBMATCHR		REGISTER_32(TIM2_32_BASE+GPTMBMATCHR)
#define GPTM2_32_TAPR			REGISTER_32(TIM2_32_BASE+GPTMTAPR)
#define GPTM2_32_TBPR			REGISTER_32(TIM2_32_BASE+GPTMTBPR)
#define GPTM2_32_TAPMR			REGISTER_32(TIM2_32_BASE+GPTMTAPMR)
#define GPTM2_32_TBPMR			REGISTER_32(TIM2_32_BASE+GPTMTBPMR)
#define GPTM2_32_TAR			REGISTER_32(TIM2_32_BASE+GPTMTAR)
#define GPTM2_32_TBR			REGISTER_32(TIM2_32_BASE+GPTMTBR)
#define GPTM2_32_TAV			REGISTER_32(TIM2_32_BASE+GPTMTAV)
#define GPTM2_32_TBV			REGISTER_32(TIM2_32_BASE+GPTMTBV)
#define GPTM2_32_RTCPD			REGISTER_32(TIM2_32_BASE+GPTMRTCPD)
#define GPTM2_32_TAPS			REGISTER_32(TIM2_32_BASE+GPTMTAPS)
#define GPTM2_32_TBPS			REGISTER_32(TIM2_32_BASE+GPTMTBPS)
#define GPTM2_32_TAPV			REGISTER_32(TIM2_32_BASE+GPTMTAPV)
#define GPTM2_32_TBPV			REGISTER_32(TIM2_32_BASE+GPTMTBPV)
#define GPTM2_32_PP				REGISTER_32(TIM2_32_BASE+GPTMPP)

//T3_32
#define GPTM3_32_CFG			REGISTER_32(TIM3_32_BASE+GPTMCFG)
#define GPTM3_32_TAMR			REGISTER_32(TIM3_32_BASE+GPTMTAMR)
#define GPTM3_32_TBMR			REGISTER_32(TIM3_32_BASE+GPTMTBMR)
#define GPTM3_32_CTL			REGISTER_32(TIM3_32_BASE+GPTMCTL)
#define GPTM3_32_SYNC			REGISTER_32(TIM3_32_BASE+GPTMSYNC)
#define GPTM3_32_IMR			REGISTER_32(TIM3_32_BASE+GPTMIMR)
#define GPTM3_32_RIS			REGISTER_32(TIM3_32_BASE+GPTMRIS)
#define GPTM3_32_MIS			REGISTER_32(TIM3_32_BASE+GPTMMIS)
#define GPTM3_32_MICR			REGISTER_32(TIM3_32_BASE+GPTMMICR)
#define GPTM3_32_TAILR			REGISTER_32(TIM3_32_BASE+GPTMTAILR)
#define GPTM3_32_TBILR			REGISTER_32(TIM3_32_BASE+GPTMTBILR)
#define GPTM3_32_TAMATCHR		REGISTER_32(TIM3_32_BASE+GPTMAMATCHR)
#define GPTM3_32_TBMATCHR		REGISTER_32(TIM3_32_BASE+GPTMBMATCHR)
#define GPTM3_32_TAPR			REGISTER_32(TIM3_32_BASE+GPTMTAPR)
#define GPTM3_32_TBPR			REGISTER_32(TIM3_32_BASE+GPTMTBPR)
#define GPTM3_32_TAPMR			REGISTER_32(TIM3_32_BASE+GPTMTAPMR)
#define GPTM3_32_TBPMR			REGISTER_32(TIM3_32_BASE+GPTMTBPMR)
#define GPTM3_32_TAR			REGISTER_32(TIM3_32_BASE+GPTMTAR)
#define GPTM3_32_TBR			REGISTER_32(TIM3_32_BASE+GPTMTBR)
#define GPTM3_32_TAV			REGISTER_32(TIM3_32_BASE+GPTMTAV)
#define GPTM3_32_TBV			REGISTER_32(TIM3_32_BASE+GPTMTBV)
#define GPTM3_32_RTCPD			REGISTER_32(TIM3_32_BASE+GPTMRTCPD)
#define GPTM3_32_TAPS			REGISTER_32(TIM3_32_BASE+GPTMTAPS)
#define GPTM3_32_TBPS			REGISTER_32(TIM3_32_BASE+GPTMTBPS)
#define GPTM3_32_TAPV			REGISTER_32(TIM3_32_BASE+GPTMTAPV)
#define GPTM3_32_TBPV			REGISTER_32(TIM3_32_BASE+GPTMTBPV)
#define GPTM3_32_PP				REGISTER_32(TIM3_32_BASE+GPTMPP)

//T4_32

#define GPTM4_32_CFG			REGISTER_32(TIM4_32_BASE+GPTMCFG)
#define GPTM4_32_TAMR			REGISTER_32(TIM4_32_BASE+GPTMTAMR)
#define GPTM4_32_TBMR			REGISTER_32(TIM4_32_BASE+GPTMTBMR)
#define GPTM4_32_CTL			REGISTER_32(TIM4_32_BASE+GPTMCTL)
#define GPTM4_32_SYNC			REGISTER_32(TIM4_32_BASE+GPTMSYNC)
#define GPTM4_32_IMR			REGISTER_32(TIM4_32_BASE+GPTMIMR)
#define GPTM4_32_RIS			REGISTER_32(TIM4_32_BASE+GPTMRIS)
#define GPTM4_32_MIS			REGISTER_32(TIM4_32_BASE+GPTMMIS)
#define GPTM4_32_MICR			REGISTER_32(TIM4_32_BASE+GPTMMICR)
#define GPTM4_32_TAILR			REGISTER_32(TIM4_32_BASE+GPTMTAILR)
#define GPTM4_32_TBILR			REGISTER_32(TIM4_32_BASE+GPTMTBILR)
#define GPTM4_32_TAMATCHR		REGISTER_32(TIM4_32_BASE+GPTMAMATCHR)
#define GPTM4_32_TBMATCHR		REGISTER_32(TIM4_32_BASE+GPTMBMATCHR)
#define GPTM4_32_TAPR			REGISTER_32(TIM4_32_BASE+GPTMTAPR)
#define GPTM4_32_TBPR			REGISTER_32(TIM4_32_BASE+GPTMTBPR)
#define GPTM4_32_TAPMR			REGISTER_32(TIM4_32_BASE+GPTMTAPMR)
#define GPTM4_32_TBPMR			REGISTER_32(TIM4_32_BASE+GPTMTBPMR)
#define GPTM4_32_TAR			REGISTER_32(TIM4_32_BASE+GPTMTAR)
#define GPTM4_32_TBR			REGISTER_32(TIM4_32_BASE+GPTMTBR)
#define GPTM4_32_TAV			REGISTER_32(TIM4_32_BASE+GPTMTAV)
#define GPTM4_32_TBV			REGISTER_32(TIM4_32_BASE+GPTMTBV)
#define GPTM4_32_RTCPD			REGISTER_32(TIM4_32_BASE+GPTMRTCPD)
#define GPTM4_32_TAPS			REGISTER_32(TIM4_32_BASE+GPTMTAPS)
#define GPTM4_32_TBPS			REGISTER_32(TIM4_32_BASE+GPTMTBPS)
#define GPTM4_32_TAPV			REGISTER_32(TIM4_32_BASE+GPTMTAPV)
#define GPTM4_32_TBPV			REGISTER_32(TIM4_32_BASE+GPTMTBPV)
#define GPTM4_32_PP				REGISTER_32(TIM4_32_BASE+GPTMPP)

// T5_32
#define GPTM5_32_CFG			REGISTER_32(TIM5_32_BASE+GPTMCFG)
#define GPTM5_32_TAMR			REGISTER_32(TIM5_32_BASE+GPTMTAMR)
#define GPTM5_32_TBMR			REGISTER_32(TIM5_32_BASE+GPTMTBMR)
#define GPTM5_32_CTL			REGISTER_32(TIM5_32_BASE+GPTMCTL)
#define GPTM5_32_SYNC			REGISTER_32(TIM5_32_BASE+GPTMSYNC)
#define GPTM5_32_IMR			REGISTER_32(TIM5_32_BASE+GPTMIMR)
#define GPTM5_32_RIS			REGISTER_32(TIM5_32_BASE+GPTMRIS)
#define GPTM5_32_MIS			REGISTER_32(TIM5_32_BASE+GPTMMIS)
#define GPTM5_32_MICR			REGISTER_32(TIM5_32_BASE+GPTMMICR)
#define GPTM5_32_TAILR			REGISTER_32(TIM5_32_BASE+GPTMTAILR)
#define GPTM5_32_TBILR			REGISTER_32(TIM5_32_BASE+GPTMTBILR)
#define GPTM5_32_TAMATCHR		REGISTER_32(TIM5_32_BASE+GPTMAMATCHR)
#define GPTM5_32_TBMATCHR		REGISTER_32(TIM5_32_BASE+GPTMBMATCHR)
#define GPTM5_32_TAPR			REGISTER_32(TIM5_32_BASE+GPTMTAPR)
#define GPTM5_32_TBPR			REGISTER_32(TIM5_32_BASE+GPTMTBPR)
#define GPTM5_32_TAPMR			REGISTER_32(TIM5_32_BASE+GPTMTAPMR)
#define GPTM5_32_TBPMR			REGISTER_32(TIM5_32_BASE+GPTMTBPMR)
#define GPTM5_32_TAR			REGISTER_32(TIM5_32_BASE+GPTMTAR)
#define GPTM5_32_TBR			REGISTER_32(TIM5_32_BASE+GPTMTBR)
#define GPTM5_32_TAV			REGISTER_32(TIM5_32_BASE+GPTMTAV)
#define GPTM5_32_TBV			REGISTER_32(TIM5_32_BASE+GPTMTBV)
#define GPTM5_32_RTCPD			REGISTER_32(TIM5_32_BASE+GPTMRTCPD)
#define GPTM5_32_TAPS			REGISTER_32(TIM5_32_BASE+GPTMTAPS)
#define GPTM5_32_TBPS			REGISTER_32(TIM5_32_BASE+GPTMTBPS)
#define GPTM5_32_TAPV			REGISTER_32(TIM5_32_BASE+GPTMTAPV)
#define GPTM5_32_TBPV			REGISTER_32(TIM5_32_BASE+GPTMTBPV)
#define GPTM5_32_PP				REGISTER_32(TIM5_32_BASE+GPTMPP)

// T0_32
#define GPTM0_64_CFG			REGISTER_32(TIM0_64_BASE+GPTMCFG)
#define GPTM0_64_TAMR			REGISTER_32(TIM0_64_BASE+GPTMTAMR)
#define GPTM0_64_TBMR			REGISTER_32(TIM0_64_BASE+GPTMTBMR)
#define GPTM0_64_CTL			REGISTER_32(TIM0_64_BASE+GPTMCTL)
#define GPTM0_64_SYNC			REGISTER_32(TIM0_64_BASE+GPTMSYNC)
#define GPTM0_64_IMR			REGISTER_32(TIM0_64_BASE+GPTMIMR)
#define GPTM0_64_RIS			REGISTER_32(TIM0_64_BASE+GPTMRIS)
#define GPTM0_64_MIS			REGISTER_32(TIM0_64_BASE+GPTMMIS)
#define GPTM0_64_MICR			REGISTER_32(TIM0_64_BASE+GPTMMICR)
#define GPTM0_64_TAILR			REGISTER_32(TIM0_64_BASE+GPTMTAILR)
#define GPTM0_64_TBILR			REGISTER_32(TIM0_64_BASE+GPTMTBILR)
#define GPTM0_64_TAMATCHR		REGISTER_32(TIM0_64_BASE+GPTMAMATCHR)
#define GPTM0_64_TBMATCHR		REGISTER_32(TIM0_64_BASE+GPTMBMATCHR)
#define GPTM0_64_TAPR			REGISTER_32(TIM0_64_BASE+GPTMTAPR)
#define GPTM0_64_TBPR			REGISTER_32(TIM0_64_BASE+GPTMTBPR)
#define GPTM0_64_TAPMR			REGISTER_32(TIM0_64_BASE+GPTMTAPMR)
#define GPTM0_64_TBPMR			REGISTER_32(TIM0_64_BASE+GPTMTBPMR)
#define GPTM0_64_TAR			REGISTER_32(TIM0_64_BASE+GPTMTAR)
#define GPTM0_64_TBR			REGISTER_32(TIM0_64_BASE+GPTMTBR)
#define GPTM0_64_TAV			REGISTER_32(TIM0_64_BASE+GPTMTAV)
#define GPTM0_64_TBV			REGISTER_32(TIM0_64_BASE+GPTMTBV)
#define GPTM0_64_RTCPD			REGISTER_32(TIM0_64_BASE+GPTMRTCPD)
#define GPTM0_64_TAPS			REGISTER_32(TIM0_64_BASE+GPTMTAPS)
#define GPTM0_64_TBPS			REGISTER_32(TIM0_64_BASE+GPTMTBPS)
#define GPTM0_64_TAPV			REGISTER_32(TIM0_64_BASE+GPTMTAPV)
#define GPTM0_64_TBPV			REGISTER_32(TIM0_64_BASE+GPTMTBPV)
#define GPTM0_64_PP				REGISTER_32(TIM0_64_BASE+GPTMPP)

// T1_32
#define GPTM1_64_CFG			REGISTER_32(TIM1_64_BASE+GPTMCFG)
#define GPTM1_64_TAMR			REGISTER_32(TIM1_64_BASE+GPTMTAMR)
#define GPTM1_64_TBMR			REGISTER_32(TIM1_64_BASE+GPTMTBMR)
#define GPTM1_64_CTL			REGISTER_32(TIM1_64_BASE+GPTMCTL)
#define GPTM1_64_SYNC			REGISTER_32(TIM1_64_BASE+GPTMSYNC)
#define GPTM1_64_IMR			REGISTER_32(TIM1_64_BASE+GPTMIMR)
#define GPTM1_64_RIS			REGISTER_32(TIM1_64_BASE+GPTMRIS)
#define GPTM1_64_MIS			REGISTER_32(TIM1_64_BASE+GPTMMIS)
#define GPTM1_64_MICR			REGISTER_32(TIM1_64_BASE+GPTMMICR)
#define GPTM1_64_TAILR			REGISTER_32(TIM1_64_BASE+GPTMTAILR)
#define GPTM1_64_TBILR			REGISTER_32(TIM1_64_BASE+GPTMTBILR)
#define GPTM1_64_TAMATCHR		REGISTER_32(TIM1_64_BASE+GPTMAMATCHR)
#define GPTM1_64_TBMATCHR		REGISTER_32(TIM1_64_BASE+GPTMBMATCHR)
#define GPTM1_64_TAPR			REGISTER_32(TIM1_64_BASE+GPTMTAPR)
#define GPTM1_64_TBPR			REGISTER_32(TIM1_64_BASE+GPTMTBPR)
#define GPTM1_64_TAPMR			REGISTER_32(TIM1_64_BASE+GPTMTAPMR)
#define GPTM1_64_TBPMR			REGISTER_32(TIM1_64_BASE+GPTMTBPMR)
#define GPTM1_64_TAR			REGISTER_32(TIM1_64_BASE+GPTMTAR)
#define GPTM1_64_TBR			REGISTER_32(TIM1_64_BASE+GPTMTBR)
#define GPTM1_64_TAV			REGISTER_32(TIM1_64_BASE+GPTMTAV)
#define GPTM1_64_TBV			REGISTER_32(TIM1_64_BASE+GPTMTBV)
#define GPTM1_64_RTCPD			REGISTER_32(TIM1_64_BASE+GPTMRTCPD)
#define GPTM1_64_TAPS			REGISTER_32(TIM1_64_BASE+GPTMTAPS)
#define GPTM1_64_TBPS			REGISTER_32(TIM1_64_BASE+GPTMTBPS)
#define GPTM1_64_TAPV			REGISTER_32(TIM1_64_BASE+GPTMTAPV)
#define GPTM1_64_TBPV			REGISTER_32(TIM1_64_BASE+GPTMTBPV)
#define GPTM1_64_PP				REGISTER_32(TIM1_64_BASE+GPTMPP)

//T2_32
#define GPTM2_64_CFG			REGISTER_32(TIM2_64_BASE+GPTMCFG)
#define GPTM2_64_TAMR			REGISTER_32(TIM2_64_BASE+GPTMTAMR)
#define GPTM2_64_TBMR			REGISTER_32(TIM2_64_BASE+GPTMTBMR)
#define GPTM2_64_CTL			REGISTER_32(TIM2_64_BASE+GPTMCTL)
#define GPTM2_64_SYNC			REGISTER_32(TIM2_64_BASE+GPTMSYNC)
#define GPTM2_64_IMR			REGISTER_32(TIM2_64_BASE+GPTMIMR)
#define GPTM2_64_RIS			REGISTER_32(TIM2_64_BASE+GPTMRIS)
#define GPTM2_64_MIS			REGISTER_32(TIM2_64_BASE+GPTMMIS)
#define GPTM2_64_MICR			REGISTER_32(TIM2_64_BASE+GPTMMICR)
#define GPTM2_64_TAILR			REGISTER_32(TIM2_64_BASE+GPTMTAILR)
#define GPTM2_64_TBILR			REGISTER_32(TIM2_64_BASE+GPTMTBILR)
#define GPTM2_64_TAMATCHR		REGISTER_32(TIM2_64_BASE+GPTMAMATCHR)
#define GPTM2_64_TBMATCHR		REGISTER_32(TIM2_64_BASE+GPTMBMATCHR)
#define GPTM2_64_TAPR			REGISTER_32(TIM2_64_BASE+GPTMTAPR)
#define GPTM2_64_TBPR			REGISTER_32(TIM2_64_BASE+GPTMTBPR)
#define GPTM2_64_TAPMR			REGISTER_32(TIM2_64_BASE+GPTMTAPMR)
#define GPTM2_64_TBPMR			REGISTER_32(TIM2_64_BASE+GPTMTBPMR)
#define GPTM2_64_TAR			REGISTER_32(TIM2_64_BASE+GPTMTAR)
#define GPTM2_64_TBR			REGISTER_32(TIM2_64_BASE+GPTMTBR)
#define GPTM2_64_TAV			REGISTER_32(TIM2_64_BASE+GPTMTAV)
#define GPTM2_64_TBV			REGISTER_32(TIM2_64_BASE+GPTMTBV)
#define GPTM2_64_RTCPD			REGISTER_32(TIM2_64_BASE+GPTMRTCPD)
#define GPTM2_64_TAPS			REGISTER_32(TIM2_64_BASE+GPTMTAPS)
#define GPTM2_64_TBPS			REGISTER_32(TIM2_64_BASE+GPTMTBPS)
#define GPTM2_64_TAPV			REGISTER_32(TIM2_64_BASE+GPTMTAPV)
#define GPTM2_64_TBPV			REGISTER_32(TIM2_64_BASE+GPTMTBPV)
#define GPTM2_64_PP				REGISTER_32(TIM2_64_BASE+GPTMPP)

//T3_32
#define GPTM3_64_CFG			REGISTER_32(TIM3_64_BASE+GPTMCFG)
#define GPTM3_64_TAMR			REGISTER_32(TIM3_64_BASE+GPTMTAMR)
#define GPTM3_64_TBMR			REGISTER_32(TIM3_64_BASE+GPTMTBMR)
#define GPTM3_64_CTL			REGISTER_32(TIM3_64_BASE+GPTMCTL)
#define GPTM3_64_SYNC			REGISTER_32(TIM3_64_BASE+GPTMSYNC)
#define GPTM3_64_IMR			REGISTER_32(TIM3_64_BASE+GPTMIMR)
#define GPTM3_64_RIS			REGISTER_32(TIM3_64_BASE+GPTMRIS)
#define GPTM3_64_MIS			REGISTER_32(TIM3_64_BASE+GPTMMIS)
#define GPTM3_64_MICR			REGISTER_32(TIM3_64_BASE+GPTMMICR)
#define GPTM3_64_TAILR			REGISTER_32(TIM3_64_BASE+GPTMTAILR)
#define GPTM3_64_TBILR			REGISTER_32(TIM3_64_BASE+GPTMTBILR)
#define GPTM3_64_TAMATCHR		REGISTER_32(TIM3_64_BASE+GPTMAMATCHR)
#define GPTM3_64_TBMATCHR		REGISTER_32(TIM3_64_BASE+GPTMBMATCHR)
#define GPTM3_64_TAPR			REGISTER_32(TIM3_64_BASE+GPTMTAPR)
#define GPTM3_64_TBPR			REGISTER_32(TIM3_64_BASE+GPTMTBPR)
#define GPTM3_64_TAPMR			REGISTER_32(TIM3_64_BASE+GPTMTAPMR)
#define GPTM3_64_TBPMR			REGISTER_32(TIM3_64_BASE+GPTMTBPMR)
#define GPTM3_64_TAR			REGISTER_32(TIM3_64_BASE+GPTMTAR)
#define GPTM3_64_TBR			REGISTER_32(TIM3_64_BASE+GPTMTBR)
#define GPTM3_64_TAV			REGISTER_32(TIM3_64_BASE+GPTMTAV)
#define GPTM3_64_TBV			REGISTER_32(TIM3_64_BASE+GPTMTBV)
#define GPTM3_64_RTCPD			REGISTER_32(TIM3_64_BASE+GPTMRTCPD)
#define GPTM3_64_TAPS			REGISTER_32(TIM3_64_BASE+GPTMTAPS)
#define GPTM3_64_TBPS			REGISTER_32(TIM3_64_BASE+GPTMTBPS)
#define GPTM3_64_TAPV			REGISTER_32(TIM3_64_BASE+GPTMTAPV)
#define GPTM3_64_TBPV			REGISTER_32(TIM3_64_BASE+GPTMTBPV)
#define GPTM3_64_PP				REGISTER_32(TIM3_64_BASE+GPTMPP)

//T4_32

#define GPTM4_64_CFG			REGISTER_32(TIM4_64_BASE+GPTMCFG)
#define GPTM4_64_TAMR			REGISTER_32(TIM4_64_BASE+GPTMTAMR)
#define GPTM4_64_TBMR			REGISTER_32(TIM4_64_BASE+GPTMTBMR)
#define GPTM4_64_CTL			REGISTER_32(TIM4_64_BASE+GPTMCTL)
#define GPTM4_64_SYNC			REGISTER_32(TIM4_64_BASE+GPTMSYNC)
#define GPTM4_64_IMR			REGISTER_32(TIM4_64_BASE+GPTMIMR)
#define GPTM4_64_RIS			REGISTER_32(TIM4_64_BASE+GPTMRIS)
#define GPTM4_64_MIS			REGISTER_32(TIM4_64_BASE+GPTMMIS)
#define GPTM4_64_MICR			REGISTER_32(TIM4_64_BASE+GPTMMICR)
#define GPTM4_64_TAILR			REGISTER_32(TIM4_64_BASE+GPTMTAILR)
#define GPTM4_64_TBILR			REGISTER_32(TIM4_64_BASE+GPTMTBILR)
#define GPTM4_64_TAMATCHR		REGISTER_32(TIM4_64_BASE+GPTMAMATCHR)
#define GPTM4_64_TBMATCHR		REGISTER_32(TIM4_64_BASE+GPTMBMATCHR)
#define GPTM4_64_TAPR			REGISTER_32(TIM4_64_BASE+GPTMTAPR)
#define GPTM4_64_TBPR			REGISTER_32(TIM4_64_BASE+GPTMTBPR)
#define GPTM4_64_TAPMR			REGISTER_32(TIM4_64_BASE+GPTMTAPMR)
#define GPTM4_64_TBPMR			REGISTER_32(TIM4_64_BASE+GPTMTBPMR)
#define GPTM4_64_TAR			REGISTER_32(TIM4_64_BASE+GPTMTAR)
#define GPTM4_64_TBR			REGISTER_32(TIM4_64_BASE+GPTMTBR)
#define GPTM4_64_TAV			REGISTER_32(TIM4_64_BASE+GPTMTAV)
#define GPTM4_64_TBV			REGISTER_32(TIM4_64_BASE+GPTMTBV)
#define GPTM4_64_RTCPD			REGISTER_32(TIM4_64_BASE+GPTMRTCPD)
#define GPTM4_64_TAPS			REGISTER_32(TIM4_64_BASE+GPTMTAPS)
#define GPTM4_64_TBPS			REGISTER_32(TIM4_64_BASE+GPTMTBPS)
#define GPTM4_64_TAPV			REGISTER_32(TIM4_64_BASE+GPTMTAPV)
#define GPTM4_64_TBPV			REGISTER_32(TIM4_64_BASE+GPTMTBPV)
#define GPTM4_64_PP				REGISTER_32(TIM4_64_BASE+GPTMPP)

// T5_32
#define GPTM5_64_CFG			REGISTER_32(TIM5_64_BASE+GPTMCFG)
#define GPTM5_64_TAMR			REGISTER_32(TIM5_64_BASE+GPTMTAMR)
#define GPTM5_64_TBMR			REGISTER_32(TIM5_64_BASE+GPTMTBMR)
#define GPTM5_64_CTL			REGISTER_32(TIM5_64_BASE+GPTMCTL)
#define GPTM5_64_SYNC			REGISTER_32(TIM5_64_BASE+GPTMSYNC)
#define GPTM5_64_IMR			REGISTER_32(TIM5_64_BASE+GPTMIMR)
#define GPTM5_64_RIS			REGISTER_32(TIM5_64_BASE+GPTMRIS)
#define GPTM5_64_MIS			REGISTER_32(TIM5_64_BASE+GPTMMIS)
#define GPTM5_64_MICR			REGISTER_32(TIM5_64_BASE+GPTMMICR)
#define GPTM5_64_TAILR			REGISTER_32(TIM5_64_BASE+GPTMTAILR)
#define GPTM5_64_TBILR			REGISTER_32(TIM5_64_BASE+GPTMTBILR)
#define GPTM5_64_TAMATCHR		REGISTER_32(TIM5_64_BASE+GPTMAMATCHR)
#define GPTM5_64_TBMATCHR		REGISTER_32(TIM5_64_BASE+GPTMBMATCHR)
#define GPTM5_64_TAPR			REGISTER_32(TIM5_64_BASE+GPTMTAPR)
#define GPTM5_64_TBPR			REGISTER_32(TIM5_64_BASE+GPTMTBPR)
#define GPTM5_64_TAPMR			REGISTER_32(TIM5_64_BASE+GPTMTAPMR)
#define GPTM5_64_TBPMR			REGISTER_32(TIM5_64_BASE+GPTMTBPMR)
#define GPTM5_64_TAR			REGISTER_32(TIM5_64_BASE+GPTMTAR)
#define GPTM5_64_TBR			REGISTER_32(TIM5_64_BASE+GPTMTBR)
#define GPTM5_64_TAV			REGISTER_32(TIM5_64_BASE+GPTMTAV)
#define GPTM5_64_TBV			REGISTER_32(TIM5_64_BASE+GPTMTBV)
#define GPTM5_64_RTCPD			REGISTER_32(TIM5_64_BASE+GPTMRTCPD)
#define GPTM5_64_TAPS			REGISTER_32(TIM5_64_BASE+GPTMTAPS)
#define GPTM5_64_TBPS			REGISTER_32(TIM5_64_BASE+GPTMTBPS)
#define GPTM5_64_TAPV			REGISTER_32(TIM5_64_BASE+GPTMTAPV)
#define GPTM5_64_TBPV			REGISTER_32(TIM5_64_BASE+GPTMTBPV)
#define GPTM5_64_PP				REGISTER_32(TIM5_64_BASE+GPTMPP)

// ADC 

#define ADCACTSS			0x0000
#define ADCRIS				0x0004
#define ADCIM				0x0008
#define ADCISC				0x000c
#define ADCOSTAT			0x0010
#define ADCEMUX				0x0014
#define ADCUSTAT			0x0018
#define ADCSSPRI			0x0020
#define ADCSPC				0x0024
#define ADCPSSI				0x0028
#define ADCSAC				0x0030
#define ADCDCISC			0x0034
#define ADCCTL				0x0038
#define ADCSSMUX0			0x0040
#define ADCSSCTL0			0x0044
#define ADCSSFIFO0			0x0048
#define ADCSSFSTAT0			0x004c
#define ADCSSOP0			0x0050
#define ADCSSDC0			0x0054
#define ADCSSMUX1			0x0060
#define ADCSSCTL1			0x0064
#define ADCSSFIFO1			0x0068
#define ADCSSFSTAT1			0x006c
#define ADCSSOP1			0x0070
#define ADCSSDC1			0x0074
#define ADCSSMUX2			0x0080
#define ADCSSCTL2			0x0084
#define ADCSSFIFO2			0x0088
#define ADCSSFSTAT2			0x008c
#define ADCSSOP2			0x0090
#define ADCSSDC2			0x0094
#define ADCSSMUX3			0x00a0
#define ADCSSCTL3			0x00a4
#define ADCSSFIFO3			0x00a8
#define ADCSSFSTAT3			0x00ac
#define ADCSSOP3			0x00b0
#define ADCSSDC3			0x00b4
#define ADCDCRIC			0x0d00
#define ADCDCCTL0			0x0e00
#define ADCDCCTL1			0x0e04
#define ADCDCCTL2			0x0e08
#define ADCDCCTL3			0x0e0c
#define ADCDCCTL4			0x0e10
#define ADCDCCTL5			0x0e14
#define ADCDCCTL6			0x0e18
#define ADCDCCTL7			0x0e1c
#define ADCDCCMP0			0x0e40
#define ADCDCCMP1			0x0e44
#define ADCDCCMP2			0x0e48
#define ADCDCCMP3			0x0e4c
#define ADCDCCMP4			0x0e50
#define ADCDCCMP5			0x0e54
#define ADCDCCMP6			0x0e58
#define ADCDCCMP7			0x0e5c
#define ADCPP				0x0fc0
#define ADCPC				0x0fc4
#define ADCCC				0x0fc8


// ADC0
#define ADC0_ACTSS				REGISTER_32(ADC0_BASE+ADCACTSS)
#define ADC0_RIS				REGISTER_32(ADC0_BASE+ADCRIS)
#define ADC0_IM					REGISTER_32(ADC0_BASE+ADCIM)
#define ADC0_ISC				REGISTER_32(ADC0_BASE+ADCISC)
#define ADC0_OSTAT				REGISTER_32(ADC0_BASE+ADCOSTAT)
#define ADC0_EMUX				REGISTER_32(ADC0_BASE+ADCEMUX)
#define ADC0_USTAT				REGISTER_32(ADC0_BASE+ADCUSTAT)
#define ADC0_SSPRI				REGISTER_32(ADC0_BASE+ADCSSPRI)
#define ADC0_SPC				REGISTER_32(ADC0_BASE+ADCSPC)
#define ADC0_PSSI				REGISTER_32(ADC0_BASE+ADCPSSI)
#define ADC0_SAC				REGISTER_32(ADC0_BASE+ADCSAC)
#define ADC0_DCISC				REGISTER_32(ADC0_BASE+ADCDCISC)
#define ADC0_CTL				REGISTER_32(ADC0_BASE+ADCCTL)
#define ADC0_SSMUX0				REGISTER_32(ADC0_BASE+ADCSSMUX0)
#define ADC0_SSCTL0				REGISTER_32(ADC0_BASE+ADCSSCTL0)
#define ADC0_SSFIFO0			REGISTER_32(ADC0_BASE+ADCSSFIFO0)
#define ADC0_SSFSTAT0			REGISTER_32(ADC0_BASE+ADCSSFSTAT0)
#define ADC0_SSOP0				REGISTER_32(ADC0_BASE+ADCSSOP0)
#define ADC0_SSDC0				REGISTER_32(ADC0_BASE+ADCSSDC0)
#define ADC0_SSMUX1				REGISTER_32(ADC0_BASE+ADCSSMUX1)
#define ADC0_SSCTL1				REGISTER_32(ADC0_BASE+ADCSSCTL1)
#define ADC0_SSFIFO1			REGISTER_32(ADC0_BASE+ADCSSFIFO1)
#define ADC0_SSFSTAT1			REGISTER_32(ADC0_BASE+ADCSSFSTAT1)
#define ADC0_SSOP1				REGISTER_32(ADC0_BASE+ADCSSOP1)
#define ADC0_SSDC1				REGISTER_32(ADC0_BASE+ADCSSDC1)
#define ADC0_SSMUX2				REGISTER_32(ADC0_BASE+ADCSSMUX2)
#define ADC0_SSCTL2				REGISTER_32(ADC0_BASE+ADCSSCTL2)
#define ADC0_SSFIFO2			REGISTER_32(ADC0_BASE+ADCSSFIFO2)
#define ADC0_SSFSTAT2			REGISTER_32(ADC0_BASE+ADCSSFSTAT2)
#define ADC0_SSOP2				REGISTER_32(ADC0_BASE+ADCSSOP2)
#define ADC0_SSDC2				REGISTER_32(ADC0_BASE+ADCSSDC2)
#define ADC0_SSMUX3				REGISTER_32(ADC0_BASE+ADCSSMUX3)
#define ADC0_SSCTL3				REGISTER_32(ADC0_BASE+ADCSSCTL3)
#define ADC0_SSFIFO3			REGISTER_32(ADC0_BASE+ADCSSFIFO3)
#define ADC0_SSFSTAT3			REGISTER_32(ADC0_BASE+ADCSSFSTAT3)
#define ADC0_SSOP3				REGISTER_32(ADC0_BASE+ADCSSOP3)
#define ADC0_SSDC3				REGISTER_32(ADC0_BASE+ADCSSDC3)
#define ADC0_DCRIC				REGISTER_32(ADC0_BASE+ADCDCRIC)
#define ADC0_DCCTL0				REGISTER_32(ADC0_BASE+ADCDCCTL0)
#define ADC0_DCCTL1				REGISTER_32(ADC0_BASE+ADCDCCTL1)
#define ADC0_DCCTL2				REGISTER_32(ADC0_BASE+ADCDCCTL2)
#define ADC0_DCCTL3				REGISTER_32(ADC0_BASE+ADCDCCTL3)
#define ADC0_DCCTL4				REGISTER_32(ADC0_BASE+ADCDCCTL4)
#define ADC0_DCCTL5				REGISTER_32(ADC0_BASE+ADCDCCTL5)
#define ADC0_DCCTL6				REGISTER_32(ADC0_BASE+ADCDCCTL6)
#define ADC0_DCCTL7				REGISTER_32(ADC0_BASE+ADCDCCTL7)
#define ADC0_DCCMP0				REGISTER_32(ADC0_BASE+ADCDCCMP0)
#define ADC0_DCCMP1				REGISTER_32(ADC0_BASE+ADCDCCMP1)
#define ADC0_DCCMP2				REGISTER_32(ADC0_BASE+ADCDCCMP2)
#define ADC0_DCCMP3				REGISTER_32(ADC0_BASE+ADCDCCMP3)
#define ADC0_DCCMP4				REGISTER_32(ADC0_BASE+ADCDCCMP4)
#define ADC0_DCCMP5				REGISTER_32(ADC0_BASE+ADCDCCMP5)
#define ADC0_DCCMP6				REGISTER_32(ADC0_BASE+ADCDCCMP6)
#define ADC0_DCCMP7				REGISTER_32(ADC0_BASE+ADCDCCMP7)
#define ADC0_PP					REGISTER_32(ADC0_BASE+ADCPP)
#define ADC0_PC					REGISTER_32(ADC0_BASE+ADCPC)
#define ADC0_CC					REGISTER_32(ADC0_BASE+ADCCC)

//ADC1 
#define ADC1_ACTSS				REGISTER_32(ADC1_BASE+ADCACTSS)
#define ADC1_RIS				REGISTER_32(ADC1_BASE+ADCRIS)
#define ADC1_IM					REGISTER_32(ADC1_BASE+ADCIM)
#define ADC1_ISC				REGISTER_32(ADC1_BASE+ADCISC)
#define ADC1_OSTAT				REGISTER_32(ADC1_BASE+ADCOSTAT)
#define ADC1_EMUX				REGISTER_32(ADC1_BASE+ADCEMUX)
#define ADC1_USTAT				REGISTER_32(ADC1_BASE+ADCUSTAT)
#define ADC1_SSPRI				REGISTER_32(ADC1_BASE+ADCSSPRI)
#define ADC1_SPC				REGISTER_32(ADC1_BASE+ADCSPC)
#define ADC1_PSSI				REGISTER_32(ADC1_BASE+ADCPSSI)
#define ADC1_SAC				REGISTER_32(ADC1_BASE+ADCSAC)
#define ADC1_DCISC				REGISTER_32(ADC1_BASE+ADCDCISC)
#define ADC1_CTL				REGISTER_32(ADC1_BASE+ADCCTL)
#define ADC1_SSMUX0				REGISTER_32(ADC1_BASE+ADCSSMUX0)
#define ADC1_SSCTL0				REGISTER_32(ADC1_BASE+ADCSSCTL0)
#define ADC1_SSFIFO0			REGISTER_32(ADC1_BASE+ADCSSFIFO0)
#define ADC1_SSFSTAT0			REGISTER_32(ADC1_BASE+ADCSSFSTAT0)
#define ADC1_SSOP0				REGISTER_32(ADC1_BASE+ADCSSOP0)
#define ADC1_SSDC0				REGISTER_32(ADC1_BASE+ADCSSDC0)
#define ADC1_SSMUX1				REGISTER_32(ADC1_BASE+ADCSSMUX1)
#define ADC1_SSCTL1				REGISTER_32(ADC1_BASE+ADCSSCTL1)
#define ADC1_SSFIFO1			REGISTER_32(ADC1_BASE+ADCSSFIFO1)
#define ADC1_SSFSTAT1			REGISTER_32(ADC1_BASE+ADCSSFSTAT1)
#define ADC1_SSOP1				REGISTER_32(ADC1_BASE+ADCSSOP1)
#define ADC1_SSDC1				REGISTER_32(ADC1_BASE+ADCSSDC1)
#define ADC1_SSMUX2				REGISTER_32(ADC1_BASE+ADCSSMUX2)
#define ADC1_SSCTL2				REGISTER_32(ADC1_BASE+ADCSSCTL2)
#define ADC1_SSFIFO2			REGISTER_32(ADC1_BASE+ADCSSFIFO2)
#define ADC1_SSFSTAT2			REGISTER_32(ADC1_BASE+ADCSSFSTAT2)
#define ADC1_SSOP2				REGISTER_32(ADC1_BASE+ADCSSOP2)
#define ADC1_SSDC2				REGISTER_32(ADC1_BASE+ADCSSDC2)
#define ADC1_SSMUX3				REGISTER_32(ADC1_BASE+ADCSSMUX3)
#define ADC1_SSCTL3				REGISTER_32(ADC1_BASE+ADCSSCTL3)
#define ADC1_SSFIFO3			REGISTER_32(ADC1_BASE+ADCSSFIFO3)
#define ADC1_SSFSTAT3			REGISTER_32(ADC1_BASE+ADCSSFSTAT3)
#define ADC1_SSOP3				REGISTER_32(ADC1_BASE+ADCSSOP3)
#define ADC1_SSDC3				REGISTER_32(ADC1_BASE+ADCSSDC3)
#define ADC1_DCRIC				REGISTER_32(ADC1_BASE+ADCDCRIC)
#define ADC1_DCCTL0				REGISTER_32(ADC1_BASE+ADCDCCTL0)
#define ADC1_DCCTL1				REGISTER_32(ADC1_BASE+ADCDCCTL1)
#define ADC1_DCCTL2				REGISTER_32(ADC1_BASE+ADCDCCTL2)
#define ADC1_DCCTL3				REGISTER_32(ADC1_BASE+ADCDCCTL3)
#define ADC1_DCCTL4				REGISTER_32(ADC1_BASE+ADCDCCTL4)
#define ADC1_DCCTL5				REGISTER_32(ADC1_BASE+ADCDCCTL5)
#define ADC1_DCCTL6				REGISTER_32(ADC1_BASE+ADCDCCTL6)
#define ADC1_DCCTL7				REGISTER_32(ADC1_BASE+ADCDCCTL7)
#define ADC1_DCCMP0				REGISTER_32(ADC1_BASE+ADCDCCMP0)
#define ADC1_DCCMP1				REGISTER_32(ADC1_BASE+ADCDCCMP1)
#define ADC1_DCCMP2				REGISTER_32(ADC1_BASE+ADCDCCMP2)
#define ADC1_DCCMP3				REGISTER_32(ADC1_BASE+ADCDCCMP3)
#define ADC1_DCCMP4				REGISTER_32(ADC1_BASE+ADCDCCMP4)
#define ADC1_DCCMP5				REGISTER_32(ADC1_BASE+ADCDCCMP5)
#define ADC1_DCCMP6				REGISTER_32(ADC1_BASE+ADCDCCMP6)
#define ADC1_DCCMP7				REGISTER_32(ADC1_BASE+ADCDCCMP7)
#define ADC1_PP					REGISTER_32(ADC1_BASE+ADCPP)
#define ADC1_PC					REGISTER_32(ADC1_BASE+ADCPC)
#define ADC1_CC					REGISTER_32(ADC1_BASE+ADCCC)

// ACMP
// ACMP OFFSETS
#define ACMIS				0x0000
#define ACRIS				0x0004
#define ACINTEN				0x0008
#define ACREFCTL			0x0010
#define ACSTAT0				0x0020
#define ACCTL0				0x0024
#define ACSTAT1				0x0040
#define ACCTL1				0x0044
#define ACMPPP				0x0fc0

// ACMP addresses

#define AC_MIS					REGISTER_32(ACMP_BASE+ACMIS)
#define AC_RIS					REGISTER_32(ACMP_BASE+ACRIS)
#define AC_INTEN				REGISTER_32(ACMP_BASE+ACINTEN)
#define AC_REFCTL				REGISTER_32(ACMP_BASE+ACREFCTL)
#define AC_STAT0				REGISTER_32(ACMP_BASE+ACSTAT0)
#define AC_CTL0					REGISTER_32(ACMP_BASE+ACCTL0)
#define AC_STAT1				REGISTER_32(ACMP_BASE+ACSTAT1)
#define AC_CTL1					REGISTER_32(ACMP_BASE+ACCTL1)
#define AC_MPPP					REGISTER_32(ACMP_BASE+ACMPPP)

// CAN Controller
#define CANCTL				0x0000
#define CANSTS				0x0004
#define CANERR				0x0008
#define CANBIT				0x000c
#define CANINT				0x0010
#define CANTST				0x0014
#define CANBRPE				0x0018
#define CANIF1CRQ			0x0020
#define CANIF1CMSK			0x0024
#define CANIF1MSK1			0x0028
#define CANIF1MSK2			0x002c
#define CANIF1ARB1			0x0030
#define CANIF1ARB2			0x0034
#define CANIF1MCTL			0x0038
#define CANIF1DA1			0x003c
#define CANIF1DA2			0x0040
#define CANIF1DB1			0x0044
#define CANIF1DB2			0x0048
#define CANIF2CRQ			0x0080
#define CANIF2CMSK			0x0084
#define CANIF2MSK1			0x0088
#define CANIF2MSK2			0x008c
#define CANIF2ARB1			0x0090
#define CANIF2ARB2			0x0094
#define CANIF2MCTL			0x0098
#define CANIF2DA1			0x009c
#define CANIF2DA2			0x00a0
#define CANIF2DB1			0x00a4
#define CANIF2DB2			0x00a8
#define CANTXRQ1			0x0100
#define CANTXRQ2			0x0104
#define CANNWDA1			0x0120
#define CANNWDA2			0x0124
#define CANMSG1INT			0x0140
#define CANMSG2INT			0x0144
#define CANMSG1VAL			0x0160
#define CANMSG2VAL			0x0164


// CAN0
#define CAN0_CTL				REGISTER_32(CAN0_BASE+CANCTL)
#define CAN0_STS				REGISTER_32(CAN0_BASE+CANSTS)
#define CAN0_ERR				REGISTER_32(CAN0_BASE+CANERR)
#define CAN0_BIT				REGISTER_32(CAN0_BASE+CANBIT)
#define CAN0_INT				REGISTER_32(CAN0_BASE+CANINT)
#define CAN0_TST				REGISTER_32(CAN0_BASE+CANTST)
#define CAN0_BRPE				REGISTER_32(CAN0_BASE+CANBRPE)
#define CAN0_IF1CRQ				REGISTER_32(CAN0_BASE+CANIF1CRQ)
#define CAN0_IF1CMSK			REGISTER_32(CAN0_BASE+CANIF1CMSK)
#define CAN0_IF1MSK1			REGISTER_32(CAN0_BASE+CANIF1MSK1)
#define CAN0_IF1MSK2			REGISTER_32(CAN0_BASE+CANIF1MSK2)
#define CAN0_IF1ARB1			REGISTER_32(CAN0_BASE+CANIF1ARB1)
#define CAN0_IF1ARB2			REGISTER_32(CAN0_BASE+CANIF1ARB2)
#define CAN0_IF1MCTL			REGISTER_32(CAN0_BASE+CANIF1MCTL)
#define CAN0_IF1DA1				REGISTER_32(CAN0_BASE+CANIF1DA1)
#define CAN0_IF1DA2				REGISTER_32(CAN0_BASE+CANIF1DA2)
#define CAN0_IF1DB1				REGISTER_32(CAN0_BASE+CANIF1DB1)
#define CAN0_IF1DB2				REGISTER_32(CAN0_BASE+CANIF1DB2)
#define CAN0_IF2CRQ				REGISTER_32(CAN0_BASE+CANIF2CRQ)
#define CAN0_IF2CMSK			REGISTER_32(CAN0_BASE+CANIF2CMSK)
#define CAN0_IF2MSK1			REGISTER_32(CAN0_BASE+CANIF2MSK1)
#define CAN0_IF2MSK2			REGISTER_32(CAN0_BASE+CANIF2MSK2)
#define CAN0_IF2ARB1			REGISTER_32(CAN0_BASE+CANIF2ARB1)
#define CAN0_IF2ARB2			REGISTER_32(CAN0_BASE+CANIF2ARB2)
#define CAN0_IF2MCTL			REGISTER_32(CAN0_BASE+CANIF2MCTL)
#define CAN0_IF2DA1				REGISTER_32(CAN0_BASE+CANIF2DA1)
#define CAN0_IF2DA2				REGISTER_32(CAN0_BASE+CANIF2DA2)
#define CAN0_IF2DB1				REGISTER_32(CAN0_BASE+CANIF2DB1)
#define CAN0_IF2DB2				REGISTER_32(CAN0_BASE+CANIF2DB2)
#define CAN0_TXRQ1				REGISTER_32(CAN0_BASE+CANTXRQ1)
#define CAN0_TXRQ2				REGISTER_32(CAN0_BASE+CANTXRQ2)
#define CAN0_NWDA1				REGISTER_32(CAN0_BASE+CANNWDA1)
#define CAN0_NWDA2				REGISTER_32(CAN0_BASE+CANNWDA2)
#define CAN0_MSG1INT			REGISTER_32(CAN0_BASE+CANMSG1INT)
#define CAN0_MSG2INT			REGISTER_32(CAN0_BASE+CANMSG2INT)
#define CAN0_MSG1VAL			REGISTER_32(CAN0_BASE+CANMSG1VAL)
#define CAN0_MSG2VAL			REGISTER_32(CAN0_BASE+CANMSG2VAL)

// USB
// USB OFFSETS
#define USBFADDR			0x0000
#define USBPOWER			0x0001
#define USBTXIS				0x0002
#define USBRXIS				0x0004
#define USBTXIE				0x0006
#define USBRXIE				0x0008
#define USBIS				0x000a
#define USBIE				0x000b
#define USBFRAME			0x000c
#define USBEPIDX			0x000e
#define USBTEST				0x000f
#define USBFIFO0			0x0020
#define USBFIFO1			0x0024
#define USBFIFO2			0x0028
#define USBFIFO3			0x002c
#define USBFIFO4			0x0030
#define USBFIFO5			0x0034
#define USBFIFO6			0x0038
#define USBFIFO7			0x003c
#define USBTXFIFOSZ			0x0062
#define USBRXFIFOSZ			0x0063
#define USBTXFIFOADD		0x0064
#define USBRXFIFOADD		0x0066
#define USBCONTIM			0x007a
#define USBFSEOF			0x007d
#define USBLSEOF			0x007e
#define USBCSRL0			0x0102
#define USBCSRH0			0x0103
#define USBCOUNT0			0x0108
#define USBTXMAXP1			0x0110
#define USBTXCSRL1			0x0112
#define USBTXCSRH1			0x0113
#define USBRXMAXP1			0x0114
#define USBRXCSRL1			0x0116
#define USBRXCSRH1			0x0117
#define USBRXCOUNT1			0x0118
#define USBTXMAXP2			0x0120
#define USBTXCSRL2			0x0122
#define USBTXCSRH2			0x0123
#define USBRXMAXP2			0x0124
#define USBRXCSRL2			0x0126
#define USBRXCSRH2			0x0127
#define USBTXMAXP3			0x0130
#define USBTXCSRL3			0x0132
#define USBTXCSRH3			0x0133
#define USBRXMAXP3			0x0134
#define USBRXCSRL3			0x0136
#define USBRXCSRH3			0x0137
#define USBRXCOUNT3			0x0138

#define USBTXMAXP4			0x0140
#define USBTXCSRL4			0x0142
#define USBTXCSRH4			0x0143
#define USBRXMAXP4			0x0144
#define USBRXCSRL4			0x0146
#define USBRXCSRH4			0x0147
#define USBRXCOUNT4			0x0148

#define USBTXMAXP5			0x0150
#define USBTXCSRL5			0x0152
#define USBTXCSRH5			0x0153
#define USBRXMAXP5			0x0154
#define USBRXCSRL5			0x0156
#define USBRXCSRH5			0x0157
#define USBRXCOUNT5			0x0158

#define USBTXMAXP6			0x0160
#define USBTXCSRL6			0x0162
#define USBTXCSRH6			0x0163
#define USBRXMAXP6			0x0164
#define USBRXCSRL6			0x0166
#define USBRXCSRH6			0x0167
#define USBRXCOUNT6			0x0168

#define USBTXMAXP7			0x0170
#define USBTXCSRL7			0x0172
#define USBTXCSRH7			0x0173
#define USBRXMAXP7			0x0174
#define USBRXCSRL7			0x0176
#define USBRXCSRH7			0x0177
#define USBRXCOUNT7			0x0178

#define USBRXDPKTBUFDIS		0x0340
#define USBTXDPKRBUFDIS		0x0342
#define USBDRRIS			0x0410
#define USBDRIM				0x0414
#define USBDRISC			0x0418
#define USBDMASEL			0x0450
#define USBPP				0xfc0

// USB addresses
#define USB_FADDR			REGISTER_8USB_BASE+USBFADDR)
#define USB_POWER			REGISTER_8USB_BASE+USBPOWER)
#define USB_TXIS			REGISTER_16USB_BASE+USBTXIS)
#define USB_RXIS			REGISTER_16USB_BASE+USBRXIS)
#define USB_TXIE			REGISTER_16USB_BASE+USBTXIE)
#define USB_RXIE			REGISTER_16USB_BASE+USBRXIE)
#define USB_IS				REGISTER_8USB_BASE+USBIS)
#define USB_IE				REGISTER_8USB_BASE+USBIE)
#define USB_FRAME			REGISTER_16USB_BASE+USBFRAME)
#define USB_EPIDX			REGISTER_8USB_BASE+USBEPIDX)
#define USB_TEST			REGISTER_8USB_BASE+USBTEST)
#define USB_FIFO0			REGISTER_32USB_BASE+USBFIFO0)
#define USB_FIFO1			REGISTER_32USB_BASE+USBFIFO1)
#define USB_FIFO2			REGISTER_32USB_BASE+USBFIFO2)
#define USB_FIFO3			REGISTER_32USB_BASE+USBFIFO3)
#define USB_FIFO4			REGISTER_32USB_BASE+USBFIFO4)
#define USB_FIFO5			REGISTER_32USB_BASE+USBFIFO5)
#define USB_FIFO6			REGISTER_32USB_BASE+USBFIFO6)
#define USB_FIFO7			REGISTER_32USB_BASE+USBFIFO7)
#define USB_TXFIFOSZ		REGISTER_8USB_BASE+USBTXFIFOSZ)
#define USB_RXFIFOSZ		REGISTER_8USB_BASE+USBRXFIFOSZ)
#define USB_TXFIFOADD		REGISTER_16USB_BASE+USBTXFIFOADD)
#define USB_RXFIFOADD		REGISTER_16USB_BASE+USBRXFIFOADD)
#define USB_CONTIM			REGISTER_8USB_BASE+USBCONTIM)
#define USB_FSEOF			REGISTER_8USB_BASE+USBFSEOF)
#define USB_LSEOF			REGISTER_8USB_BASE+USBLSEOF)
#define USB_CSRL0			REGISTER_8USB_BASE+USBCSRL0)
#define USB_CSRH0			REGISTER_8USB_BASE+USBCSRH0)
#define USB_COUNT0			REGISTER_8USB_BASE+USBCOUNT0)
#define USB_TXMAXP1			REGISTER_16USB_BASE+USBTXMAXP1)
#define USB_TXCSRL1			REGISTER_8USB_BASE+USBTXCSRL1)
#define USB_TXCSRH1			REGISTER_8USB_BASE+USBTXCSRH1)
#define USB_RXMAXP1			REGISTER_16USB_BASE+USBRXMAXP1)
#define USB_RXCSRL1			REGISTER_8USB_BASE+USBRXCSRL1)
#define USB_RXCSRH1			REGISTER_8USB_BASE+USBRXCSRH1)
#define USB_RXCOUNT1		REGISTER_16USB_BASE+USBRXCOUNT1)
#define USB_TXMAXP2			REGISTER_16USB_BASE+USBTXMAXP1)
#define USB_TXCSRL2			REGISTER_8USB_BASE+USBTXCSRL2)
#define USB_TXCSRH2			REGISTER_8USB_BASE+USBTXCSRH2)
#define USB_RXMAXP2			REGISTER_16USB_BASE+USBRXMAXP2)
#define USB_RXCSRL2			REGISTER_8USB_BASE+USBRXCSRL2)
#define USB_RXCSRH2			REGISTER_8USB_BASE+USBRXCSRH2)
#define USB_TXMAXP3			REGISTER_16USB_BASE+USBTXMAXP3)
#define USB_TXCSRL3			REGISTER_8USB_BASE+USBTXCSRL3)
#define USB_TXCSRH3			REGISTER_8USB_BASE+USBTXCSRH3)
#define USB_RXMAXP3			REGISTER_16USB_BASE+USBRXMAXP3)
#define USB_RXCSRL3			REGISTER_8USB_BASE+USBRXCSRL3)
#define USB_RXCSRH3			REGISTER_8USB_BASE+USBRXCSRH3)
#define USB_RXCOUNT3		REGISTER_16USB_BASE+USBRXCOUNT3)

#define USB_TXMAXP4			REGISTER_16USB_BASE+USBTXMAXP4)
#define USB_TXCSRL4			REGISTER_8USB_BASE+USBTXCSRL4)
#define USB_TXCSRH4			REGISTER_8USB_BASE+USBTXCSRH4)
#define USB_RXMAXP4			REGISTER_16USB_BASE+USBRXMAXP4)
#define USB_RXCSRL4			REGISTER_8USB_BASE+USBRXCSRL4)
#define USB_RXCSRH4			REGISTER_8USB_BASE+USBRXCSRH4)
#define USB_RXCOUNT4		REGISTER_16USB_BASE+USBRXCOUNT4)

#define USB_TXMAXP5			REGISTER_16USB_BASE+USBTXMAXP5)
#define USB_TXCSRL5			REGISTER_8USB_BASE+USBTXCSRL5)
#define USB_TXCSRH5			REGISTER_8USB_BASE+USBTXCSRH5)
#define USB_RXMAXP5			REGISTER_16USB_BASE+USBRXMAXP5)
#define USB_RXCSRL5			REGISTER_8USB_BASE+USBRXCSRL5)
#define USB_RXCSRH5			REGISTER_8USB_BASE+USBRXCSRH5)
#define USB_RXCOUNT5		REGISTER_16USB_BASE+USBRXCOUNT5)

#define USB_TXMAXP6			REGISTER_16USB_BASE+USBTXMAXP6)
#define USB_TXCSRL6			REGISTER_8USB_BASE+USBTXCSRL6)
#define USB_TXCSRH6			REGISTER_8USB_BASE+USBTXCSRH6)
#define USB_RXMAXP6			REGISTER_16USB_BASE+USBRXMAXP6)
#define USB_RXCSRL6			REGISTER_8USB_BASE+USBRXCSRL6)
#define USB_RXCSRH6			REGISTER_8USB_BASE+USBRXCSRH6)
#define USB_RXCOUNT6		REGISTER_16(USB_BASE+USBRXCOUNT6)

#define USB_TXMAXP7			REGISTER_16USB_BASE+USBTXMAXP7)
#define USB_TXCSRL7			REGISTER_8USB_BASE+USBTXCSRL7)
#define USB_TXCSRH7			REGISTER_8USB_BASE+USBTXCSRH7)
#define USB_RXMAXP7			REGISTER_16USB_BASE+USBRXMAXP7)
#define USB_RXCSRL7			REGISTER_8USB_BASE+USBRXCSRL7)
#define USB_RXCSRH7			REGISTER_8USB_BASE+USBRXCSRH7)
#define USB_RXCOUNT7		REGISTER_16USB_BASE+USBRXCOUNT7)

#define USB_RXDPKTBUFDIS	REGISTER_16USB_BASE+USBRXDPKTBUFDIS)
#define USB_TXDPKRBUFDIS	REGISTER_16USB_BASE+USBTXDPKRBUFDIS)
#define USB_DRRIS			REGISTER_32USB_BASE+USBDRRIS)
#define USB_DRIM			REGISTER_32USB_BASE+USBDRIM)
#define USB_DRISC			REGISTER_32USB_BASE+USBDRISC)
#define USB_DMASEL			REGISTER_32USB_BASE+USBDMASEL)
#define USB_PP				REGISTER_32USB_BASE+USBPP)

// EEPROM
// EEPROM Offsets
#define EESIZE			0x0000
#define EEBLOCK			0x0004
#define EEOFFSET		0x0008
#define EERDWR			0x0010
#define EERDWRINC		0x0014
#define EEDONE			0x0018
#define EESUPP			0x001c
#define EEUNLOCK		0x0020
#define EEPROT			0x0030
#define EEPASS0			0x0034
#define EEPASS1			0x0038
#define EEPASS2			0x003c
#define EEINT			0x0040
#define EEHIDE			0x0050
#define EEDBGME			0x0080
#define EEPROMPP		0x0fc0


// EEPROM Addresses
#define EE_SIZE				REGISTER_32(EEPROM_BASE+EESIZE)
#define EE_BLOCK			REGISTER_32(EEPROM_BASE+EEBLOCK)
#define EE_OFFSET			REGISTER_32(EEPROM_BASE+EEOFFSET)
#define EE_RDWR				REGISTER_32(EEPROM_BASE+EERDWR)
#define EE_RDWRINC			REGISTER_32(EEPROM_BASE+EERDWRINC)
#define EE_DONE				REGISTER_32(EEPROM_BASE+EEDONE)
#define EE_SUPP				REGISTER_32(EEPROM_BASE+EESUPP)
#define EE_UNLOCK			REGISTER_32(EEPROM_BASE+EEUNLOCK)
#define EE_PROT				REGISTER_32(EEPROM_BASE+EEPROT)
#define EE_PASS0			REGISTER_32(EEPROM_BASE+EEPASS0)
#define EE_PASS1			REGISTER_32(EEPROM_BASE+EEPASS1)
#define EE_PASS2			REGISTER_32(EEPROM_BASE+EEPASS2)
#define EE_INT				REGISTER_32(EEPROM_BASE+EEINT)
#define EE_HIDE				REGISTER_32(EEPROM_BASE+EEHIDE)
#define EE_DBGME			REGISTER_32(EEPROM_BASE+EEDBGME)
#define EE_PROMPP			REGISTER_32(EEPROM_BASE+EEPROMPP)


// System exception module
// system exception module offsets
#define SYSEXCRIS		0x0000
#define SYSEXCIM		0x0004
#define SYSEXCMIS		0x0008
#define SYSEXCIC		0x000c

// SYSEX addresses
#define SYSEX_CRIS			REGISTER_32(SYSEX_BASE+SYSEXCRIS)
#define SYSEX_CIM			REGISTER_32(SYSEX_BASE+SYSEXCIM)
#define SYSEX_CMIS			REGISTER_32(SYSEX_BASE+SYSEXCMIS)
#define SYSEX_CIC			REGISTER_32(SYSEX_BASE+SYSEXCIC)

// Hibernation module
// Hibernation offsets
#define HIBRTCC			0x0000
#define HIBRTCM0		0x0004
#define HIBRTCLD		0x000c
#define HIBCTL			0x0010

// Hibernation module addresses
#define HIB_RTCC			REGISTER_32(HIB_BASE+HIBRTCC)
#define HIB_RTCM0			REGISTER_32(HIB_BASE+HIBRTCM0)
#define HIB_RTCLD			REGISTER_32(HIB_BASE+HIBRTCLD)
#define HIB_HIBCTL			REGISTER_32(HIB_BASE+HIBCTL)


// Flash memory control
// Flash memory offsets
#define FMA				0x0000
#define FMD				0x0004
#define FMC				0x0008
#define FCRIS			0x000c
#define FCIM			0x0010
#define FCMISC			0x0014
#define FMC2			0x0020
#define FWBVAL			0x0030
#define FWB				0x0100
#define FSIZE			0x0fc0
#define SSIZE			0x0fc4
#define ROMSWMAP		0x0fcc

#define FLASH_MA			REGISTER_32(FLASH_BASE+FMA)
#define FLASH_MD			REGISTER_32(FLASH_BASE+FMD)
#define FLASH_MC			REGISTER_32(FLASH_BASE+FMC)
#define FLASH_CRIS			REGISTER_32(FLASH_BASE+FCRIS)
#define FLASH_CIM			REGISTER_32(FLASH_BASE+FCIM)
#define FLASH_CMISC			REGISTER_32(FLASH_BASE+FCMISC)
#define FLASH_MC2			REGISTER_32(FLASH_BASE+FMC2)
#define FLASH_WBVAL			REGISTER_32(FLASH_BASE+FWBVAL)
// The following is an array of values
#define FLASH_WB			(((volatile unsigned int *)(FLASH_BASE+FWB)))
#define FLASH_SIZE			REGISTER_32(FLASH_BASE+FSIZE)
// slight departure from naming convention here.
#define FLASH_SSIZE			REGISTER_32(FLASH_BASE+SSIZE)
#define FLASH_ROMSWMAP		REGISTER_32(FLASH_BASE+ROMSWMAP)


// System control module
// SYSCTL Offsets
#define	DID0		0x000
#define	DID1		0x004
#define	DC0			0x008
#define	DC1			0x010
#define	DC2			0x014
#define	DC3			0x018
#define	DC4			0x01c
#define	DC5			0x020
#define	DC6			0x024
#define	DC7			0x028
#define	DC8			0x02c
#define	PBORCTL		0x030
#define	SRCR0		0x040
#define	SRCR1		0x044
#define	SRCR2		0x048
#define	RIS			0x050
#define	IMC			0x054
#define	MISC		0x058
#define	RESC		0x05c
#define	RCC			0x060
#define	GPIOHBCTL	0x06c
#define	RCC2		0x070
#define	MOSCCTL		0x07c
#define	RMCTL		0x00f0
#define	RCGC0		0x100
#define	RCGC1		0x104
#define	RCGC2		0x108
#define	SCGC0		0x110
#define	SCGC1		0x114
#define	SCGC2		0x118
#define	DCGC0		0x120
#define	DCGC1		0x124
#define	DCGC2		0x128
#define	FMPRE0		0x0130
#define	FMPPE0		0x0134
#define	DSLPCLKCFG	0x144
#define	SYSPROP		0x14c
#define	PIOSCCAL	0x150
#define	PIOSCSTAT	0x154
#define	PLLFREQ0	0x160
#define	PLLFREQ1	0x164
#define	PLLSTAT		0x168
#define	DC9			0x190
#define	BOOTCFG		0x01d0
#define	NVMSTAT		0x1a0
#define	USER_REG0	0x01e0
#define	USER_REG1	0x01e4
#define	USER_REG2	0x01e8
#define	USER_REG3	0x01ec
#define	FMPRE1		0x0204
#define	FMPRE2		0x0208
#define	FMPRE3		0x020c
#define	PPWD		0x300
#define	PPTIMER		0x304
#define	PPGPIO		0x308
#define	PPDMA		0x30c
#define	PPHIB		0x314
#define	PPUART		0x318
#define	PPSSI		0x31c
#define	PPI2C		0x320
#define	PPUSB		0x328
#define	PPCAN		0x334
#define	PPADC		0x338
#define	PPACMP		0x33c
#define	PPPWM		0x340
#define	PPQEI		0x344
#define	PPEEPROM	0x358
#define	PPWTIMER	0x35c
#define	FMPPE1		0x0404
#define	FMPPE2		0x0408
#define	FMPPE3		0x040c
#define	SRWD		0x500
#define	SRTIMER		0x504
#define	SRGPIO		0x508
#define	SRDMA		0x50c
#define	SRHIB		0x514
#define	SRUART		0x518
#define	SRSSI		0x51c
#define	SRI2C		0x520
#define	SRUSB		0x528
#define	SRCAN		0x534
#define	SRADC		0x538
#define	SRACMP		0x53c
#define	SREEPROM	0x558
#define	SRWTIMER	0x55c
#define	RCGCWD		0x600
#define	RCGCTIMER	0x604
#define	RCGCGPIO	0x608
#define	RCGCDMA		0x60c
#define	RCGCHIB		0x614
#define	RCGCUART	0x618
#define	RCGCSSI		0x61c
#define	RCGCI2C		0x620
#define	RCGCUSB		0x628
#define	RCGCCAN		0x634
#define	RCGCADC		0x638
#define	RCGCACMP	0x63c
#define	RCGCEEPROM	0x658
#define	RCGCWTIMER	0x65c
#define	SCGCWD		0x700
#define	SCGCTIMER	0x704
#define	SCGCGPIO	0x708
#define	SCGCDMA		0x70c
#define	SCGCHIB		0x714
#define	SCGCUART	0x718
#define	SCGCSSI		0x71c
#define	SCGCI2C		0x720
#define	SCGCUSB		0x728
#define	SCGCCAN		0x734
#define	SCGCADC		0x738
#define	SCGCACMP	0x73c
#define	SCGCEEPROM	0x758
#define	SCGCWTIMER	0x75c
#define	DCGCWD		0x800
#define	DCGCTIMER	0x804
#define	DCGCGPIO	0x808
#define	DCGCDMA		0x80c
#define	DCGCHIB		0x814
#define	DCGCUART	0x818
#define	DCGCSSI		0x81c
#define	DCGCI2C		0x820
#define	DCGCUSB		0x828
#define	DCGCCAN		0x834
#define	DCGCADC		0x838
#define	DCGCACMP	0x83c
#define	DCGCEEPROM	0x858
#define	DCGCWTIMER	0x85c
#define	PRWD		0xa00
#define	PRTIMER		0xa04
#define	PRGPIO		0xa08
#define	PRDMA		0xa0c
#define	PRHIB		0xa14
#define	PRUART		0xa18
#define	PRSSI		0xa1c
#define	PRI2C		0xa20
#define	PRUSB		0xa28
#define	PRCAN		0xa34
#define	PRADC		0xa38
#define	PRACMP		0xa3c
#define	PREEPROM	0xa58
#define	PRWTIMER	0xa5c


// SYSCTL Addresses
// All addresses in the System control area are prefixed with SYSCTL_

#define	SYSCTL_DID0				REGISTER_32(SYSCTL_BASE+DID0)
#define	SYSCTL_DID1				REGISTER_32(SYSCTL_BASE+DID1)
#define	SYSCTL_DC0				REGISTER_32(SYSCTL_BASE+DC0)
#define	SYSCTL_DC1				REGISTER_32(SYSCTL_BASE+DC1)
#define	SYSCTL_DC2				REGISTER_32(SYSCTL_BASE+DC2)
#define	SYSCTL_DC3				REGISTER_32(SYSCTL_BASE+DC3)
#define	SYSCTL_DC4				REGISTER_32(SYSCTL_BASE+DC4)
#define	SYSCTL_DC5				REGISTER_32(SYSCTL_BASE+DC5)
#define	SYSCTL_DC6				REGISTER_32(SYSCTL_BASE+DC6)
#define	SYSCTL_DC7				REGISTER_32(SYSCTL_BASE+DC7)
#define	SYSCTL_DC8				REGISTER_32(SYSCTL_BASE+DC8)
#define	SYSCTL_PBORCTL			REGISTER_32(SYSCTL_BASE+PBORCTL)
#define	SYSCTL_SRCR0			REGISTER_32(SYSCTL_BASE+SRCR0)
#define	SYSCTL_SRCR1			REGISTER_32(SYSCTL_BASE+SRCR1)
#define	SYSCTL_SRCR2			REGISTER_32(SYSCTL_BASE+SRCR2)
#define	SYSCTL_RIS				REGISTER_32(SYSCTL_BASE+RIS)
#define	SYSCTL_IMC				REGISTER_32(SYSCTL_BASE+IMC)
#define	SYSCTL_MISC				REGISTER_32(SYSCTL_BASE+MISC)
#define	SYSCTL_RESC				REGISTER_32(SYSCTL_BASE+RESC)
#define	SYSCTL_RCC				REGISTER_32(SYSCTL_BASE+RCC)
#define	SYSCTL_GPIOHBCTL		REGISTER_32(SYSCTL_BASE+GPIOHBCTL)
#define	SYSCTL_RCC2				REGISTER_32(SYSCTL_BASE+RCC2)
#define	SYSCTL_MOSCCTL			REGISTER_32(SYSCTL_BASE+MOSCCTL)
#define	SYSCTL_RMCTL			REGISTER_32(SYSCTL_BASE+RMCTL)
#define	SYSCTL_RCGC0			REGISTER_32(SYSCTL_BASE+RCGC0)
#define	SYSCTL_RCGC1			REGISTER_32(SYSCTL_BASE+RCGC1)
#define	SYSCTL_RCGC2			REGISTER_32(SYSCTL_BASE+RCGC2)
#define	SYSCTL_SCGC0			REGISTER_32(SYSCTL_BASE+SCGC0)
#define	SYSCTL_SCGC1			REGISTER_32(SYSCTL_BASE+SCGC1)
#define	SYSCTL_SCGC2			REGISTER_32(SYSCTL_BASE+SCGC2)
#define	SYSCTL_DCGC0			REGISTER_32(SYSCTL_BASE+DCGC0)
#define	SYSCTL_DCGC1			REGISTER_32(SYSCTL_BASE+DCGC1)
#define	SYSCTL_DCGC2			REGISTER_32(SYSCTL_BASE+DCGC2)
#define	SYSCTL_FMPRE0			REGISTER_32(SYSCTL_BASE+FMPRE0)
#define	SYSCTL_FMPPE0			REGISTER_32(SYSCTL_BASE+FMPPE0)
#define	SYSCTL_DSLPCLKCFG		REGISTER_32(SYSCTL_BASE+DSLPCLKCFG)
#define	SYSCTL_SYSPROP			REGISTER_32(SYSCTL_BASE+SYSPROP)
#define	SYSCTL_PIOSCCAL			REGISTER_32(SYSCTL_BASE+PIOSCCAL)
#define	SYSCTL_PIOSCSTAT		REGISTER_32(SYSCTL_BASE+PIOSCSTAT)
#define	SYSCTL_PLLFREQ0			REGISTER_32(SYSCTL_BASE+PLLFREQ0)
#define	SYSCTL_PLLFREQ1			REGISTER_32(SYSCTL_BASE+PLLFREQ1)
#define	SYSCTL_PLLSTAT			REGISTER_32(SYSCTL_BASE+PLLSTAT)
#define	SYSCTL_DC9				REGISTER_32(SYSCTL_BASE+DC9)
#define	SYSCTL_BOOTCFG			REGISTER_32(SYSCTL_BASE+BOOTCFG)
#define	SYSCTL_NVMSTAT			REGISTER_32(SYSCTL_BASE+NVMSTAT)
#define	SYSCTL_USER_REG0		REGISTER_32(SYSCTL_BASE+USER_REG0)
#define	SYSCTL_USER_REG1		REGISTER_32(SYSCTL_BASE+USER_REG1)
#define	SYSCTL_USER_REG2		REGISTER_32(SYSCTL_BASE+USER_REG2)
#define	SYSCTL_USER_REG3		REGISTER_32(SYSCTL_BASE+USER_REG3)
#define	SYSCTL_FMPRE1			REGISTER_32(SYSCTL_BASE+FMPRE1)
#define	SYSCTL_FMPRE2			REGISTER_32(SYSCTL_BASE+FMPRE2)
#define	SYSCTL_FMPRE3			REGISTER_32(SYSCTL_BASE+FMPRE3)
#define	SYSCTL_PPWD				REGISTER_32(SYSCTL_BASE+PPWD)
#define	SYSCTL_PPTIMER			REGISTER_32(SYSCTL_BASE+PPTIMER)
#define	SYSCTL_PPGPIO			REGISTER_32(SYSCTL_BASE+PPGPIO)
#define	SYSCTL_PPDMA			REGISTER_32(SYSCTL_BASE+PPDMA)
#define	SYSCTL_PPHIB			REGISTER_32(SYSCTL_BASE+PPHIB)
#define	SYSCTL_PPUART			REGISTER_32(SYSCTL_BASE+PPUART)
#define	SYSCTL_PPSSI			REGISTER_32(SYSCTL_BASE+PPSSI)
#define	SYSCTL_PPI2C			REGISTER_32(SYSCTL_BASE+PPI2C)
#define	SYSCTL_PPUSB			REGISTER_32(SYSCTL_BASE+PPUSB)
#define	SYSCTL_PPCAN			REGISTER_32(SYSCTL_BASE+PPCAN)
#define	SYSCTL_PPADC			REGISTER_32(SYSCTL_BASE+PPADC)
#define	SYSCTL_PPACMP			REGISTER_32(SYSCTL_BASE+PPACMP)
#define	SYSCTL_PPPWM			REGISTER_32(SYSCTL_BASE+PPPWM)
#define	SYSCTL_PPQEI			REGISTER_32(SYSCTL_BASE+PPQEI)
#define	SYSCTL_PPEEPROM			REGISTER_32(SYSCTL_BASE+PPEEPROM)
#define	SYSCTL_PPWTIMER			REGISTER_32(SYSCTL_BASE+PPWTIMER)
#define	SYSCTL_FMPPE1			REGISTER_32(SYSCTL_BASE+FMPPE1)
#define	SYSCTL_FMPPE2			REGISTER_32(SYSCTL_BASE+FMPPE2)
#define	SYSCTL_FMPPE3			REGISTER_32(SYSCTL_BASE+FMPPE3)
#define	SYSCTL_SRWD				REGISTER_32(SYSCTL_BASE+SRWD)
#define	SYSCTL_SRTIMER			REGISTER_32(SYSCTL_BASE+SRTIMER)
#define	SYSCTL_SRGPIO			REGISTER_32(SYSCTL_BASE+SRGPIO)
#define	SYSCTL_SRDMA			REGISTER_32(SYSCTL_BASE+SRDMA)
#define	SYSCTL_SRHIB			REGISTER_32(SYSCTL_BASE+SRHIB)
#define	SYSCTL_SRUART			REGISTER_32(SYSCTL_BASE+SRUART)
#define	SYSCTL_SRSSI			REGISTER_32(SYSCTL_BASE+SRSSI)
#define	SYSCTL_SRI2C			REGISTER_32(SYSCTL_BASE+SRI2C)
#define	SYSCTL_SRUSB			REGISTER_32(SYSCTL_BASE+SRUSB)
#define	SYSCTL_SRCAN			REGISTER_32(SYSCTL_BASE+SRCAN)
#define	SYSCTL_SRADC			REGISTER_32(SYSCTL_BASE+SRADC)
#define	SYSCTL_SRACMP			REGISTER_32(SYSCTL_BASE+SRACMP)
#define	SYSCTL_SREEPROM			REGISTER_32(SYSCTL_BASE+SREEPROM)
#define	SYSCTL_SRWTIMER			REGISTER_32(SYSCTL_BASE+SRWTIMER)
#define	SYSCTL_RCGCWD			REGISTER_32(SYSCTL_BASE+RCGCWD)
#define	SYSCTL_RCGCTIMER		REGISTER_32(SYSCTL_BASE+RCGCTIMER)
#define	SYSCTL_RCGCGPIO			REGISTER_32(SYSCTL_BASE+RCGCGPIO)
#define	SYSCTL_RCGCDMA			REGISTER_32(SYSCTL_BASE+RCGCDMA)
#define	SYSCTL_RCGCHIB			REGISTER_32(SYSCTL_BASE+RCGCHIB)
#define	SYSCTL_RCGCUART			REGISTER_32(SYSCTL_BASE+RCGCUART)
#define	SYSCTL_RCGCSSI			REGISTER_32(SYSCTL_BASE+RCGCSSI)
#define	SYSCTL_RCGCI2C			REGISTER_32(SYSCTL_BASE+RCGCI2C)
#define	SYSCTL_RCGCUSB			REGISTER_32(SYSCTL_BASE+RCGCUSB)
#define	SYSCTL_RCGCCAN			REGISTER_32(SYSCTL_BASE+RCGCCAN)
#define	SYSCTL_RCGCADC			REGISTER_32(SYSCTL_BASE+RCGCADC)
#define	SYSCTL_RCGCACMP			REGISTER_32(SYSCTL_BASE+RCGCACMP)
#define	SYSCTL_RCGCEEPROM		REGISTER_32(SYSCTL_BASE+RCGCEEPROM)
#define	SYSCTL_RCGCWTIMER		REGISTER_32(SYSCTL_BASE+RCGCWTIMER)
#define	SYSCTL_SCGCWD			REGISTER_32(SYSCTL_BASE+SCGCWD)
#define	SYSCTL_SCGCTIMER		REGISTER_32(SYSCTL_BASE+SCGCTIMER)
#define	SYSCTL_SCGCGPIO			REGISTER_32(SYSCTL_BASE+SCGCGPIO)
#define	SYSCTL_SCGCDMA			REGISTER_32(SYSCTL_BASE+SCGCDMA)
#define	SYSCTL_SCGCHIB			REGISTER_32(SYSCTL_BASE+SCGCHIB)
#define	SYSCTL_SCGCUART			REGISTER_32(SYSCTL_BASE+SCGCUART)
#define	SYSCTL_SCGCSSI			REGISTER_32(SYSCTL_BASE+SCGCSSI)
#define	SYSCTL_SCGCI2C			REGISTER_32(SYSCTL_BASE+SCGCI2C)
#define	SYSCTL_SCGCUSB			REGISTER_32(SYSCTL_BASE+SCGCUSB)
#define	SYSCTL_SCGCCAN			REGISTER_32(SYSCTL_BASE+SCGCCAN)
#define	SYSCTL_SCGCADC			REGISTER_32(SYSCTL_BASE+SCGCADC)
#define	SYSCTL_SCGCACMP			REGISTER_32(SYSCTL_BASE+SCGCACMP)
#define	SYSCTL_SCGCEEPROM		REGISTER_32(SYSCTL_BASE+SCGCEEPROM)
#define	SYSCTL_SCGCWTIMER		REGISTER_32(SYSCTL_BASE+SCGCWTIMER)
#define	SYSCTL_DCGCWD			REGISTER_32(SYSCTL_BASE+DCGCWD)
#define	SYSCTL_DCGCTIMER		REGISTER_32(SYSCTL_BASE+DCGCTIMER)
#define	SYSCTL_DCGCGPIO			REGISTER_32(SYSCTL_BASE+DCGCGPIO)
#define	SYSCTL_DCGCDMA			REGISTER_32(SYSCTL_BASE+DCGCDMA)
#define	SYSCTL_DCGCHIB			REGISTER_32(SYSCTL_BASE+DCGCHIB)
#define	SYSCTL_DCGCUART			REGISTER_32(SYSCTL_BASE+DCGCUART)
#define	SYSCTL_DCGCSSI			REGISTER_32(SYSCTL_BASE+DCGCSSI)
#define	SYSCTL_DCGCI2C			REGISTER_32(SYSCTL_BASE+DCGCI2C)
#define	SYSCTL_DCGCUSB			REGISTER_32(SYSCTL_BASE+DCGCUSB)
#define	SYSCTL_DCGCCAN			REGISTER_32(SYSCTL_BASE+DCGCCAN)
#define	SYSCTL_DCGCADC			REGISTER_32(SYSCTL_BASE+DCGCADC)
#define	SYSCTL_DCGCACMP			REGISTER_32(SYSCTL_BASE+DCGCACMP)
#define	SYSCTL_DCGCEEPROM		REGISTER_32(SYSCTL_BASE+DCGCEEPROM)
#define	SYSCTL_DCGCWTIMER		REGISTER_32(SYSCTL_BASE+DCGCWTIMER)
#define	SYSCTL_PRWD				REGISTER_32(SYSCTL_BASE+PRWD)
#define	SYSCTL_PRTIMER			REGISTER_32(SYSCTL_BASE+PRTIMER)
#define	SYSCTL_PRGPIO			REGISTER_32(SYSCTL_BASE+PRGPIO)
#define	SYSCTL_PRDMA			REGISTER_32(SYSCTL_BASE+PRDMA)
#define	SYSCTL_PRHIB			REGISTER_32(SYSCTL_BASE+PRHIB)
#define	SYSCTL_PRUART			REGISTER_32(SYSCTL_BASE+PRUART)
#define	SYSCTL_PRSSI			REGISTER_32(SYSCTL_BASE+PRSSI)
#define	SYSCTL_PRI2C			REGISTER_32(SYSCTL_BASE+PRI2C)
#define	SYSCTL_PRUSB			REGISTER_32(SYSCTL_BASE+PRUSB)
#define	SYSCTL_PRCAN			REGISTER_32(SYSCTL_BASE+PRCAN)
#define	SYSCTL_PRADC			REGISTER_32(SYSCTL_BASE+PRADC)
#define	SYSCTL_PRACMP			REGISTER_32(SYSCTL_BASE+PRACMP)
#define	SYSCTL_PREEPROM			REGISTER_32(SYSCTL_BASE+PREEPROM)
#define	SYSCTL_PRWTIMER			REGISTER_32(SYSCTL_BASE+PRWTIMER)

// uDMA
// uDMA offsets
// The following three values are offsets from the contents of the DMA Channel control table base
// No absolute addresses will be defined for these as the base register changes at runtime
#define DMASRCENDP		0x0000
#define DMADSTENDP		0x0004
#define DMACHCTL		0x0008
// The following are offsets from uDMA base address register
#define DMSTAT			0x0000
#define DMACFG			0x0004
#define DMACTLBASE		0x0008
#define DMAALTBASE		0x000c
#define DMAWAITSTAT		0x0010
#define DMASWREQ		0x0014
#define DMAUSEBURSTSET	0x0018
#define DMAUSEBURSTCLR	0x001c
#define DMAREQMASKSET	0x0020
#define DMAREQMASKCLR	0x0024
#define DMAENASET		0x0028
#define DMAENACLR		0x002c
#define DMAALTSET		0x0030
#define DMAALTCLR		0x0034
#define DMAPRIOSET		0x0038
#define DMAPRIOCLR		0x003c
#define DMAERRCLR		0x004c
#define DMACHASGN		0x0500
#define DMACHIS			0x0504
#define DMACHMAP0		0x0510
#define DMACHMAP1		0x0514
#define DMACHMAP2		0x0518
#define DMACHMAP3		0x051c
#define DMAPeriphID4	0x0fd0
#define DMAPeriphID0	0x0fe0
#define DMAPeriphID1	0x0fe4
#define DMAPeriphID2	0x0fe8
#define DMAPeriphID3	0x0fec
#define DMAPCellID0		0x0ff0
#define DMAPCellID1		0x0ff4
#define DMAPCellID2		0x0ff8
#define DMAPCellID3		0x0ffc

  
// Cortex M4 (internal) peripherals  
// Offsets
#define ACTLR 			0x008
#define STCTRL 			0x010
#define STRELOAD 		0x014
#define STCURRENT 		0x018
#define EN0		 		0x100
#define EN1				0x104
#define EN2				0x108
#define EN3				0x10c
#define EN4				0x110
#define DIS0			0x180
#define DIS1			0x184
#define DIS2			0x188
#define DIS3			0x18c
#define DIS4			0x190
#define PEND0			0x200
#define PEND1			0x204
#define PEND2			0x208
#define PEND3			0x20c
#define PEND4			0x210
#define UNPEND0			0x280
#define UNPEND1			0x284
#define UNPEND2			0x288
#define UNPEND3			0x28c
#define UNPEND4			0x290
#define ACTIVE0			0x300
#define ACTIVE1			0x304
#define ACTIVE2			0x308
#define ACTIVE3			0x30c
#define ACTIVE4			0x310
#define PRI0			0x400
#define PRI1			0x404
#define PRI2			0x408
#define PRI3			0x40c
#define PRI4			0x410
#define PRI5			0x414
#define PRI6			0x418
#define PRI7			0x41c
#define PRI8			0x420
#define PRI9			0x424
#define PRI10			0x428
#define PRI11			0x42c
#define PRI12			0x430
#define PRI13			0x434
#define PRI14			0x438
#define PRI15			0x43c
#define PRI16			0x440
#define PRI17			0x444
#define PRI18			0x448
#define PRI19			0x44c
#define PRI20			0x450
#define PRI21			0x454
#define PRI22			0x458
#define PRI23			0x45c
#define PRI24			0x460
#define PRI25			0x464
#define PRI26			0x468
#define PRI27			0x46c
#define PRI28			0x470
#define PRI29			0x474
#define PRI30			0x478
#define PRI31			0x47c
#define PRI32			0x480
#define PRI33			0x484
#define PRI34			0x488
#define CPUID			0xd00
#define INTCTRL			0xd04
#define VTABLE			0xd08
#define APINT			0xd0c
#define SYSCTRL			0xd10
#define CFGCTRL			0xd14
#define SYSPRI1			0xd18
#define SYSPRI2			0xd1c
#define SYSPRI3			0xd20
#define SYSHNDCTRL		0xd24
#define FAULTSTAT		0xd28
#define HFAULTSTAT		0xd2c
#define MMADDR			0xd34
#define FAULTADDR		0xd38
#define CPAC			0xd88
#define MPUTYPE			0xd90
#define MPUCTRL			0xd94
#define MPUNUMBER		0xd98
#define MPUBASE			0xd9c
#define MPUATTR			0xda0
#define MPUBASE1		0xda4
#define MPUATTR1		0xda8
#define MPUBASE2		0xdac
#define MPUATTR2		0xdb0
#define MPUBASE3		0xdb4
#define MPUATTR3		0xdb8
#define SWTRIG			0xf00
#define FPCC			0xf34
#define FPCA			0xf38
#define FPDSC			0xf3c

// Cortex M4 (internal) peripherals  
// Addresses (all prefixed with SYS_)

#define SYS_ACTLR  			REGISTER_32(SYS_BASE+ ACTLR )
#define SYS_STCTRL			REGISTER_32(SYS_BASE+ STCTRL )
#define SYS_STRELOAD		REGISTER_32(SYS_BASE+ STRELOAD )
#define SYS_STCURRENT		REGISTER_32(SYS_BASE+ STCURRENT )
#define SYS_EN0				REGISTER_32(SYS_BASE+ EN0 )
#define SYS_EN1				REGISTER_32(SYS_BASE+ EN1 )
#define SYS_EN2				REGISTER_32(SYS_BASE+ EN2 )
#define SYS_EN3				REGISTER_32(SYS_BASE+ EN3 )
#define SYS_EN4				REGISTER_32(SYS_BASE+ EN4 )
#define SYS_DIS0			REGISTER_32(SYS_BASE+ DIS0 )
#define SYS_DIS1			REGISTER_32(SYS_BASE+ DIS1 )
#define SYS_DIS2			REGISTER_32(SYS_BASE+ DIS2 )
#define SYS_DIS3			REGISTER_32(SYS_BASE+ DIS3 )
#define SYS_DIS4			REGISTER_32(SYS_BASE+ DIS4 )
#define SYS_PEND0			REGISTER_32(SYS_BASE+ PEND0 )
#define SYS_PEND1			REGISTER_32(SYS_BASE+ PEND1 )
#define SYS_PEND2			REGISTER_32(SYS_BASE+ PEND2 )
#define SYS_PEND3			REGISTER_32(SYS_BASE+ PEND3 )
#define SYS_PEND4			REGISTER_32(SYS_BASE+ PEND4 )
#define SYS_UNPEND0			REGISTER_32(SYS_BASE+ UNPEND0 )
#define SYS_UNPEND1			REGISTER_32(SYS_BASE+ UNPEND1 )
#define SYS_UNPEND2			REGISTER_32(SYS_BASE+ UNPEND2 )
#define SYS_UNPEND3			REGISTER_32(SYS_BASE+ UNPEND3 )
#define SYS_UNPEND4			REGISTER_32(SYS_BASE+ UNPEND4 )
#define SYS_ACTIVE0			REGISTER_32(SYS_BASE+ ACTIVE0 )
#define SYS_ACTIVE1			REGISTER_32(SYS_BASE+ ACTIVE1 )
#define SYS_ACTIVE2			REGISTER_32(SYS_BASE+ ACTIVE2 )
#define SYS_ACTIVE3			REGISTER_32(SYS_BASE+ ACTIVE3 )
#define SYS_ACTIVE4			REGISTER_32(SYS_BASE+ ACTIVE4 )
#define SYS_PRI0			REGISTER_32(SYS_BASE+ PRI0 )
#define SYS_PRI1			REGISTER_32(SYS_BASE+ PRI1 )
#define SYS_PRI2			REGISTER_32(SYS_BASE+ PRI2 )
#define SYS_PRI3			REGISTER_32(SYS_BASE+ PRI3 )
#define SYS_PRI4			REGISTER_32(SYS_BASE+ PRI4 )
#define SYS_PRI5			REGISTER_32(SYS_BASE+ PRI5 )
#define SYS_PRI6			REGISTER_32(SYS_BASE+ PRI6 )
#define SYS_PRI7			REGISTER_32(SYS_BASE+ PRI7 )
#define SYS_PRI8			REGISTER_32(SYS_BASE+ PRI8 )
#define SYS_PRI9			REGISTER_32(SYS_BASE+ PRI9 )
#define SYS_PRI10			REGISTER_32(SYS_BASE+ PRI10 )
#define SYS_PRI11			REGISTER_32(SYS_BASE+ PRI11 )
#define SYS_PRI12			REGISTER_32(SYS_BASE+ PRI12 )
#define SYS_PRI13			REGISTER_32(SYS_BASE+ PRI13 )
#define SYS_PRI14			REGISTER_32(SYS_BASE+ PRI14 )
#define SYS_PRI15			REGISTER_32(SYS_BASE+ PRI15 )
#define SYS_PRI16			REGISTER_32(SYS_BASE+ PRI16 )
#define SYS_PRI17			REGISTER_32(SYS_BASE+ PRI17 )
#define SYS_PRI18			REGISTER_32(SYS_BASE+ PRI18 )
#define SYS_PRI19			REGISTER_32(SYS_BASE+ PRI19 )
#define SYS_PRI20			REGISTER_32(SYS_BASE+ PRI20 )
#define SYS_PRI21			REGISTER_32(SYS_BASE+ PRI21 )
#define SYS_PRI22			REGISTER_32(SYS_BASE+ PRI22 )
#define SYS_PRI23			REGISTER_32(SYS_BASE+ PRI23 )
#define SYS_PRI24			REGISTER_32(SYS_BASE+ PRI24 )
#define SYS_PRI25			REGISTER_32(SYS_BASE+ PRI25 )
#define SYS_PRI26			REGISTER_32(SYS_BASE+ PRI26 )
#define SYS_PRI27			REGISTER_32(SYS_BASE+ PRI27 )
#define SYS_PRI28			REGISTER_32(SYS_BASE+ PRI28 )
#define SYS_PRI29			REGISTER_32(SYS_BASE+ PRI29 )
#define SYS_PRI30			REGISTER_32(SYS_BASE+ PRI30 )
#define SYS_PRI31			REGISTER_32(SYS_BASE+ PRI31 )
#define SYS_PRI32			REGISTER_32(SYS_BASE+ PRI32 )
#define SYS_PRI33			REGISTER_32(SYS_BASE+ PRI33 )
#define SYS_PRI34			REGISTER_32(SYS_BASE+ PRI34 )
#define SYS_CPUID			REGISTER_32(SYS_BASE+ CPUID )
#define SYS_INTCTRL			REGISTER_32(SYS_BASE+ INTCTRL )
#define SYS_VTABLE			REGISTER_32(SYS_BASE+ VTABLE )
#define SYS_APINT			REGISTER_32(SYS_BASE+ APINT )
#define SYS_SYSCTRL			REGISTER_32(SYS_BASE+ SYSCTRL )
#define SYS_CFGCTRL			REGISTER_32(SYS_BASE+ CFGCTRL )
#define SYS_SYSPRI1			REGISTER_32(SYS_BASE+ SYSPRI1 )
#define SYS_SYSPRI2			REGISTER_32(SYS_BASE+ SYSPRI2 )
#define SYS_SYSPRI3			REGISTER_32(SYS_BASE+ SYSPRI3 )
#define SYS_SYSHNDCTRL		REGISTER_32(SYS_BASE+ SYSHNDCTRL )
#define SYS_FAULTSTAT		REGISTER_32(SYS_BASE+ FAULTSTAT )
#define SYS_HFAULTSTAT		REGISTER_32(SYS_BASE+ HFAULTSTAT )
#define SYS_MMADDR			REGISTER_32(SYS_BASE+ MMADDR )
#define SYS_FAULTADDR		REGISTER_32(SYS_BASE+ FAULTADDR )
#define SYS_CPAC			REGISTER_32(SYS_BASE+ CPAC )
#define SYS_MPUTYPE			REGISTER_32(SYS_BASE+ MPUTYPE )
#define SYS_MPUCTRL			REGISTER_32(SYS_BASE+ MPUCTRL )
#define SYS_MPUNUMBER		REGISTER_32(SYS_BASE+ MPUNUMBER )
#define SYS_MPUBASE			REGISTER_32(SYS_BASE+ MPUBASE )
#define SYS_MPUATTR			REGISTER_32(SYS_BASE+ MPUATTR )
#define SYS_MPUBASE1		REGISTER_32(SYS_BASE+ MPUBASE1 )
#define SYS_MPUATTR1		REGISTER_32(SYS_BASE+ MPUATTR1 )
#define SYS_MPUBASE2		REGISTER_32(SYS_BASE+ MPUBASE2 )
#define SYS_MPUATTR2		REGISTER_32(SYS_BASE+ MPUATTR2 )
#define SYS_MPUBASE3		REGISTER_32(SYS_BASE+ MPUBASE3 )
#define SYS_MPUATTR3		REGISTER_32(SYS_BASE+ MPUATTR3 )
#define SYS_SWTRIG			REGISTER_32(SYS_BASE+ SWTRIG )
#define SYS_FPCC			REGISTER_32(SYS_BASE+ FPCC )
#define SYS_FPCA			REGISTER_32(SYS_BASE+ FPCA )
#define SYS_FPDSC			REGISTER_32(SYS_BASE+ FPDSC )
