/*
 * MLX90640_I2C_Driver.c
 *
 */

#include <stdint.h>
#include <stdio.h>
#include <stdbool.h>

#include <string.h>

#include <./inc/tm4c123gh6pm.h>

#include <inc/hw_memmap.h>

#include <inc/hw_types.h>

#include <driverlib/gpio.h>

#include <driverlib/pin_map.h>

#include <driverlib/sysctl.h>

#include <driverlib/uart.h>

#include <driverlib/i2c.h>



#include <MLX90640_I2C_Driver.h>
#include <MLX90640_API.h>
uint32_t check1,check2;

#define MLX90640_I2C_RESET_ADDR 0x00
#define MLX90640_I2C_RESET_COMMAND 0x06
#define MLX90640_I2C_TIMEOUT 10000 // Timeout value for I2C communication
#define I2C_SUCCESS 0
#define I2C_NACK -1
#define I2C_DATA_MISMATCH -2
uint32_t g_ui32SysClock;



void MLX90640_I2CInit()
{
    //SysCtlClockSet(SYSCTL_SYSDIV_5 | SYSCTL_USE_PLL | SYSCTL_XTAL_16MHZ |
    //                       SYSCTL_OSC_MAIN);
    check1 = SysCtlClockGet();

    SYSCTL_RCGCI2C_R    |= 0x08;                /* enable clock to I2C3         */
    SYSCTL_RCGCGPIO_R   |= (1<<3);              /* enable clock to GPIOD       */
    GPIO_PORTD_AFSEL_R  |= ((1<<0)|(1<<1));     /* PORTE 0, 1 for I2C3          */
    GPIO_PORTD_PCTL_R   |= ((3<<0)|(3<<4));   /* PORTD 0, 1 for I2C3          */
    GPIO_PORTD_DEN_R    |= 0x03;                /* PORTD 0, 1 as digital pins   */
    GPIO_PORTD_ODR_R    |= 0x02;                /* PORTD 2 as open drain        */
    I2C3_MCR_R = 0x10;                          /* master mode                  */
    I2C3_MTPR_R = 1;
//    GPIOPinTypeI2C(GPIO_PORTD_BASE, GPIO_PIN_1);
//    IntMasterEnable();
//    I2CMasterEnable(I2C3_BASE);
//    I2CMasterInitExpClk(I2C3_BASE,SysCtlClockGet(), true);

    //SysCtlDelay(100);

}




//Set I2C Freq, in kHz
//MLX90640_I2CFreqSet(1000) sets frequency to 1MHz
void MLX90640_I2CFreqSet()
{
    I2CMasterEnable(I2C3_BASE);
    I2CMasterInitExpClk(I2C3_BASE, g_ui32SysClock, 0);
    SysCtlDelay(100);
}


static int I2C3_wait_till_done(void)
{
    while(I2C3_MCS_R & 1);        /* wait until I2C master is not busy  */
    return I2C3_MCS_R & 0xE;      /* return I2C error code              */
}



//Write two bytes to a two byte address


/* Read memory */

int MLX90640_I2CRead(uint8_t slaveAddr,uint16_t memAddr, uint16_t nMemAddressRead, uint16_t *data)
{
    int error;
    char L_Byte, H_Byte;

    if (nMemAddressRead <= 0)
        return -1; /* no read was performed */

    /* send slave address and starting address */
    I2C3_MSA_R = slaveAddr << 1;
    I2C3_MDR_R = (memAddr >> 8);
    //I2C3_MDR_R = ((memAddr & 0xFF00) >> 8);
    I2C3_MCS_R = 3; /* S-(saddr+w)-ACK-maddr-ACK */
    error = I2C3_wait_till_done(); /* wait until write is complete */
    if(error) return error;

    I2C3_MDR_R = (memAddr & 0xFF);
    I2C3_MCS_R = 1; //Continue in Transmitting STATE
    error = I2C3_wait_till_done(); /* wait until write is complete */
    if(error) return error;

    /* to change bus from write to read, send restart with slave addr */
    I2C3_MSA_R = (slaveAddr << 1) + 1; /* restart: -R-(saddr+r)-ACK */

    if(nMemAddressRead == 1 ) /* if last byte, don't ack */
    {
        I2C3_MCS_R = 0xB; /* -data-ACK- */
        error = I2C3_wait_till_done();
        if(error) return error;
        H_Byte = I2C3_MDR_R; /* store the data received */

        I2C3_MCS_R = 5; /* -data-NACK-P */
        error = I2C3_wait_till_done();
        if(error) return error;
        L_Byte = I2C3_MDR_R; /* store the data received */

        *data++ = (H_Byte << 8) | (L_Byte);
    }
    else /* else ack */
    {
        I2C3_MCS_R = 0xB; /* -data-ACK- */
        error = I2C3_wait_till_done();
        if(error) return error;
        H_Byte = I2C3_MDR_R; /* store the data received */

        I2C3_MCS_R = 9; //Continue Receiving
        error = I2C3_wait_till_done();
        if(error) return error;
        L_Byte = I2C3_MDR_R; /* store the data received */

        *data++ = (H_Byte << 8) | (L_Byte);
    }

    if( --nMemAddressRead == 0 )
    { /* if single word read, done */
        while(I2C3_MCS_R & 0x40 ) ; /* wait until bus is not busy */
        return 0; /* no error */
    }

    /* read the rest of the bytes */
    while( nMemAddressRead > 1 )
    {
        I2C3_MCS_R = 0x9; //Continue Receiving
        error = I2C3_wait_till_done();
        if(error) return error;
        H_Byte = I2C3_MDR_R; /* store the data received */

        I2C3_MCS_R = 9; //Continue Receiving
        error = I2C3_wait_till_done();
        if(error) return error;
        L_Byte = I2C3_MDR_R; /* store the data received */

        *data++ = (H_Byte << 8) | (L_Byte);

        nMemAddressRead--;
        //uart_write(data);
    }

    I2C3_MCS_R = 0x9; //Continue Receiving
    error = I2C3_wait_till_done();
    if(error) return error;
    H_Byte = I2C3_MDR_R; /* store the data received */

    I2C3_MCS_R = 5; /* -data-NACK-P */
    error = I2C3_wait_till_done();
    if(error) return error;
    L_Byte = I2C3_MDR_R; /* store the data received */

    *data = (H_Byte << 8) | (L_Byte);


    while( I2C3_MCS_R & 0x40 ); /* wait until bus is not busy */

    return 0; /* no error */
}


/* Write one byte only */
/* byte write: S-(saddr+w)-ACK-maddr-ACK-data-ACK-P */
int MLX90640_I2CWrite(uint8_t slaveAddr,uint16_t memAddr, uint16_t data)
{
    int error;

    /* send slave address and starting address */
    I2C3_MSA_R = slaveAddr << 1;
    I2C3_MDR_R = (memAddr >> 8);
    I2C3_MCS_R = 3; /* S-(saddr+w)-ACK-maddr-ACK */
    error = I2C3_wait_till_done(); /* wait until write is complete */
    if(error) return error;

    I2C3_MDR_R = (memAddr & 0xFF);
    I2C3_MCS_R = 1; //Continue in Transmitting STATE
    error = I2C3_wait_till_done(); /* wait until write is complete */
    if(error) return error;

    /* send data */
    I2C3_MDR_R = (data >> 8);
    I2C3_MCS_R = 1; //Continue in Transmitting STATE
    error = I2C3_wait_till_done(); /* wait until write is complete */
    //while( I2C3_MCS_R & 0x40 ) ; /* wait until bus is not busy */
    error = I2C3_MCS_R & 0xE;
    if(error) return error;

    I2C3_MDR_R = (data & 0xFF);
    I2C3_MCS_R = 5; /* -data-ACK-P */
    error = I2C3_wait_till_done(); /* wait until write is complete */
    while( I2C3_MCS_R & 0x40 ) ; /* wait until bus is not busy */
    error = I2C3_MCS_R & 0xE;
    if(error) return error;

    return 0; /* no error */
}



int MLX90640_I2CGeneralReset(void) {
    int error;

    // Send the reset command (0x06) to address 0x00
    I2C3_MSA_R = MLX90640_I2C_RESET_ADDR << 1;
    I2C3_MDR_R = MLX90640_I2C_RESET_COMMAND;
    I2C3_MCS_R = 3; // S-(saddr+w)-ACK-maddr-ACK
    error = I2C3_wait_till_done();
    if (error) {
        return -1; // NACK occurred during communication
    }

    return 0; // Communication successful
}

void
InitConsole(void)
{
    SysCtlPeripheralEnable(SYSCTL_PERIPH_UART0);
    SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOA);

    GPIOPinConfigure(GPIO_PA0_U0RX);
    GPIOPinConfigure(GPIO_PA1_U0TX);
    GPIOPinTypeUART(GPIO_PORTA_BASE, GPIO_PIN_0 | GPIO_PIN_1);
    UARTConfigSetExpClk(UART0_BASE, SysCtlClockGet(), 115200,(UART_CONFIG_WLEN_8 | UART_CONFIG_STOP_ONE | UART_CONFIG_PAR_NONE));

}


void uart_write( uint16_t data ){
    uint16_t d;
    d = data;
    char v[6];
    v[4]= (d%10)+48;
    d = d/10;
    v[3] = (d%10)+48;
    d = d/10;
    v[2] = (d%10)+48;
    d = d/10;
    v[1] = (d%10)+48;
    d = d/10;
    v[0] = (d%10)+48;
    v[5] = '\0';
    int j=0;
    //UARTCharPut(UART0_BASE,'\n');
    while(v[j] != '\0'){
        UARTCharPut(UART0_BASE, v[j]);
        j = j + 1;
    }
    //UARTCharPut(UART0_BASE,'\n');
    //UARTCharPut(UART0_BASE, '\r');
}

void float_to_string(float num, char *str) {
    int whole = (int)num; // Extract the whole part
    float fraction = num - whole; // Extract the fractional part
    int i = 0;

    // Convert the whole part to string
    while (whole != 0) {
        str[i++] = '0' + (whole % 10);
        whole /= 10;
    }
    if (i == 0) {
        str[i++] = '0'; // If whole part is zero, add '0'
    }
    str[i] = '\0'; // Null-terminate the string
    // Reverse the string
    int start = 0;
    int end = i - 1;
    while (start < end) {
        char temp = str[start];
        str[start] = str[end];
        str[end] = temp;
        start++;
        end--;
    }

    // Append decimal point
    str[i++] = '.';

    // Convert the fractional part to string
    for (int j = 0; j < 2; ++j) {
        fraction *= 10;
        int digit = (int)fraction;
        str[i++] = '0' + digit;
        fraction -= digit;
    }

    str[i] = '\0'; // Null-terminate the string
}



void uartPrint(char data[]){
    int j=0;
    UARTCharPut(UART0_BASE,'\n');
    while(data[j] != '\0'){
        UARTCharPut(UART0_BASE, data[j]);
        j = j + 1;
    }
    UARTCharPut(UART0_BASE,'\n');
    UARTCharPut(UART0_BASE, '\r');

}


