
#include <stdint.h>

#include <stdbool.h>

#include "inc/tm4c123gh6pm.h"

#define ADC_channels 3//1)referance 2)current 3)speed

float temp_result=0;

int ADC_buff[ADC_channels];

float Nx[]={7.51,1};//1,0.133

float Nu=0.284;

float K[]={96.5517,1.5284};     //(96.5517    1.5284 for 0,0) //now poles at 0.8,0.8  3.5561,0.3114

//float KI=0.09;

int result;

float duty1=0;

float duty2=0;

float meas=0;

float Kp=2.5;

        float Ki=0.0001;

        int PF4=0;

        int PF1=0;

        int PD0=0;

        int PE3=0;

        int PD2=0;

        int PE2=0;

        int PD3=0;

        int PE1=0;

float u_hat;

float D;

float Ref=0.09375;

//float omega_feedback=0;

//float current_feedback=0;

//float omega_pridicted=0;

//float current_pridicted=0;

float c_meas;

//float W_prev;

//float integrator_op_predicted=0;

//float integrator_op_present_step=0;

//float error=0;

int k=0;

float W_meas=0;

int count=1;

void delayMs(int n);

void PWM_init_PF3(int freq_khz,float initial_duty);

void PWM_init_PE4(int freq,float initial_duty);

void clock_configuration();

//void PWM1GEN3_ISR();

void PWM0GEN2_ISR();

void ADC_SS2_ISR(void);

void EnableInterrupts(void);

void SPI_config(void);

void SSI1_Write(int data);

//int gpio_toggle=0;

int start_motor_flag=0;

int calculate_flag=0;

int main(void)

{

    clock_configuration();

    PWM_init_PF3(2,0.25); //this runs at 10khz, provides gate pulses

    PWM_init_PE4(8,0.5);//this runs at 100hz, samples the signals

    //ADC_config();

    SPI_config();

    NVIC_EN0_R = 0x00010000;//enable interrupt for ADC0 SS2

    EnableInterrupts();

    GPIO_PORTD_DIR_R |= 0x00;//PA4

    GPIO_PORTD_DEN_R |= 0xFF;

    GPIO_PORTE_DIR_R |= 0x00;//PA4

    GPIO_PORTE_DEN_R |= 0xEF;

    GPIO_PORTF_DIR_R |= 0x00;//PA4

    GPIO_PORTF_DEN_R |= 0xF7;

    //_____________________________________________________________________________________________________________________________

    while(1)

    {

        if(calculate_flag==1)

        {

            calculate_flag=0;


        }

    }

}


/* delay n milliseconds (16 MHz CPU clock) */

void delayMs(int n)

{

    int i, j;

    for(i = 0 ; i < n; i++)

        for(j = 0; j < 3180; j++)

            {}  /* do nothing for 1 ms */

}

void PWM_init_PF3(int freq,float initial_duty)

{

    /* Enable port PF3 for PWM1 M1PWM7 */

        GPIO_PORTF_AFSEL_R = 8;      /* PF3 uses alternate function */

        GPIO_PORTF_PCTL_R &= ~0x0000F000; /* make PF3 PWM output pin */

        GPIO_PORTF_PCTL_R |= 0x00005000;

        GPIO_PORTF_DEN_R |= 8;       /* pin digital */

        PWM1_3_CTL_R = 0x02;            /* stop counter */

        PWM1_3_GENB_R = 0x000000E0;  /* M1PWM7 output set when reload, */

        PWM1_3_LOAD_R = (int)8000/freq;       /* set load value for 10kHz (16MHz/1600) */

        PWM1_3_CMPA_R = (int)((8000/freq)*initial_duty);       /* set duty cycle to 0.5 */

        PWM1_3_CTL_R = 0x03;            /* start timer */

        PWM1_ENABLE_R = 0x80;        /* start PWM1 ch7 */

}

void PWM_init_PE4(int freq,float initial_duty)

{

    /* Enable port PE4 for PWM0 M0PWM4 */

        GPIO_PORTE_AFSEL_R = 0x10;      /* PE4 uses alternate function */

        GPIO_PORTE_PCTL_R &= ~0x000F0000; /* make PE4 PWM output pin */

        GPIO_PORTE_PCTL_R |= 0x00040000;

        GPIO_PORTE_DEN_R |= 0x10;       /* pin digital */

        PWM0_2_CTL_R = 0x02;            /* stop counter */

        PWM0_2_GENA_R = 0x000000E0;  /* M0PWM4 output set when reload, */

        //PWM0_2_LOAD_R = (int)16000/freq;       /* set load value for 10kHz (16MHz/1600) */

        PWM0_2_LOAD_R = (int)4000; //4000===500

        //PWM0_2_CMPA_R = (int)((16000/freq)*initial_duty);       /* set duty cycle to 0.5 */

        PWM0_2_CMPA_R = (int)((4000)*initial_duty);

        PWM0_2_CTL_R = 0x03;            /* start timer */

        PWM0_ENABLE_R = 0x10;        /* start PWM0 ch4 */

        PWM0_INTEN_R |= 0x04;

        PWM0_2_INTEN_R |=0x00000808;

        NVIC_EN0_R |= 0x00001000;        /*  Enable interrupt for PWM2 in pwm module 0  in NVIC */

}


void clock_configuration()

{

    /* Enable Peripheral Clocks */

    SYSCTL_RCGCPWM_R |= 2;       /* enable clock to PWM1 */

    SYSCTL_RCGCPWM_R |= 1;       /* enable clock to PWM0 */

    for(int i=0;i<100;i++);

    SYSCTL_RCGCGPIO_R |= 0x38;   /* enable clock to PORTF and PORTD and PORTE*/

    for(int i=0;i<100;i++);

    SYSCTL_RCC_R &= ~0x001C0000; /* pre-divide for PWM0 clock - by 64 */

    SYSCTL_RCC_R |= 0x00100000;

    for(int i=0;i<100;i++);

    SYSCTL_RCGCADC_R |= 1;       /* enable clock to ADC0 */

}

void PWM0GEN2_ISR()

{

    /*if (gpio_toggle==0)

    {

        GPIO_PORTD_DATA_R |=  0x01;

        gpio_toggle =1;

    }

    else{

        GPIO_PORTD_DATA_R &= ~0x01;

        gpio_toggle =0;

    }*/

    static float e_k=0;

              static float e_k_minus_1=0;

              static float x_k=0;

              static float Y_c_k=0;

              //static float x=0;

              //float x = (2^7)*((GPIO_PORTF_DATA_R & 0x10)/16)+((2^5)*GPIO_PORTF_DATA_R & 0x02)+((2^5)*GPIO_PORTD_DATA_R & 0x01)+((2)*GPIO_PORTE_DATA_R & 0x08)+((2)*GPIO_PORTD_DATA_R & 0x04)+(*GPIO_PORTE_DATA_R & 0x04)+(0.25*GPIO_PORTD_DATA_R & 0x08)+(0.5*GPIO_PORTE_DATA_R & 0x02);

                                //PF4                             PF1                           PD0                                   PE3                              PD2                                     PE2                          PD3                      PE1

              //meas=x;

              PF4=(int)(GPIO_PORTF_DATA_R & 0x10)/(int)16;

              PF1=(int)(GPIO_PORTF_DATA_R & 0x02)/(int)2;

                PD0=(int)(GPIO_PORTD_DATA_R & 0x01);

                PE3=(int)(GPIO_PORTE_DATA_R & 0x08)/(int)8;

                PD2=(int)(GPIO_PORTD_DATA_R & 0x04)/(int)4;

                PE2=(int)(GPIO_PORTE_DATA_R & 0x04)/(int)4;

                PD3=(int)(GPIO_PORTD_DATA_R & 0x08)/(int)8;

                PE1=(int)(GPIO_PORTE_DATA_R & 0x02)/(int)2;

                meas =(float) (128*PF4+64*PF1+32*PD0+16*PE3+8*PD2+4*PE2+2*PD3+PE1)/256;


              e_k=Ref-meas;

              x_k=x_k+Ki*(e_k+e_k_minus_1);

              if(x_k>1500)

              {

                  x_k=1500;

              }

              if(x_k<-1500)

              {

                  x_k=-1500;

              }

              Y_c_k=e_k*Kp+x_k;

              duty1=(0.25-Y_c_k);

              duty2=(0.25+Y_c_k);

              e_k_minus_1=e_k;


                          if(duty1<0)

                          {

                              duty1=0.04;

                          }

                          if(duty1>1)

                          {

                              duty1=0.96;

                          }

                          if(duty2<0)

                          {

                              duty2=0.04;

                          }

                          if(duty2>1)

                          {

                              duty2=0.96;

                          }

                          PWM1_3_CMPA_R=(int)4000*(duty1);

                          PWM0_2_CMPA_R = (int)((4000)*duty2);


              calculate_flag=1;

    PWM0_2_ISC_R|=0x00000008;

}

void EnableInterrupts(void)

{

    __asm  ("    CPSIE  I\n");

}

void ADC_config()

{

    //here we will be using PE3(AIN0),PE2(AIN1),PE1(AIN2) pins for the analog inputs

    /* initialize ADC0 */

        GPIO_PORTE_AFSEL_R |= 0x07;   /* enable alternate function */

        GPIO_PORTE_DEN_R &= ~0x07;    /* disable digital function */

        GPIO_PORTE_AMSEL_R |= 0x07;   /* enable analog function */

        ADC0_ACTSS_R &= ~4;          /* disable SS2 during configuration */

        ADC0_EMUX_R &= ~0x0F00;

        ADC0_EMUX_R |= 0x0800;       /* PWM0 gen2 trigger conversion seq  */

        ADC0_TSSEL_R&=~0x00300000;

        ADC0_SSMUX2_R = 0X3210;           /* get input from channel 0,1,2. LEAVE 3 */

        ADC0_SSCTL2_R |= 0x0600;       /* take one value, set flag at 1st sample */

        //ADC0_IM_R|=0x08;//Sends the raw interrupt to the interrupt manager upon conversion

        ADC0_ACTSS_R |= 4;           /* enable ADC0 sequencer 2 */

        ADC0_IM_R|=0x04;//Sends the raw interrupt to the interrupt manager upon conversion

}


void ADC_SS2_ISR(void)

{

    int omega_DAC=0;

    int i=0;

    int curent_DAC=0;

    int du=0;

    ADC0_ISC_R |= 0x04;

    while(i<ADC_channels)

    {

        ADC_buff[i] = ADC0_SSFIFO2_R;  //(i=0||PE3)ref (i=1||PE2)omega (i=2||PE1)current

        i++;

    }

    //Ref=(float)(ADC_buff[0]*3.3)/(float)4096;//53.665

    c_meas=(float)(ADC_buff[2]*1.7*3.3)/(float)4096;//53.665

    W_meas=(float)(ADC_buff[1]*3.3)/(float)4096;//53.665

    //du=(int)(duty*4096)/3.3;

    //SSI1_Write(0x9000|(int)1.7*ADC_buff[2]);

    //SSI1_Write(0xA000|(int)ADC_buff[0]);

    calculate_flag=1;

}

void SPI_config(void)

{

    SYSCTL_RCGCSSI_R |= 2;       /* enable clock to SSI1 */

        SYSCTL_RCGCGPIO_R |= 8;      /* enable clock to GPIOD for SSI1 */

        SYSCTL_RCGCGPIO_R |= 0x20;   /* enable clock to GPIOF for slave select */

        /* configure PORTD 3, 1 for SSI1 clock and Tx */

        GPIO_PORTD_AMSEL_R &= ~0x0B; /* disable analog for these pins */

        GPIO_PORTD_DEN_R |= 0x0B;    /* and make them digital */

        GPIO_PORTD_AFSEL_R |= 0x0B;  /* enable alternate function */

        GPIO_PORTD_PCTL_R &= ~0x0000F0FF; /* assign pins to SSI1 */

        GPIO_PORTD_PCTL_R |= 0x00002022;  /* assign pins to SSI1 */

        /* configure PORTF 2 for slave select */

        GPIO_PORTD_DEN_R |= 0x02;    /* make the pin digital */

        //GPIO_PORTF_DIR_R |= 0x02;    /* make the pin output */

        ///GPIO_PORTF_DATA_R |= 0x02;   /* keep SS idle high */

        /* SPI Master, POL = 0, PHA = 0, clock = 4 MHz, 16 bit data */

        SSI1_CR1_R = 0;             /* disable SSI and make it master */

        SSI1_CC_R = 0;              /* use system clock */

        SSI1_CPSR_R = 2;            /* prescaler divided by 2 */

        SSI1_CR0_R = 0x000F;        /* 8 MHz SSI clock, SPI mode, 8 bit data */

        SSI1_CR1_R |= 2;

}

void SSI1_Write(int data)

{

    GPIO_PORTD_DATA_R &= ~0x02;  /* assert SS low */

    while((SSI1_SR_R & 2) == 0)

        ;                        /* wait until FIFO not full */

    SSI1_DR_R = data;            /* transmit high byte */

    while(SSI1_SR_R & 0x10)

        ;                        /* wait until transmit complete */

    GPIO_PORTD_DATA_R |= 0x02;   /* keep SS idle high */

}
