

/**
 * main.c
 */

#include <stdbool.h>
#include <stdint.h>
#include <math.h>
#include <stdlib.h>

#include "inc/hw_memmap.h"
#include "inc/hw_types.h"
//#include "inc/hw_can.h"
//#include "inc/hw_ints.h"
#include "inc/hw_gpio.h"
#include "driverlib/can.h"
#include "driverlib/interrupt.h"
#include "driverlib/sysctl.h"
#include "driverlib/gpio.h"
#include "driverlib/pin_map.h"
#include "driverlib/sysctl.h"
#include <./inc/tm4c123gh6pm.h>



#include "CAN/Static/CAN.h"

#include "CAN/Dynamic/CAN_Cfg.h"

void SystemInit(void);

static bool g_bTransmitNow = false;


tCANMsgObject RxMsg;

uint8_t my_Tx_Data1[8] = {0, 0, 0, 0, 0, 0, 0, 0};

uint8_t my_Tx_Data2[8] = {0, 0, 0, 0, 0, 0, 0, 0};

uint8_t my_Tx_Data3[8] = {0, 0, 0, 0, 0, 0, 0, 0};

uint8_t my_Rx_Data[8] = {0, 0, 0, 0, 0, 0, 0, 0};

uint8_t receivedData[10] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

uint8_t receivedData1[8] = {0, 0, 0, 0, 0, 0, 0, 0};

uint8_t time = 0;

int c = 0;

int ARRAY_SIZE = 8;
int ARRAY_SIZE1 = 10;
int auto1=1;

int value=8;
int value1=0;
int value2=0;
int value3=0;
int value4=0;
int value5=0;

char var[8];

int threshold_plant=50;
int threshold_temp=30;
int threshold_hum=60;

int count=0;
//int check1_interrupt_flag = 0x00;
//int check1_cool_off_time=0;
int check_interrupt_flag = 0x00;
int check_cool_off_time=0;
void systick_setup(void);
void SysTick_Handler(void);
void condition_check(void);
void UART1_Init(void);
char UART1_Read(void);
void UART1_Write(const char* data, int size);
void delayms(int n);


#define BAUD_RATE 9600


void UART1_Init(void) {
    SYSCTL_RCGCUART_R |= 0x02;       // Activate UART1
    SYSCTL_RCGCGPIO_R |= 0x04;       // Activate Port C
    SYSCTL_RCGCGPIO_R |= 0x20;

    // Disable UART1 before configuration
    UART1_CTL_R &= ~0x0001;

    // Configure UART1 clock source and baud rate (assuming 9600 baud rate)
    UART1_CTL_R &= ~0x0300;            // Clear the baud rate divisor
    UART1_IBRD_R = 104;                // IBRD = int(16,000,000 / (16 * 9600)) = 104
    UART1_FBRD_R = 11;                 // FBRD = round(0.1667 * 64) = 11

    // Configure UART1 settings (8-N-1)
    UART1_LCRH_R = 0x0070;

    // Configure Port C pins for UART1 (PC4: RX, PC5: TX)
    GPIO_PORTC_AFSEL_R |= 0x30;        // Enable alternate function on PC4 (UART1RX) and PC5 (UART1TX)
    GPIO_PORTC_DEN_R |= 0x30;          // Enable digital I/O on PC4 and PC5
    GPIO_PORTC_PCTL_R = (GPIO_PORTC_PCTL_R & 0xFF00FFFF) + 0x00220000; // Select UART1 function for PC4 and PC5
    GPIO_PORTC_AMSEL_R &= ~0x30;       // Disable analog functionality on PC4 and PC5

    // Enable UART1
    UART1_CTL_R |= 0x301;
}

void UART1_ReadArray(uint8_t *data, uint32_t size) {
    for (uint32_t i = 0; i < size; i++) {
        while ((UART1_FR_R & UART_FR_RXFE) != 0);  // Wait until RXFE is 0 (receive FIFO is not empty)
        data[i] = UART1_DR_R & 0xFF;               // Read data from the receive FIFO
    }
}

void UART1_WriteArray(uint8_t *data, uint32_t size) {
    for (uint32_t i = 0; i < size; i++) {
        while ((UART1_FR_R & UART_FR_TXFF) != 0);  // Wait until TXFF is 0 (transmit FIFO is not full)
        UART1_DR_R = data[i];                      // Write data to the transmit FIFO
    }
}


int main(void)
{

    RxMsg.pui8MsgData = my_Rx_Data;

    SystemInit();

    systick_setup();

    UART1_Init();

    CAN_my_Init(CAN_getConfig());

    CAN_MsgInint(CAN_getMsgConfig());

            int j = 0;

    while(1){

        if(check_interrupt_flag == 0x00){
            check_interrupt_flag = 0xFF;
            check_cool_off_time = 0;
            while(1){

                for(j = 0; j < 1000; j++);
        if(count == 0){

            CAN_MsgSend(6, 0x73, my_Tx_Data1, 0);
             for(j = 0; j < 100; j++);
            count=1;
        }

                for(j = 0; j < 1000; j++);
        if(count == 1){

            for(int k=0;k<20;k++){
                                        if(g_bRXFlag_RX7 == 1){
                                            g_bRXFlag_RX7 = 0;
                                            CANMessageGet(CAN0_BASE, 7, &RxMsg, 0);
                                            UART1_WriteArray(my_Rx_Data, ARRAY_SIZE);
                                           count=2;
                                           break;
                                        }
                        }
                     }

        if(count==2){

                        UART1_ReadArray(receivedData, ARRAY_SIZE1);
                        auto1=(int)(receivedData[6]);
                        if(auto1==1){
                            GPIOPinWrite(GPIO_PORTF_BASE, GPIO_PIN_2, 0);
                            GPIOPinWrite(GPIO_PORTF_BASE, GPIO_PIN_3, GPIO_PIN_3);
                        }
                        if(auto1==0){
                            GPIOPinWrite(GPIO_PORTF_BASE, GPIO_PIN_3, 0);
                            GPIOPinWrite(GPIO_PORTF_BASE, GPIO_PIN_2, GPIO_PIN_2);
                        }
//                        for (int m=1; m<9; m++){
                            receivedData1[0]=receivedData[7];
                            receivedData1[1]=receivedData[8];
                            receivedData1[2]=receivedData[9];
                            receivedData1[3]=receivedData[0];
                            receivedData1[4]=receivedData[1];
                            receivedData1[5]=receivedData[2];
                            receivedData1[6]=receivedData[3];
                            receivedData1[7]=receivedData[4];
                            time = receivedData[5];
//                        }
                        count=3;
        }


        if(g_bRXFlag_TX6 == 1){
                        g_bRXFlag_TX6 = 0;
                        if(auto1==1)
                        condition_check();
                        if(auto1==0){
                            for (int n=0; n<8; n++){
                                my_Tx_Data3[n]=(int)(receivedData1[n]);
                            }
                        }
                    }
        for(j = 0; j < 1000; j++);

        if(count==3){
                 if (auto1 == 1){
                     CAN_MsgSend(6, 0x18, my_Tx_Data2, 8);
                      for(j = 0; j < 100; j++);
                      count=0;
                      break;
                 }
                 if (auto1 == 0){
                     CAN_MsgSend(6, 0x18, my_Tx_Data3, 8);
                     for(j = 0; j < 100; j++);
                     count=0;
                     break;
                 }
             }
      }
        }
}
}

void delayms(int n)
{
    for(float i = 0 ; i < n; i++){
    for(int j = 0; j < 3180; j++) {}
    }
}

void condition_check(void){
    //plant 1
    if((int)(my_Rx_Data[0])<threshold_plant)
       my_Tx_Data2[1]=1;
    else my_Tx_Data2[1]=0;
    //plant2
    if((int)(my_Rx_Data[1])<threshold_plant)
           my_Tx_Data2[2]=1;
    else my_Tx_Data2[2]=0;
    //plant3
    if((int)(my_Rx_Data[2])<threshold_plant)
       my_Tx_Data2[3]=1;
    else my_Tx_Data2[3]=0;
    //plant4
    if((int)(my_Rx_Data[3])<threshold_plant)
           my_Tx_Data2[4]=1;
    else my_Tx_Data2[4]=0;
    //plant5
    if((int)(my_Rx_Data[4])<threshold_plant)
       my_Tx_Data2[5]=1;
    else my_Tx_Data2[5]=0;
    //humidity
    if((int)(my_Rx_Data[5])<threshold_hum)
           my_Tx_Data2[7]=1;
    else my_Tx_Data2[7]=0;
    //temperature
    if((int)(my_Rx_Data[6])>threshold_temp)
       my_Tx_Data2[6]=1;
    else my_Tx_Data2[6]=0;
    //8
    if((time>6) && (time<18))
           my_Tx_Data2[0]=4;
    else my_Tx_Data2[0]=0;


}

void SystemInit(void){
    SysCtlClockSet(SYSCTL_SYSDIV_1 | SYSCTL_USE_OSC | SYSCTL_OSC_MAIN | SYSCTL_XTAL_8MHZ);


    SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOF);

    /* Check if the peripheral access is enabled. */
    while(!SysCtlPeripheralReady(SYSCTL_PERIPH_GPIOF))
    {
    }


    GPIOPinTypeGPIOOutput(GPIO_PORTF_BASE, GPIO_PIN_1 | GPIO_PIN_2 | GPIO_PIN_3);
    /* Set GPIO_PORTF_BASE, GPIO_PIN_1 high */
    GPIOPinWrite(GPIO_PORTF_BASE, GPIO_PIN_3, GPIO_PIN_3);




    HWREG(GPIO_PORTF_BASE+GPIO_O_LOCK) = GPIO_LOCK_KEY;
    HWREG(GPIO_PORTF_BASE+GPIO_O_CR) |= GPIO_PIN_0;
    GPIOPinTypeGPIOInput(GPIO_PORTF_BASE, GPIO_PIN_0 | GPIO_PIN_4);
    GPIOPadConfigSet(GPIO_PORTF_BASE, GPIO_PIN_0 | GPIO_PIN_4, GPIO_STRENGTH_12MA, GPIO_PIN_TYPE_STD_WPU);
    GPIOIntTypeSet(GPIO_PORTF_BASE, GPIO_PIN_0 | GPIO_PIN_4, GPIO_FALLING_EDGE);
    GPIOIntEnable(GPIO_PORTF_BASE, GPIO_PIN_0 | GPIO_PIN_4);

    /* enable interrupt to portf */
    IntEnable(INT_GPIOF);

}

void GPIOFIntHandler(void)
{


    /*check if interrupt is by SW1*/
    if (GPIOIntStatus(GPIO_PORTF_BASE,0) & GPIO_PIN_4)
    {
        GPIOIntClear(GPIO_PORTF_BASE, GPIO_PIN_4);
        g_bTransmitNow = true;
    }
    /* check if interrupt causes by PF0/SW2 */
    else if (GPIOIntStatus(GPIO_PORTF_BASE,0) & GPIO_PIN_0)
    {
        GPIOIntClear(GPIO_PORTF_BASE, GPIO_PIN_0);
        g_bTransmitNow = true;
    }
    else
    {
        /*do nothing*/
    }
}

void systick_setup()
{
    // clk_freq = 16 MHz
    // 1 tick = 1 / (16000000) = 62.5 ns
    // for time_delay = 1 ms
    // Reload value = (clk_freq * time_delay) - 1
    //              = 16000 - 1
    // reload with number of clocks per second
    NVIC_ST_RELOAD_R = 16000-1;
    // enable SysTick interrupt, use system clock
    NVIC_ST_CTRL_R = 7;
}

void SysTick_Handler(){
          if(check_interrupt_flag == 0xFF)
                          {
                              check_cool_off_time++;
                              if(check_cool_off_time == 2000)
                              {
                                  check_interrupt_flag = 0x00;
                              }
                          }
}





