#include "Arduino.h"
#include <SPI.h>
#include <RF24.h>

const int pumpPin =  4;  

//Bangalore Tank

// This is just the way the RF24 library works:
// Hardware configuration: Set up nRF24L01 radio on SPI bus (pins 10, 11, 12, 13) plus pins 7 & 8
RF24 radio(7, 8);

byte addresses[][6] = {"1Node", "2Node","3Node"};

// -----------------------------------------------------------------------------
// SETUP   SETUP   SETUP   SETUP   SETUP   SETUP   SETUP   SETUP   SETUP
// -----------------------------------------------------------------------------
void setup() {
  Serial.begin(9600);
  Serial.println("THIS IS THE TRANSMITTER CODE - YOU NEED THE OTHER ARDIUNO TO SEND BACK A RESPONSE");
  pinMode(pumpPin,OUTPUT);
  // Initiate the radio object
  radio.begin();

  // Set the transmit power to lowest available to prevent power supply related issues
  radio.setPALevel(RF24_PA_MIN);

  // Set the speed of the transmission to the quickest available
  radio.setDataRate(RF24_2MBPS);

  // Use a channel unlikely to be used by Wifi, Microwave ovens etc
  radio.setChannel(124);

  // Open a writing and reading pipe on each radio, with opposite addresses
  radio.openWritingPipe(addresses[0]);
  radio.openReadingPipe(1, addresses[1]);
  //radio.openReadingPipe(2, addresses[2]);

  // Random number seeding (we're going to be sending a single random number)
  randomSeed(analogRead(A0));
}

// -----------------------------------------------------------------------------
// LOOP     LOOP     LOOP     LOOP     LOOP     LOOP     LOOP     LOOP     LOOP
// -----------------------------------------------------------------------------
void loop() {

  // Generate a single random character to transmit
  int get_id = 0;
  int flag = 0;
 
    
  // Ensure we have stopped listening (even if we're not) or we won't be able to transmit
  radio.startListening(); 

  if (radio.available())
    {
        radio.read( &get_id, sizeof(get_id) );

    }


  delay(2000);

  if(get_id == 123)
  {
    radio.read( &flag, sizeof(flag) );
    Serial.println("Request from IIsc");
    if(flag == 1)
    {
      digitalWrite(pumpPin, HIGH); 
      radio.stopListening();
          Serial.println("flag =1");

      // const char text[] = "Pumping to IISc ";
      // radio.write( &text, sizeof(text) );
    }


    else
    {
      digitalWrite(pumpPin, LOW);
      radio.stopListening();
      //const char text[] = "Blr Tank Off!";
    Serial.println("flag =0");

      //radio.write( &text, sizeof(text) );
      
    }

  }


  delay(2000);
}