#include "Arduino.h"
#include <SPI.h>
#include <RF24.h>

//DESE //DESE

const int pumpPin =  4; // pump pin
const int trigPin = 3;       // Trigger pin of Ultra sonic sensor
const int echoPin = 2;       // Echo pin of ultrasonic sensor


int flag = 0;
int upper_limit = 6;     // Upper level where pump should be turned off.  Even level 5 works
int lower_limit = 1;     // Lower level where pump should turn on
// defines variables
long duration,diff;
int distance, Base,state;  // state to implement FSM, Base is the first value for calibration. 
int upper_count, lower_count;    // upper_count and lower_count to avoid wrong detection of height difference. 

// This is just the way the RF24 library works:
// Hardware configuration: Set up nRF24L01 radio on SPI bus (pins 10, 11, 12, 13) plus pins 7 & 8
RF24 radio(7, 8);

byte addresses[][6] = {"1Node","2Node","3Node"};

// -----------------------------------------------------------------------------
// SETUP   SETUP   SETUP   SETUP   SETUP   SETUP   SETUP   SETUP   SETUP
// -----------------------------------------------------------------------------
void setup() 
{
  pinMode(pumpPin, OUTPUT);        // initialize the pump pin as an output:
  pinMode(trigPin, OUTPUT);      // Sets the trigPin as an Output
  pinMode(echoPin, INPUT);       // Sets the echoPin as an Input

  Serial.begin(9600);
  Serial.println("THIS IS THE RECEIVER CODE - YOU NEED THE OTHER ARDUINO TO TRANSMIT");


  // Initiate the radio object
  radio.begin();

  // Set the transmit power to lowest available to prevent power supply related issues
  radio.setPALevel(RF24_PA_MIN);

  // Set the speed of the transmission to the quickest available
  radio.setDataRate(RF24_2MBPS);

  // Use a channel unlikely to be used by Wifi, Microwave ovens etc
  radio.setChannel(124);

  // Open a writing and reading pipe on each radio, with opposite addresses
  radio.openWritingPipe(addresses[2]);
  radio.openReadingPipe(1, addresses[1]);

  state = 0;       // Initially state 0 means Pump ON by default
  upper_count = 0;
  lower_count = 0;
  // Read the base distance for the first time.. "B"
   // Clears the trigPin
  digitalWrite(trigPin, LOW);
  delayMicroseconds(2);
  // Sets the trigPin on HIGH state for 10 micro seconds
  digitalWrite(trigPin, HIGH);
  delayMicroseconds(10);
  digitalWrite(trigPin, LOW);
  // Reads the echoPin, returns the sound wave travel time in microseconds
  duration = pulseIn(echoPin, HIGH);
  // Calculating the distance
  Base = duration * 0.034 / 2;
  // Prints the distance on the Serial Monitor
  Serial.println(" ");
  Serial.print("Base: ");
  Serial.println(Base);
 // radio.openReadingPipe(2, addresses[2]);

  // Start the radio listening for data
  //radio.startListening();
}

// -----------------------------------------------------------------------------
// We are LISTENING on this device only (although we do transmit a response)
// -----------------------------------------------------------------------------
void loop() {

// Clears the trigPin
  digitalWrite(trigPin, LOW);
  delayMicroseconds(2);
  // Sets the trigPin on HIGH state for 10 micro seconds
  digitalWrite(trigPin, HIGH);
  delayMicroseconds(10);
  digitalWrite(trigPin, LOW);
  // Reads the echoPin, returns the sound wave travel time in microseconds
  duration = pulseIn(echoPin, HIGH);
  // Calculating the distance
  distance = duration * 0.034 / 2;
  // Prints the distance on the Serial Monitor
  diff = Base-distance;
  Serial.print("diff: ");
  Serial.println(diff);

  if((Base-distance) >= upper_limit)             // Water filled condition
    {
      state = 1;                       // Change to state 1
      upper_count = (upper_count + 1)% 4 ;
    }
  else if ((Base-distance) <= lower_limit)        // Water empty condition
  {
    state = 0;                      // Change to state 0
    lower_count = lower_count + 1;
  }
  
  if (state == 1 && upper_count >= 3)
  {
    flag = 0; // Indicates turn-off
    
    //digitalWrite(pumpPin, LOW);      // Turn off pump
    lower_count = 0;                 // Reset the lower counter value
    upper_count = 0;
    Serial.print("Turn off: ");
    Serial.println((Base-distance));
  }

  else if (state == 0 && lower_count >= 3)
  {
    flag =1 ; //turn-on
    
    //digitalWrite(pumpPin, HIGH);      // Turn on pump
    lower_count = 5;
    Serial.print("Turn ON: ");
    Serial.println((Base-distance));
  }

  // This is what we receive from the other device (the transmitter)

  int water_lvl  = 1;
  // Is there any data for us to get?



  if(flag == 1)
  {
    Serial.println("Low Water LVL!");
    radio.stopListening();
    int Tank_id = 345;
     radio.write( &Tank_id, sizeof(Tank_id) );
    //const char text[] = "Water Required!";
    //int req_water = 8 - water_lvl;
    delay(1000);
    radio.write( &flag, sizeof(int) );
    Serial.println("Need Water:");
    //Serial.println(req_water);

    // const char text[30] = "";

    // radio.startListening();
    // if (radio.available())
    // {
    //  radio.read(&text, sizeof(text));
    //  Serial.println(text);

    }
  

  else if(flag == 0)
  {
     radio.stopListening();
     int Tank_id = 345;
     radio.write( &Tank_id, sizeof(Tank_id) );
    //const char text[] = "Water Required!";
    delay(2000);
    radio.write( &flag, sizeof(int) );
    const char text[30] = "";

    // radio.startListening();
    // if (radio.available())
    // {
    //   radio.read(&text, sizeof(text));
    //   Serial.println(text);
    // }

  }

  delay(2000);
    // Now, resume listening so we catch the next packets.
    //radio.startListening(); 
}