#include <ESP8266WiFi.h>

const char* ssid = "VAIBHAV";
const char* password = "123456789";
// const char* ssid = "Redmi";
// const char* password = "qwertyui";
const char* receiverIP = "192.168.137.78";//192.168.137.93
const int receiverPort = 1234; // Choose any unused port

void setup() {
  Serial.begin(115200);
  delay(100);

  // Connect to Wi-Fi
  WiFi.begin(ssid, password);
  while (WiFi.status() != WL_CONNECTED) {
    delay(1000);
    Serial.println("Connecting to WiFi..");
  }
  Serial.println("Connected to WiFi");
}

void loop() {
  if (Serial.available() > 0) {
    String data = Serial.readStringUntil('\n');
    sendData(data);
  }
}

void sendData(String data) {
  WiFiClient client;
  if (client.connect(receiverIP, receiverPort)) {
    client.print(data);
    client.stop();
  }
}
