#include <SoftwareSerial.h>

#define baudrate 115200//57600//38400//9600//115200

const int BUFFER_SIZE = 3;
char buffer[BUFFER_SIZE];
int head = 0;
int tail = 0;
bool bufferFull = false;

// pins Rx D5 (14) and Tx D6(12)
//SoftwareSerial mySerial(14, 12); // RX, TX
SoftwareSerial mySerial(D5, D6); // RX, TX

void setup() {
  // Open serial communications and wait for port to open:
  Serial.begin(115200);
  while (!Serial) {  }
  Serial.println();
  Serial.println("ESP SoftwareSerial  test!");
  // set the data rate for the SoftwareSerial port
  mySerial.begin(baudrate);//9600);
  Serial.print("Serial test - Serial 1 at  baudrate ");
  Serial.println(baudrate);
  //while(1) mySerial.write('X');  // send continuous test
}

void loop() {
  // Receive data from mySerial and store it in the buffer
  while (mySerial.available() > 0) {
    char incomingChar = mySerial.read();
    buffer[head] = incomingChar;
    head = (head + 1) % BUFFER_SIZE;
    if (head == tail) {
      // Buffer is full
      bufferFull = true;
    }
  }

  // Transmit data from buffer to Serial
  while (Serial.available() > 0) {
    mySerial.write(Serial.read());
  }

  // If buffer is full, print its contents and reset
  if (bufferFull) {
    // Serial.println("Buffer is full, printing its contents:");
    // for (int i = 0; i< 3; i = (i + 1)) {
    //   Serial.print(buffer[i]);
    // }
    Serial.println(buffer);
    // Reset buffer
    head = 0;
    tail = 0;
    bufferFull = false;
  }

  delay(100); // Adjust delay as needed
}