#include <ESP8266WiFi.h>
#include <WiFiClient.h>

const char *ssid = "VAIBHAV";
const char *password = "123456789";
const char *serverIP = "192.168.137.105"; // IP address of the ESP8266 running the server

WiFiClient client;

String dataBuffer = "000"; // Define the buffer
bool newDataReceived = false; // Flag to indicate new data received from UART

const int trigPin = 12;
const int echoPin = 14;

// Define sound velocity in cm/uS
#define SOUND_VELOCITY 0.034
#define CM_TO_INCH 0.393701

void setup() {
  Serial.begin(115200);
  delay(1000);

  Serial.println();
  Serial.println("Connecting to WiFi");
  WiFi.begin(ssid, password);

  while (WiFi.status() != WL_CONNECTED) {
    delay(1000);
    Serial.print(".");
  }

  Serial.println("");
  Serial.println("WiFi connected");
  Serial.println("IP address: ");
  Serial.println(WiFi.localIP());

  pinMode(trigPin, OUTPUT); // Sets the trigPin as an Output
  pinMode(echoPin, INPUT);  // Sets the echoPin as an Input
}

void loop() {
  // Read data from Serial
  if (Serial.available() > 0) {
    dataBuffer = Serial.readStringUntil('\n');
    Serial.println("Received new data: " + dataBuffer);
    newDataReceived = true;
  }

  // Measure distance
  digitalWrite(trigPin, LOW);    // Clears the trigPin
  delayMicroseconds(2);
  digitalWrite(trigPin, HIGH);   // Sets the trigPin on HIGH state for 10 microseconds
  delayMicroseconds(10);
  digitalWrite(trigPin, LOW);

  // Reads the echoPin, returns the sound wave travel time in microseconds
  long duration = pulseIn(echoPin, HIGH);

  // Calculate the distance in centimeters
  float distanceCm = duration * SOUND_VELOCITY / 2;

  // Modify dataBuffer based on distance
  if (distanceCm < 20 && dataBuffer[0] != '0') {// off the motor
    // Set buffer to "000"
    dataBuffer[1] = '0';
    newDataReceived = true;
    //delay(2000); // Add delay for human detection
  } else if (distanceCm >= 100 && dataBuffer[0] != '1') {//on the motor
    // Set buffer to "111"
    dataBuffer[1] = '1';
    newDataReceived = true;
    //delay(2000); // Add delay for human detection
  }

  // Send POST request if new data received
  if (newDataReceived && client.connect(serverIP, 80)) {
    String postData = "data=" + dataBuffer; // New data to be sent
    client.print(String("POST /updateData HTTP/1.1\r\n") +
                 "Host: " + serverIP + "\r\n" +
                 "Content-Type: application/x-www-form-urlencoded\r\n" +
                 "Content-Length: " + postData.length() + "\r\n" +
                 "Connection: close\r\n\r\n" +
                 postData);

    // Read response
    while (client.available()) {
      String line = client.readStringUntil('\r');
      dataBuffer = line; // Store the data in dataBuffer
    }

    client.stop();
    newDataReceived = false; // Reset the flag
    delay(2000);
  }

  // Send GET request to fetch data
  if (client.connect(serverIP, 80)) {
    client.print(String("GET /getData HTTP/1.1\r\n") +
                 "Host: " + serverIP + "\r\n" +
                 "Connection: close\r\n\r\n");
    delay(4); // Add delay for 
    // Read response
    while (client.available()) {
      String line = client.readStringUntil('\r');
      dataBuffer = line; // Store the data in dataBuffer
    }

    client.stop();
  } else {
    Serial.println("Connection failed");
  }

  // Print the data received from the server
  dataBuffer.trim();
  Serial.println(dataBuffer);
}

