#include <ESP8266WiFi.h>
#include <WiFiClient.h>

const char *ssid = "VAIBHAV";
const char *password = "123456789";
const char *serverIP = "192.168.137.105"; // IP address of the ESP8266 running the server

WiFiClient client;

String dataBuffer = "000"; // Define the buffer
bool newDataReceived = false; // Flag to indicate new data received from UART

// Motor A
int motor1Pin1 = 12; 
int motor1Pin2 = 14; 
int enable1Pin = 13; 

// Setting minimum duty cycle
int dutyCycle = 60;

void turnOnMotor() {
  digitalWrite(enable1Pin, HIGH); // Enable motor
}

void turnOffMotor() {
  digitalWrite(enable1Pin, LOW); // Disable motor
}

void setup() {
  Serial.begin(115200);
  delay(1000);

  Serial.println();
  Serial.println("Connecting to WiFi");
  WiFi.begin(ssid, password);

  while (WiFi.status() != WL_CONNECTED) {
    delay(1000);
    Serial.print(".");
  }

  Serial.println("");
  Serial.println("WiFi connected");
  Serial.println("IP address: ");
  Serial.println(WiFi.localIP());

  pinMode(motor1Pin1, OUTPUT);
  pinMode(motor1Pin2, OUTPUT);
  pinMode(enable1Pin, OUTPUT);

  // Set initial motor state
  digitalWrite(motor1Pin1, LOW);
  digitalWrite(motor1Pin2, HIGH);

  delay(1000);
}

void loop() {
  // Read data from Serial
  if (Serial.available() > 0) {
    dataBuffer = Serial.readStringUntil('\n');
    Serial.println("Received new data: " + dataBuffer);
    newDataReceived = true;
  }

  // Send POST request if new data received
  if (newDataReceived) {
    if (client.connect(serverIP, 80)) {
      String postData = "data=" + dataBuffer; // New data to be sent
      client.print(String("POST /updateData HTTP/1.1\r\n") +
                   "Host: " + serverIP + "\r\n" +
                   "Content-Type: application/x-www-form-urlencoded\r\n" +
                   "Content-Length: " + postData.length() + "\r\n" +
                   "Connection: close\r\n\r\n" +
                   postData);

      delay(10); // Reduce delay

      // Read response
      while (client.available()) {
        String line = client.readStringUntil('\r');
        dataBuffer = line; // Store the data in dataBuffer
      }

      client.stop();
    } else {
      Serial.println("Connection failed");
    }
    newDataReceived = false; // Reset the flag
  }

  // Send GET request to fetch data
  if (client.connect(serverIP, 80)) {
    client.print(String("GET /getData HTTP/1.1\r\n") +
                 "Host: " + serverIP + "\r\n" +
                 "Connection: close\r\n\r\n");

    delay(10); // Reduce delay

    // Read response
    while (client.available()) {
      String line = client.readStringUntil('\r');
      dataBuffer = line; // Store the data in dataBuffer
    }

    client.stop();
  } else {
    Serial.println("Connection failed");
  }
  // Serial.print("the buffer is");
  // Serial.println(dataBuffer);
  // Control motor based on dataBuffer content
  dataBuffer.trim(); // Remove leading and trailing whitespaces
  if (dataBuffer[2] == '1') {
    Serial.println("motor on");
    turnOnMotor();
  } else if (dataBuffer[2] == '0') {
    turnOffMotor();
    Serial.println("motor off");
  }

  // Print the data received from the server
  Serial.println(dataBuffer);

  delay(10); // Reduce delay
}
