#include <ESP8266WiFi.h>
#include <ESP8266WebServer.h>

const char *ssid = "VAIBHAV";
const char *password = "123456789";

ESP8266WebServer server(80);

// Define the buffer
String dataBuffer = "000";

// Handler for the root page
void handleRoot() {
  server.send(200, "text/plain", dataBuffer);
}

// Handler for the GET request
void handleGetRequest() {
  server.send(200, "text/plain", dataBuffer);
}

// Handler for the POST request
void handlePostRequest() {
  if (server.hasArg("data")) {
    dataBuffer = server.arg("data");
    server.send(200, "text/plain", "Data updated successfully");
  } else {
    server.send(400, "text/plain", "Bad Request");
  }
}

void setup() {
  Serial.begin(115200);

  // Connect to Wi-Fi
  WiFi.begin(ssid, password);
  while (WiFi.status() != WL_CONNECTED) {
    delay(1000);
    Serial.println("Connecting to WiFi...");
  }
  Serial.println("Connected to WiFi");

  // Start the server
  server.on("/", HTTP_GET, handleRoot);
  server.on("/getData", HTTP_GET, handleGetRequest);
  server.on("/updateData", HTTP_POST, handlePostRequest);

  server.begin();
  Serial.println("HTTP server started");
}

void loop() {
  // Handle client requests
  server.handleClient();
}
