#include "inc/tm4c123gh6pm.h"
#include <stdint.h>
#include <stdio.h>
#include <ultrasonic_distance_calculator.h>

/* from Timer Block 0 Timer A and returns the time difference (the period of the signal). */
unsigned int measureHeight() {
    volatile int lastEdge, thisEdge;
    GPIO_PORTF_DATA_R &= ~0x08; /* create trigger pulse */
    timer1AMicroSecondDelay(10);
    GPIO_PORTF_DATA_R |= 0x08;
    timer1AMicroSecondDelay(10);
    GPIO_PORTF_DATA_R &= ~0x08;

    while (1) {
        TIMER0_ICR_R = 0x0400; /* clear timer0A capture flag */
        while ((TIMER0_RIS_R & 0x0400) == 0); /* wait till captured */
        if (GPIO_PORTF_DATA_R & (1 << 1)) { /*check if rising edge occurs */
            lastEdge = TIMER0_TBR_R; /* save the time stamp */

            /* detect falling edge */
            TIMER0_ICR_R = 0x0400; /* clear timer0A capture flag */

            while ((TIMER0_RIS_R & 0x0400) == 0); /* wait till captured */
            if ((GPIO_PORTF_DATA_R & (1 << 1)) == 0) {
                thisEdge = TIMER0_TBR_R;
                unsigned int pulse_width = (thisEdge - lastEdge) & 0x00FFFFFF; /* take pulse duration measurement */
                return ((pulse_width * 10625) / 100000); /* convert pulse duration into distance */
            }
        }
    }

}

/* Initialize Timer0B in input-edge time mode with up-count mode */
void timer0B1AAndPortFInit() {
    SYSCTL_RCGC2_R |= 0x00000020; /* enable clock to PORTF */
    GPIO_PORTF_DIR_R &= ~0x02; /* make PF1 an input pin */
    GPIO_PORTF_DEN_R |= 0x02; /* make PF1 as digital pin */
    GPIO_PORTF_AFSEL_R |= 0x02; /* use PF1 alternate function */
    GPIO_PORTF_PCTL_R &= 0xFFFFFF0F; /* configure PF1 for T0CCP1 */
    GPIO_PORTF_PCTL_R |= 0x00000070;

    //SYSCTL_RCGC2_R |= 0x00000020; /* enable clock to PORTF */
    GPIO_PORTF_DIR_R |= 0x08; /* set PF3 as a  output pin */
    GPIO_PORTF_DEN_R |= 0x08; /* make PF3 as digital pin */

    SYSCTL_RCGCTIMER_R |= 0x00000001; /* enable clock to Timer Block 0 */
    TIMER0_CTL_R &= 0; /* disable timer0B during setup */
    TIMER0_CFG_R = 0x04; /* 16-bit timer mode */
    TIMER0_TBMR_R = 0x17; /* up-count, edge-time, capture mode */
    TIMER0_CTL_R |= 0x0C00; /* capture the rising edge */
    TIMER0_CTL_R |= 0x0100; /* enable timer0B */

    SYSCTL_RCGCTIMER_R |= 0x00000002; /* enable clock to Timer Block 1 */
    TIMER1_CTL_R = 0; /* disable Timer before initialization */
    TIMER1_CFG_R = 0x04; /* 16-bit option */
    TIMER1_TAMR_R = 0x02; /* periodic mode and down-counter */
    TIMER1_TAILR_R = 16 - 1; /* TimerA interval load value reg */
}

void timer1AMicroSecondDelay(int time) {
    TIMER1_ICR_R = 0x1; /* clear the TimerA timeout flag */
    TIMER1_CTL_R |= 0x01; /* enable Timer A after initialization */
    for (int i = 0; i < time; i++) {
        while((TIMER1_RIS_R & 0x1) == 0); /*wait for TimerA timeout flag */
        TIMER1_ICR_R = 0x1; /* clear the TimerA timeout flag */
    }
}
