#include <./inc/tm4c123gh6pm.h>
#include <stdint.h>
#include <lcd_status_viewer.h>

void LCDInit() {
    SYSCTL_RCGC2_R |= PORT_A_B_CLOCK_ENABLE;
    GPIO_PORTA_DIR_R |= ENABLE_OUT_PA_7_6_5_4;
    GPIO_PORTB_DIR_R |= ENABLE_OUT_PB_ALL;
    GPIO_PORTA_DEN_R |= ENABLE_DIGITAL_PA_7_6_5_4;
    GPIO_PORTB_DEN_R |= ENABLE_DIGITAL_PB_ALL;
    LCDWriteCmd(FUNCTION_SET_8BIT);
    LCDWriteCmd(CURSOR_OFF);
    LCDWriteCmd(CLEAR_DISPLAY);
    LCDWriteCmd(FIRST_ROW);
}

void LCDWriteCmd(char command) {
    int port_B, port_A, delay;
    port_A = GPIO_PORTA_DATA_R;
    port_B = GPIO_PORTB_DATA_R;

    GPIO_PORTA_DATA_R &= 0x0F;
    GPIO_PORTA_DATA_R &= ~(RS);
    GPIO_PORTB_DATA_R = command;

    GPIO_PORTA_DATA_R |= EN;
    GPIO_PORTA_DATA_R &= ~(EN);

    GPIO_PORTA_DATA_R = port_A;
    GPIO_PORTB_DATA_R = port_B;
    CREATE_DELAY(delay, DELAY_TO_COMPLETE_ACTION);
}

void LCDCharPut(char data) {
    int port_B, port_A, delay;
    port_A = GPIO_PORTA_DATA_R;
    port_B = GPIO_PORTB_DATA_R;

    GPIO_PORTA_DATA_R &= 0x0F;
    GPIO_PORTA_DATA_R |= RS;
    GPIO_PORTB_DATA_R = data;

    GPIO_PORTA_DATA_R |= EN;
    GPIO_PORTA_DATA_R &= ~(EN);

    GPIO_PORTA_DATA_R = port_A;
    GPIO_PORTB_DATA_R = port_B;
    CREATE_DELAY(delay, DELAY_TO_COMPLETE_ACTION);
}

void LCDPrintString(char str[]) {
    LCDWriteCmd(RETURN_HOME);
    LCDWriteCmd(FIRST_ROW);
    while(*str) {
        LCDCharPut(*(str++));
    }
}
