#include <stdlib.h>
#include <stdio.h>
#include <./inc/tm4c123gh6pm.h>
#include <keypad_manager.h>

unsigned int keypad_columns[NUMBER_OF_COLUMNS] = {KEYPAD_COLUMN1, KEYPAD_COLUMN2,
                                         KEYPAD_COLUMN3, KEYPAD_COLUMN4};

void keyPadPortsCEInit() {
    SYSCTL_RCGC2_R |= PORT_E_CLOCK_ENABLE;
    GPIO_PORTE_DIR_R |= ENABLE_OUT_PE_3_2_1_0;
    GPIO_PORTE_DEN_R |= ENABLE_DIGITAL_PE_3_2_1_0;
    GPIO_PORTE_DATA_R = SET_ALL_PINS_LOW;

    SYSCTL_RCGC2_R |= PORT_C_CLOCK_ENABLE;
    GPIO_PORTC_DIR_R &= ENABLE_IN_PC_7_6_5_4;
    GPIO_PORTC_DEN_R |= ENABLE_DIGITAL_PC_7_6_5_4;
    GPIO_PORTC_PUR_R |= ENABLE_PUR_PC_7_6_5_4;

    GPIO_PORTC_IS_R &= SENSE_PC_7_6_5_4_EDGES;
    GPIO_PORTC_IBE_R &= SENSE_PC_7_6_5_4_SINGLE_EDGE;
    GPIO_PORTC_IEV_R &= SENSE_PC_7_6_5_4_FALLING_EDGE;
    GPIO_PORTC_ICR_R = CLEAR_PC_7_6_5_4_INTERRUPTS;
    GPIO_PORTC_IM_R |= UNMASK_PC_7_6_5_4_INTERRUPTS;
    NVIC_PRI0_R |= SET_PRIORITY_0_FOR_IRQ2;
    NVIC_EN0_R |= ENABLE_IRQ2_FOR_PC;
}

unsigned int isKeyPressed() {
    GPIO_PORTE_DATA_R = SET_ALL_PINS_LOW ;

    if((GPIO_PORTC_DATA_R & MSB_4_BITS_HIGH) != MSB_4_BITS_HIGH)
        return TRUE;
    else
        return FALSE;
}

unsigned int getPressedkey() {
    unsigned int keypad_row, keypad_column, pressed_key_column;
    GPIO_PORTE_DATA_R = SET_ALL_PINS_LOW ;

    for(keypad_row = 0; keypad_row < (NUMBER_OF_ROWS - 1); keypad_row++) {
        GPIO_PORTE_DATA_R = (LSB_4_BITS_HIGH & ~(1 << keypad_row));
        pressed_key_column = GPIO_PORTC_DATA_R & MSB_4_BITS_HIGH ;

        if(pressed_key_column != MSB_4_BITS_HIGH) {
            for (keypad_column = 0; keypad_column < NUMBER_OF_COLUMNS; keypad_column++) {
                if( pressed_key_column == keypad_columns[keypad_column]) {
                    return ((keypad_row * NUMBER_OF_COLUMNS) + keypad_column);
                }
            }
        }
    }
    return 20;
}
