#include <./inc/tm4c123gh6pm.h>
#include <stdint.h>

void PWMForMotorInit() {

    /* PWM on PD0*/
    SYSCTL_RCGCPWM_R |= 2;
    SYSCTL_RCGCGPIO_R |= 0x08;
    SYSCTL_RCC_R &= ~0x00100000;
    GPIO_PORTD_AFSEL_R = 1;
    GPIO_PORTD_PCTL_R &= ~0x0000000F;
    GPIO_PORTD_PCTL_R |= 0x00000005;
    GPIO_PORTD_DEN_R |= 1;

    PWM1_0_CTL_R &= ~(1 << 0);
    PWM1_0_CTL_R &= ~(1 << 1);
    PWM1_0_GENA_R = 0x0000008C;
    PWM1_0_LOAD_R = 16000;
    PWM1_0_CMPA_R = 15999;
    PWM1_ENABLE_R |= 0x01;
    PWM1_0_CTL_R = 1;

    GPIO_PORTD_DIR_R |= (1 << 3) | (1 << 2);
    GPIO_PORTD_DEN_R |= (1 << 3) | (1 << 2);
    GPIO_PORTD_DATA_R |= (1 << 3);
    GPIO_PORTD_DATA_R &= ~(1 << 2);

    GPIO_PORTD_DIR_R |= (1 << 1);
    GPIO_PORTD_DEN_R |= (1 << 1);
}

void setMainDCMotorPulseAndDirection(int pulse_width, int direction) {
    PWM1_0_CMPA_R = pulse_width;
    if (direction == 0) {
        GPIO_PORTD_DATA_R |= (1 << 3);
        GPIO_PORTD_DATA_R &= ~(1 << 2);
    } else {
        GPIO_PORTD_DATA_R |= (1 << 2);
        GPIO_PORTD_DATA_R &= ~(1 << 3);
    }
}

