/*
* rsa.c
*
*  Created on: 02-May-2024
*      Author: Kevin
*/

#include "rsa.h"

uint8_t temp_size = 0;
// Function to perform modular exponentiation
uint32_t mod_exp(uint32_t base, uint32_t exp, uint32_t mod)
{
    uint32_t result = 1;
    base %= mod;
    while (exp > 0)
    {
        if (exp & 1) // If exp is odd
            result = (result * base) % mod;
        exp >>= 1; // Divide the exponent by 2
        base = (base * base) % mod;
    }
    return result;
}

void decrypt(uint8_t *crypt_msg, unsigned char *msg, int sz, uint32_t n, uint32_t d)
{
    uint32_t i;
    uint16_t acc;

    for (i = 0; i < sz; i += 2)
    {
        acc = ((uint16_t)crypt_msg[i + 1] << 8) + crypt_msg[i];
        acc = mod_exp(acc, d, n);
        msg[(temp_size) + (i >> 1)] = acc;
    }
}
