/*
  sw1 and sw2 completely working fine
  sw1 -> for 10000 to 14000 addr
  sw2 -> for 14000 to 18000 addr
 */


#include <stdint.h>
#include <stdio.h>
#include <stdbool.h>
#include <string.h>
#include <stdlib.h>
#include <math.h>

#include "driverlib/systick.h"
#include "inc/hw_gpio.h"
#include <ctype.h>
#include "C:\Users\Prathmesh\OneDrive\Desktop\TivaWare_C_Series-2.2.0.295\inc\tm4c123gh6pm.h"
#include <C:\Users\Prathmesh\OneDrive\Desktop\TivaWare_C_Series-2.2.0.295\inc\hw_memmap.h>
#include <C:\Users\Prathmesh\OneDrive\Desktop\TivaWare_C_Series-2.2.0.295\inc\hw_types.h>
#include <C:\Users\Prathmesh\OneDrive\Desktop\TivaWare_C_Series-2.2.0.295\driverlib\gpio.h>
#include <C:\Users\Prathmesh\OneDrive\Desktop\TivaWare_C_Series-2.2.0.295\driverlib\pin_map.h>
#include <C:\Users\Prathmesh\OneDrive\Desktop\TivaWare_C_Series-2.2.0.295\driverlib\sysctl.h>
#include <C:\Users\Prathmesh\OneDrive\Desktop\TivaWare_C_Series-2.2.0.295\driverlib\uart.h>

#include "crc.h"
#include "packet.h"
#include "utils.h"
#include "rsa.h"


#define GPIO_PORTF_DATA_RD (*((volatile unsigned long *)0x40025044))
#define GPIO_PORTF_DATA_WR (*((volatile unsigned long *)0x40025038))


#define LEDBASE GPIO_PORTF_BASE
#define LEDRED GPIO_PIN_1
#define LEDBLUE GPIO_PIN_2
#define LEDGREEN GPIO_PIN_3

#define SWBASE      GPIO_PORTF_BASE
#define SW1         GPIO_PIN_4
#define SW2         GPIO_PIN_0
#define BUFFER_SIZE 64

#define APP_1_START_ADDRESS ((uint32_t)0x00010000U)
#define APP_1_END_ADDRESS   ((uint32_t)0x00014000U)
#define APP_2_START_ADDRESS ((uint32_t)0x00014000U)
#define APP_2_END_ADDRESS   ((uint32_t)0x00018000U)

void UART0Init(uint32_t ui32Port, uint32_t ui32BaudRate);
void UART_OutChar(unsigned char data);
void UART_OutString(char *pt);
unsigned char UART_InChar(void);
void updateSwitchState(uint8_t switchIndex, bool pressed);
bool isSwitchPressedTwice(uint8_t switchIndex);
void delayMs(int x);
void LCD_default_display(char *ar);
void LCD_send_char(int command, char value);
void data_overwritten(void);
void LCD_init(void);
void app_1_2(void);
void flashed_success(int app_no);


strPacket_t rxBuffer;
strPacket_t txBuffer;

uint32_t flsDrvBuffer[32];
uint8_t flsDrvBufferInd = 0;
uint32_t payloadSize;

// RSA decryption change

uint32_t decrypt_temp_reg;
uint64_t decrypt_accumulator;
uint8_t buffer_size;
uint8_t decrypted_buffer[256];
uint8_t decrypt_buffer_idx = 0;

uint8_t decrypted_data[256]; // Adjust size as per your requirement
//uint8_t temp_size = 0;

uint32_t n = 299, d = 53;
// n = 13 x 23
// d : private key (23)
// e : public key (5)

crc_t crc;

uint8_t buffer[BUFFER_SIZE];

typedef enum
{
    BL_STATE_IDLE,
    BL_STATE_ERASE_STARTED,
    BL_STATE_WRITE_STARTED,
    BL_STATE_WRITE_FINISHED,
} enuState_t;

static enuState_t BL_State = BL_STATE_IDLE;

static uint32_t flashIndexApp1 = APP_1_START_ADDRESS; // first app address
static uint32_t flashIndexApp2 = APP_2_START_ADDRESS; // second app address

#define DEBOUNCE_DELAY_MS 50 // Adjust debounce delay as needed

typedef struct
{
    bool pressed;       // Flag to indicate if the switch is currently pressed
    uint8_t pressCount; // Number of times the switch is pressed
} SwitchState;

SwitchState switchStates[2]; // Array to store state of each switch

// Function to perform modular exponentiation
/*uint32_t mod_exp(uint32_t base, uint32_t exp, uint32_t mod)
{
    uint32_t result = 1;
    base %= mod;
    while (exp > 0)
    {
        if (exp & 1) // If exp is odd
            result = (result * base) % mod;
        exp >>= 1; // Divide the exponent by 2
        base = (base * base) % mod;
    }
    return result;
}

void decrypt(uint8_t *crypt_msg, unsigned char *msg, int sz, uint32_t n, uint32_t d)
{
    uint32_t i;
    uint16_t acc;

    for (i = 0; i < sz; i += 2)
    {
        acc = ((uint16_t)crypt_msg[i + 1] << 8) + crypt_msg[i];
        acc = mod_exp(acc, d, n);
        msg[(temp_size) + (i >> 1)] = acc;
    }
}*/

char *app1    = "Chosen App1";
char *app2    = "Chosen App2";
char *boot    = "Bootloader Area";
char *app11   = "Executing App1";
char *app21   = "Executing App2";

int main(void)
{
    // Initialize system clock
    SysCtlClockSet(SYSCTL_SYSDIV_4 | SYSCTL_USE_PLL | SYSCTL_OSC_MAIN |
                   SYSCTL_XTAL_16MHZ);

    LCD_init();

    // Enable GPIOF,GPIOA clock
    SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOF);
    while (!SysCtlPeripheralReady(SYSCTL_PERIPH_GPIOF));

    SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOA);
    while (!SysCtlPeripheralReady(SYSCTL_PERIPH_GPIOA));

    // Unlock PF0
    HWREG(GPIO_PORTF_BASE + GPIO_O_LOCK) = GPIO_LOCK_KEY;
    HWREG(GPIO_PORTF_BASE + GPIO_O_CR)  |= GPIO_PIN_0;

    // Set push buttons pins as input (PF0,PF4)
    GPIOPinTypeGPIOInput(SWBASE, SW1 | SW2);

    UART0Init(UART0_BASE, 115200); // Use UART0 for communication

    // Enable pullup resistors on PF0,PF4
    GPIOPadConfigSet(SWBASE, SW1 | SW2, GPIO_STRENGTH_2MA, GPIO_PIN_TYPE_STD_WPU);

    // Erased application check
    uint64_t *pApp1Area = (uint64_t *)0x00010000U;
    uint64_t *pApp2Area = (uint64_t *)0x00014000U;

    uint8_t erasedApp1Flag = *pApp1Area == 0xFFFFFFFFFFFFFFFFU ? 1 : 0;
    uint8_t erasedApp2Flag = *pApp2Area == 0xFFFFFFFFFFFFFFFFU ? 1 : 0;

    // Ask the user to choose between application 1 and application 2 through UART
    int selectedApp1 = !GPIOPinRead(SWBASE, SW1);
    int selectedApp2 = !GPIOPinRead(SWBASE, SW2);

    bool switchPressedTwice = false;

    //     If pushbuttons were not pressed, jump to application.
    if ((selectedApp1 && erasedApp1Flag == 0x00) || (selectedApp2 && erasedApp2Flag == 0x00))
    {
        if (selectedApp1 == 1 && !selectedApp2)
        {
            // Reinit used peripherals
            LCD_default_display(app11);
            SysCtlPeripheralReset(SYSCTL_PERIPH_GPIOF);
            __asm(
                // Update vector table offset to application vector table
                "ldr     r0, = 0x00010000\n" // pApp1Area
                "ldr     r1, = 0xe000ed08\n"
                "str     r0, [r1]\n"

                // Update stack pointer from application vector table. First entry of vector table is SP
                "ldr     r1, [r0]\n"
                "mov     sp, r1\n"

                // Load application reset handler and jump to the user code
                "ldr     r0, [r0, #4]\n"
                "bx      r0\n");

        }
        else if (selectedApp2 == 1 && !selectedApp1)
        {
            // Reinit used
            LCD_default_display(app21);
            SysCtlPeripheralReset(SYSCTL_PERIPH_GPIOF);
            __asm(
                // Update vector table offset to application vector table
                "ldr     r0, = 0x00014000\n" // pApp2Area
                "ldr     r1, = 0xe000ed08\n"
                "str     r0, [r1]\n"

                // Update stack pointer from application vector table. First entry of vector table is SP
                "ldr     r1, [r0]\n"
                "mov     sp, r1\n"

                // Load application reset handler and jump to the user code
                "ldr     r0, [r0, #4]\n"
                "bx      r0\n");
        }
    }
    else if(selectedApp2 == 0 && selectedApp1 == 0) LCD_default_display(boot);


    if(selectedApp1 & !selectedApp2) LCD_default_display(app1);
    else if(selectedApp2 & !selectedApp1) LCD_default_display(app2);


    delayMs(DEBOUNCE_DELAY_MS + 200);

    if (selectedApp2 == 1 && selectedApp1 == 1)
    {
        app_1_2();
        while (!switchPressedTwice)
        {
            // Read switch states and update switch state machine
            updateSwitchState(0, !GPIOPinRead(SWBASE, SW1)); // Update state of switch 1
            updateSwitchState(1, !GPIOPinRead(SWBASE, SW2)); // Update state of switch 2

            // Check if any switch is pressed twice
            if (isSwitchPressedTwice(0))
            {
                switchPressedTwice = true; // Set flag to exit loop
                selectedApp1 = 1;
                selectedApp2 = 0;
                LCD_default_display(app1);
            }
            else if (isSwitchPressedTwice(1))
            {
                switchPressedTwice = true; // Set flag to exit loop
                selectedApp2 = 1;
                selectedApp1 = 0;
                LCD_default_display(app2);
            }

            // Delay for switch debouncing
            delayMs(DEBOUNCE_DELAY_MS);
        }
    }

    // Set LEDs pins type as output
    GPIOPinTypeGPIOOutput(LEDBASE, LEDRED | LEDBLUE | LEDGREEN);

    // Initialize CRC lib
    crc = crc_init();

    GPIOPinWrite(LEDBASE, LEDBLUE, LEDBLUE);
    //    GPIOPinWrite(LEDBASE, LEDBLUE, 0);

    while (1)
    {

        rcvPacket(&rxBuffer);

        if (rxBuffer.packetValid)
        {

            // Erase request
            if (rxBuffer.packetOpcode == 1 && BL_State == BL_STATE_IDLE)
            {

                BL_State = BL_STATE_ERASE_STARTED;

                if (selectedApp1 == 1 && !selectedApp2)
                {
                    for (uint32_t appArea = APP_1_START_ADDRESS; appArea < APP_1_END_ADDRESS; appArea += 0x400)
                    {
                        GPIOPinWrite(LEDBASE, LEDRED, LEDRED);
                        if (FlashErase(appArea) != 0)
                        {
                            // Erasing flash failed. Send error and break.
                            txBuffer.packetOpcode = 0xA1;
                            txBuffer.dataLen = 1;
                            // erase failed
                            txBuffer.packetData[0] = 0xF0;
                            sendPacket(&txBuffer);
                            break;
                        }
                        else
                        {
                            GPIOPinWrite(LEDBASE, LEDRED, 0);
                        }
                    }
                }
                else if (selectedApp2 == 1 && !selectedApp1)
                {
                    for (uint32_t appArea = APP_2_START_ADDRESS; appArea < APP_2_END_ADDRESS; appArea += 0x400)
                    {
                        GPIOPinWrite(LEDBASE, LEDRED, LEDRED);
                        if (FlashErase(appArea) != 0)
                        {
                            // Erasing flash failed. Send error and break.
                            txBuffer.packetOpcode = 0xA1;
                            txBuffer.dataLen = 1;
                            // erase failed
                            txBuffer.packetData[0] = 0xF0;
                            sendPacket(&txBuffer);
                            break;
                        }
                        else
                        {
                            GPIOPinWrite(LEDBASE, LEDRED, 0);
                        }
                    }
                }

                // Send erase end indication
                txBuffer.packetOpcode = 0xA1;
                txBuffer.dataLen = 1;
                // erase finished
                txBuffer.packetData[0] = 1;
                sendPacket(&txBuffer);

                BL_State = BL_STATE_IDLE;

                // Flash request
            }
            else if (rxBuffer.packetOpcode == 0x02 && BL_State == BL_STATE_IDLE)
            {
                payloadSize = bytesToU32(rxBuffer.packetData, 0);

                txBuffer.packetOpcode = 0xA2;
                txBuffer.dataLen = 0x01;

                if (selectedApp1 == 1 && !selectedApp2)
                {
                    if (payloadSize <= (APP_1_END_ADDRESS - APP_1_START_ADDRESS))
                    {
                        flashIndexApp1 = APP_1_START_ADDRESS;
                        BL_State = BL_STATE_WRITE_STARTED;
                        crc = crc_init();
                        txBuffer.packetData[0] = 0x01; // flashing accepted
                    }
                    else
                    {
                        txBuffer.packetData[0] = 0x00; // flashing refused
                    }
                }
                else if (selectedApp2 == 1 && !selectedApp1)
                {
                    if (payloadSize <= (APP_2_END_ADDRESS - APP_2_START_ADDRESS))
                    {
                        flashIndexApp2 = APP_2_START_ADDRESS;
                        BL_State = BL_STATE_WRITE_STARTED;
                        crc = crc_init();
                        txBuffer.packetData[0] = 0x01; // flashing accepted
                    }
                    else
                    {
                        txBuffer.packetData[0] = 0x00; // flashing refused
                    }
                }

                sendPacket(&txBuffer);

                // Flash data
            }
            else if (rxBuffer.packetOpcode == 0x03 && BL_State == BL_STATE_WRITE_STARTED)
            {

                if (selectedApp1 == 1 && !selectedApp2)
                {

                    if (((rxBuffer.dataLen % 4) == 0) && ((flashIndexApp1 + rxBuffer.dataLen) <= APP_1_END_ADDRESS))
                    {
                        // calculate crc before decrypting
                        // update CRC
                        crc = crc_update(crc, rxBuffer.packetData, rxBuffer.dataLen);

                        // Decrypt task

                        for (int i = 0; i < rxBuffer.dataLen; i = i + 2)
                        {
                            /* We can't do the power using pow(), because with huge
                             * exponents as d it will surely lead to overflow. We have
                             * to control each operation and make a modulo operation on
                             * every iteration to avoid overflow. This is extremely slow,
                             * but it's the simplest solution. */
                            decrypt_accumulator = (((uint16_t)rxBuffer.packetData[i + 1] << 8) + (rxBuffer.packetData[i]));
                            decrypt_temp_reg = decrypt_accumulator;
                            for (int j = 1; j < d; ++j)
                            {
                                decrypt_accumulator = (decrypt_accumulator * decrypt_temp_reg);
                                if (decrypt_accumulator >= n)
                                    decrypt_accumulator %= n;
                            }
                            decrypted_buffer[decrypt_buffer_idx + (i >> 1)] = decrypt_accumulator;
                        }

                        // update size of decrypted data received
                        decrypt_buffer_idx += rxBuffer.dataLen / 2;
                        int32_t writeRes;
                        if (decrypt_buffer_idx % 4 == 0)
                        {
                            // Concatenate every 4 bytes into an UInt32 because flash driver expects an array of UInt32s
                            // TM4C123 is little-endian.
                            flsDrvBufferInd = 0;
                            for (int i = 0; i < decrypt_buffer_idx;)
                            {
                                flsDrvBuffer[flsDrvBufferInd] = decrypted_buffer[i++];
                                flsDrvBuffer[flsDrvBufferInd] |= decrypted_buffer[i++] << 8;
                                flsDrvBuffer[flsDrvBufferInd] |= decrypted_buffer[i++] << 16;
                                flsDrvBuffer[flsDrvBufferInd] |= decrypted_buffer[i++] << 24;
                                flsDrvBufferInd++;
                            }
                            writeRes = FlashProgram(flsDrvBuffer, flashIndexApp1, decrypt_buffer_idx);
                            flashIndexApp1 += (decrypt_buffer_idx);
                            decrypt_buffer_idx = 0;
                        }
                        else
                        {
                            writeRes = 0; // assume successful transmission, will be checked next during next packet
                        }

                        // prepare response
                        txBuffer.packetOpcode = 0xA3;
                        txBuffer.dataLen = 0x01;

                        if (writeRes == 0)
                        {
                            // success
                            if ((flashIndexApp1 - APP_1_START_ADDRESS) < payloadSize / 2)
                            {
                                txBuffer.packetData[0] = 0x01; // send next chunk of data
//                                GPIOPinWrite(LEDBASE, LEDGREEN, LEDGREEN);
                            }
                            else
                            {
                                txBuffer.packetData[0] = 0x02; // application is completely transferred.
                                BL_State = BL_STATE_WRITE_FINISHED;
//                                GPIOPinWrite(LEDBASE, LEDGREEN, 0);
                            }
                        }
                        else
                        {
                            txBuffer.packetData[0] = 0x00; // failed
                        }
                        sendPacket(&txBuffer);
                    }
                    else
                    {
                        txBuffer.packetOpcode = 0xA3;
                        txBuffer.dataLen = 0x01;
                        txBuffer.packetData[0] = 0xFF; // overflow
                        sendPacket(&txBuffer);
                    }
                }

                else if (selectedApp2 == 1 && !selectedApp1)
                {

                    if (((rxBuffer.dataLen % 4) == 0) && ((flashIndexApp2 + rxBuffer.dataLen) <= APP_2_END_ADDRESS))
                    {
                        // calculate crc before decrypting
                        // update CRC
                        crc = crc_update(crc, rxBuffer.packetData, rxBuffer.dataLen);

                        // Decrypt task
                        for (int i = 0; i < rxBuffer.dataLen; i = i + 2)
                        {
                            /* We can't do the power using pow(), because with huge
                             * exponents as d it will surely lead to overflow. We have
                             * to control each operation and make a modulo operation on
                             * every iteration to avoid overflow. This is extremely slow,
                             * but it's the simplest solution. */
                            decrypt_accumulator = (((uint16_t)rxBuffer.packetData[i + 1] << 8) + (rxBuffer.packetData[i]));
                            decrypt_temp_reg = decrypt_accumulator;
                            for (int j = 1; j < d; ++j)
                            {
                                decrypt_accumulator = (decrypt_accumulator * decrypt_temp_reg);
                                if (decrypt_accumulator >= n)
                                    decrypt_accumulator %= n;
                            }
                            decrypted_buffer[decrypt_buffer_idx + (i >> 1)] = decrypt_accumulator;
                        }

                        // update size of decrypted data received
                        decrypt_buffer_idx += rxBuffer.dataLen / 2;
                        int32_t writeRes;
                        if (decrypt_buffer_idx % 4 == 0)
                        {
                            // Concatenate every 4 bytes into an UInt32 because flash driver expects an array of UInt32s
                            // TM4C123 is little-endian.
                            flsDrvBufferInd = 0;
                            for (int i = 0; i < decrypt_buffer_idx;)
                            {
                                flsDrvBuffer[flsDrvBufferInd] = decrypted_buffer[i++];
                                flsDrvBuffer[flsDrvBufferInd] |= decrypted_buffer[i++] << 8;
                                flsDrvBuffer[flsDrvBufferInd] |= decrypted_buffer[i++] << 16;
                                flsDrvBuffer[flsDrvBufferInd] |= decrypted_buffer[i++] << 24;
                                flsDrvBufferInd++;
                            }
                            writeRes = FlashProgram(flsDrvBuffer, flashIndexApp2, decrypt_buffer_idx);
                            flashIndexApp2 += (decrypt_buffer_idx);
                            decrypt_buffer_idx = 0;
                        }
                        else
                        {
                            writeRes = 0; // assume successful transmission, will be checked next during next packet
                        }

                        // prepare response
                        txBuffer.packetOpcode = 0xA3;
                        txBuffer.dataLen = 0x01;

                        if (writeRes == 0)
                        {
                            // success
                            if ((flashIndexApp2 - APP_2_START_ADDRESS) < payloadSize / 2)
                            {
                                txBuffer.packetData[0] = 0x01; // send next chunk of data
                            }
                            else
                            {
                                txBuffer.packetData[0] = 0x02; // application is completely transferred.
                                BL_State = BL_STATE_WRITE_FINISHED;
                            }
                        }
                        else
                        {
                            txBuffer.packetData[0] = 0x00; // failed
                        }
                        sendPacket(&txBuffer);
                    }
                    else
                    {
                        txBuffer.packetOpcode = 0xA3;
                        txBuffer.dataLen = 0x01;
                        txBuffer.packetData[0] = 0xFF; // overflow
                        sendPacket(&txBuffer);
                    }
                }
            }

            // End flash
        }
        if (BL_State == BL_STATE_WRITE_FINISHED)
        {
            crc = crc_finalize(crc);

            txBuffer.packetOpcode = 0xA4;
            txBuffer.dataLen = 1;

            uint32_t rcvdCrc = bytesToU32(rxBuffer.packetData, 0);

            if (rcvdCrc == crc)
            {
                // correct
                txBuffer.packetData[0] = 0;
            }
            else
            {
                // mismatch
                txBuffer.packetData[0] = 1;
            }
            flashed_success(selectedApp1);

            sendPacket(&txBuffer);

            BL_State = BL_STATE_IDLE;
            // Restart request
        }
        else if (rxBuffer.packetOpcode == 0x05)
        {
            SysCtlReset();
            // Get PC (Just for testing code execution from RAM)
        }
        else if (rxBuffer.packetOpcode == 0x06)
        {
            // send PC
            uint32_t pc = _get_PC();
            txBuffer.packetOpcode = 0xA6;
            txBuffer.dataLen = 4;
            txBuffer.packetData[0] = (pc & 0xFF000000) >> 24;
            txBuffer.packetData[1] = (pc & 0x00FF0000) >> 16;
            txBuffer.packetData[2] = (pc & 0x0000FF00) >> 8;
            txBuffer.packetData[3] = pc & 0x000000FF;
            sendPacket(&txBuffer);
        }
    }
    return 0;
}

// Function to update switch state
void updateSwitchState(uint8_t switchIndex, bool pressed)
{
    if (pressed)
    {
        // If switch is currently pressed, ignore further presses until released
        if (!switchStates[switchIndex].pressed)
        {
            switchStates[switchIndex].pressCount++;   // Increment press count
            switchStates[switchIndex].pressed = true; // Update switch state
        }
    }
    else
    {
        switchStates[switchIndex].pressed = false; // Update switch state when released
    }
}

// Function to check if a switch is pressed twice within any time interval
bool isSwitchPressedTwice(uint8_t switchIndex)
{
    if (switchStates[switchIndex].pressCount == 2)
    {
        switchStates[switchIndex].pressCount = 0; // Reset press count
        return true;                              // Switch pressed twice
    }
    return false; // Switch not pressed twice
}

void delayMs(int x)
{
    int i, j;
    for (i = 0; i < x; i++)
        for (j = 0; j < 3180; j++)
        {
        } // Loop for 1 ms delay
}

void UART0Init(uint32_t ui32Port, uint32_t ui32BaudRate)
{
    // Enable UART Clock
    SysCtlPeripheralEnable(SYSCTL_PERIPH_UART0);
//    SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOA);

    // Configure UART GPIO
    GPIOPinConfigure(GPIO_PA0_U0RX);
    GPIOPinConfigure(GPIO_PA1_U0TX);
    GPIOPinTypeUART(GPIO_PORTA_BASE, GPIO_PIN_0 | GPIO_PIN_1);

    // Configure UART with baud rate
    UARTConfigSetExpClk(ui32Port, SysCtlClockGet(), ui32BaudRate,UART_CONFIG_WLEN_8 | UART_CONFIG_STOP_ONE | UART_CONFIG_PAR_NONE);
}

void LCD_default_display(char *ar)
{
    LCD_send_char(1, 0x01); // clear screen
    LCD_send_char(1, 0x38); //  use 2 lines and 5x7 matrix
    LCD_send_char(1, 0x0F); // LCD on, cursor blinking on, cursor on
    // 1st line
    LCD_send_char(1, 0x80); // force cursor to start of 1st line

    int i=0;
    while(*(ar+i)!='\0')
    {
        LCD_send_char(0, *(ar+i));
        i++;
    }

    delayMs(500);
}

void app_1_2(void)
{
    LCD_send_char(1, 0x01); // clear screen
    LCD_send_char(1, 0x38); //  use 2 lines and 5x7 matrix
    LCD_send_char(1, 0x0F); // LCD on, cursor blinking on, cursor on
    // 1st line
    LCD_send_char(1, 0x80); // force cursor to start of 1st line
    LCD_send_char(0, 'C');
    LCD_send_char(0, 'H');
    LCD_send_char(0, 'O');
    LCD_send_char(0, 'O');
    LCD_send_char(0, 'S');
    LCD_send_char(0, 'E');
    LCD_send_char(0, ' ');
    LCD_send_char(0, 'A');
    LCD_send_char(0, 'P');
    LCD_send_char(0, 'P');
    LCD_send_char(0, '1');

    // 2nd line
    LCD_send_char(1, 0xC0); // force cursor to start of 2nd line
    LCD_send_char(0, 'O');
    LCD_send_char(0, 'R');
    LCD_send_char(0, ' ');
    LCD_send_char(0, 'A');
    LCD_send_char(0, 'P');
    LCD_send_char(0, 'P');
    LCD_send_char(0, '2');
    delayMs(500);
}

void flashed_success(int app_no)
{
    LCD_send_char(1, 0x01); // clear screen
    LCD_send_char(1, 0x38); //  use 2 lines and 5x7 matrix
    LCD_send_char(1, 0x0F); // LCD on, cursor blinking on, cursor on
    // 1st line
    LCD_send_char(1, 0x80); // force cursor to start of 1st line
    LCD_send_char(0, 'A');
    LCD_send_char(0, 'P');
    LCD_send_char(0, 'P');
    LCD_send_char(0, ' ');

    if(app_no) LCD_send_char(0, '1'); //if app_1 is flashed
    else LCD_send_char(0, '2');       //else app_2 is flashed

    LCD_send_char(0, ' ');
    LCD_send_char(0, 'F');
    LCD_send_char(0, 'L');
    LCD_send_char(0, 'A');
    LCD_send_char(0, 'S');
    LCD_send_char(0, 'H');
    LCD_send_char(0, 'E');
    LCD_send_char(0, 'D');

    // 2nd line
    LCD_send_char(1, 0xC0); // force cursor to start of 2nd line
    LCD_send_char(0, 'S');
    LCD_send_char(0, 'U');
    LCD_send_char(0, 'C');
    LCD_send_char(0, 'C');
    LCD_send_char(0, 'E');
    LCD_send_char(0, 'S');
    LCD_send_char(0, 'S');
    LCD_send_char(0, 'F');
    LCD_send_char(0, 'U');
    LCD_send_char(0, 'L');
    LCD_send_char(0, 'L');
    LCD_send_char(0, 'Y');
    LCD_send_char(0, '!');
    LCD_send_char(0, '!');
    delayMs(500);
}

void LCD_send_char(int command, char value)
{
    if (command == 1)
    {
        GPIO_PORTA_DATA_R &= ~0x40;
        GPIO_PORTB_DATA_R = value;
        GPIO_PORTA_DATA_R |= 0x80;
        //        delay_us(200);
        delayMs(5);
        GPIO_PORTA_DATA_R &= ~0x80;
    }
    else
    {
        GPIO_PORTA_DATA_R |= 0x40;
        GPIO_PORTB_DATA_R = value;
        GPIO_PORTA_DATA_R |= 0x80;
        //        delay_us(200);
        delayMs(5);
        GPIO_PORTA_DATA_R &= ~0x80;
    }
}

void LCD_init(void)
{
    SYSCTL_RCGC2_R |= 0x00000023;   // Enable clock to GPIOA and GPIOB at clock gating control register
    GPIO_PORTA_LOCK_R = 0x4C4F434B; // Unlock commit register
    GPIO_PORTA_CR_R |= 0xC0;        // Make PORTA configurable
    GPIO_PORTA_DEN_R |= 0xC0;       // Enable digital IO for PA7, PA6
    GPIO_PORTA_DIR_R |= 0xC0;       // Make PA7, PA6 output
    GPIO_PORTB_LOCK_R = 0x4C4F434B; // Unlock commit register
    GPIO_PORTB_CR_R |= 0xFF;        // Make PORTB configurable
    GPIO_PORTB_DEN_R |= 0xFF;       // Enable digital IO for PB0-7
    GPIO_PORTB_DIR_R |= 0xFF;       // Make PB0-7 as outputs
}
