#include <stdio.h>
#include <stdint.h>
#include <stdlib.h>
#include <math.h>

// Function to perform modular exponentiation
uint32_t mod_exp(uint32_t base, uint32_t exp, uint32_t mod) {
    uint32_t result = 1;
    base %= mod;
    while (exp > 0) {
        if (exp & 1) // If exp is odd
            result = (result * base) % mod;
        exp >>= 1; // Divide the exponent by 2
        base = (base * base) % mod;
    }
    return result;
}

void encrypt(unsigned char *msg, uint8_t *enc_msg, int SZ, uint32_t n, uint32_t e) {
    int i;
    for (i = 0; i < SZ; ++i) {
        uint16_t temp = mod_exp(msg[i], e, n);
        enc_msg[(i << 1)] = (uint8_t)temp;
        enc_msg[(i << 1) + 1] = (uint8_t)(temp >> 8);
    }
}

void decrypt(uint8_t *crypt_msg, unsigned char *msg, int sz, uint32_t n, uint32_t d) {
    uint32_t i, j;
    uint16_t acc;

    for (i = 0; i < sz; i += 2) {
        acc = ((uint16_t)crypt_msg[i + 1] << 8) + crypt_msg[i];
        acc = mod_exp(acc, d, n);
        msg[i >> 1] = acc;
    }
}

int main() {
    // Open input binary file for reading
    FILE *input_file = fopen("Green_blink_10000.bin", "rb");
    if (input_file == NULL) {
        perror("Error opening input file");
        return 1;
    }

    // Get the size of the input binary file
    fseek(input_file, 0, SEEK_END);
    long input_file_size = ftell(input_file);
    rewind(input_file);

    // Allocate memory for input data
    unsigned char *input_data = (unsigned char *)malloc(input_file_size);
    if (input_data == NULL) {
        perror("Error allocating memory");
        fclose(input_file);
        return 1;
    }

    // Read input binary data
    if (fread(input_data, 1, input_file_size, input_file) != input_file_size) {
        perror("Error reading input file");
        free(input_data);
        fclose(input_file);
        return 1;
    }

    fclose(input_file);

    // Perform encryption
    int n = 299, d = 53, e = 5;
    uint8_t encoded_data[input_file_size * 2]; // Twice the size for encoded data
    encrypt(input_data, encoded_data, input_file_size, n, e);

    // Write encoded data to output binary file
    FILE *output_file_encrypted = fopen("Green_blink_10000_encoded.bin", "wb");
    if (output_file_encrypted == NULL) {
        perror("Error opening output file for writing");
        free(input_data);
        return 1;
    }
    fwrite(encoded_data, 1, input_file_size * 2, output_file_encrypted);
    fclose(output_file_encrypted);

    // Perform decryption
    unsigned char decoded_data[input_file_size];
    decrypt(encoded_data, decoded_data, input_file_size * 2, n, d);

    // Write decoded data to output binary file
    FILE *output_file_decrypted = fopen("Green_blink_10000_decoded.bin", "wb");
    if (output_file_decrypted == NULL) {
        perror("Error opening output file for writing");
        free(input_data);
        return 1;
    }
    fwrite(decoded_data, 1, input_file_size, output_file_decrypted);
    fclose(output_file_decrypted);

    free(input_data);
    return 0;
}
