#include <stdint.h>
#include <math.h>
#include <./inc/tm4c123gh6pm.h>

#include "UART_init.h"
#include "GPIO.h"
#include "ADC_PWM.h"
#include "core_logic.h"
#include "ultrasonic_sensor.h"

/* global variables to store and display distance in cm */
uint32_t time; /*stores pulse on time */
uint32_t distance; /* stores measured distance value */

char mesg[25];  /* string format of distance value */

int front_obstacle_detected = 0;
int left_obstacle_detected = 0;
int right_obstacle_detected = 0;

/* main code to take distance measurement and send data to UART terminal */
int main(void)
{
    NVIC_ST_CTRL_R = 0;            /* disable SysTick during setup */

    /* Configure SysTick */
    NVIC_ST_RELOAD_R = 16000-1; /* reload with number of clocks per second */
    NVIC_ST_CTRL_R = 7; /* enable SysTick interrupt, use system clock */

    all_GPIO_INIT ();                          /* All GPIO Port Initializations */
    UART_init_lib_func ();
    GPIOPortC_Interrupt_Init ();               /* initialize GPIO Port C interrupt */
    GPIOPortF_Interrupt_Init ();               /* initialize GPIO Port F interrupt */

    PWM_init ();
    ADC_init ();


    Timer0ACapture_init();  /*initialize Timer0A in edge edge time */
    Timer1ACapture_init();  /*initialize Timer2A in edge edge time */
    Timer3ACapture_init();  /*initialize Timer3A in edge edge time */

    ADC_PWM_output ();

    while(1)
    {
            flag_motor = 1;
            time = Measure_distance_from_front_sensor(); /* take pulse duration measurement */
            distance = (time * 10625)/10000000; /* convert pulse duration into distance */
            UARTprintf("Distance from front sensor = %u\n", distance);

            if (distance <= 40) {
                front_obstacle_detected = 1;
                UARTprintf("front_obstacle_detected = %d\n", front_obstacle_detected);
            }
            time = Measure_distance_from_left_sensor(); /* take pulse duration measurement */
            distance = (time * 10625)/10000000; /* convert pulse duration into distance */
            UARTprintf("Distance from left sensor = %u\n", distance);

            if (distance <= 40) {
                left_obstacle_detected = 1;
                UARTprintf("left_obstacle_detected = %d\n", left_obstacle_detected);
            }
            time = Measure_distance_from_right_sensor(); /* take pulse duration measurement */
            distance = (time * 10625)/10000000; /* convert pulse duration into distance */
            UARTprintf("Distance from right sensor = %u\n", distance);

            if (distance <= 40) {
                right_obstacle_detected = 1;
                UARTprintf("right_obstacle_detected = %d\n", right_obstacle_detected);
            }

            UARTprintf ("Debug: sec is %d\n", sec);
            if (timer_state == RUNNING)
                monitor_and_act_based_on_ultrasonic_sensors ();
    }
}
