/*
 * core_logic.c
 *
 *  Created on: 03-Apr-2024
 *      Author: krish
 */

#include <stdio.h>
#include "core_logic.h"
#include "UART_init.h"
#include "GPIO.h"

#define TURN_MILLI_SEC_DURATION 600

void Delay_stop(unsigned long counter);

void take_uturn (void) {

    int time_sensed_front_ultrasonic_sensor = sec;
    UARTprintf("Debug: uturn !!");

    // STOP BOTH THE MOTORS
    GPIO_PORTA_DATA_R &= ~(1<<5);
    GPIO_PORTA_DATA_R &= ~(1<<6);

    GPIO_PORTA_DATA_R &= ~(1<<3);
    GPIO_PORTA_DATA_R &= ~(1<<2);

    while (sec != (time_sensed_front_ultrasonic_sensor - 5)) ;

    int milli_sec_time_sensed_front_ultrasonic_sensor = millisec;
    UARTprintf("millisec is %d\n", millisec);
       UARTprintf("millisec_used_recent is %d\n", milli_sec_time_sensed_front_ultrasonic_sensor);
    while (millisec < (milli_sec_time_sensed_front_ultrasonic_sensor + (2*TURN_MILLI_SEC_DURATION))) { // Left wheel moves backward for 5 seconds in the opposite direction
        GPIO_PORTA_DATA_R |= (1<<5);
        GPIO_PORTA_DATA_R &= ~(1<<6);
    }

    GPIO_PORTA_DATA_R |= (1<<6);
    GPIO_PORTA_DATA_R &= ~(1<<5);

    GPIO_PORTA_DATA_R |= (1<<3);
    GPIO_PORTA_DATA_R &= ~(1<<2);
}

void take_left_turn (void) {
    int time_sensed_left_ultrasonic_sensor = sec;
    UARTprintf("Debug: left turn !!");

    // STOP BOTH THE MOTORS
    GPIO_PORTA_DATA_R &= ~(1<<5);
    GPIO_PORTA_DATA_R &= ~(1<<6);

    GPIO_PORTA_DATA_R &= ~(1<<3);
    GPIO_PORTA_DATA_R &= ~(1<<2);

    while (sec != (time_sensed_left_ultrasonic_sensor - 5)) ;

    int milli_sec_time_sensed_left_ultrasonic_sensor = millisec;

    while (millisec < (milli_sec_time_sensed_left_ultrasonic_sensor + TURN_MILLI_SEC_DURATION)) { // Left wheel moves backward for 5 seconds in the opposite direction
        UARTprintf("millisec is %d\n", millisec);
        UARTprintf("millisec_used_recent is %d\n", milli_sec_time_sensed_left_ultrasonic_sensor);

        GPIO_PORTA_DATA_R |= (1<<5);
        GPIO_PORTA_DATA_R &= ~(1<<6);
    }

    GPIO_PORTA_DATA_R |= (1<<6);
    GPIO_PORTA_DATA_R &= ~(1<<5);

    GPIO_PORTA_DATA_R |= (1<<3);
    GPIO_PORTA_DATA_R &= ~(1<<2);
}


void take_right_turn (void) {
    int time_sensed_right_ultrasonic_sensor = sec;
    UARTprintf("Debug: right turn !!");

    // STOP BOTH THE MOTORS
     GPIO_PORTA_DATA_R &= ~(1<<5);
     GPIO_PORTA_DATA_R &= ~(1<<6);

     GPIO_PORTA_DATA_R &= ~(1<<3);
     GPIO_PORTA_DATA_R &= ~(1<<2);

     while (sec != (time_sensed_right_ultrasonic_sensor - 5)) ;

     int milli_sec_time_sensed_right_ultrasonic_sensor = millisec;

    while (millisec < (milli_sec_time_sensed_right_ultrasonic_sensor + TURN_MILLI_SEC_DURATION)) { // Left wheel moves backward for 5 seconds in the opposite direction
        UARTprintf("millisec is %d\n", millisec);
        UARTprintf("millisec_used_recent is %d\n", milli_sec_time_sensed_right_ultrasonic_sensor);
        GPIO_PORTA_DATA_R |= (1<<2);
        GPIO_PORTA_DATA_R &= ~(1<<3);
    }

    GPIO_PORTA_DATA_R |= (1<<6);
    GPIO_PORTA_DATA_R &= ~(1<<5);

    GPIO_PORTA_DATA_R |= (1<<3);
    GPIO_PORTA_DATA_R &= ~(1<<2);
}

void go_straight (void) {
        GPIO_PORTA_DATA_R |= (1<<6);
        GPIO_PORTA_DATA_R &= ~(1<<5);

        GPIO_PORTA_DATA_R |= (1<<3);
        GPIO_PORTA_DATA_R &= ~(1<<2);
}

void monitor_and_act_based_on_ultrasonic_sensors (void) {

    UARTprintf("core_logic: left_obstacle_detected = %d\n", left_obstacle_detected);
    UARTprintf("core_logic: right_obstacle_detected = %d\n", right_obstacle_detected);
    UARTprintf("core_logic: front_obstacle_detected = %d\n", front_obstacle_detected);
    if ((left_obstacle_detected == 0) && (right_obstacle_detected == 0) && (front_obstacle_detected == 1)) {
        take_left_turn ();
        UARTprintf("Motor: Left turn\n");
    }
    else if ((left_obstacle_detected == 0) && (right_obstacle_detected == 1) && (front_obstacle_detected == 0)) {
        take_left_turn ();
        UARTprintf("Motor: Left turn\n");
    }
    else if ((left_obstacle_detected == 0) && (right_obstacle_detected == 1) && (front_obstacle_detected == 1)) {
        take_left_turn ();
        UARTprintf("Motor: Left turn\n");
    }
    else if ((left_obstacle_detected == 1) && (right_obstacle_detected == 0) && (front_obstacle_detected == 0)) {
        go_straight ();
        UARTprintf("Motor: Go Straight\n");
    }
    else if ((left_obstacle_detected == 1) && (right_obstacle_detected == 0) && (front_obstacle_detected == 1)) {
        take_right_turn ();
        UARTprintf("Motor: Right turn\n");
    }
    else if ((left_obstacle_detected == 1) && (right_obstacle_detected == 1) && (front_obstacle_detected == 0)) {
        go_straight ();
        UARTprintf("Motor: Go Straight\n");
    }
    else if ((left_obstacle_detected == 1) && (right_obstacle_detected == 1) && (front_obstacle_detected == 1)) {
        take_uturn ();
        UARTprintf("Motor: Uturn\n");
    }
    front_obstacle_detected = 0;
    left_obstacle_detected = 0;
    right_obstacle_detected = 0;
}
