/*
 * UART.c
 *
 *  Created on: 10-Feb-2024
 *      Author: krish
 */
#include <stdlib.h>

#include <stdio.h>

#ifndef GPIO_H_
#include"GPIO.h"
#endif
//#include "SSD.h"
#include "UART_init.h"

void UART_init_lib_func (void) {
        SysCtlPeripheralEnable(SYSCTL_PERIPH_UART0);
        SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOA);

        GPIOPinConfigure(GPIO_PA0_U0RX);
        GPIOPinConfigure(GPIO_PA1_U0TX);
        GPIOPinTypeUART(GPIO_PORTA_BASE, GPIO_PIN_0 | GPIO_PIN_1);

        UARTConfigSetExpClk(UART0_BASE, SysCtlClockGet(), 115200,(UART_CONFIG_WLEN_8 | UART_CONFIG_STOP_ONE | UART_CONFIG_PAR_NONE));

        // Initialize UART0
        UARTStdioConfig(0, 115200, SysCtlClockGet());

        UARTprintf ("\nCommand help: (Valid Commands are mentioned below)\n");
        UARTprintf ("1. timer start (with any tab/spaces in it) - Command is case insensitive\n");
        UARTprintf ("2. timer stop (with any tab/spaces in it) - Command is case insensitive\n");
        UARTprintf ("3. timer pause (with any tab/spaces in it) - Command is case insensitive\n");
        UARTprintf ("4. timer resume (with any tab/spaces in it) - Command is case insensitive\n");
        UARTprintf ("5. timer set xxx  (sec) (with any tab/spaces in it) - Command is case insensitive\n");
}

// Pre-processing the input string and removing all tabs, spaces and converting into lower case so as to support both lower case and upper case
void pre_process_input_string (char *input_string) {
    int j = 0;
    int invalid_command = 0;
    char checking_if_command_is_timerset [MAX_INPUT_SIZE];
    char seconds_in_char [MAX_INPUT_SIZE];
    int timerset_command_entered = 0;

    char modified_input_string [MAX_INPUT_SIZE];

    // Iterating over each character in the input_string, and if the character is not a whitespace character, it adds it to the modified_input_string.
    for (int i = 0; input_string[i] != '\0'; i++) {
         if (!isspace((unsigned char)input_string[i])) {
             modified_input_string[j] = input_string[i];
             j++;
         }
    }

    modified_input_string[j] = '\0'; // Null terminate the modified string
    strlwr(modified_input_string); // convert a string to lower case

    j = 0;
    // Check if the string till first numeric character = 'timerset'. If yes then assign the numeric value to sec
    for (int i = 0; modified_input_string[i] != '\0'; i++){
        if (!isdigit((unsigned char) modified_input_string[i])) {
            checking_if_command_is_timerset [j] = modified_input_string[i];
            j++;
        }
    }
    checking_if_command_is_timerset [j] = '\0';

    int k = 0;
    if (strcmp(checking_if_command_is_timerset, "timerset") == 0) {
        timerset_command_entered = 1;
        for (int i = j; (modified_input_string[i] != '\0'); i++) {
            if (isdigit((unsigned char) modified_input_string[i])) {
                seconds_in_char [k] = modified_input_string [i];
                k++;
            } else {
                invalid_command = 1;
                break;
            }
        }
        seconds_in_char [k] = '\0';

        if (invalid_command == 0){
            sec = atoi (seconds_in_char);
            default_stopwatch_count = atoi (seconds_in_char);
        }
    }

     // Check for start, stop, pause and resume commands
     if ((strcmp(modified_input_string, "timerstop") == 0) || (strcmp(modified_input_string, "timerreset") == 0)) {
         timer_state = STOP;
         return; // Exit the function prematurely
     } else if (strcmp(modified_input_string, "timerpause") == 0) {
         if (timer_state != STOP)
             timer_state = PAUSE;
         return; // Exit the function prematurely
     } else if (strcmp(modified_input_string, "timerresume") == 0) {
         timer_state = RUNNING;
         return; // Exit the function prematurely
     } else if (strcmp(modified_input_string, "timerstart") == 0) {
         timer_state = RUNNING;
         return; // Exit the function prematurely
     } else if ((timerset_command_entered == 1) && (invalid_command == 0) ) {
         UARTprintf("\nChanging Stopwatch Initial value to %d sec\n", atoi (seconds_in_char));
     }
     else {
         UARTprintf("\nInvalid Command. Please re-check the command given\n");
         UARTprintf ("\nCommand help: (Valid Commands are mentioned below)\n");
         UARTprintf ("1. timer start (with any tab/spaces in it) - Command is case insensitive\n");
         UARTprintf ("2. timer stop (with any tab/spaces in it) - Command is case insensitive\n");
         UARTprintf ("3. timer pause (with any tab/spaces in it) - Command is case insensitive\n");
         UARTprintf ("4. timer resume (with any tab/spaces in it) - Command is case insensitive\n");
         UARTprintf ("5. timer set xxx  (sec) (with any tab/spaces in it) - Command is case insensitive\n");
         return; // Exit the function prematurely
     }
}

void read_through_UART (void) {
// Commands through UART(Console)
    if (UARTCharsAvail(UART0_BASE)) { // Wait until a character is available in the UART receive FIFO
     //To read characters from UART
     char console_cmd_buffer [MAX_INPUT_SIZE];
     int bufferIndex = 0;
     while (1) {
         // Read the character from UART
         char receivedChar = UARTCharGet(UART0_BASE);

         // Check if "Enter" key (newline) is pressed - Here, enter is being recognized as "\r" so below condition is used.
         if (receivedChar == '\n' || receivedChar == '\r') {
             // Enter key detected, process the input buffer and reset the buffer
             console_cmd_buffer[bufferIndex] = '\0';  // Null-terminate the string
             UARTCharPut(UART0_BASE, '\r');
             UARTCharPut(UART0_BASE, '\n');
             // Reset the buffer index for the next input
             bufferIndex = 0;
         } else if (receivedChar == '\b') {
             bufferIndex = bufferIndex - 1;
             UARTCharPut(UART0_BASE, '\b');
             UARTCharPut(UART0_BASE, ' ');
             UARTCharPut(UART0_BASE, '\b');
         } else {
             // Store the character in the input buffer
             if (bufferIndex < (MAX_INPUT_SIZE - 1)) {
                 console_cmd_buffer[bufferIndex++] = receivedChar;
                 UARTCharPut(UART0_BASE, receivedChar);
             } else {
                 // Handling buffer overflow
                 UARTprintf("\n");
                 UARTprintf("Buffer Overflow");
                 UARTprintf("Maximum limit of 20 characters reached. Re-check the command");
                 UARTprintf(" ");
                 UARTprintf ("Please enter a valid command: ");
                 break;
             }
         }
         if (bufferIndex == 0) {
             pre_process_input_string (console_cmd_buffer);
             UARTprintf("\n%s\n", (timer_state == RUNNING) ? "Timer RUNNING" : (timer_state == PAUSE) ? "Timer PAUSE" : "Timer READY");
             UARTprintf("\nPlease enter new valid command: \n");
             break;
         }
     }
  }
}
