/*
 * GPIO.c
 */
#include<stdio.h>
#include "GPIO.h"
#include "UART_init.h"
#include "ADC_PWM.h"

int default_stopwatch_count = 999;

int sec = 999;
int millisec = 0;
int millisec_display = 0;

int debouncing_time = 0;
int flag_debouncing = 0;
int flag_motor = 0;

int led_time = 0;

int SSD_time = 0;

int motor_delay_time = 0;

int timer_state = STOP;

void all_GPIO_INIT (void) {
    GPIOA_INIT ();
    GPIOB_INIT ();
    GPIOC_INIT ();
    GPIOD_INIT ();
    GPIOE_INIT ();
    GPIOF_INIT ();
}
void GPIOA_INIT(void)
{
    SYSCTL_RCGC2_R |= 0x00000001 ;       /* Enable clock to GPIO_A_ at clock gating control register */

    SYSCTL_RCGCGPIO_R |= 0x00000001 ;    /* Enable and provide a clock to GPIO Port_A_ in Run mode */

    while((SYSCTL_PRGPIO_R & 0x01) == 0){}; // Wait for clock to stabilize

    GPIO_PORTA_DIR_R |= 0x000000FC ;    /*  GPIO Direction | 0 -> INPUT | 1 -> OUTPUT */

//    GPIO_PORTA_DIR_R &= ~ 0x000000E1 ;

//    GPIO_PORTA_LOCK_R = 0x4C4F434B;     /* unlock commit register */

    GPIO_PORTA_AFSEL_R |= 0x00000000 ;  /* Disable alternate function on PORT */

    GPIO_PORTA_AMSEL_R |= 0x00000000 ;  /* Disable analog function on PORT */

    GPIO_PORTA_PCTL_R &= ~ 0xFFFFFF00 ; /* Regular digital function */

//    GPIO_PORTA_ODR_R |= 0x00000008 ;    /* 1 -> The corresponding pin is configured as open drain */
//
//    GPIO_PORTA_PUR_R |= 0x00000000 ;    /* 1 -> The corresponding pin's weak pull-up resistor is enabled */
//
//    GPIO_PORTA_PDR_R |= 0x000000F0 ;    /* 1 -> The corresponding pin's weak pull-down resistor is enabled */

    GPIO_PORTA_DEN_R |= 0xFC;       /* enable the GPIO pins for digital function */

    GPIO_PORTA_DATA_R |= 0x00000000 ;

}


void GPIOB_INIT(void)
{
    SYSCTL_RCGC2_R |= 0x00000002 ;       /* Enable clock to GPIO_B_ at clock gating control register */

    SYSCTL_RCGCGPIO_R |= 0x00000002 ;    /* Enable and provide a clock to GPIO Port_B_ in Run mode */

    while((SYSCTL_PRGPIO_R & 0x02) == 0){}; // Wait for clock to stabilize

    GPIO_PORTB_DIR_R |= 0x000000FC ;    /*  GPIO Direction | 0 -> INPUT | 1 -> OUTPUT */

//    GPIO_PORTB_DIR_R &= ~0xE0 ;

//    GPIO_PORTB_LOCK_R = 0x4C4F434B;     /* unlock commit register */

    GPIO_PORTB_AFSEL_R &= ~ 0xFFFFFFFC ;  /* Disable alternate function on PORT */

    GPIO_PORTB_AMSEL_R &= ~ 0xFFFFFFFF ;  /* Disable analog function on PORT */

    GPIO_PORTB_PCTL_R &= ~ 0xFFFFFF00 ; /* Regular digital function */

//    GPIO_PORTB_ODR_R |= 0x00000000 ;    /* 1 -> The corresponding pin is configured as open drain */
//
//    GPIO_PORTB_PUR_R |= 0x00000000 ;    /* 1 -> The corresponding pin's weak pull-up resistor is enabled */

//    GPIO_PORTB_PDR_R |= 0x000000E0 ;    /* 1 -> The corresponding pin's weak pull-down resistor is enabled */

    GPIO_PORTB_DEN_R |= 0xFC;       /* enable the GPIO pins for digital function */

    GPIO_PORTB_DATA_R |= 0x00000000 ;

}

void GPIOC_INIT(void)
{
    /* Do no use PC[3:0] */

//    SYSCTL_RCGCGPIO_R |= 0x34;      // Enable clock to GPIO PORTC, PORTE and PORTF
//    GPIO_PORTC_DIR_R |= 0x00;       // Set PC 4-7 as input
//    GPIO_PORTC_DEN_R |= 0xF0;       // Digital Enable PC 4-7
//    GPIO_PORTC_PUR_R |= 0xF0;       // Enable Pull Up Resistors for input PORTC 4-7

    SYSCTL_RCGC2_R |= 0x00000004 ;       /* Enable clock to GPIO_C_ at clock gating control register */

    SYSCTL_RCGCGPIO_R |= 0x00000004 ;    /* Enable and provide a clock to GPIO Port_C_ in Run mode */

//    GPIO_PORTC_CR_R |= 0xFFFFFFFF ;     /* 1 -> The corresponding GPIOAFSEL, GPIOPUR, GPIOPDR, or GPIODEN bits can be written */

//    GPIO_PORTC_LOCK_R &= ~ 0x4C4F434B;     /* unlock commit register */

    GPIO_PORTC_DIR_R &= ~ 0xF0 ;    /*  GPIO Direction | 0 -> INPUT | 1 -> OUTPUT */

//    GPIO_PORTC_LOCK_R = 0x4C4F434B;     /* unlock commit register */

//    GPIO_PORTC_AFSEL_R |= 0x00 ;  /* Disable alternate function on PORT */

//    GPIO_PORTC_AMSEL_R |= 0x00 ;  /* Disable analog function on PORT */

//    GPIO_PORTC_PCTL_R &= ~ 0xF0 ; /* Regular digital function */

    GPIO_PORTC_ODR_R |= 0xF0 ;    /* 1 -> The corresponding pin is configured as open drain */

    GPIO_PORTC_DEN_R |= 0xF0;       /* enable the GPIO pins for digital function */

    GPIO_PORTC_PUR_R |= 0xF0 ;    /* 1 -> The corresponding pin's weak pull-up resistor is enabled */
//
//    GPIO_PORTC_PDR_R |= 0x00 ;    /* 1 -> The corresponding pin's weak pull-down resistor is enabled */

}

void GPIOD_INIT(void)
{
    SYSCTL_RCGC2_R |= 0x00000008 ;       /* Enable clock to GPIO_D_ at clock gating control register */

//    SYSCTL_RCGCGPIO_R |= 0x00000008 ;    /* Enable and provide a clock to GPIO Port_D_ in Run mode */

    GPIO_PORTD_DIR_R |= 0xFF ;    /* PD2 -> I | PD3-> O */ /*  GPIO Direction | 0 -> INPUT | 1 -> OUTPUT */

//    GPIO_PORTD_LOCK_R = 0x4C4F434B;     /* unlock commit register */

    GPIO_PORTD_AFSEL_R &= ~ 0xFFFFFFFF ;  /* Disable alternate function on PORT */

    GPIO_PORTD_AFSEL_R |= 0x00000000 ;  /* Enable alternate function on PORTD2 */

    GPIO_PORTD_AMSEL_R &= ~0xFFFFFFFF ;  /* Disable analog function on PORT */

    GPIO_PORTD_PCTL_R &= ~ 0xFFFFFFFF ; /* Regular digital function */

    GPIO_PORTD_PCTL_R |= 0x00000000 ; /* Alternate digital function -> PD2 */

//    GPIO_PORTD_ODR_R |= 0x00000000 ;    /* 1 -> The corresponding pin is configured as open drain */
//
//    GPIO_PORTD_PUR_R |= 0x00000000 ;    /* 1 -> The corresponding pin's weak pull-up resistor is enabled */
//
//    GPIO_PORTD_PDR_R |= 0x00000000 ;    /* 1 -> The corresponding pin's weak pull-down resistor is enabled */

    GPIO_PORTD_DEN_R |= 0xFF;       /* enable the GPIO pins for digital function */

    GPIO_PORTD_DATA_R |= 0x00 ;
}

void GPIOE_INIT(void)
{
    SYSCTL_RCGC2_R |= 0x00000010 ;       /* Enable clock to GPIO_E_ at clock gating control register */

    SYSCTL_RCGCGPIO_R |= 0x00000010 ;    /* Enable and provide a clock to GPIO Port_E_ in Run mode */

    GPIO_PORTE_DIR_R |= 0x0F ;    /*  GPIO Direction | 0 -> INPUT | 1 -> OUTPUT */

//    GPIO_PORTE_AFSEL_R &= ~ 0x0F ;  /* Disable alternate function on PORT */
//
//    GPIO_PORTE_AMSEL_R &= ~ 0x0F ;  /* Disable analog function on PORT */
//
//    GPIO_PORTE_PCTL_R &= ~ 0x0F ; /* Regular digital function */

    GPIO_PORTE_DEN_R |= 0x0F;       /* enable the GPIO pins for digital function */

    GPIO_PORTE_DATA_R = 0x00 ;
}

void GPIOF_INIT(void)
{
    SYSCTL_RCGC2_R |= 0x00000020 ;       /* Enable clock to GPIO_F_ at clock gating control register */

    SYSCTL_RCGCGPIO_R |= 0x00000020 ;    /* Enable and provide a clock to GPIO Port_F_ in Run mode */

    GPIO_PORTF_DIR_R = 0x0000000E ;    /*  GPIO Direction | 0 -> INPUT | 1 -> OUTPUT */

    GPIO_PORTF_LOCK_R = 0x4C4F434B;     /* unlock commit register */

    GPIO_PORTF_CR_R |= 0xFFFFFFFF ;     /* 1 -> The corresponding GPIOAFSEL, GPIOPUR, GPIOPDR, or GPIODEN bits can be written */

    GPIO_PORTF_AFSEL_R &= ~ 0xFFFFFFFF ;  /* Disable alternate function on PORT */

    GPIO_PORTF_AMSEL_R = 0x00000000 ;  /* Disable analog function on PORT */

    GPIO_PORTF_PCTL_R &= ~ 0xFFFFFFFF ; /* Regular digital function */

    GPIO_PORTF_ODR_R |= 0x00000000 ;    /* 1 -> The corresponding pin is configured as open drain */

    GPIO_PORTF_PUR_R |= 0x00000011 ;    /* 1 -> The corresponding pin's weak pull-up resistor is enabled */

    GPIO_PORTF_PDR_R |= 0x00000000 ;    /* 1 -> The corresponding pin's weak pull-down resistor is enabled */

    GPIO_PORTF_DEN_R |= 0x1F;       /* enable the GPIO pins for digital function */

    GPIO_PORTF_DATA_R |= 0x00000000 ;
}

void GPIOPortF_Interrupt_Init(void)
{
    SYSCTL_RCGC2_R |= 0x00000020;   /* 1) activate clock for Port F */
    GPIO_PORTF_LOCK_R = 0x4C4F434B; /* 2) unlock GPIO Port F */
    GPIO_PORTF_CR_R = 0x1F;         /* allow changes to PF4-0 */
    GPIO_PORTF_AMSEL_R = 0x00;      /* 3) disable analog on PF */
    GPIO_PORTF_PCTL_R = 0x00000000; /* 4) PCTL GPIO on PF4-0 */
    GPIO_PORTF_DIR_R = 0x0E;        /* 5) PF4,PF0 in, PF3-1 out */
    GPIO_PORTF_AFSEL_R = 0x00;      /* 6) disable alt funct on PF7-0 */
    GPIO_PORTF_PUR_R = 0x11;        /* enable pull-up on PF0 and PF4 */
    GPIO_PORTF_DEN_R = 0x1F;        /* 7) enable digital I/O on PF4-0 */

    GPIO_PORTF_IS_R &= ~0x11;       /*  PF4 and PF0 are edge-sensitive */
    GPIO_PORTF_IBE_R &= ~0x11;      /*  PF4 and PF0 are not both edges */
    GPIO_PORTF_IEV_R &= ~0x11;      /*  PF4 and PF0 are falling edge events */
    GPIO_PORTF_ICR_R = 0x11;        /*  Clear flag4 and flag0 */
    GPIO_PORTF_IM_R |= 0x11;        /*  arm interrupt on PF4 */
    NVIC_PRI7_R = (NVIC_PRI7_R & 0xFF1FFFFF) | 0x00A00000; /*  priority 5 */
    NVIC_EN0_R = 0x40000000;        /*  Enable interrupt 30 in NVIC */

    EnableInterrupts();             /* Enable global Interrupt flag (I) */
}

void GPIOPortC_Interrupt_Init(void)
{
    GPIO_PORTC_IS_R &= ~0xF0;       /*  PF4 and PF0 are edge-sensitive */
    GPIO_PORTC_IBE_R &= ~0xF0;      /*  PF4 and PF0 are not both edges */
    GPIO_PORTC_IEV_R &= ~0xF0;      /*  PF4 and PF0 are falling edge events */
    GPIO_PORTC_ICR_R = 0xF0;        /*  Clear flag4 and flag0 */
    GPIO_PORTC_IM_R |= 0xF0;        /*  arm interrupt on PF4 */
    NVIC_PRI0_R = (NVIC_PRI0_R & 0xFF1FFFFF) | 0x00A00000; /*  priority 5 */
    NVIC_EN0_R |= 0x00000004;        /*  Enable interrupt 02 in NVIC */
}

void GPIOPortF_Handler(void)
{
    volatile int readback;

    if (timer_state == RUNNING) {
        if (((GPIO_PORTF_MIS_R & 0x10) >> 4) && (debouncing_time == 0)) {
            flag_debouncing = 1;
            timer_state = STOP;
        } else if (((GPIO_PORTF_MIS_R & 0x01) >> 0) && (debouncing_time == 0)) {
            flag_debouncing = 1;
            timer_state = PAUSE;
        }
    } else if (timer_state == STOP) {
        if (((GPIO_PORTF_MIS_R & 0x10) >> 4)  && (debouncing_time == 0)) {
            flag_debouncing = 1;
            timer_state = RUNNING;
        }
    } else if (timer_state == PAUSE) {
        if (((GPIO_PORTF_MIS_R & 0x01) >> 0) && (debouncing_time == 0)) {
            flag_debouncing = 1;
            timer_state = RUNNING;
        }
    }

    GPIO_PORTF_ICR_R = 0x11;        /* clear PF4 and PF0 int */
    readback = GPIO_PORTF_ICR_R;    /* a read to force clearing of interrupt flag */
    readback = readback;            /* suppress compiler warning "unused variable" */
}

// SYSTICK interrupt Handler
void SysTick_Handler(void) {
    // Handling stop watch timer
    if (timer_state == RUNNING) {
        millisec = millisec + 1;
    } else if (timer_state == STOP) {
        NVIC_ST_RELOAD_R = 16000-1; /* reload with number of clocks per second */
        sec = default_stopwatch_count;
        millisec = 0;
        millisec_display = 0;
    }

    if (millisec % 1000 == 0) {
       sec = sec - 1;
    }

    if (millisec % 100 == 0) {
        millisec_display = millisec_display + 1;
        millisec_display = millisec_display % 10;
    }

    // Handling De-bouncing delay
    if (flag_debouncing == 1)
        debouncing_time = debouncing_time + 1;
    if (debouncing_time == 200) {
        debouncing_time = 0;
        flag_debouncing = 0;
    }

    // Handling led blink delay of "blink_rate" ms
    led_time = led_time + 1;
    if (led_time > blink_rate)
        led_time = led_time - blink_rate;

    SSD_time = SSD_time + 1;

    if (flag_motor == 1)
        motor_delay_time = motor_delay_time + 1;
    if (motor_delay_time == 1000) {
        flag_motor = 0;
        motor_delay_time = 0;
    }

    if (flag_ADC_result_changed == 1)
        ADC_changed_count = ADC_changed_count + 1;
    if (ADC_changed_count == 6000) { // Displaying ADC value for 6 sec before displaying counter value
        ADC_changed_count = 0;
        flag_ADC_result_changed = 0;
    }
}
void LED_color_and_blink (void) {
// LED Blinking Delay
    switch (timer_state) {
        case RUNNING:
            if ((blink_rate - 10) < 0) // Buffer of 10
                GPIO_PORTF_DATA_R = COLOR_GREEN_ON;
            else if ((blink_rate + 10) > 4095)  // Buffer of 10
                GPIO_PORTF_DATA_R = 0;
            else if (led_time < (blink_rate/2))
                GPIO_PORTF_DATA_R = COLOR_GREEN_ON;
            else
                GPIO_PORTF_DATA_R = 0x00;
            break;
        case STOP:
            millisec_display = 0;
            sec = default_stopwatch_count;
            GPIO_PORTF_DATA_R = COLOR_GREEN_ON; // GREEN
            break;
        case PAUSE:
            if ((blink_rate - 10) < 0)  // Buffer of 10
                GPIO_PORTF_DATA_R = COLOR_BLUE_ON;
            else if ((blink_rate + 10) > 4095)  // Buffer of 10
                GPIO_PORTF_DATA_R = 0;
            else if (led_time < (blink_rate/2))
                GPIO_PORTF_DATA_R = COLOR_BLUE_ON; // BLUE
            else
                GPIO_PORTF_DATA_R = 0x00;
            break;
    }
}

/*********** DisableInterrupts ***************
*
* disable interrupts
*
* inputs:  none
* outputs: none
*/
void DisableInterrupts(void)
{
    __asm ("    CPSID  I\n");
}

/*********** EnableInterrupts ***************
*
* enable interrupts
*
* inputs:  none
* outputs: none
*/
void EnableInterrupts(void)
{
    __asm  ("    CPSIE  I\n");
}

/*********** WaitForInterrupt ************************
*
* go to low power mode while waiting for the next interrupt
*
* inputs:  none
* outputs: none
*/
void WaitForInterrupt(void)
{
    __asm  ("    WFI\n");
}
