#include <stdio.h>
#include "C:\Users\krish\OneDrive - Indian Institute of Science\Desktop\Course_work\Jan_session\Embedded\TivaWare\TivaWare_C_Series-2.2.0.295\inc\tm4c123gh6pm.h"
#include "ADC_PWM.h"
#include "UART_init.h"

volatile int result_ADC = 0;
int flag_ADC_result_changed = 0;
int ADC_changed_count = 0;
int previous_ADC_result = 0;

int blink_rate = 500;

void PWM_init (void) {
    /* Enable Peripheral Clocks */
    SYSCTL_RCGCPWM_R |= 1; /* enable clock to PWM0 */
    SYSCTL_RCGCGPIO_R |= 0x10; /* enable clock to PORTE */
    SYSCTL_RCC_R &= ~0x00100000; /* no pre-divide for PWM clock */
    SYSCTL_RCC_R |= 0x000E0000; // Configures PWM clock settings.

    /* Enable port PE4 and PE5 for PWM0 M0PWM5 and PWM0 M0PWM4 */
    GPIO_PORTE_AFSEL_R |= 0x30; /* PE4 and PE5 uses alternate function */
    GPIO_PORTE_PCTL_R &= ~0x00FF0000; // Clears bits for PE4 and PE5 to configure it for PWM.
    GPIO_PORTE_PCTL_R |= 0x00440000; // Configures PE4 and PE5 for PWM. /* make PE4 and PE5 PWM output pin */
    GPIO_PORTE_DEN_R |= 0x30; /* pin digital */ // Enables digital function for PE4 and PE5.

    /* Configuring PWM0 Module */
    PWM0_2_CTL_R &= ~(1<<0); /* stop counter */
    PWM0_2_CTL_R &= ~(1<<1); // Disables the output signal.

    PWM0_2_GENB_R = 0x0000008C; /* M0PWM5 output set when reload, */
    PWM0_2_GENA_R = 0x0000008C;  /* M0PWM4 output set when reload */

    PWM0_2_LOAD_R = 5000; /* set load value for 3.2kHz (16MHz/5000) */
    PWM0_2_CMPA_R = 4999; /* set duty cycle to min */ /* clear when match PWMCMPA */

    PWM0_2_CTL_R = 1; /* start timer */
    PWM0_ENABLE_R = 0x30; /* start PWM0 ch4 and ch5 */

    // Configuring GPIO for Motor Control:
    // Configures GPIO Port A pins PA2 and PA3; PA5 and PA6 for motor control
    SYSCTL_RCGCGPIO_R |= 0x01;
    GPIO_PORTA_DIR_R |= (1<<3)|(1<<2);
    GPIO_PORTA_DEN_R |= (1<<3)|(1<<2);
    GPIO_PORTA_DATA_R |= (1<<3);
    GPIO_PORTA_DATA_R &= ~(1<<2);

    GPIO_PORTA_DIR_R |= (1<<6)|(1<<5);
    GPIO_PORTA_DEN_R |= (1<<6)|(1<<5);
    GPIO_PORTA_DATA_R |= (1<<6);
    GPIO_PORTA_DATA_R &= ~(1<<5);
}

void ADC_init (void) {
    // ADC (Analog to Digital Conversion) Setup
    SYSCTL_RCGCADC_R |= 0x00000001; /* enable clock to ADC0 */
    SYSCTL_RCGCGPIO_R |= 0x10; /* enable clock to PE (AIN0 is on PE3) */
    ADC0_ACTSS_R |= 0x00000008; /* enable ADC0 sequencer 3 */
    ADC0_EMUX_R &= ~0xF000; /* software trigger conversion */
    ADC0_SSMUX3_R = 0; /* get input from channel 0 */

    /* initialize PE3 for AIN0 input */
    GPIO_PORTE_AFSEL_R |= 8; /* enable alternate function */
    GPIO_PORTE_DEN_R &= ~8; /* disable digital function */
    GPIO_PORTE_AMSEL_R |= 8; /* enable analog function */
    ADC0_SSCTL3_R |= 6; /* take one sample at a time, set flag at 1st sample */
    ADC0_ACTSS_R |= 8; /* enable ADC0 sequencer 3 */
}

void ADC_PWM_output (void) {
    int x = 4999;
    float temp;
    int temp2;

        result_ADC = 2978.0;
        temp = (((result_ADC)/4095.0)*4999.0);
        UARTprintf("result_ADC is %d", result_ADC);
        temp2 = (int) temp;
        x = 4999 - temp2;
        PWM0_2_CMPA_R = x; // Left aligned PWM -> Output high when input > COMPARE VALUE.
}
