/*
 * led_control.c
 *
 *  Created on: 25-Mar-2024
 *      Author: kalyan
 */
#include "myheader.h"

void lcd_init(void){
    GPIO_CLK |= 0X03;
    // Wait for the GPIO modules to be ready
         //   while ((SYSCTL_PRGPIO_R & 0x03) != 0x03); // Wait until the clock is stabilized for Port A, B, C, E, and F

  // Set the direction of the pins on Port A, B, E, and F as outputs
   PORTA_DIR |= 0xFF; // Set all pins on Port A as outputs (pins 0 to 7)
   PORTB_DIR |= 0xFF; // Set all pins on Port B as outputs (pins 0 to 7)
   PORTA_DEN |= 0xFF; // Enable digital functionality on all pins on Port A
   PORTB_DEN |= 0xFF;
    lcd_cmd(0x38);
    lcd_cmd(0x06);
    lcd_cmd(0x0C);
    lcd_cmd(0x01);
}
void lcd_cmd(  uint32_t c){
    lcd_print(c);
    PORTA_DATA=0x80;
    delay(10000);
    PORTA_DATA=0x00;
}

void lcd_data(  uint32_t  data){
    lcd_print(data);
    PORTA_DATA=0xC0;
    delay(10000);
    PORTA_DATA=0x00;
}
void lcd_display(unsigned  char *str){
for(int i=0;str[i]!='\0';i++){
            lcd_data(str[i]);
         }
}
void lcd_print(uint32_t  data){
    if((data & 0x01)==0x01){
        PORTB_DATA= PORTB_DATA | 0x01;
    }
    else{
        PORTB_DATA=  PORTB_DATA & (~0x01);
    }
    if((data &  0x02)==0x02){
        PORTB_DATA=  PORTB_DATA| 0x02;
    }
    else{
           PORTB_DATA=  PORTB_DATA & (~0x02);
       }
    if((data & 0x04) ==0x04){
        PORTB_DATA=  PORTB_DATA | 0x04;
    }
    else{
              PORTB_DATA=  PORTB_DATA & (~0x04);
          }
     if((data &0x08) == 0x08){
         PORTB_DATA=  PORTB_DATA | 0x08;

     }
     else{
         PORTB_DATA=  PORTB_DATA & (~0x08);
     }
     if((data & 0x10) == 0x10){
         PORTB_DATA=  PORTB_DATA | 0x10;
         }
     else{
         PORTB_DATA=  PORTB_DATA & (~0x10);
         }
     if((data &  0x20) == 0x20){
         PORTB_DATA=  PORTB_DATA | 0x20;
            }
     else{
         PORTB_DATA=  PORTB_DATA & (~0x20);
              }
     if((data & 0x40) == 0x40){
         PORTB_DATA=  PORTB_DATA | 0x40;
                 }
     else{
         PORTB_DATA=  PORTB_DATA & (~0x40);
                 }
     if((data &  0x80) == 0x80){
         PORTB_DATA=  PORTB_DATA | 0x80;
                    }
     else{
         PORTB_DATA=  PORTB_DATA & (~0x80);
                    }
}

void configure_SYSTCK() {
    SYSTCK_CTRL = 0;                  // Disable timer during setup
    SYSTCK_LOAD = 2500 - 1;           // Set reload value for 0.15625 ms interval
    SYSTCK_CTRL = 0x00000007;         // Clock src set to system clock, enable timer, and interrupt
}


// Function to initialize SYSTCK timer for delay
void SYSTCK_Delay(uint32_t ms) {
    uint32_t reloadValue = (ms * 16000);
    uint32_t count = 0;

    while (reloadValue > (1 << 24) - 1) {
        // If reloadValue exceeds the 24-bit limit, reduce it
        reloadValue -= (1 << 24);
        count++;
    }

    while (count--) {
        SYSTCK_CTRL = 0;                               // Disable SYSTCK during setup
        SYSTCK_LOAD = (1 << 24) - 1;                   // Set reload register for the desired delay
        SYSTCK_VAL = 0;                                // Clear current register
        SYSTCK_CTRL |= 0x05;                           // Enable SYSTCK with core clock (0101)

        while ((SYSTCK_CTRL & 0x00010000) == 0);
    }

    SYSTCK_CTRL = 0;                                  // Disable SYSTCK during setup
    SYSTCK_LOAD = reloadValue - 1;                    // Set reload register for the desired delay
    SYSTCK_VAL = 0;                                   // Clear current register
    SYSTCK_CTRL |= 0x05;                              // Enable SYSTCK with core clock (0101)

    while ((SYSTCK_CTRL & 0x00010000) == 0);
}

// Define delay function
void delay(uint32_t count) {
    for (volatile uint32_t i = 0; i < count; ++i) {
        // Do nothing
    }
}

void timer1A_delay(int ms)
{
    int i;
    TIMER_CLK |= 2;                  // Enable clock to Timer Block 1

    TIM1_CTL = 0;                         // Disable Timer before initialization

    TIM1_CFG = 0x04;                      // 16-bit option

    TIM1_TAMR = 0x02;                     // Periodic mode and down-counter

    TIM1_TAILR = 64000 - 1;               // TimerA interval load value register

    TIM1_TAPR = 250 - 1;                  // TimerA Prescaler 16MHz/250 = 64000Hz

    TIM1_ICR = 0x1;                       // Clear the TimerA timeout flag

    TIM1_CTL |= 0x01;                     // Enable Timer A after initialization

    for(i = 0; i < ms; i++)
    {
        while ((TIM1_RIS & 0x1) == 0) ;   // Wait for TimerA timeout flag

        TIM1_ICR = 0x1;                   // Clear the TimerA timeout flag
    }
}

void GPIO_Debounce_Init(uint32_t portEnableReg, uint32_t portBase, uint8_t pin) {
    // Enable clock to GPIO port
    GPIO_CLK |= (1 << ((uint8_t)(portBase - PORTA) / 0x1000));

    // Configure pin as input
    GPIO_REG(portBase, DIR_OFFSET) &= ~pin;

    // Enable digital pin
    GPIO_REG(portBase, DEN_OFFSET) |= pin;

    // Enable interrupt for the specified pin
    GPIO_REG(portBase, IM_OFFSET) |= pin;         // Arm interrupt on specified pin
    GPIO_REG(portBase, IS_OFFSET) &= ~pin;        // Set specified pin as edge-sensitive
    GPIO_REG(portBase, IBE_OFFSET) &= ~pin;       // Specify falling edge event
    GPIO_REG(portBase, IEV_OFFSET) &= ~pin;       // Specify falling edge event
    NVIC_ISER |= (1 << (30 % 32));        // Enable interrupt 30 in NVIC (GPIO Port F)
}
void Timer0A_Init(uint32_t period) {
    TIMER_CLK |= 0x01;    // Enable clock to Timer Block 0
    TIM0_CTL |= 0;                                // Disable TIM0A during setup
    TIM0_CFG = 0x04;                              // 16-bit mode
    TIM0_TAMR = 0x02;                             // Periodic mode
    TIM0_TAILR = period - 1;                      // TIM0A interval load value register
    TIM0_ICR = 0x1;                               // Clear TIM0A timeout flag
    TIM0_CTL |= 0x01;                             // Enable TIM0A

    // Enable interrupt 19 (Timer0A) in NVIC
    NVIC_ISER  |= (1 << (19 % 32));
}


// Function to initialize Timer in capture mode for each mode
void Timermode_init(uint32_t timer, uint32_t mode) {
    // Enable clock to the specified Timer Block
    TIMER_CLK |= (1 << timer);

    // Select T base address
    uint32_t TIM_base=timer;
    switch (TIM_base) {
        case 0:
            TIM_base = TIM0;
            break;
        case 1:
            TIM_base = TIM1;
            break;
        case 2:
            TIM_base = TIM2;
            break;
        case 3:
            TIM_base = TIM3;
            break;
        default:
            // Handle invalid T
            return;
    }

    // Disable T during setup
    TIM_CTL(TIM_base) &= ~(1 << 0);

    // T in 16-bit T mode
    TIM_CFG(TIM_base) = 4;

    // Set T mode based on the provided mode
    switch(mode) {
        case ONE_SHOT_MODE:
            TIM_TAMR(TIM_base) = 0x01;  // T one-shot mode
            break;
        case PERIODIC_MODE:
            TIM_TAMR(TIM_base) = 0x02;  // T periodic mode
            break;
        case CAPTURE_MODE:
            TIM_TAMR(TIM_base) = 0x03;  // T capture mode
            break;
        case PWM_MODE:
            // Add PWM mode configuration here
            TIM_TAMR(TIM_base) = 0x08;  // PWM mode
            break;
        case PWM_OUTPUT_MODE:
            // Add PWM output mode configuration here
            TIM_TAMR(TIM_base) = 0x0A;  // PWM output mode
            break;
        case INPUT_EDGE_MODE:
            // Add input edge mode configuration here
            TIM_TAMR(TIM_base) = 0x07;  // Capture mode edge-time mode
            break;
        case COUNT_UP_DOWN_MODE:
            // Add count up/down mode configuration here
            TIM_TAMR(TIM_base) = 0x0B;  // T edge count mode
            break;
        default:
            // Handle invalid mode
            break;
    }

    // Capture rising edges on PB6 pin (for example)
    TIM_CTL(TIM_base) &= ~(1 << 3) & ~(1 << 2);

    // Enable Timer
    TIM_CTL(TIM_base) |= (1 << 0);
}
void UART0_init(void)
{
    UART_CLK |= 0x01;  /* enable clock to UART0 */
    GPIO_CLK |= 0x01;  /* enable clock to PORTA for PA0/Rx and PA1/Tx */
    /* UART0 initialization */
    UART0_CTL = 0;         /* UART0 module disbable */
    UART0_IBRD = 104;      /* for 9600 baud rate, integer = 104 */
    UART0_FBRD = 11;       /* for 9600 baud rate, fractional = 11*/
    UART0_CC = 0;          /*select system clock*/
    UART0_LCRH = 0x60;     /* data length 8-bit, not parity bit, no FIFO */
    UART0_CTL = 0x301;     /* Enable UART0 module, Rx and Tx */
    /* UART5 TX5 and RX5 use PE4 and PE5. Configure them digital and enable alternate function */
    PORTA_DEN = 0x03;      /* set PA0 and PA1 as digital */
    PORTA_AFSEL = 0x03;    /* Use PA1,PA0 alternate function */
    PORTA_AMSEL = 0;    /* Turn off analog function*/
    PORTA_PCTL = 0x00000011;     /* configure PA0 and PA1 for UART */
}
void UART0_Transmitter(unsigned char data)
{
    while((UART0_FR & (1<<5)) != 0); /* wait until Tx buffer not full */
       UART0_DR = data;              /* before giving it another byte */
}
void printString(char *str)
{
  while(*str)
    {
        UART0_Transmitter(*(str++));
        delay(250000);
    }
}


int UART_Init(uint32_t uartPort) {
    // Enable clock for UART and GPIO
   // UART_CLK |= (1 << (uartPort & 0xFF)); // Enable UART clock
    //GPIO_CLK |= (1 << ((uartPort >> 12) & 0xF)); // Enable GPIO clock

    // Configure GPIO pins for UART
    switch (uartPort) {
        case UART0:
            // Configure GPIO pins for UART0
            UART_CLK |=0x01;
            GPIO_CLK |=0x01;
            PORTA_DEN |= 0x03;   // Set PA0 and PA1 as digital
            PORTA_AFSEL |= 0x03; // Use PA0 and PA1 alternate function
            PORTA_PCTL |= 0x11;  // Configure PA0 and PA1 for UART
            break;
        case UART1:
            UART_CLK |=0x02;
            // Configure GPIO pins for UART1
            PORTC_DEN |= 0x30;   // Set PC4 and PC5 as digital
            PORTC_AFSEL |= 0x30; // Use PC4 and PC5 alternate function
            PORTC_PCTL |= 0x110000; // Configure PC4 and PC5 for UART
            break;
        case UART2:
            // Configure GPIO pins for UART2
            PORTD_DEN |= 0xC0;   // Set PD6 and PD7 as digital
            PORTD_AFSEL |= 0xC0; // Use PD6 and PD7 alternate function
            PORTD_PCTL |= 0x11000000; // Configure PD6 and PD7 for UART
            break;
        case UART3:
            // Configure GPIO pins for UART3
            PORTC_DEN |= 0xC0;   // Set PC6 and PC7 as digital
            PORTC_AFSEL |= 0xC0; // Use PC6 and PC7 alternate function
            PORTC_PCTL |= 0x11000000; // Configure PC6 and PC7 for UART
            break;
        case UART4:
            // Configure GPIO pins for UART4
            PORTE_DEN |= 0x30;   // Set PE4 and PE5 as digital
            PORTE_AFSEL |= 0x30; // Use PE4 and PE5 alternate function
            PORTE_PCTL |= 0x110000; // Configure PE4 and PE5 for UART
            break;
        case UART5:
            // Configure GPIO pins for UART5
            PORTD_DEN |= 0x30;   // Set PD4 and PD5 as digital
            PORTD_AFSEL |= 0x30; // Use PD4 and PD5 alternate function
            PORTD_PCTL |= 0x1100; // Configure PD4 and PD5 for UART
            break;
        case UART6:
            // Configure GPIO pins for UART6
            PORTC_DEN |= 0x300;   // Set PC5 and PC6 as digital
            PORTC_AFSEL |= 0x300; // Use PC5 and PC6 alternate function
            PORTC_PCTL |= 0x11000000; // Configure PC5 and PC6 for UART
            break;
        case UART7:
            // Configure GPIO pins for UART7
            PORTE_DEN |= 0xC0;   // Set PE6 and PE7 as digital
            PORTE_AFSEL |= 0xC0; // Use PE6 and PE7 alternate function
            PORTE_PCTL |= 0x11000000; // Configure PE6 and PE7 for UART
            break;
        default:
            return -1; // Invalid UART port
    }

    // UART initialization
        UART_REG(uartPort, UART_CTL_OFFSET) = 0;         // UART module disable
        UART_REG(uartPort, UART_IBRD_OFFSET) = 104;      // Integer part of the baud rate divisor
        UART_REG(uartPort, UART_FBRD_OFFSET) = 11;       // Fractional part of the baud rate divisor
        UART_REG(uartPort, UART_CC_OFFSET) = 0;          // Select system clock
        UART_REG(uartPort, UART_LCRH_OFFSET) = 0x60;     // Data length 8-bit, no parity bit, no FIFO
        UART_REG(uartPort, UART_CTL_OFFSET) = 0x301;     // Enable UART module, Rx and Tx

        return 0;  // Success
}

void UART_Transmitter(uint32_t uartPort, char data) {
    volatile uint32_t *UART_DR; // Pointer to UART Data register

    switch (uartPort) {
        case UART0:
            UART_DR = &UART0_DR;
            break;
        case UART1:
            UART_DR = &UART1_DR;
            break;
        case UART2:
            UART_DR = &UART2_DR;
            break;
        case UART3:
            UART_DR = &UART3_DR;
            break;
        case UART4:
            UART_DR = &UART4_DR;
            break;
        case UART5:
            UART_DR = &UART5_DR;
            break;
        case UART6:
            UART_DR = &UART6_DR;
            break;
        case UART7:
            UART_DR = &UART7_DR;
            break;
        default:
            // Invalid UART port
            return;
    }

    // Wait until Tx buffer is not full
    while ((*UART_DR & 0x20) != 0);

    // Transmit data
    *UART_DR = data;
}

void printString_UART(uint32_t uartPort, char *str) {
    while (*str) {
        UART_Transmitter(uartPort, *(str++));
    }
}


// GPIO Initialization
void GPIO_Init(uint32_t port, uint32_t pin) {
    // Enable clock for the specified port and configure pin direction as output
    switch (port) {
        case PORTA:
            GPIO_CLK |= (1 << 0);
            PORTA_DIR |= (1 << pin);
            PORTA_DEN |= (1 << pin);
            break;
        case PORTB:
            GPIO_CLK |= (1 << 1);
            PORTB_DIR |= (1 << pin);
            PORTB_DEN |= (1 << pin);
            break;
        case PORTC:
            GPIO_CLK |= (1 << 2);
            PORTC_DIR |= (1 << pin);
            PORTC_DEN |= (1 << pin);
            break;
        case PORTD:
            GPIO_CLK |= (1 << 3);
            PORTD_DIR |= (1 << pin);
            PORTD_DEN |= (1 << pin);
            break;
        case PORTE:
            GPIO_CLK |= (1 << 4);
            PORTE_DIR |= (1 << pin);
            PORTE_DEN |= (1 << pin);
            break;
        case PORTF:
            GPIO_CLK |= (1 << 5);
            PORTF_DIR |= (1 << pin);
            PORTF_DEN |= (1 << pin);
            break;
        default:
            // Handle error: Invalid port
            break;
    }
}

// GPIO Set Pin
void GPIO_SetPin(uint32_t port, uint32_t pin) {
    // Set the specified pin
    switch (port) {
        case PORTA:
            PORTA_DATA |= (1 << pin);
            break;
        case PORTB:
            PORTB_DATA |= (1 << pin);
            break;
        case PORTC:
            PORTC_DATA |= (1 << pin);
            break;
        case PORTD:
            PORTD_DATA |= (1 << pin);
            break;
        case PORTE:
            PORTE_DATA |= (1 << pin);
            break;
        case PORTF:
            PORTF_DATA |= (1 << pin);
            break;
        default:
            // Handle error: Invalid port
            break;
    }
}

// GPIO Clear Pin
void GPIO_ClearPin(uint32_t port, uint32_t pin) {
    // Clear the specified pin
    switch (port) {
        case PORTA:
            PORTA_DATA &= ~(1 << pin);
            break;
        case PORTB:
            PORTB_DATA &= ~(1 << pin);
            break;
        case PORTC:
            PORTC_DATA &= ~(1 << pin);
            break;
        case PORTD:
            PORTD_DATA &= ~(1 << pin);
            break;
        case PORTE:
            PORTE_DATA &= ~(1 << pin);
            break;
        case PORTF:
            PORTF_DATA &= ~(1 << pin);
            break;
        default:
            // Handle error: Invalid port
            break;
    }
}

// GPIO Toggle Pin
void GPIO_TogglePin(uint32_t port, uint32_t pin) {
    // Toggle the specified pin
    switch (port) {
        case PORTA:
            PORTA_DATA ^= (1 << pin);
            break;
        case PORTB:
            PORTB_DATA ^= (1 << pin);
            break;
        case PORTC:
            PORTC_DATA ^= (1 << pin);
            break;
        case PORTD:
            PORTD_DATA ^= (1 << pin);
            break;
        case PORTE:
            PORTE_DATA ^= (1 << pin);
            break;
        case PORTF:
            PORTF_DATA ^= (1 << pin);
            break;
        default:
            // Handle error: Invalid port
            break;
    }
}

// GPIO Read Pin
uint32_t GPIO_ReadPin(uint32_t port, uint32_t pin) {
    // Read the specified pin
    switch (port) {
        case PORTA:
            return (PORTA_DATA >> pin) & 0x01;
        case PORTB:
            return (PORTB_DATA >> pin) & 0x01;
        case PORTC:
            return (PORTC_DATA >> pin) & 0x01;
        case PORTD:
            return (PORTD_DATA >> pin) & 0x01;
        case PORTE:
            return (PORTE_DATA >> pin) & 0x01;
        case PORTF:
            return (PORTF_DATA >> pin) & 0x01;
        default:
            // Handle error: Invalid port
            return 0;
    }
}

// GPIO Write Port
void GPIO_WritePort(uint32_t port, uint32_t value) {
    // Write value to the specified port
    switch (port) {
        case PORTA:
            PORTA_DATA = value;
            break;
        case PORTB:
            PORTB_DATA = value;
            break;
        case PORTC:
            PORTC_DATA = value;
            break;
        case PORTD:
            PORTD_DATA = value;
            break;
        case PORTE:
            PORTE_DATA = value;
            break;
        case PORTF:
            PORTF_DATA = value;
            break;
        default:
            // Handle error: Invalid port
            break;
    }
}

// GPIO Read Port
uint32_t GPIO_ReadPort(uint32_t port) {
    // Read value from the specified port
    switch (port) {
        case PORTA:
            return PORTA_DATA;
        case PORTB:
            return PORTB_DATA;
        case PORTC:
            return PORTC_DATA;
        case PORTD:
            return PORTD_DATA;
        case PORTE:
            return PORTE_DATA;
        case PORTF:
            return PORTF_DATA;
        default:
            // Handle error: Invalid port
            return 0;
    }
}

// Function to blink built-in LED with specified color pin
// Function to blink built-in LED with specified color pin
void blink_led(char color) {
    // Enable clock gating for PORTF
    GPIO_CLK |= 0x20;
    PORTF_DEN |= 0x0E;
    PORTF_DIR |= 0X0E; //Set direction as output
    // Turn on the LED
    PORTF_DATA |= color;
    delay(200);
    PORTF_DATA &= 0x00 ;
    delay(200);
}




