/*
 * led_control.h
 *
 *  Created on: 25-Mar-2024
 *      Author: kalyan
 */

#ifndef MYHEADER_H_
#define MYHEADER_H_

#include <stdint.h>

  //FUNCTION DECLARATIONS
void delay(uint32_t count);                               // delay function
void SYSTCK_Delay(uint32_t ms);                          // SYSTCK timer delay
void timer1A_delay(int ms);                               //Timer1A Delay
void Timer0A_Init(uint32_t period);                       //Timer0A delay for debouncing
void Debounce_Init(uint32_t portEnableReg, uint32_t portBase, uint8_t pin); // Debouncing function for a GPOIO pin
void configure_SYSTCK();                                 // SYSTCK timer config
void blink_led(char color);                       // Function to blink built-in LED with specified color pin
void Init(uint32_t port, uint32_t pin);              // GPIO Initialization
void SetPin(uint32_t port, uint32_t pin);            // GPIO Set Pin
void ClearPin(uint32_t port, uint32_t pin);          // GPIO Clear Pin
void TogglePin(uint32_t port, uint32_t pin);         // GPIO Toggle Pin
uint32_t ReadPin(uint32_t port, uint32_t pin);       // GPIO Read Pin
void WritePort(uint32_t port, uint32_t value);       // GPIO Write Port
uint32_t ReadPort(uint32_t port);                    // GPIO Read Port
int UART_Init(uint32_t uartPort);                         // UART Initialization
void UART_Transmitter(uint32_t uartPort, char data) ;      // UART transmitter function
void printString_UART(uint32_t uartPort, char *str) ;      // UART PRINT FUNCTION
void Timermode_init(uint32_t timer, uint32_t mode);        //TIMER initialization
void UART0_init(void);  // UART Initialization
 void UART0_Transmitter(unsigned char data) ;              // UART transmitter function
 void printString(char *str) ;                             // UART PRINT FUNCTION
 void lcd_init(void);                                      //LCD Initialization
 void lcd_cmd(  uint32_t c);                               //LCD Command function
 void lcd_data(  uint32_t  data);
 void lcd_display(unsigned  char *str);                     //LCD display function
 void lcd_print(uint32_t  data);



 // MACRO definition for LCD COMMANDS
#define LCD_CLEAR   0x01
#define LCD_HOME    0x02
#define LCD_SHIFT_RIGHT   0x06
#define LCD_ON    0x0F
#define LCD_FIRST_ROW    0x80
#define LCD_SECOND_ROW    0xC0
#define LCD_4BIT_MODE    0x28
#define LCD_8BIT_MODE    0x38


// Macro definitions for pins 0 to 8
#define PIN0   (1 << 0)
#define PIN1   (1 << 1)
#define PIN2   (1 << 2)
#define PIN3   (1 << 3)
#define PIN4   (1 << 4)
#define PIN5   (1 << 5)
#define PIN6   (1 << 6)
#define PIN7   (1 << 7)
#define PIN8   (1 << 8)


 //Macros for LED colors
 #define g  0x08
 #define b  0x04
 #define r  0x02
 #define y  0x0A
 #define m  0x06
 #define w  0x0E
 #define cy  0x0C


// Base address for System Control (SYSCTL)
#define SYSCTL_BASE             0x400FE000

// System Control register offsets
#define SYSCTL_RCGCPWM_OFFSET   0x640   // PWM Clock Gating Control
#define SYSCTL_RCGCOFFSET  0x608   // GPIO Clock Gating Control
#define SYSCTL_RCC_OFFSET       0x060   // Run-Mode Clock Configuration
#define SYSCTL_RCGCUART_OFFSET  0x618   //UART Clock Gating Control
#define SYSCTL_RCGCTIMER_OFFSET 0x604   // Timer Clock Gating Control


// Macros for accessing System Control registers
#define SYSCTL_REG(offset)      (*((volatile uint32_t *)(SYSCTL_BASE + offset)))

#define PWM_CLK       SYSCTL_REG(SYSCTL_RCGCPWM_OFFSET)    // PWM Clock Gating Control
#define GPIO_CLK      SYSCTL_REG(SYSCTL_RCGCOFFSET)   // GPIO Clock Gating Control
#define RUN_MODE_CLK  SYSCTL_REG(SYSCTL_RCC_OFFSET)        // Run-Mode Clock Configuration
#define UART_CLK      SYSCTL_REG(SYSCTL_RCGCUART_OFFSET)   // UART Clock Gating Control
#define TIMER_CLK     SYSCTL_REG(SYSCTL_RCGCTIMER_OFFSET)  // Timer Clock Gating Control

// Base address for SYSTCK
#define SYSTCK_BASE            0xE000E010

// SYSTCK register offsets
#define SYSTCK_CTRL_OFFSET     0x000 // SYSTCK Control and Status
#define SYSTCK_LOAD_OFFSET     0x004 // SYSTCK Reload Value
#define SYSTCK_VAL_OFFSET      0x008 // SYSTCK Current Value
#define SYSTCK_CALIB_OFFSET    0x00C // SYSTCK Calibration Value

// Macro to access SYSTCK register
#define SYSTCK_REG(offset)     (*((volatile uint32_t *)(SYSTCK_BASE + offset)))

// Macros for accessing SYSTCK registers
#define SYSTCK_CTRL            SYSTCK_REG(SYSTCK_CTRL_OFFSET)     // SYSTCK Control and Status
#define SYSTCK_LOAD            SYSTCK_REG(SYSTCK_LOAD_OFFSET)     // SYSTCK Reload Value
#define SYSTCK_VAL             SYSTCK_REG(SYSTCK_VAL_OFFSET)      // SYSTCK Current Value
#define SYSTCK_CALIB           SYSTCK_REG(SYSTCK_CALIB_OFFSET)    // SYSTCK Calibration Value


/// GPIO Base Addresses
#define PORTA 0x40004000
#define PORTB 0x40005000
#define PORTC 0x40006000
#define PORTD 0x40007000
#define PORTE 0x40024000
#define PORTF 0x40025000


// GPIO register offsets
#define DATA_OFFSET        0x3FC // GPIO Data
#define DIR_OFFSET         0x400 // GPIO Direction
#define IE_OFFSET          0x410 // GPIO Interrupt Enable
#define IM_OFFSET          0x414 // GPIO Interrupt Mask
#define IBE_OFFSET         0x41C // GPIO Interrupt Both Edges
#define IEV_OFFSET         0x420 // GPIO Interrupt Event
#define RIS_OFFSET         0x414 // GPIO Raw Interrupt Status
#define MIS_OFFSET         0x418 // GPIO Masked Interrupt Status
#define ICR_OFFSET         0x41C // GPIO Interrupt Clear
#define LOCK_OFFSET        0x520 // GPIO Lock
#define PUR_OFFSET         0x510 // GPIO Pull-Up
#define PDR_OFFSET         0x514 // GPIO Pull-Down
#define DEN_OFFSET         0x51C // GPIO Digital Enable
#define AFSEL_OFFSET       0x420 // GPIO Alternate Function Select
#define IS_OFFSET          0x404 // GPIO Interrupt Sense
#define PID_OFFSET         0xFD0 // GPIO Peripheral Identification
#define IP_OFFSET          0x400 // GPIO Interrupt Priority
#define PCTL_OFFSET        0x52C // GPIO Port Control
#define IV_OFFSET          0x300 // GPIO Interrupt Vector
#define AMSEL_OFFSET       0X528 // GPIO Analog Mode Selection

// Macros for accessing GPIO registers
#define GPIO_REG(base, offset)  (*((volatile uint32_t *)((base) + (offset))))

// GPIO register macros
#define PORTA_DATA          (*((volatile uint32_t *)(PORTA + DATA_OFFSET)))
#define PORTA_DIR           (*((volatile uint32_t *)(PORTA + DIR_OFFSET)))
#define PORTA_IE            (*((volatile uint32_t *)(PORTA + IE_OFFSET)))
#define PORTA_IM            (*((volatile uint32_t *)(PORTA + IM_OFFSET)))
#define PORTA_IBE           (*((volatile uint32_t *)(PORTA + IBE_OFFSET)))
#define PORTA_IEV           (*((volatile uint32_t *)(PORTA + IEV_OFFSET)))
#define PORTA_RIS           (*((volatile uint32_t *)(PORTA + RIS_OFFSET)))
#define PORTA_MIS           (*((volatile uint32_t *)(PORTA + MIS_OFFSET)))
#define PORTA_ICR           (*((volatile uint32_t *)(PORTA + ICR_OFFSET)))
#define PORTA_LOCK          (*((volatile uint32_t *)(PORTA + LOCK_OFFSET)))
#define PORTA_PUR           (*((volatile uint32_t *)(PORTA + PUR_OFFSET)))
#define PORTA_PDR           (*((volatile uint32_t *)(PORTA + PDR_OFFSET)))
#define PORTA_DEN           (*((volatile uint32_t *)(PORTA + DEN_OFFSET)))
#define PORTA_AFSEL         (*((volatile uint32_t *)(PORTA + AFSEL_OFFSET)))
#define PORTA_IS            (*((volatile uint32_t *)(PORTA + IS_OFFSET)))
#define PORTA_PID           (*((volatile uint32_t *)(PORTA + PID_OFFSET)))
#define PORTA_IP            (*((volatile uint32_t *)(PORTA + IP_OFFSET)))
#define PORTA_IV            (*((volatile uint32_t *)(PORTA + IV_OFFSET)))
#define PORTA_PCTL          (*((volatile uint32_t *)(PORTA + PCTL_OFFSET)))
#define PORTA_AMSEL         (*((volatile uint32_t *)(PORTA + AMSEL_OFFSET)))

#define PORTB_DATA          (*((volatile uint32_t *)(PORTB + DATA_OFFSET)))
#define PORTB_DIR           (*((volatile uint32_t *)(PORTB + DIR_OFFSET)))
#define PORTB_IE            (*((volatile uint32_t *)(PORTB + IE_OFFSET)))
#define PORTB_IM            (*((volatile uint32_t *)(PORTB + IM_OFFSET)))
#define PORTB_IBE           (*((volatile uint32_t *)(PORTB + IBE_OFFSET)))
#define PORTB_IEV           (*((volatile uint32_t *)(PORTB + IEV_OFFSET)))
#define PORTB_RIS           (*((volatile uint32_t *)(PORTB + RIS_OFFSET)))
#define PORTB_MIS           (*((volatile uint32_t *)(PORTB + MIS_OFFSET)))
#define PORTB_ICR           (*((volatile uint32_t *)(PORTB + ICR_OFFSET)))
#define PORTB_LOCK          (*((volatile uint32_t *)(PORTB + LOCK_OFFSET)))
#define PORTB_PUR           (*((volatile uint32_t *)(PORTB + PUR_OFFSET)))
#define PORTB_PDR           (*((volatile uint32_t *)(PORTB + PDR_OFFSET)))
#define PORTB_DEN           (*((volatile uint32_t *)(PORTB + DEN_OFFSET)))
#define PORTB_AFSEL         (*((volatile uint32_t *)(PORTB + AFSEL_OFFSET)))
#define PORTB_IS            (*((volatile uint32_t *)(PORTB + IS_OFFSET)))
#define PORTB_PID           (*((volatile uint32_t *)(PORTB + PID_OFFSET)))
#define PORTB_IP            (*((volatile uint32_t *)(PORTB + IP_OFFSET)))
#define PORTB_IV            (*((volatile uint32_t *)(PORTB + IV_OFFSET)))
#define PORTB_PCTL          (*((volatile uint32_t *)(PORTB + PCTL_OFFSET)))

#define PORTC_DATA          (*((volatile uint32_t *)(PORTC + DATA_OFFSET)))
#define PORTC_DIR           (*((volatile uint32_t *)(PORTC + DIR_OFFSET)))
#define PORTC_IE            (*((volatile uint32_t *)(PORTC + IE_OFFSET)))
#define PORTC_IM            (*((volatile uint32_t *)(PORTC + IM_OFFSET)))
#define PORTC_IBE           (*((volatile uint32_t *)(PORTC + IBE_OFFSET)))
#define PORTC_IEV           (*((volatile uint32_t *)(PORTC + IEV_OFFSET)))
#define PORTC_RIS           (*((volatile uint32_t *)(PORTC + RIS_OFFSET)))
#define PORTC_MIS           (*((volatile uint32_t *)(PORTC + MIS_OFFSET)))
#define PORTC_ICR           (*((volatile uint32_t *)(PORTC + ICR_OFFSET)))
#define PORTC_LOCK          (*((volatile uint32_t *)(PORTC + LOCK_OFFSET)))
#define PORTC_PUR           (*((volatile uint32_t *)(PORTC + PUR_OFFSET)))
#define PORTC_PDR           (*((volatile uint32_t *)(PORTC + PDR_OFFSET)))
#define PORTC_DEN           (*((volatile uint32_t *)(PORTC + DEN_OFFSET)))
#define PORTC_AFSEL         (*((volatile uint32_t *)(PORTC + AFSEL_OFFSET)))
#define PORTC_IS            (*((volatile uint32_t *)(PORTC + IS_OFFSET)))
#define PORTC_PID           (*((volatile uint32_t *)(PORTC + PID_OFFSET)))
#define PORTC_IP            (*((volatile uint32_t *)(PORTC + IP_OFFSET)))
#define PORTC_IV            (*((volatile uint32_t *)(PORTC + IV_OFFSET)))
#define PORTC_PCTL          (*((volatile uint32_t *)(PORTC + PCTL_OFFSET)))

#define PORTD_DATA          (*((volatile uint32_t *)(PORTD + DATA_OFFSET)))
#define PORTD_DIR           (*((volatile uint32_t *)(PORTD + DIR_OFFSET)))
#define PORTD_IE            (*((volatile uint32_t *)(PORTD + IE_OFFSET)))
#define PORTD_IM            (*((volatile uint32_t *)(PORTD + IM_OFFSET)))
#define PORTD_IBE           (*((volatile uint32_t *)(PORTD + IBE_OFFSET)))
#define PORTD_IEV           (*((volatile uint32_t *)(PORTD + IEV_OFFSET)))
#define PORTD_RIS           (*((volatile uint32_t *)(PORTD + RIS_OFFSET)))
#define PORTD_MIS           (*((volatile uint32_t *)(PORTD + MIS_OFFSET)))
#define PORTD_ICR           (*((volatile uint32_t *)(PORTD + ICR_OFFSET)))
#define PORTD_LOCK          (*((volatile uint32_t *)(PORTD + LOCK_OFFSET)))
#define PORTD_PUR           (*((volatile uint32_t *)(PORTD + PUR_OFFSET)))
#define PORTD_PDR           (*((volatile uint32_t *)(PORTD + PDR_OFFSET)))
#define PORTD_DEN           (*((volatile uint32_t *)(PORTD + DEN_OFFSET)))
#define PORTD_AFSEL         (*((volatile uint32_t *)(PORTD + AFSEL_OFFSET)))
#define PORTD_IS            (*((volatile uint32_t *)(PORTD + IS_OFFSET)))
#define PORTD_PID           (*((volatile uint32_t *)(PORTD + PID_OFFSET)))
#define PORTD_IP            (*((volatile uint32_t *)(PORTD + IP_OFFSET)))
#define PORTD_IV            (*((volatile uint32_t *)(PORTD + IV_OFFSET)))
#define PORTD_PCTL          (*((volatile uint32_t *)(PORTD + PCTL_OFFSET)))

#define PORTE_DATA          (*((volatile uint32_t *)(PORTE + DATA_OFFSET)))
#define PORTE_DIR           (*((volatile uint32_t *)(PORTE + DIR_OFFSET)))
#define PORTE_IE            (*((volatile uint32_t *)(PORTE + IE_OFFSET)))
#define PORTE_IM            (*((volatile uint32_t *)(PORTE + IM_OFFSET)))
#define PORTE_IBE           (*((volatile uint32_t *)(PORTE + IBE_OFFSET)))
#define PORTE_IEV           (*((volatile uint32_t *)(PORTE + IEV_OFFSET)))
#define PORTE_RIS           (*((volatile uint32_t *)(PORTE + RIS_OFFSET)))
#define PORTE_MIS           (*((volatile uint32_t *)(PORTE + MIS_OFFSET)))
#define PORTE_ICR           (*((volatile uint32_t *)(PORTE + ICR_OFFSET)))
#define PORTE_LOCK          (*((volatile uint32_t *)(PORTE + LOCK_OFFSET)))
#define PORTE_PUR           (*((volatile uint32_t *)(PORTE + PUR_OFFSET)))
#define PORTE_PDR           (*((volatile uint32_t *)(PORTE + PDR_OFFSET)))
#define PORTE_DEN           (*((volatile uint32_t *)(PORTE + DEN_OFFSET)))
#define PORTE_AFSEL         (*((volatile uint32_t *)(PORTE + AFSEL_OFFSET)))
#define PORTE_IS            (*((volatile uint32_t *)(PORTE + IS_OFFSET)))
#define PORTE_PID           (*((volatile uint32_t *)(PORTE + PID_OFFSET)))
#define PORTE_IP            (*((volatile uint32_t *)(PORTE + IP_OFFSET)))
#define PORTE_IV            (*((volatile uint32_t *)(PORTE + IV_OFFSET)))
#define PORTE_PCTL          (*((volatile uint32_t *)(PORTE + PCTL_OFFSET)))

#define PORTF_DATA          (*((volatile uint32_t *)(PORTF + DATA_OFFSET)))
#define PORTF_DIR           (*((volatile uint32_t *)(PORTF + DIR_OFFSET)))
#define PORTF_IE            (*((volatile uint32_t *)(PORTF + IE_OFFSET)))
#define PORTF_IM            (*((volatile uint32_t *)(PORTF + IM_OFFSET)))
#define PORTF_IBE           (*((volatile uint32_t *)(PORTF + IBE_OFFSET)))
#define PORTF_IEV           (*((volatile uint32_t *)(PORTF + IEV_OFFSET)))
#define PORTF_RIS           (*((volatile uint32_t *)(PORTF + RIS_OFFSET)))
#define PORTF_MIS           (*((volatile uint32_t *)(PORTF + MIS_OFFSET)))
#define PORTF_ICR           (*((volatile uint32_t *)(PORTF + ICR_OFFSET)))
#define PORTF_LOCK          (*((volatile uint32_t *)(PORTF + LOCK_OFFSET)))
#define PORTF_PUR           (*((volatile uint32_t *)(PORTF + PUR_OFFSET)))
#define PORTF_PDR           (*((volatile uint32_t *)(PORTF + PDR_OFFSET)))
#define PORTF_DEN           (*((volatile uint32_t *)(PORTF + DEN_OFFSET)))
#define PORTF_AFSEL         (*((volatile uint32_t *)(PORTF + AFSEL_OFFSET)))
#define PORTF_IS            (*((volatile uint32_t *)(PORTF + IS_OFFSET)))
#define PORTF_PID           (*((volatile uint32_t *)(PORTF + PID_OFFSET)))
#define PORTF_IP            (*((volatile uint32_t *)(PORTF + IP_OFFSET)))
#define PORTF_IV            (*((volatile uint32_t *)(PORTF + IV_OFFSET)))
#define PORTF_PCTL          (*((volatile uint32_t *)(PORTF + PCTL_OFFSET)))


// Base addresses for ADC modules
#define ADC0 0x40038000
#define ADC1 0x40039000
#define ADC2 0x4003C000
#define ADC3 0x4003D000
#define ADC4 0x4003E000
#define ADC5 0x4003F000
#define ADC6 0x40040000
#define ADC7 0x40041000
#define ADC8 0x40042000
#define ADC9 0x40043000
#define ADC10 0x40044000
#define ADC11 0x40045000

// ADC register offsets
#define ADC_ACTSS_OFFSET       0x000 // ADC Active Sample Sequencer
#define ADC_EMUX_OFFSET        0x014 // ADC Event Multiplexer Select
#define ADC_SSMUX_OFFSET       0x040 // ADC Sample Sequence Input Multiplexer Select
#define ADC_SSCTL_OFFSET       0x044 // ADC Sample Sequence Control
#define ADC_SSFIFO_OFFSET      0x048 // ADC Sample Sequence Result FIFO
#define ADC_PSSI_OFFSET        0x028 // ADC Processor Sample Sequence Initiate
#define ADC_RIS_OFFSET         0x004 // ADC Raw Interrupt Status
#define ADC_IM_OFFSET          0x008 // ADC Interrupt Mask
#define ADC_ISC_OFFSET         0x00C // ADC Interrupt Status and Clear
#define ADC_SSFSTAT_OFFSET     0x028 // ADC Sample Sequence FIFO Status

// Macros for accessing ADC registers for ADC0
#define ADC0_ACTSS              (*((volatile uint32_t *)(ADC0 + ADC_ACTSS_OFFSET)))      // Active Sample Sequencer
#define ADC0_EMUX               (*((volatile uint32_t *)(ADC0 + ADC_EMUX_OFFSET)))       // Event Multiplexer Select
#define ADC0_SSMUX              (*((volatile uint32_t *)(ADC0 + ADC_SSMUX_OFFSET)))      // Sample Sequence Input Multiplexer Select
#define ADC0_SSCTL              (*((volatile uint32_t *)(ADC0 + ADC_SSCTL_OFFSET)))      // Sample Sequence Control
#define ADC0_SSFIFO             (*((volatile uint32_t *)(ADC0 + ADC_SSFIFO_OFFSET)))     // Sample Sequence Result FIFO
#define ADC0_PSSI               (*((volatile uint32_t *)(ADC0 + ADC_PSSI_OFFSET)))       // Processor Sample Sequence Initiate
#define ADC0_RIS                (*((volatile uint32_t *)(ADC0 + ADC_RIS_OFFSET)))        // Raw Interrupt Status
#define ADC0_IM                 (*((volatile uint32_t *)(ADC0 + ADC_IM_OFFSET)))         // Interrupt Mask
#define ADC0_ISC                (*((volatile uint32_t *)(ADC0 + ADC_ISC_OFFSET)))        // Interrupt Status and Clear
#define ADC0_SSFSTAT            (*((volatile uint32_t *)(ADC0 + ADC_SSFSTAT_OFFSET)))    // Sample Sequence FIFO Status

// Macros for accessing ADC registers for ADC1
#define ADC1_ACTSS              (*((volatile uint32_t *)(ADC1 + ADC_ACTSS_OFFSET)))      // Active Sample Sequencer
#define ADC1_EMUX               (*((volatile uint32_t *)(ADC1 + ADC_EMUX_OFFSET)))       // Event Multiplexer Select
#define ADC1_SSMUX              (*((volatile uint32_t *)(ADC1 + ADC_SSMUX_OFFSET)))      // Sample Sequence Input Multiplexer Select
#define ADC1_SSCTL              (*((volatile uint32_t *)(ADC1 + ADC_SSCTL_OFFSET)))      // Sample Sequence Control
#define ADC1_SSFIFO             (*((volatile uint32_t *)(ADC1 + ADC_SSFIFO_OFFSET)))     // Sample Sequence Result FIFO
#define ADC1_PSSI               (*((volatile uint32_t *)(ADC1 + ADC_PSSI_OFFSET)))       // Processor Sample Sequence Initiate
#define ADC1_RIS                (*((volatile uint32_t *)(ADC1 + ADC_RIS_OFFSET)))        // Raw Interrupt Status
#define ADC1_IM                 (*((volatile uint32_t *)(ADC1 + ADC_IM_OFFSET)))         // Interrupt Mask
#define ADC1_ISC                (*((volatile uint32_t *)(ADC1 + ADC_ISC_OFFSET)))        // Interrupt Status and Clear
#define ADC1_SSFSTAT            (*((volatile uint32_t *)(ADC1 + ADC_SSFSTAT_OFFSET)))    // Sample Sequence FIFO Status

// Macros for accessing ADC registers for ADC2
#define ADC2_ACTSS              (*((volatile uint32_t *)(ADC2 + ADC_ACTSS_OFFSET)))      // Active Sample Sequencer
#define ADC2_EMUX               (*((volatile uint32_t *)(ADC2 + ADC_EMUX_OFFSET)))       // Event Multiplexer Select
#define ADC2_SSMUX              (*((volatile uint32_t *)(ADC2 + ADC_SSMUX_OFFSET)))      // Sample Sequence Input Multiplexer Select
#define ADC2_SSCTL              (*((volatile uint32_t *)(ADC2 + ADC_SSCTL_OFFSET)))      // Sample Sequence Control
#define ADC2_SSFIFO             (*((volatile uint32_t *)(ADC2 + ADC_SSFIFO_OFFSET)))     // Sample Sequence Result FIFO
#define ADC2_PSSI               (*((volatile uint32_t *)(ADC2 + ADC_PSSI_OFFSET)))       // Processor Sample Sequence Initiate
#define ADC2_RIS                (*((volatile uint32_t *)(ADC2 + ADC_RIS_OFFSET)))        // Raw Interrupt Status
#define ADC2_IM                 (*((volatile uint32_t *)(ADC2 + ADC_IM_OFFSET)))         // Interrupt Mask
#define ADC2_ISC                (*((volatile uint32_t *)(ADC2 + ADC_ISC_OFFSET)))        // Interrupt Status and Clear
#define ADC2_SSFSTAT            (*((volatile uint32_t *)(ADC2 + ADC_SSFSTAT_OFFSET)))    // Sample Sequence FIFO Status

// Macros for accessing ADC registers for ADC3
#define ADC3_ACTSS              (*((volatile uint32_t *)(ADC3 + ADC_ACTSS_OFFSET)))      // Active Sample Sequencer
#define ADC3_EMUX               (*((volatile uint32_t *)(ADC3 + ADC_EMUX_OFFSET)))       // Event Multiplexer Select
#define ADC3_SSMUX              (*((volatile uint32_t *)(ADC3 + ADC_SSMUX_OFFSET)))      // Sample Sequence Input Multiplexer Select
#define ADC3_SSCTL              (*((volatile uint32_t *)(ADC3 + ADC_SSCTL_OFFSET)))      // Sample Sequence Control
#define ADC3_SSFIFO             (*((volatile uint32_t *)(ADC3 + ADC_SSFIFO_OFFSET)))     // Sample Sequence Result FIFO
#define ADC3_PSSI               (*((volatile uint32_t *)(ADC3 + ADC_PSSI_OFFSET)))       // Processor Sample Sequence Initiate
#define ADC3_RIS                (*((volatile uint32_t *)(ADC3 + ADC_RIS_OFFSET)))        // Raw Interrupt Status
#define ADC3_IM                 (*((volatile uint32_t *)(ADC3 + ADC_IM_OFFSET)))         // Interrupt Mask
#define ADC3_ISC                (*((volatile uint32_t *)(ADC3 + ADC_ISC_OFFSET)))        // Interrupt Status and Clear
#define ADC3_SSFSTAT            (*((volatile uint32_t *)(ADC3 + ADC_SSFSTAT_OFFSET)))    // Sample Sequence FIFO Status

// Macros for accessing ADC registers for ADC4
#define ADC4_ACTSS              (*((volatile uint32_t *)(ADC4 + ADC_ACTSS_OFFSET)))      // Active Sample Sequencer
#define ADC4_EMUX               (*((volatile uint32_t *)(ADC4 + ADC_EMUX_OFFSET)))       // Event Multiplexer Select
#define ADC4_SSMUX              (*((volatile uint32_t *)(ADC4 + ADC_SSMUX_OFFSET)))      // Sample Sequence Input Multiplexer Select
#define ADC4_SSCTL              (*((volatile uint32_t *)(ADC4 + ADC_SSCTL_OFFSET)))      // Sample Sequence Control
#define ADC4_SSFIFO             (*((volatile uint32_t *)(ADC4 + ADC_SSFIFO_OFFSET)))     // Sample Sequence Result FIFO
#define ADC4_PSSI               (*((volatile uint32_t *)(ADC4 + ADC_PSSI_OFFSET)))       // Processor Sample Sequence Initiate
#define ADC4_RIS                (*((volatile uint32_t *)(ADC4 + ADC_RIS_OFFSET)))        // Raw Interrupt Status
#define ADC4_IM                 (*((volatile uint32_t *)(ADC4 + ADC_IM_OFFSET)))         // Interrupt Mask
#define ADC4_ISC                (*((volatile uint32_t *)(ADC4 + ADC_ISC_OFFSET)))        // Interrupt Status and Clear
#define ADC4_SSFSTAT            (*((volatile uint32_t *)(ADC4 + ADC_SSFSTAT_OFFSET)))    // Sample Sequence FIFO Status

// Macros for accessing ADC registers for ADC5
#define ADC5_ACTSS              (*((volatile uint32_t *)(ADC5 + ADC_ACTSS_OFFSET)))      // Active Sample Sequencer
#define ADC5_EMUX               (*((volatile uint32_t *)(ADC5 + ADC_EMUX_OFFSET)))       // Event Multiplexer Select
#define ADC5_SSMUX              (*((volatile uint32_t *)(ADC5 + ADC_SSMUX_OFFSET)))      // Sample Sequence Input Multiplexer Select
#define ADC5_SSCTL              (*((volatile uint32_t *)(ADC5 + ADC_SSCTL_OFFSET)))      // Sample Sequence Control
#define ADC5_SSFIFO             (*((volatile uint32_t *)(ADC5 + ADC_SSFIFO_OFFSET)))     // Sample Sequence Result FIFO
#define ADC5_PSSI               (*((volatile uint32_t *)(ADC5 + ADC_PSSI_OFFSET)))       // Processor Sample Sequence Initiate
#define ADC5_RIS                (*((volatile uint32_t *)(ADC5 + ADC_RIS_OFFSET)))        // Raw Interrupt Status
#define ADC5_IM                 (*((volatile uint32_t *)(ADC5 + ADC_IM_OFFSET)))         // Interrupt Mask
#define ADC5_ISC                (*((volatile uint32_t *)(ADC5 + ADC_ISC_OFFSET)))        // Interrupt Status and Clear
#define ADC5_SSFSTAT            (*((volatile uint32_t *)(ADC5 + ADC_SSFSTAT_OFFSET)))    // Sample Sequence FIFO Status

// Macros for accessing ADC registers for ADC6
#define ADC6_ACTSS              (*((volatile uint32_t *)(ADC6 + ADC_ACTSS_OFFSET)))      // Active Sample Sequencer
#define ADC6_EMUX               (*((volatile uint32_t *)(ADC6 + ADC_EMUX_OFFSET)))       // Event Multiplexer Select
#define ADC6_SSMUX              (*((volatile uint32_t *)(ADC6 + ADC_SSMUX_OFFSET)))      // Sample Sequence Input Multiplexer Select
#define ADC6_SSCTL              (*((volatile uint32_t *)(ADC6 + ADC_SSCTL_OFFSET)))      // Sample Sequence Control
#define ADC6_SSFIFO             (*((volatile uint32_t *)(ADC6 + ADC_SSFIFO_OFFSET)))     // Sample Sequence Result FIFO
#define ADC6_PSSI               (*((volatile uint32_t *)(ADC6 + ADC_PSSI_OFFSET)))       // Processor Sample Sequence Initiate
#define ADC6_RIS                (*((volatile uint32_t *)(ADC6 + ADC_RIS_OFFSET)))        // Raw Interrupt Status
#define ADC6_IM                 (*((volatile uint32_t *)(ADC6 + ADC_IM_OFFSET)))         // Interrupt Mask
#define ADC6_ISC                (*((volatile uint32_t *)(ADC6 + ADC_ISC_OFFSET)))        // Interrupt Status and Clear
#define ADC6_SSFSTAT            (*((volatile uint32_t *)(ADC6 + ADC_SSFSTAT_OFFSET)))    // Sample Sequence FIFO Status

// Macros for accessing ADC registers for ADC7
#define ADC7_ACTSS              (*((volatile uint32_t *)(ADC7 + ADC_ACTSS_OFFSET)))      // Active Sample Sequencer
#define ADC7_EMUX               (*((volatile uint32_t *)(ADC7 + ADC_EMUX_OFFSET)))       // Event Multiplexer Select
#define ADC7_SSMUX              (*((volatile uint32_t *)(ADC7 + ADC_SSMUX_OFFSET)))      // Sample Sequence Input Multiplexer Select
#define ADC7_SSCTL              (*((volatile uint32_t *)(ADC7 + ADC_SSCTL_OFFSET)))      // Sample Sequence Control
#define ADC7_SSFIFO             (*((volatile uint32_t *)(ADC7 + ADC_SSFIFO_OFFSET)))     // Sample Sequence Result FIFO
#define ADC7_PSSI               (*((volatile uint32_t *)(ADC7 + ADC_PSSI_OFFSET)))       // Processor Sample Sequence Initiate
#define ADC7_RIS                (*((volatile uint32_t *)(ADC7 + ADC_RIS_OFFSET)))        // Raw Interrupt Status
#define ADC7_IM                 (*((volatile uint32_t *)(ADC7 + ADC_IM_OFFSET)))         // Interrupt Mask
#define ADC7_ISC                (*((volatile uint32_t *)(ADC7 + ADC_ISC_OFFSET)))        // Interrupt Status and Clear
#define ADC7_SSFSTAT            (*((volatile uint32_t *)(ADC7 + ADC_SSFSTAT_OFFSET)))    // Sample Sequence FIFO Status

// Macros for accessing ADC registers for ADC8
#define ADC8_ACTSS              (*((volatile uint32_t *)(ADC8 + ADC_ACTSS_OFFSET)))      // Active Sample Sequencer
#define ADC8_EMUX               (*((volatile uint32_t *)(ADC8 + ADC_EMUX_OFFSET)))       // Event Multiplexer Select
#define ADC8_SSMUX              (*((volatile uint32_t *)(ADC8 + ADC_SSMUX_OFFSET)))      // Sample Sequence Input Multiplexer Select
#define ADC8_SSCTL              (*((volatile uint32_t *)(ADC8 + ADC_SSCTL_OFFSET)))      // Sample Sequence Control
#define ADC8_SSFIFO             (*((volatile uint32_t *)(ADC8 + ADC_SSFIFO_OFFSET)))     // Sample Sequence Result FIFO
#define ADC8_PSSI               (*((volatile uint32_t *)(ADC8 + ADC_PSSI_OFFSET)))       // Processor Sample Sequence Initiate
#define ADC8_RIS                (*((volatile uint32_t *)(ADC8 + ADC_RIS_OFFSET)))        // Raw Interrupt Status
#define ADC8_IM                 (*((volatile uint32_t *)(ADC8 + ADC_IM_OFFSET)))         // Interrupt Mask
#define ADC8_ISC                (*((volatile uint32_t *)(ADC8 + ADC_ISC_OFFSET)))        // Interrupt Status and Clear
#define ADC8_SSFSTAT            (*((volatile uint32_t *)(ADC8 + ADC_SSFSTAT_OFFSET)))    // Sample Sequence FIFO Status

// Macros for accessing ADC registers for ADC9
#define ADC9_ACTSS              (*((volatile uint32_t *)(ADC9 + ADC_ACTSS_OFFSET)))      // Active Sample Sequencer
#define ADC9_EMUX               (*((volatile uint32_t *)(ADC9 + ADC_EMUX_OFFSET)))       // Event Multiplexer Select
#define ADC9_SSMUX              (*((volatile uint32_t *)(ADC9 + ADC_SSMUX_OFFSET)))      // Sample Sequence Input Multiplexer Select
#define ADC9_SSCTL              (*((volatile uint32_t *)(ADC9 + ADC_SSCTL_OFFSET)))      // Sample Sequence Control
#define ADC9_SSFIFO             (*((volatile uint32_t *)(ADC9 + ADC_SSFIFO_OFFSET)))     // Sample Sequence Result FIFO
#define ADC9_PSSI               (*((volatile uint32_t *)(ADC9 + ADC_PSSI_OFFSET)))       // Processor Sample Sequence Initiate
#define ADC9_RIS                (*((volatile uint32_t *)(ADC9 + ADC_RIS_OFFSET)))        // Raw Interrupt Status
#define ADC9_IM                 (*((volatile uint32_t *)(ADC9 + ADC_IM_OFFSET)))         // Interrupt Mask
#define ADC9_ISC                (*((volatile uint32_t *)(ADC9 + ADC_ISC_OFFSET)))        // Interrupt Status and Clear
#define ADC9_SSFSTAT            (*((volatile uint32_t *)(ADC9 + ADC_SSFSTAT_OFFSET)))    // Sample Sequence FIFO Status

// Macros for accessing ADC registers for ADC10
#define ADC10_ACTSS             (*((volatile uint32_t *)(ADC10 + ADC_ACTSS_OFFSET)))     // Active Sample Sequencer
#define ADC10_EMUX              (*((volatile uint32_t *)(ADC10 + ADC_EMUX_OFFSET)))      // Event Multiplexer Select
#define ADC10_SSMUX             (*((volatile uint32_t *)(ADC10 + ADC_SSMUX_OFFSET)))     // Sample Sequence Input Multiplexer Select
#define ADC10_SSCTL             (*((volatile uint32_t *)(ADC10 + ADC_SSCTL_OFFSET)))     // Sample Sequence Control
#define ADC10_SSFIFO            (*((volatile uint32_t *)(ADC10 + ADC_SSFIFO_OFFSET)))    // Sample Sequence Result FIFO
#define ADC10_PSSI              (*((volatile uint32_t *)(ADC10 + ADC_PSSI_OFFSET)))      // Processor Sample Sequence Initiate
#define ADC10_RIS               (*((volatile uint32_t *)(ADC10 + ADC_RIS_OFFSET)))       // Raw Interrupt Status
#define ADC10_IM                (*((volatile uint32_t *)(ADC10 + ADC_IM_OFFSET)))        // Interrupt Mask
#define ADC10_ISC               (*((volatile uint32_t *)(ADC10 + ADC_ISC_OFFSET)))       // Interrupt Status and Clear
#define ADC10_SSFSTAT           (*((volatile uint32_t *)(ADC10 + ADC_SSFSTAT_OFFSET)))   // Sample Sequence FIFO Status

// Macros for accessing ADC registers for ADC11
#define ADC11_ACTSS             (*((volatile uint32_t *)(ADC11 + ADC_ACTSS_OFFSET)))     // Active Sample Sequencer
#define ADC11_EMUX              (*((volatile uint32_t *)(ADC11 + ADC_EMUX_OFFSET)))      // Event Multiplexer Select
#define ADC11_SSMUX             (*((volatile uint32_t *)(ADC11 + ADC_SSMUX_OFFSET)))     // Sample Sequence Input Multiplexer Select
#define ADC11_SSCTL             (*((volatile uint32_t *)(ADC11 + ADC_SSCTL_OFFSET)))     // Sample Sequence Control
#define ADC11_SSFIFO            (*((volatile uint32_t *)(ADC11 + ADC_SSFIFO_OFFSET)))    // Sample Sequence Result FIFO
#define ADC11_PSSI              (*((volatile uint32_t *)(ADC11 + ADC_PSSI_OFFSET)))      // Processor Sample Sequence Initiate
#define ADC11_RIS               (*((volatile uint32_t *)(ADC11 + ADC_RIS_OFFSET)))       // Raw Interrupt Status
#define ADC11_IM                (*((volatile uint32_t *)(ADC11 + ADC_IM_OFFSET)))        // Interrupt Mask
#define ADC11_ISC               (*((volatile uint32_t *)(ADC11 + ADC_ISC_OFFSET)))       // Interrupt Status and Clear
#define ADC11_SSFSTAT           (*((volatile uint32_t *)(ADC11 + ADC_SSFSTAT_OFFSET)))   // Sample Sequence FIFO Status




// NVIC base address
#define NVIC_BASE              0xE000E100

// NVIC register offsets
#define NVIC_ISER_OFFSET       0x000 // NVIC Interrupt Set-Enable Register
#define NVIC_ICER_OFFSET       0x080 // NVIC Interrupt Clear-Enable Register
#define NVIC_ISPR_OFFSET       0x100 // NVIC Interrupt Set-Pending Register
#define NVIC_ICPR_OFFSET       0x180 // NVIC Interrupt Clear-Pending Register
#define NVIC_IPR_OFFSET        0x300 // NVIC Interrupt Priority Register

// Macro to access NVIC register
#define NVIC_REG(offset)       (*((volatile uint32_t *)(NVIC_BASE + offset)))

// Macros for accessing NVIC registers
#define NVIC_ISER              NVIC_REG(NVIC_ISER_OFFSET) // NVIC Interrupt Set-Enable Register
#define NVIC_ICER              NVIC_REG(NVIC_ICER_OFFSET) // NVIC Interrupt Clear-Enable Register
#define NVIC_ISPR              NVIC_REG(NVIC_ISPR_OFFSET) // NVIC Interrupt Set-Pending Register
#define NVIC_ICPR              NVIC_REG(NVIC_ICPR_OFFSET) // NVIC Interrupt Clear-Pending Register
#define NVIC_IPR               NVIC_REG(NVIC_IPR_OFFSET)  // NVIC Interrupt Priority Register

// Base addresses for Timer modules
#define TIM0 0x40030000
#define TIM1 0x40031000
#define TIM2 0x40032000
#define TIM3 0x40033000


// Define T modes
#define ONE_SHOT_MODE           0x1
#define PERIODIC_MODE           0x2
#define CAPTURE_MODE            0x3
#define PWM_MODE                0x4
#define PWM_OUTPUT_MODE         0x5
#define INPUT_EDGE_MODE         0x6
#define COUNT_UP_DOWN_MODE      0x7

// T register offsets
#define TIM_CFG_OFFSET          0x000  // Configuration
#define TIM_TAMR_OFFSET         0x004  // Timer A Mode
#define TIM_TBMR_OFFSET         0x008  // Timer B Mode
#define TIM_CTL_OFFSET          0x00C  // Control
#define TIM_SYNC_OFFSET         0x010  // Synchronization
#define TIM_IMR_OFFSET          0x018  // Interrupt Mask
#define TIM_RIS_OFFSET          0x01C  // Raw Interrupt Status
#define TIM_MIS_OFFSET          0x020  // Masked Interrupt Status
#define TIM_ICR_OFFSET          0x024  // Interrupt Clear
#define TIM_TAILR_OFFSET        0x028  // Timer A Interval Load
#define TIM_TBILR_OFFSET        0x02C  // Timer B Interval Load
#define TIM_TAMATCHR_OFFSET     0x030  // Timer A Match
#define TIM_TBMATCHR_OFFSET     0x034  // Timer B Match
#define TIM_TAPR_OFFSET         0x038  // TimerT A Prescale
#define TIM_TBPR_OFFSET         0x03C  // Timer B Prescale
#define TIM_TAPMR_OFFSET        0x040  // Timer A Prescale Match
#define TIM_TBPMR_OFFSET        0x044  // Timer B Prescale Match
#define TIM_TAR_OFFSET          0x048  // Timer A
#define TIM_TBR_OFFSET          0x04C  // Timer B
#define TIM_TAV_OFFSET          0x050  //Timer A Value
#define TIM_TBV_OFFSET          0x054  // Timer B Value
#define TIM_RTCPD_OFFSET        0x058  // RTC Predivide
#define TIM_TAPS_OFFSET         0x05C  // Timer A Prescale Snapshot
#define TIM_TBPS_OFFSET         0x060  // Timer B Prescale Snapshot
#define TIM_TAPV_OFFSET         0x064  // Timer A Prescale Value
#define TIM_TBPV_OFFSET         0x068  // Timer B Prescale Value
#define TIM_PP_OFFSET           0xFC0  // Peripheral Properties

// Macro to access Timer register
#define TIM_REG(base, offset)  (*((volatile uint32_t *)((base) + (offset))))

// Macros for accessing Timer registers
#define TIM_CFG(base)          TIM_REG(base, TIM_CFG_OFFSET)        // Configuration
#define TIM_TAMR(base)         TIM_REG(base, TIM_TAMR_OFFSET)       // Timer A Mode
#define TIM_TBMR(base)         TIM_REG(base, TIM_TBMR_OFFSET)       // T B Mode
#define TIM_CTL(base)          TIM_REG(base, TIM_CTL_OFFSET)        // Control
#define TIM_SYNC(base)         TIM_REG(base, TIM_SYNC_OFFSET)       // Synchronization
#define TIM_IMR(base)          TIM_REG(base, TIM_IMR_OFFSET)        // Interrupt Mask
#define TIM_RIS(base)          TIM_REG(base, TIM_RIS_OFFSET)        // Raw Interrupt Status
#define TIM_MIS(base)          TIM_REG(base, TIM_MIS_OFFSET)        // Masked Interrupt Status
#define TIM_ICR(base)          TIM_REG(base, TIM_ICR_OFFSET)        // Interrupt Clear
#define TIM_TAILR(base)        TIM_REG(base, TIM_TAILR_OFFSET)      // T A Interval Load
#define TIM_TBILR(base)        TIM_REG(base, TIM_TBILR_OFFSET)      // T B Interval Load
#define TIM_TAMATCHR(base)     TIM_REG(base, TIM_TAMATCHR_OFFSET)   // T A Match
#define TIM_TBMATCHR(base)     TIM_REG(base, TIM_TBMATCHR_OFFSET)   // T B Match
#define TIM_TAPR(base)         TIM_REG(base, TIM_TAPR_OFFSET)       // T A Prescale
#define TIM_TBPR(base)         TIM_REG(base, TIM_TBPR_OFFSET)       // T B Prescale
#define TIM_TAPMR(base)        TIM_REG(base, TIM_TAPMR_OFFSET)      // T A Prescale Match
#define TIM_TBPMR(base)        TIM_REG(base, TIM_TBPMR_OFFSET)      // T B Prescale Match
#define TIM_TAR(base)          TIM_REG(base, TIM_TAR_OFFSET)        // T A
#define TIM_TBR(base)          TIM_REG(base, TIM_TBR_OFFSET)        // T B
#define TIM_TAV(base)          TIM_REG(base, TIM_TAV_OFFSET)        // T A Value
#define TIM_TBV(base)          TIM_REG(base, TIM_TBV_OFFSET)        // T B Value
#define TIM_RTCPD(base)        TIM_REG(base, TIM_RTCPD_OFFSET)      // RTC Predivide
#define TIM_TAPS(base)         TIM_REG(base, TIM_TAPS_OFFSET)       // T A Prescale Snapshot
#define TIM_TBPS(base)         TIM_REG(base, TIM_TBPS_OFFSET)       // T B Prescale Snapshot
#define TIM_TAPV(base)         TIM_REG(base, TIM_TAPV_OFFSET)       // T A Prescale Value
#define TIM_TBPV(base)         TIM_REG(base, TIM_TBPV_OFFSET)       // T B Prescale Value
#define TIM_PP(base)           TIM_REG(base, TIM_PP_OFFSET)         // Peripheral Properties

// Define T-specific register macros for T 0
#define TIM0_CFG              TIM_CFG(TIM0)
#define TIM0_TAMR             TIM_TAMR(TIM0)
#define TIM0_TBMR             TIM_TBMR(TIM0)
#define TIM0_CTL              TIM_CTL(TIM0)
#define TIM0_SYNC             TIM_SYNC(TIM0)
#define TIM0_IMR              TIM_IMR(TIM0)
#define TIM0_RIS              TIM_RIS(TIM0)
#define TIM0_MIS              TIM_MIS(TIM0)
#define TIM0_ICR              TIM_ICR(TIM0)
#define TIM0_TAILR            TIM_TAILR(TIM0)
#define TIM0_TBILR            TIM_TBILR(TIM0)
#define TIM0_TAMATCHR         TIM_TAMATCHR(TIM0)
#define TIM0_TBMATCHR         TIM_TBMATCHR(TIM0)
#define TIM0_TAPR             TIM_TAPR(TIM0)
#define TIM0_TBPR             TIM_TBPR(TIM0)
#define TIM0_TAPMR            TIM_TAPMR(TIM0)
#define TIM0_TBPMR            TIM_TBPMR(TIM0)
#define TIM0_TAR              TIM_TAR(TIM0)
#define TIM0_TBR              TIM_TBR(TIM0)
#define TIM0_TAV              TIM_TAV(TIM0)
#define TIM0_TBV              TIM_TBV(TIM0)
#define TIM0_RTCPD            TIM_RTCPD(TIM0)
#define TIM0_TAPS             TIM_TAPS(TIM0)
#define TIM0_TBPS             TIM_TBPS(TIM0)
#define TIM0_TAPV             TIM_TAPV(TIM0)
#define TIM0_TBPV             TIM_TBPV(TIM0)
#define TIM0_PP               TIM_PP(TIM0)

// Define T-specific register macros for T 1
#define TIM1_CFG              TIM_CFG(TIM1)
#define TIM1_TAMR             TIM_TAMR(TIM1)
#define TIM1_TBMR             TIM_TBMR(TIM1)
#define TIM1_CTL              TIM_CTL(TIM1)
#define TIM1_SYNC             TIM_SYNC(TIM1)
#define TIM1_IMR              TIM_IMR(TIM1)
#define TIM1_RIS              TIM_RIS(TIM1)
#define TIM1_MIS              TIM_MIS(TIM1)
#define TIM1_ICR              TIM_ICR(TIM1)
#define TIM1_TAILR            TIM_TAILR(TIM1)
#define TIM1_TBILR            TIM_TBILR(TIM1)
#define TIM1_TAMATCHR         TIM_TAMATCHR(TIM1)
#define TIM1_TBMATCHR         TIM_TBMATCHR(TIM1)
#define TIM1_TAPR             TIM_TAPR(TIM1)
#define TIM1_TBPR             TIM_TBPR(TIM1)
#define TIM1_TAPMR            TIM_TAPMR(TIM1)
#define TIM1_TBPMR            TIM_TBPMR(TIM1)
#define TIM1_TAR              TIM_TAR(TIM1)
#define TIM1_TBR              TIM_TBR(TIM1)
#define TIM1_TAV              TIM_TAV(TIM1)
#define TIM1_TBV              TIM_TBV(TIM1)
#define TIM1_RTCPD            TIM_RTCPD(TIM1)
#define TIM1_TAPS             TIM_TAPS(TIM1)
#define TIM1_TBPS             TIM_TBPS(TIM1)
#define TIM1_TAPV             TIM_TAPV(TIM1)
#define TIM1_TBPV             TIM_TBPV(TIM1)
#define TIM1_PP               TIM_PP(TIM1)

// Define T-specific register macros for T 2
#define TIM2_CFG              TIM_CFG(TIM2)
#define TIM2_TAMR             TIM_TAMR(TIM2)
#define TIM2_TBMR             TIM_TBMR(TIM2)
#define TIM2_CTL              TIM_CTL(TIM2)
#define TIM2_SYNC             TIM_SYNC(TIM2)
#define TIM2_IMR              TIM_IMR(TIM2)
#define TIM2_RIS              TIM_RIS(TIM2)
#define TIM2_MIS              TIM_MIS(TIM2)
#define TIM2_ICR              TIM_ICR(TIM2)
#define TIM2_TAILR            TIM_TAILR(TIM2)
#define TIM2_TBILR            TIM_TBILR(TIM2)
#define TIM2_TAMATCHR         TIM_TAMATCHR(TIM2)
#define TIM2_TBMATCHR         TIM_TBMATCHR(TIM2)
#define TIM2_TAPR             TIM_TAPR(TIM2)
#define TIM2_TBPR             TIM_TBPR(TIM2)
#define TIM2_TAPMR            TIM_TAPMR(TIM2)
#define TIM2_TBPMR            TIM_TBPMR(TIM2)
#define TIM2_TAR              TIM_TAR(TIM2)
#define TIM2_TBR              TIM_TBR(TIM2)
#define TIM2_TAV              TIM_TAV(TIM2)
#define TIM2_TBV              TIM_TBV(TIM2)
#define TIM2_RTCPD            TIM_RTCPD(TIM2)
#define TIM2_TAPS             TIM_TAPS(TIM2)
#define TIM2_TBPS             TIM_TBPS(TIM2)
#define TIM2_TAPV             TIM_TAPV(TIM2)
#define TIM2_TBPV             TIM_TBPV(TIM2)
#define TIM2_PP               TIM_PP(TIM2)

// Define T-specific register macros for T 3
#define TIM3_CFG              TIM_CFG(TIM3)
#define TIM3_TAMR             TIM_TAMR(TIM3)
#define TIM3_TBMR             TIM_TBMR(TIM3)
#define TIM3_CTL              TIM_CTL(TIM3)
#define TIM3_SYNC             TIM_SYNC(TIM3)
#define TIM3_IMR              TIM_IMR(TIM3)
#define TIM3_RIS              TIM_RIS(TIM3)
#define TIM3_MIS              TIM_MIS(TIM3)
#define TIM3_ICR              TIM_ICR(TIM3)
#define TIM3_TAILR            TIM_TAILR(TIM3)
#define TIM3_TBILR            TIM_TBILR(TIM3)
#define TIM3_TAMATCHR         TIM_TAMATCHR(TIM3)
#define TIM3_TBMATCHR         TIM_TBMATCHR(TIM3)
#define TIM3_TAPR             TIM_TAPR(TIM3)
#define TIM3_TBPR             TIM_TBPR(TIM3)
#define TIM3_TAPMR            TIM_TAPMR(TIM3)
#define TIM3_TBPMR            TIM_TBPMR(TIM3)
#define TIM3_TAR              TIM_TAR(TIM3)
#define TIM3_TBR              TIM_TBR(TIM3)
#define TIM3_TAV              TIM_TAV(TIM3)
#define TIM3_TBV              TIM_TBV(TIM3)
#define TIM3_RTCPD            TIM_RTCPD(TIM3)
#define TIM3_TAPS             TIM_TAPS(TIM3)
#define TIM3_TBPS             TIM_TBPS(TIM3)
#define TIM3_TAPV             TIM_TAPV(TIM3)
#define TIM3_TBPV             TIM_TBPV(TIM3)
#define TIM3_PP               TIM_PP(TIM3)

// Base addresses for PWM modules
#define PWM0_BASE 0x40028000
#define PWM1_BASE 0x40029000
#define PWM2_BASE 0x4002A000
#define PWM3_BASE 0x4002B000
#define PWM4_BASE 0x4002C000
#define PWM5_BASE 0x4002D000

// PWM generator specific registers offsets
#define PWM_GEN0_LOAD_OFFSET    0x000  // PWM Generator 0 Load
#define PWM_GEN0_CMPA_OFFSET    0x004  // PWM Generator 0 Compare A
#define PWM_GEN0_CMPB_OFFSET    0x008  // PWM Generator 0 Compare B
#define PWM_GEN0_CTL_OFFSET     0x040  // PWM Generator 0 Control
#define PWM_GEN0_INTEN_OFFSET   0x004  // PWM Generator 0 Interrupt Enable
#define PWM_GEN0_RIS_OFFSET     0x010  // PWM Generator 0 Raw Interrupt Status
#define PWM_GEN0_ISC_OFFSET     0x014  // PWM Generator 0 Interrupt Status and Clear

// PWM Registers for PWM0
#define PWM0_GEN0_LOAD   (*((volatile uint32_t *)(PWM0_BASE + PWM_GEN0_LOAD_OFFSET)))
#define PWM0_GEN0_CMPA   (*((volatile uint32_t *)(PWM0_BASE + PWM_GEN0_CMPA_OFFSET)))
#define PWM0_GEN0_CMPB   (*((volatile uint32_t *)(PWM0_BASE + PWM_GEN0_CMPB_OFFSET)))
#define PWM0_GEN0_CTL    (*((volatile uint32_t *)(PWM0_BASE + PWM_GEN0_CTL_OFFSET)))
#define PWM0_GEN0_INTEN  (*((volatile uint32_t *)(PWM0_BASE + PWM_GEN0_INTEN_OFFSET)))
#define PWM0_GEN0_RIS    (*((volatile uint32_t *)(PWM0_BASE + PWM_GEN0_RIS_OFFSET)))
#define PWM0_GEN0_ISC    (*((volatile uint32_t *)(PWM0_BASE + PWM_GEN0_ISC_OFFSET)))

// PWM Registers for PWM1
#define PWM1_GEN0_LOAD   (*((volatile uint32_t *)(PWM1_BASE + PWM_GEN0_LOAD_OFFSET)))
#define PWM1_GEN0_CMPA   (*((volatile uint32_t *)(PWM1_BASE + PWM_GEN0_CMPA_OFFSET)))
#define PWM1_GEN0_CMPB   (*((volatile uint32_t *)(PWM1_BASE + PWM_GEN0_CMPB_OFFSET)))
#define PWM1_GEN0_CTL    (*((volatile uint32_t *)(PWM1_BASE + PWM_GEN0_CTL_OFFSET)))
#define PWM1_GEN0_INTEN  (*((volatile uint32_t *)(PWM1_BASE + PWM_GEN0_INTEN_OFFSET)))
#define PWM1_GEN0_RIS    (*((volatile uint32_t *)(PWM1_BASE + PWM_GEN0_RIS_OFFSET)))
#define PWM1_GEN0_ISC    (*((volatile uint32_t *)(PWM1_BASE + PWM_GEN0_ISC_OFFSET)))

// PWM Registers for PWM2
#define PWM2_GEN0_LOAD   (*((volatile uint32_t *)(PWM2_BASE + PWM_GEN0_LOAD_OFFSET)))
#define PWM2_GEN0_CMPA   (*((volatile uint32_t *)(PWM2_BASE + PWM_GEN0_CMPA_OFFSET)))
#define PWM2_GEN0_CMPB   (*((volatile uint32_t *)(PWM2_BASE + PWM_GEN0_CMPB_OFFSET)))
#define PWM2_GEN0_CTL    (*((volatile uint32_t *)(PWM2_BASE + PWM_GEN0_CTL_OFFSET)))
#define PWM2_GEN0_INTEN  (*((volatile uint32_t *)(PWM2_BASE + PWM_GEN0_INTEN_OFFSET)))
#define PWM2_GEN0_RIS    (*((volatile uint32_t *)(PWM2_BASE + PWM_GEN0_RIS_OFFSET)))
#define PWM2_GEN0_ISC    (*((volatile uint32_t *)(PWM2_BASE + PWM_GEN0_ISC_OFFSET)))

// PWM Registers for PWM3
#define PWM3_GEN0_LOAD   (*((volatile uint32_t *)(PWM3_BASE + PWM_GEN0_LOAD_OFFSET)))
#define PWM3_GEN0_CMPA   (*((volatile uint32_t *)(PWM3_BASE + PWM_GEN0_CMPA_OFFSET)))
#define PWM3_GEN0_CMPB   (*((volatile uint32_t *)(PWM3_BASE + PWM_GEN0_CMPB_OFFSET)))
#define PWM3_GEN0_CTL    (*((volatile uint32_t *)(PWM3_BASE + PWM_GEN0_CTL_OFFSET)))
#define PWM3_GEN0_INTEN  (*((volatile uint32_t *)(PWM3_BASE + PWM_GEN0_INTEN_OFFSET)))
#define PWM3_GEN0_RIS    (*((volatile uint32_t *)(PWM3_BASE + PWM_GEN0_RIS_OFFSET)))
#define PWM3_GEN0_ISC    (*((volatile uint32_t *)(PWM3_BASE + PWM_GEN0_ISC_OFFSET)))

// PWM Registers for PWM4
#define PWM4_GEN0_LOAD   (*((volatile uint32_t *)(PWM4_BASE + PWM_GEN0_LOAD_OFFSET)))
#define PWM4_GEN0_CMPA   (*((volatile uint32_t *)(PWM4_BASE + PWM_GEN0_CMPA_OFFSET)))
#define PWM4_GEN0_CMPB   (*((volatile uint32_t *)(PWM4_BASE + PWM_GEN0_CMPB_OFFSET)))
#define PWM4_GEN0_CTL    (*((volatile uint32_t *)(PWM4_BASE + PWM_GEN0_CTL_OFFSET)))
#define PWM4_GEN0_INTEN  (*((volatile uint32_t *)(PWM4_BASE + PWM_GEN0_INTEN_OFFSET)))
#define PWM4_GEN0_RIS    (*((volatile uint32_t *)(PWM4_BASE + PWM_GEN0_RIS_OFFSET)))
#define PWM4_GEN0_ISC    (*((volatile uint32_t *)(PWM4_BASE + PWM_GEN0_ISC_OFFSET)))

// PWM Registers for PWM5
#define PWM5_GEN0_LOAD   (*((volatile uint32_t *)(PWM5_BASE + PWM_GEN0_LOAD_OFFSET)))
#define PWM5_GEN0_CMPA   (*((volatile uint32_t *)(PWM5_BASE + PWM_GEN0_CMPA_OFFSET)))
#define PWM5_GEN0_CMPB   (*((volatile uint32_t *)(PWM5_BASE + PWM_GEN0_CMPB_OFFSET)))
#define PWM5_GEN0_CTL    (*((volatile uint32_t *)(PWM5_BASE + PWM_GEN0_CTL_OFFSET)))
#define PWM5_GEN0_INTEN  (*((volatile uint32_t *)(PWM5_BASE + PWM_GEN0_INTEN_OFFSET)))
#define PWM5_GEN0_RIS    (*((volatile uint32_t *)(PWM5_BASE + PWM_GEN0_RIS_OFFSET)))
#define PWM5_GEN0_ISC    (*((volatile uint32_t *)(PWM5_BASE + PWM_GEN0_ISC_OFFSET)))

// UART Base Addresses
#define UART0      0x4000C000
#define UART1      0x4000D000
#define UART2      0x4000E000
#define UART3      0x4000F000
#define UART4      0x40010000
#define UART5      0x40011000
#define UART6      0x40012000
#define UART7      0x40013000


// UART Register Offsets
#define UART_DR_OFFSET      0x000   // Data Register
#define UART_RSR_OFFSET     0x004   // Receive Status/Error Clear Register
#define UART_FR_OFFSET      0x018   // Flag Register
#define UART_IBRD_OFFSET    0x024   // Integer Baud-Rate Divisor
#define UART_FBRD_OFFSET    0x028   // Fractional Baud-Rate Divisor
#define UART_LCRH_OFFSET    0x02C   // Line Control
#define UART_CTL_OFFSET     0x030   // Control
#define UART_IFLS_OFFSET    0x034   // Interrupt FIFO Level Select
#define UART_IM_OFFSET      0x038   // Interrupt Mask
#define UART_RIS_OFFSET     0x03C   // Raw Interrupt Status
#define UART_MIS_OFFSET     0x040   // Masked Interrupt Status
#define UART_ICR_OFFSET     0x044   // Interrupt Clear
#define UART_DMACTL_OFFSET  0x048   // DMA Control
#define UART_CC_OFFSET      0xFC8   // Clock Configuration


// UART register macros
#define UART_REG(base, offset)  (*((volatile uint32_t *)((base) + (offset))))

// UART Registers for UART0
#define UART0_DR            (*((volatile uint32_t *)(UART0 + UART_DR_OFFSET)))
#define UART0_RSR           (*((volatile uint32_t *)(UART0 + UART_RSR_OFFSET)))
#define UART0_FR            (*((volatile uint32_t *)(UART0 + UART_FR_OFFSET)))
#define UART0_IBRD          (*((volatile uint32_t *)(UART0 + UART_IBRD_OFFSET)))
#define UART0_FBRD          (*((volatile uint32_t *)(UART0 + UART_FBRD_OFFSET)))
#define UART0_LCRH          (*((volatile uint32_t *)(UART0 + UART_LCRH_OFFSET)))
#define UART0_CTL           (*((volatile uint32_t *)(UART0 + UART_CTL_OFFSET)))
#define UART0_IFLS          (*((volatile uint32_t *)(UART0 + UART_IFLS_OFFSET)))
#define UART0_IM            (*((volatile uint32_t *)(UART0 + UART_IM_OFFSET)))
#define UART0_RIS           (*((volatile uint32_t *)(UART0 + UART_RIS_OFFSET)))
#define UART0_MIS           (*((volatile uint32_t *)(UART0 + UART_MIS_OFFSET)))
#define UART0_ICR           (*((volatile uint32_t *)(UART0 + UART_ICR_OFFSET)))
#define UART0_DMACTL        (*((volatile uint32_t *)(UART0 + UART_DMACTL_OFFSET)))
#define UART0_CC            (*((volatile uint32_t *)(UART0 + UART_CC_OFFSET)))

// UART Registers for UART1
#define UART1_DR            (*((volatile uint32_t *)(UART1 + UART_DR_OFFSET)))
#define UART1_RSR           (*((volatile uint32_t *)(UART1 + UART_RSR_OFFSET)))
#define UART1_FR            (*((volatile uint32_t *)(UART1 + UART_FR_OFFSET)))
#define UART1_IBRD          (*((volatile uint32_t *)(UART1 + UART_IBRD_OFFSET)))
#define UART1_FBRD          (*((volatile uint32_t *)(UART1 + UART_FBRD_OFFSET)))
#define UART1_LCRH          (*((volatile uint32_t *)(UART1 + UART_LCRH_OFFSET)))
#define UART1_CTL           (*((volatile uint32_t *)(UART1 + UART_CTL_OFFSET)))
#define UART1_IFLS          (*((volatile uint32_t *)(UART1 + UART_IFLS_OFFSET)))
#define UART1_IM            (*((volatile uint32_t *)(UART1 + UART_IM_OFFSET)))
#define UART1_RIS           (*((volatile uint32_t *)(UART1 + UART_RIS_OFFSET)))
#define UART1_MIS           (*((volatile uint32_t *)(UART1 + UART_MIS_OFFSET)))
#define UART1_ICR           (*((volatile uint32_t *)(UART1 + UART_ICR_OFFSET)))
#define UART1_DMACTL        (*((volatile uint32_t *)(UART1 + UART_DMACTL_OFFSET)))
#define UART1_CC            (*((volatile uint32_t *)(UART1 + UART_CC_OFFSET)))

// UART Registers for UART2
#define UART2_DR            (*((volatile uint32_t *)(UART2 + UART_DR_OFFSET)))
#define UART2_RSR           (*((volatile uint32_t *)(UART2 + UART_RSR_OFFSET)))
#define UART2_FR            (*((volatile uint32_t *)(UART2 + UART_FR_OFFSET)))
#define UART2_IBRD          (*((volatile uint32_t *)(UART2 + UART_IBRD_OFFSET)))
#define UART2_FBRD          (*((volatile uint32_t *)(UART2 + UART_FBRD_OFFSET)))
#define UART2_LCRH          (*((volatile uint32_t *)(UART2 + UART_LCRH_OFFSET)))
#define UART2_CTL           (*((volatile uint32_t *)(UART2 + UART_CTL_OFFSET)))
#define UART2_IFLS          (*((volatile uint32_t *)(UART2 + UART_IFLS_OFFSET)))
#define UART2_IM            (*((volatile uint32_t *)(UART2 + UART_IM_OFFSET)))
#define UART2_RIS           (*((volatile uint32_t *)(UART2 + UART_RIS_OFFSET)))
#define UART2_MIS           (*((volatile uint32_t *)(UART2 + UART_MIS_OFFSET)))
#define UART2_ICR           (*((volatile uint32_t *)(UART2 + UART_ICR_OFFSET)))
#define UART2_DMACTL        (*((volatile uint32_t *)(UART2 + UART_DMACTL_OFFSET)))
#define UART2_CC            (*((volatile uint32_t *)(UART2 + UART_CC_OFFSET)))


// UART Registers for UART3
#define UART3_DR            (*((volatile uint32_t *)(UART3 + UART_DR_OFFSET)))
#define UART3_RSR           (*((volatile uint32_t *)(UART3 + UART_RSR_OFFSET)))
#define UART3_FR            (*((volatile uint32_t *)(UART3 + UART_FR_OFFSET)))
#define UART3_IBRD          (*((volatile uint32_t *)(UART3 + UART_IBRD_OFFSET)))
#define UART3_FBRD          (*((volatile uint32_t *)(UART3 + UART_FBRD_OFFSET)))
#define UART3_LCRH          (*((volatile uint32_t *)(UART3 + UART_LCRH_OFFSET)))
#define UART3_CTL           (*((volatile uint32_t *)(UART3 + UART_CTL_OFFSET)))
#define UART3_IFLS          (*((volatile uint32_t *)(UART3 + UART_IFLS_OFFSET)))
#define UART3_IM            (*((volatile uint32_t *)(UART3 + UART_IM_OFFSET)))
#define UART3_RIS           (*((volatile uint32_t *)(UART3 + UART_RIS_OFFSET)))
#define UART3_MIS           (*((volatile uint32_t *)(UART3 + UART_MIS_OFFSET)))
#define UART3_ICR           (*((volatile uint32_t *)(UART3 + UART_ICR_OFFSET)))
#define UART3_DMACTL        (*((volatile uint32_t *)(UART3 + UART_DMACTL_OFFSET)))
#define UART3_CC            (*((volatile uint32_t *)(UART3 + UART_CC_OFFSET)))


// UART Registers for UART4
#define UART4_DR            (*((volatile uint32_t *)(UART4 + UART_DR_OFFSET)))
#define UART4_RSR           (*((volatile uint32_t *)(UART4 + UART_RSR_OFFSET)))
#define UART4_FR            (*((volatile uint32_t *)(UART4 + UART_FR_OFFSET)))
#define UART4_IBRD          (*((volatile uint32_t *)(UART4 + UART_IBRD_OFFSET)))
#define UART4_FBRD          (*((volatile uint32_t *)(UART4 + UART_FBRD_OFFSET)))
#define UART4_LCRH          (*((volatile uint32_t *)(UART4 + UART_LCRH_OFFSET)))
#define UART4_CTL           (*((volatile uint32_t *)(UART4 + UART_CTL_OFFSET)))
#define UART4_IFLS          (*((volatile uint32_t *)(UART4 + UART_IFLS_OFFSET)))
#define UART4_IM            (*((volatile uint32_t *)(UART4 + UART_IM_OFFSET)))
#define UART4_RIS           (*((volatile uint32_t *)(UART4 + UART_RIS_OFFSET)))
#define UART4_MIS           (*((volatile uint32_t *)(UART4 + UART_MIS_OFFSET)))
#define UART4_ICR           (*((volatile uint32_t *)(UART4 + UART_ICR_OFFSET)))
#define UART4_DMACTL        (*((volatile uint32_t *)(UART4 + UART_DMACTL_OFFSET)))
#define UART4_CC            (*((volatile uint32_t *)(UART4 + UART_CC_OFFSET)))


// UART Registers for UART5
#define UART5_DR            (*((volatile uint32_t *)(UART5 + UART_DR_OFFSET)))
#define UART5_RSR           (*((volatile uint32_t *)(UART5 + UART_RSR_OFFSET)))
#define UART5_FR            (*((volatile uint32_t *)(UART5 + UART_FR_OFFSET)))
#define UART5_IBRD          (*((volatile uint32_t *)(UART5 + UART_IBRD_OFFSET)))
#define UART5_FBRD          (*((volatile uint32_t *)(UART5 + UART_FBRD_OFFSET)))
#define UART5_LCRH          (*((volatile uint32_t *)(UART5 + UART_LCRH_OFFSET)))
#define UART5_CTL           (*((volatile uint32_t *)(UART5 + UART_CTL_OFFSET)))
#define UART5_IFLS          (*((volatile uint32_t *)(UART5 + UART_IFLS_OFFSET)))
#define UART5_IM            (*((volatile uint32_t *)(UART5 + UART_IM_OFFSET)))
#define UART5_RIS           (*((volatile uint32_t *)(UART5 + UART_RIS_OFFSET)))
#define UART5_MIS           (*((volatile uint32_t *)(UART5 + UART_MIS_OFFSET)))
#define UART5_ICR           (*((volatile uint32_t *)(UART5 + UART_ICR_OFFSET)))
#define UART5_DMACTL        (*((volatile uint32_t *)(UART5 + UART_DMACTL_OFFSET)))
#define UART5_CC            (*((volatile uint32_t *)(UART5 + UART_CC_OFFSET)))


// UART Registers for UART6
#define UART6_DR            (*((volatile uint32_t *)(UART6 + UART_DR_OFFSET)))
#define UART6_RSR           (*((volatile uint32_t *)(UART6 + UART_RSR_OFFSET)))
#define UART6_FR            (*((volatile uint32_t *)(UART6 + UART_FR_OFFSET)))
#define UART6_IBRD          (*((volatile uint32_t *)(UART6 + UART_IBRD_OFFSET)))
#define UART6_FBRD          (*((volatile uint32_t *)(UART6 + UART_FBRD_OFFSET)))
#define UART6_LCRH          (*((volatile uint32_t *)(UART6 + UART_LCRH_OFFSET)))
#define UART6_CTL           (*((volatile uint32_t *)(UART6 + UART_CTL_OFFSET)))
#define UART6_IFLS          (*((volatile uint32_t *)(UART6 + UART_IFLS_OFFSET)))
#define UART6_IM            (*((volatile uint32_t *)(UART6 + UART_IM_OFFSET)))
#define UART6_RIS           (*((volatile uint32_t *)(UART6 + UART_RIS_OFFSET)))
#define UART6_MIS           (*((volatile uint32_t *)(UART6 + UART_MIS_OFFSET)))
#define UART6_ICR           (*((volatile uint32_t *)(UART6 + UART_ICR_OFFSET)))
#define UART6_DMACTL        (*((volatile uint32_t *)(UART6 + UART_DMACTL_OFFSET)))
#define UART6_CC            (*((volatile uint32_t *)(UART6 + UART_CC_OFFSET)))


// UART Registers for UART7
#define UART7_DR            (*((volatile uint32_t *)(UART7 + UART_DR_OFFSET)))
#define UART7_RSR           (*((volatile uint32_t *)(UART7 + UART_RSR_OFFSET)))
#define UART7_FR            (*((volatile uint32_t *)(UART7 + UART_FR_OFFSET)))
#define UART7_IBRD          (*((volatile uint32_t *)(UART7 + UART_IBRD_OFFSET)))
#define UART7_FBRD          (*((volatile uint32_t *)(UART7 + UART_FBRD_OFFSET)))
#define UART7_LCRH          (*((volatile uint32_t *)(UART7 + UART_LCRH_OFFSET)))
#define UART7_CTL           (*((volatile uint32_t *)(UART7 + UART_CTL_OFFSET)))
#define UART7_IFLS          (*((volatile uint32_t *)(UART7 + UART_IFLS_OFFSET)))
#define UART7_IM            (*((volatile uint32_t *)(UART7 + UART_IM_OFFSET)))
#define UART7_RIS           (*((volatile uint32_t *)(UART7 + UART_RIS_OFFSET)))
#define UART7_MIS           (*((volatile uint32_t *)(UART7 + UART_MIS_OFFSET)))
#define UART7_ICR           (*((volatile uint32_t *)(UART7 + UART_ICR_OFFSET)))
#define UART7_DMACTL        (*((volatile uint32_t *)(UART7 + UART_DMACTL_OFFSET)))
#define UART7_CC            (*((volatile uint32_t *)(UART7 + UART_CC_OFFSET)))


// Base addresses for I2C modules
#define I2C0_BASE 0x40020000
#define I2C1_BASE 0x40021000
#define I2C2_BASE 0x40022000
#define I2C3_BASE 0x40023000

// I2C Registers Offsets
#define I2C_MSA_OFFSET      0x000   // I2C Master Slave Address
#define I2C_MCS_OFFSET      0x004   // I2C Master Control/Status
#define I2C_MTPR_OFFSET     0x00C   // I2C Master Timer Period
#define I2C_MDR_OFFSET      0x008   // I2C Master Data
#define I2C_MACKCTL_OFFSET  0x018   // I2C Master Data Acknowledge Control
#define I2C_MMIS_OFFSET     0x020   // I2C Master Masked Interrupt Status
#define I2C_MICR_OFFSET     0x024   // I2C Master Interrupt Clear
#define I2C_MRIS_OFFSET     0x020   // I2C Master Raw Interrupt Status
#define I2C_MIMR_OFFSET     0x024   // I2C Master Interrupt Mask

// I2C Registers for I2C0
#define I2C0_MSA            (*((volatile uint32_t *)(I2C0_BASE + I2C_MSA_OFFSET)))
#define I2C0_MCS            (*((volatile uint32_t *)(I2C0_BASE + I2C_MCS_OFFSET)))
#define I2C0_MTPR           (*((volatile uint32_t *)(I2C0_BASE + I2C_MTPR_OFFSET)))
#define I2C0_MDR            (*((volatile uint32_t *)(I2C0_BASE + I2C_MDR_OFFSET)))
#define I2C0_MACKCTL        (*((volatile uint32_t *)(I2C0_BASE + I2C_MACKCTL_OFFSET)))
#define I2C0_MMIS           (*((volatile uint32_t *)(I2C0_BASE + I2C_MMIS_OFFSET)))
#define I2C0_MICR           (*((volatile uint32_t *)(I2C0_BASE + I2C_MICR_OFFSET)))
#define I2C0_MRIS           (*((volatile uint32_t *)(I2C0_BASE + I2C_MRIS_OFFSET)))
#define I2C0_MIMR           (*((volatile uint32_t *)(I2C0_BASE + I2C_MIMR_OFFSET)))

// I2C Registers for I2C1
#define I2C1_MSA            (*((volatile uint32_t *)(I2C1_BASE + I2C_MSA_OFFSET)))
#define I2C1_MCS            (*((volatile uint32_t *)(I2C1_BASE + I2C_MCS_OFFSET)))
#define I2C1_MTPR           (*((volatile uint32_t *)(I2C1_BASE + I2C_MTPR_OFFSET)))
#define I2C1_MDR            (*((volatile uint32_t *)(I2C1_BASE + I2C_MDR_OFFSET)))
#define I2C1_MACKCTL        (*((volatile uint32_t *)(I2C1_BASE + I2C_MACKCTL_OFFSET)))
#define I2C1_MMIS           (*((volatile uint32_t *)(I2C1_BASE + I2C_MMIS_OFFSET)))
#define I2C1_MICR           (*((volatile uint32_t *)(I2C1_BASE + I2C_MICR_OFFSET)))
#define I2C1_MRIS           (*((volatile uint32_t *)(I2C1_BASE + I2C_MRIS_OFFSET)))
#define I2C1_MIMR           (*((volatile uint32_t *)(I2C1_BASE + I2C_MIMR_OFFSET)))

// I2C Registers for I2C2
#define I2C2_MSA            (*((volatile uint32_t *)(I2C2_BASE + I2C_MSA_OFFSET)))
#define I2C2_MCS            (*((volatile uint32_t *)(I2C2_BASE + I2C_MCS_OFFSET)))
#define I2C2_MTPR           (*((volatile uint32_t *)(I2C2_BASE + I2C_MTPR_OFFSET)))
#define I2C2_MDR            (*((volatile uint32_t *)(I2C2_BASE + I2C_MDR_OFFSET)))
#define I2C2_MACKCTL        (*((volatile uint32_t *)(I2C2_BASE + I2C_MACKCTL_OFFSET)))
#define I2C2_MMIS           (*((volatile uint32_t *)(I2C2_BASE + I2C_MMIS_OFFSET)))
#define I2C2_MICR           (*((volatile uint32_t *)(I2C2_BASE + I2C_MICR_OFFSET)))
#define I2C2_MRIS           (*((volatile uint32_t *)(I2C2_BASE + I2C_MRIS_OFFSET)))
#define I2C2_MIMR           (*((volatile uint32_t *)(I2C2_BASE + I2C_MIMR_OFFSET)))

// I2C Registers for I2C3
#define I2C3_MSA            (*((volatile uint32_t *)(I2C3_BASE + I2C_MSA_OFFSET)))
#define I2C3_MCS            (*((volatile uint32_t *)(I2C3_BASE + I2C_MCS_OFFSET)))
#define I2C3_MTPR           (*((volatile uint32_t *)(I2C3_BASE + I2C_MTPR_OFFSET)))
#define I2C3_MDR            (*((volatile uint32_t *)(I2C3_BASE + I2C_MDR_OFFSET)))
#define I2C3_MACKCTL        (*((volatile uint32_t *)(I2C3_BASE + I2C_MACKCTL_OFFSET)))
#define I2C3_MMIS           (*((volatile uint32_t *)(I2C3_BASE + I2C_MMIS_OFFSET)))
#define I2C3_MICR           (*((volatile uint32_t *)(I2C3_BASE + I2C_MICR_OFFSET)))
#define I2C3_MRIS           (*((volatile uint32_t *)(I2C3_BASE + I2C_MRIS_OFFSET)))
#define I2C3_MIMR           (*((volatile uint32_t *)(I2C3_BASE + I2C_MIMR_OFFSET)))

// CAN Base Addresses
#define CAN0_BASE   0x40040000
#define CAN1_BASE   0x40041000

// CAN Module Registers Offsets
#define CAN_CTL_OFFSET          0x000   // CAN Control
#define CAN_STS_OFFSET          0x004   // CAN Status
#define CAN_ERR_OFFSET          0x008   // CAN Error Counter
#define CAN_BIT_OFFSET          0x00C   // CAN Bit Timing
#define CAN_INT_OFFSET          0x010   // CAN Interrupt
#define CAN_TST_OFFSET          0x014   // CAN Test
#define CAN_BRPE_OFFSET         0x018   // CAN Baud Rate Prescaler Extension
#define CAN_NWDA_OFFSET         0x020   // CAN New Data
#define CAN_IFnCMSK_OFFSET      0x200   // CAN Interface n Command Mask
#define CAN_IFnCRQ_OFFSET       0x204   // CAN Interface n Command Request
#define CAN_IFnMSK1_OFFSET      0x204   // CAN Interface n Mask 1
#define CAN_IFnMSK2_OFFSET      0x208   // CAN Interface n Mask 2

// CAN Registers for CAN0
#define CAN0_CTL        (*((volatile uint32_t *)(CAN0_BASE + CAN_CTL_OFFSET)))
#define CAN0_STS        (*((volatile uint32_t *)(CAN0_BASE + CAN_STS_OFFSET)))
#define CAN0_ERR        (*((volatile uint32_t *)(CAN0_BASE + CAN_ERR_OFFSET)))
#define CAN0_BIT        (*((volatile uint32_t *)(CAN0_BASE + CAN_BIT_OFFSET)))
#define CAN0_INT        (*((volatile uint32_t *)(CAN0_BASE + CAN_INT_OFFSET)))
#define CAN0_TST        (*((volatile uint32_t *)(CAN0_BASE + CAN_TST_OFFSET)))
#define CAN0_BRPE       (*((volatile uint32_t *)(CAN0_BASE + CAN_BRPE_OFFSET)))
#define CAN0_NWDA       (*((volatile uint32_t *)(CAN0_BASE + CAN_NWDA_OFFSET)))
#define CAN0_IF1CMSK    (*((volatile uint32_t *)(CAN0_BASE + CAN_IF1CMSK_OFFSET)))
#define CAN0_IF1CRQ     (*((volatile uint32_t *)(CAN0_BASE + CAN_IF1CRQ_OFFSET)))
#define CAN0_IF1MSK1    (*((volatile uint32_t *)(CAN0_BASE + CAN_IF1MSK1_OFFSET)))
#define CAN0_IF1MSK2    (*((volatile uint32_t *)(CAN0_BASE + CAN_IF1MSK2_OFFSET)))

// CAN Registers for CAN1
#define CAN1_CTL        (*((volatile uint32_t *)(CAN1_BASE + CAN_CTL_OFFSET)))
#define CAN1_STS        (*((volatile uint32_t *)(CAN1_BASE + CAN_STS_OFFSET)))
#define CAN1_ERR        (*((volatile uint32_t *)(CAN1_BASE + CAN_ERR_OFFSET)))
#define CAN1_BIT        (*((volatile uint32_t *)(CAN1_BASE + CAN_BIT_OFFSET)))
#define CAN1_INT        (*((volatile uint32_t *)(CAN1_BASE + CAN_INT_OFFSET)))
#define CAN1_TST        (*((volatile uint32_t *)(CAN1_BASE + CAN_TST_OFFSET)))
#define CAN1_BRPE       (*((volatile uint32_t *)(CAN1_BASE + CAN_BRPE_OFFSET)))
#define CAN1_NWDA       (*((volatile uint32_t *)(CAN1_BASE + CAN_NWDA_OFFSET)))
#define CAN1_IF1CMSK    (*((volatile uint32_t *)(CAN1_BASE + CAN_IF1CMSK_OFFSET)))
#define CAN1_IF1CRQ     (*((volatile uint32_t *)(CAN1_BASE + CAN_IF1CRQ_OFFSET)))
#define CAN1_IF1MSK1    (*((volatile uint32_t *)(CAN1_BASE + CAN_IF1MSK1_OFFSET)))
#define CAN1_IF1MSK2    (*((volatile uint32_t *)(CAN1_BASE + CAN_IF1MSK2_OFFSET)))





#endif /* MYHEADER_H_ */
