/*
 * Ultrasonic.c
 *
 *  Created on: 10-Apr-2024
 *      Author: spbha
 */

#include <stdint.h>
#include "tm4c123gh6pm.h"
#include "hw_memmap.h"
#include "Ultrasonic.h"
#include "Timer.h"


void init_tim_ultrasound()                  // PD0, PD3 for echo and trig respectively
{
        SYSCTL_RCGCWTIMER_R  |= (1<<2);     /* enable clock to wide Timer Block 2 */
        SYSCTL_RCGCGPIO_R    |= (1<<3);      /* enable clock to PORTD */
        GPIO_PORTD_DIR_R &= ~0x01;        /* make PD0 an input pin */
        GPIO_PORTD_DEN_R |= 0x01;         /* make PD0 as digital pin */
        GPIO_PORTD_AFSEL_R |= 0x01;       /* use PD0 alternate function */
        GPIO_PORTD_PCTL_R &= ~0x0000000F;  /* configure PD0 for T0CCP0. Even block or WTimer2A */
        GPIO_PORTD_PCTL_R |= 0x00000007;
        /* PD3 as a digital output signal to provide trigger signal */
        GPIO_PORTD_DIR_R |=(1<<3);         /* set PD3 as a digital output pin */
        GPIO_PORTD_DEN_R |=(1<<3);         /* make PD3 as digital pin */
        WTIMER2_CTL_R  &= ~1;          /* disable Wtimer2A during setup */
        WTIMER2_CFG_R   = 4;           /* 32-bit Wtimer mode */
        WTIMER2_TAMR_R  = 0x17;        /* up-count, edge-time, capture mode */
        WTIMER2_CTL_R  |= 0x0C;        /* capture the rising edge */
        WTIMER2_CTL_R  |= (1<<0);      /* enable Wtimer2A */
}


uint32_t Measure_distance(void)
{
      unsigned int lastEdge, thisEdge,distance;
      unsigned int ovf;
      /* Given 10us trigger pulse. PD3 is trigger pin (output) */
      GPIO_PORTD_DATA_R &= ~(1<<3); /* make trigger  pin low */
      Delay_MicroSecond(10); /*10 seconds delay */
      GPIO_PORTD_DATA_R |= (1<<3); /* make trigger  pin high */
      Delay_MicroSecond(10); /*10 seconds delay */
      GPIO_PORTD_DATA_R &= ~(1<<3); /* make trigger  pin low */
      ovf = 0;
    while(1)
    {
        WTIMER2_ICR_R = 4;                      /* clear Wtimer2A capture flag */
        while(((WTIMER2_RIS_R & 4) == 0)) ;       /* wait till captured */
        if((GPIO_PORTD_DATA_R&(1<<0)))          /*check if rising edge occurs on PD0 echo pin*/
        {
            lastEdge = WTIMER2_TAR_R;           /* save the timestamp */
            WTIMER2_ICR_R = 4;                  /* detect falling edge. Hence clear Wtimer2A capture flag */
            while(((WTIMER2_RIS_R&4) == 0));     /* wait till falling edge is captured */
            thisEdge = WTIMER2_TAR_R;            /* save the timestamp */
            distance = ((thisEdge - lastEdge)* 10625)/10000000;
            if(distance < 30 )
                return (distance);       /* return the distance */
            else
                return (distance);
        }
    }
}
