/*
 * UART.c
 *
 *  Created on: 01-May-2024
 *      Author: shish
 */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <stdint.h>
#include <stdbool.h>
#include <string.h>
#include <ctype.h>
#include "driverlib/uart.h"
#include "utils/uartstdio.h"
#include "UART.h"
#include "inc/hw_memmap.h"

int state = 1;
char buffer[3];
//void UART_config()
//{
//     SysCtlPeripheralEnable(SYSCTL_PERIPH_UART0);
//     SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOA);
//
//     GPIOPinConfigure(GPIO_PA0_U0RX);
//     GPIOPinConfigure(GPIO_PA1_U0TX);
//     GPIOPinTypeUART(GPIO_PORTA_BASE, GPIO_PIN_0 | GPIO_PIN_1);
//
//     UARTConfigSetExpClk(UART0_BASE, SysCtlClockGet(), 9600,(UART_CONFIG_WLEN_8 | UART_CONFIG_STOP_ONE | UART_CONFIG_PAR_NONE));
//}

void UART_read()
{
    int i = 0;
    //int count = 0;
    do
    {
        buffer[i] = UARTCharGet(UART0_BASE);
        if (buffer[i] == 127 || buffer[i] == 8) // ASCII of backspace is 8. But compiler interprets as DEL with ASCII 127. For some other console it might take 8
        {
            buffer[i - 1] = ' ';   // Logic of backspace. Move one position back
            i = i - 2;
        }
        i++;
        //count = i;

    }
    while (buffer[i - 1] != '\r' && i != 3); // ASCII of right clock of mouse = 252. Enter =\r

//    for(int j=0;j<count;j++)                                // Echo the word back to console
//        UARTCharPut(UART0_BASE, buffer[j]);
//    UARTCharPut(UART0_BASE, 13);                      // ASCII of new line or line feed is 10. CR = 13
//    UARTCharPut(UART0_BASE, 10);

    removeSpace(buffer);                 // Pre process to remove spcae and tabs

    process(buffer);                             // Compare with desired strings
    UARTCharPut(UART0_BASE, 10);
    strcpy(buffer, "\0");                         // strcpy(val," ")

}

void removeSpace(char *str)
{
    int count = 0, i;
    for (i = 0; str[i] != '\r'; i++)        // Last character is \r due to enter
        if (str[i] != 9 && str[i] != 32)
            str[count++] = tolower(str[i]);         // here count is incremented

    str[count] = '\0';

}

void process(char *str)
{
    int i;
    if (strcmp(str, "s") == 0)
        state = 1;
    else
    {
        state = 0;
        strcpy(str, "Command help 1.s\0");
        for (i = 0; str[i] != '\0'; i++)
            UARTCharPut(UART0_BASE, str[i]);
        UARTCharPut(UART0_BASE, 10);
        UARTCharPut(UART0_BASE, 13);
    }

}
