/*
 * Timer.c
 *
 *  Created on: 10-Apr-2024
 *      Author: spbha
 */

#include <stdint.h>
#include "tm4c123gh6pm.h"
#include "hw_memmap.h"
#include "Timer.h"

/* Implements Delay for given micro second using Timer 2A  of 16/32 bit block */
void Delay_MicroSecond(int time)
{
    int i;
    SYSCTL_RCGCTIMER_R |= 4;     /* enable clock to Timer Block 2 */
    TIMER2_CTL_R = 0;            /* disable Timer before initialization */
    TIMER2_CFG_R = 0x04;         /* 16-bit option */
    TIMER2_TAMR_R = 0x02;        /* periodic mode and down-counter */
    TIMER2_TAILR_R = 16 - 1;    /* TimerA interval load value reg for 1us */
    TIMER2_ICR_R = 0x1;          /* clear the TimerA timeout flag */
    TIMER2_CTL_R |= 0x01;        /* enable Timer A after initialization */

    for(i = 0; i < time; i++)
    {
        while ((TIMER2_RIS_R  & 0x1) == 0) ;      /* wait for Timer2A timeout flag. Interrupt is generated for every 1us */
        TIMER2_ICR_R = 0x1;      /* clear the TimerA timeout flag */
    }
}
