/*
 * PWM.c
 *
 *  Created on: 01-May-2024
 *      Author: spbha
 */


/*
 * PWM.c
 *
 *  Created on: 28-Apr-2024
  *      Author: spbha
 */

#include <stdint.h>
#include "C:\Users\shish\Downloads\software\TivaWare_C_Series-2.2.0.295\TivaWare_C_Series-2.2.0.295\inc\tm4c123gh6pm.h"
#include "PWM.h"
void PORTC_PWM_init()                    // PC4 PWM pin   Generator A

{
    SYSCTL_RCGCPWM_R |= 1; /* enable clock to PWM0 */
    SYSCTL_RCGCGPIO_R |= 0x04; /* enable clock to PORTC */
    SYSCTL_RCC_R &= ~0x00100000; /* no pre-divide for PWM clock */
    SYSCTL_RCC_R |= 0x000E0000;

    /* Enable port PC4 for PWM0 M0PWM6 */

    GPIO_PORTC_AFSEL_R |= (1 << 4);  // PC4 uses alternate function
    GPIO_PORTC_PCTL_R &= ~0x000F0000; // Make PC4 PWM output pin
    GPIO_PORTC_PCTL_R |= 0x00040000;
    GPIO_PORTC_DEN_R |= (1 << 4);  // Make PC4 pin digital

    PWM0_3_CTL_R &= ~(1<<0); /* stop counter */
    PWM0_3_CTL_R &= ~(1<<1);
    PWM0_3_GENA_R = 0x0000008C; /* M0PWM6 output set when reload, */
    /* clear when match PWMCMPA */
    PWM0_3_LOAD_R = 7000; /* set load value for 1kHz (16MHz/16000) */
    PWM0_3_CMPA_R = 4999; /* set duty cycle to min */
    PWM0_3_CTL_R = 1; /* start timer */
    //PWM0_ENABLE_R |= 0x40; /* start PWM0 ch6 */

    //////////////////////////////////////////////////////////////////





    ////**************** For Tail Motor*******************************////

    /* Enable port PC5 for PWM0 M0PWM7 */            // Generator B
//    GPIO_PORTC_AFSEL_R |= (1 << 5);  // PC5 uses alternate function
//    GPIO_PORTC_PCTL_R &= ~0x00F00000; // Make PC5 PWM output pin
//    GPIO_PORTC_PCTL_R |= 0x00400000;
//    GPIO_PORTC_DEN_R |= (1 << 5);  // Make PC5 pin digital
//
//    PWM0_3_CTL_R &= ~(1<<0); /* stop counter */
//    PWM0_3_CTL_R &= ~(1<<1);
//    PWM0_3_GENB_R = 0x0000080C; /* M0PWM7 output set when reload, */
//    /* clear when match PWMCMPB */
//    PWM0_3_LOAD_R = 5000; /* set load value for 1kHz (16MHz/16000) */
//    PWM0_3_CMPB_R = 4999; /* set duty cycle to min */
//    PWM0_3_CTL_R = 1; /* start timer */
//    PWM0_ENABLE_R |= 0x80; /* start PWM0 ch7 */


}


////**************** For Tail Motor*******************************////
void PORTD_PWM_init()                   /// PD1 PWM  Generator B
{

    /* Enable Peripheral Clocks */
    SYSCTL_RCGCPWM_R |= 2; /* enable clock to PWM1 */
    SYSCTL_RCGCGPIO_R |= 0x08; /* enable clock to PORTD */
    SYSCTL_RCC_R &= ~0x00100000; /* no pre-divide for PWM clock */
    SYSCTL_RCC_R |= 0x000E0000;
    /* Enable port PD1 for PWM1 M1PWM1 */
    GPIO_PORTD_AFSEL_R = (1<<1); /* PD1 uses alternate function */
    GPIO_PORTD_PCTL_R &= ~0x000000F0; /* make PD1 PWM output pin */
    GPIO_PORTD_PCTL_R |= 0x00000050;
    GPIO_PORTD_DEN_R |= (1<<1); /* pin digital */


    PWM1_0_CTL_R &= ~(1<<0); /* stop counter */
    PWM1_0_CTL_R &= ~(1<<1);
    PWM1_0_GENB_R = 0x0000080C; /* M1PWM1 output set when reload, */
    /* clear when match PWMCMPA */
    PWM1_0_LOAD_R |= 7000; /* set load value for 1kHz (16MHz/16000) */
    PWM1_0_CMPB_R |= 4999; /* set duty cycle to min */
    PWM1_0_CTL_R |= 1; /* start timer */
    PWM1_ENABLE_R |= 0x02; /* start PWM1 ch1 */

}

void PORTF_PWM_init()                   /// PF2 - PWM  Generator A
{
    ////**************** For Servo Motor*******************************////



    /* Enable Peripheral Clocks */
    SYSCTL_RCGCPWM_R |= 2; /* enable clock to PWM1 */
    SYSCTL_RCGCGPIO_R |= 0x20; /* enable clock to PORTF */
    SYSCTL_RCC_R &= ~0x00100000; /* no pre-divide for PWM clock */
    SYSCTL_RCC_R |= 0x000E0000;
    /* Enable port PF2 for PWM1 M1PWM7 */
    GPIO_PORTF_AFSEL_R = 6; /* PF2 uses alternate function */
    GPIO_PORTF_PCTL_R &= ~0x00000F00; /* make PF2 PWM output pin */
    GPIO_PORTF_PCTL_R |= 0x00000500;
    GPIO_PORTF_DEN_R |= 6; /* pin digital */


    PWM1_3_CTL_R &= ~(1<<0); /* stop counter */
    PWM1_3_CTL_R &= ~(1<<1);
    PWM1_3_GENA_R = 0x0000008C; /* M1PWM7 output set when reload, */
    /* clear when match PWMCMPA */
    PWM1_3_LOAD_R |= 5000; /* set load value for 1kHz (16MHz/16000) */
    PWM1_3_CMPA_R |= 4999; /* set duty cycle to min */
    PWM1_3_CTL_R |= 1; /* start timer */
    //PWM1_ENABLE_R |= 0x40; /* start PWM1 ch7 */

    ////////////////////////////////////////////////////////////////////
}

void PWM_init()                          /// PE5 - PWM Generator A
{
/* Enable Peripheral Clocks */

    SYSCTL_RCGCPWM_R |= 2;          /* enable clock to PWM1 */
    SYSCTL_RCGCGPIO_R |= 0x10;     /* enable clock to PORTE */
    SYSCTL_RCC_R &= ~0x00100000;   /* no pre-divide for PWM clock */
    SYSCTL_RCC_R |= 0x000E0000;  /* PWM clock divisor set to 64. System clock gets divided by 64

    /* Enable port PE4 for PWM1 M1PWM2 */

    GPIO_PORTE_AFSEL_R |= 0X10;              /* PE4 uses alternate function */
    GPIO_PORTE_PCTL_R &= ~0x00F00000;   /* make PE4 PWM output pin */
    GPIO_PORTE_PCTL_R |= 0x00050000;      /* Write 5 to the PCTL register of PE4. Refer PWM chapter in datasheet */
    GPIO_PORTE_DEN_R |= 16;                /*pin digital */
    PWM1_1_CTL_R &= ~(1<<0);      /* stop counter. Disabled the PWM block */
    PWM1_1_CTL_R &= ~(1<<1);        /* Count down mode and counter wraps back. Write 0 to bit 8 and 9 to immediately load value once count reaches 0 */
    PWM1_1_GENA_R = 0x0000008C;     /* M1PWM2 output set when reload. Drive pwmA high when loaded and invert when matches compare A reg. This gives left aligned square wave */

    /* clear when match PWMCMPA */
    PWM1_1_LOAD_R = 7000; /* set load value for 3.2kHz (16MHz/5000) */
    PWM1_1_CMPA_R = 4999; /* set duty cycle to min */
    PWM1_1_CTL_R = 1; /* start timer */
    //PWM1_ENABLE_R = 0x04; /* start PWM1 ch2 */
}


