/*
 * DTW.c
 *
 *  Created on: 30-Apr-2024
 *      Author: shish
 */



#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <stdint.h>
#include <stdbool.h>
#include "driverlib/uart.h"
#include "utils/uartstdio.h"
#include "DTW.h"

int dp[11][12];


// Function to find the minimum of three numbers
int min(int a, int b, int c)
{
    if (a < b && a < c)
        return a;
    if (b < a && b < c)
        return b;
    return c;
}

// Function to calculate the distance between two points (elements of the time series)
int distance(int x, int y)
{
    return abs(x - y);                  // Use Euclidean distance or any other distance metric
}

// Function to perform Dynamic Time Warping and obtain the warp path
float dtw(float s1[], const float s2[], int n, int m)
{

    int path[11][12];
    float total_distance;
    int i ,j;
    float count =0;                        // Counnt is the number of elements traced in the DP 2D array
    float normalised_distance;
    int dec_normalised_distance,int_normalised_distance;

    // Initialize the DP and path arrays. Indexing is from 0 to n-1
    for ( i = 0; i <= n; i++)
    {
        for (j = 0; j <= m; j++)
        {
            dp[i][j] = INF;
            path[i][j] = 0;
        }
    }

    dp[0][0] = 0;

    // Fill the DP array
    for ( i = 1; i <= n; i++)
    {
        for ( j = 1; j <= m; j++)
        {
            int cost = distance(s1[i-1], s2[j-1]);
            int min_cost = min(dp[i-1][j], dp[i][j-1], dp[i-1][j-1]);
            dp[i][j] = cost + min_cost;

            // Update the path
            if (dp[i-1][j] == min_cost) path[i][j] = 1; // Move up
            else if (dp[i][j-1] == min_cost) path[i][j] = 2; // Move left
            else path[i][j] = 3; // Move diagonally
        }
    }


    // Backtrack to find the warp path
     i = n, j = m;
    total_distance = dp[n][m];       // Add the last element

    while (i > 0 && j > 0)
    {

        total_distance = total_distance + min(dp[i-1][j],dp[i][j-1],dp[i-1][j-1]);         // Keep adding total distance to minimum value
        count = count +1;
        int direction = path[i][j];
        if (direction == 1)
            i--;                  // Move up
        else if (direction == 2)
            j--;                  // Move left
        else
        {                           // Move diagonally
            i--;
            j--;
        }
    }
    UARTprintf("data ready3\n");

    // Print the cost matrix

//    for ( i = n; i >= 1; i--)
//    {
//        for ( j = 1; j <= m; j++)
//        {
//            //UARTprintf ("%d",dp[i][j]);
//            //UARTprintf ("%d %d",i,j);
//            //UARTprintf("\t");
//        }
//        //UARTprintf("\n");
//    }

    //Get the normalised distance
    normalised_distance =  (float) (total_distance/(count));
    int_normalised_distance = (int32_t) normalised_distance;

    // Multiply by 1000 to preserve first three decimal values. Truncates at the 3rd decimal place.

    dec_normalised_distance = (int32_t) (normalised_distance * 1000.0f);

    // Subtract off the integer part from this newly formed decimal part. make the decimal part a positive number for display.

    if (dec_normalised_distance < 0)
    {
        dec_normalised_distance *= -1;
    }

    UARTprintf("%d.%3d\n",int_normalised_distance,dec_normalised_distance);
    return normalised_distance;
}

