/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Interface
extends JDialog {
    public ServerSocket serverSocket;
    public Socket server;
    public DataOutputStream out;
    private JButton jButton1;
    private JButton jButton2;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JSlider jSlider1;

    public Interface(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.OpenServer();
    }

    public void OpenServer() {
        try {
            this.serverSocket = new ServerSocket(9999);
        }
        catch (IOException e) {
            System.out.println("Error");
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Interface.this.server = Interface.this.serverSocket.accept();
                    Interface.this.jLabel1.setText("Client Info:" + Interface.this.server.getRemoteSocketAddress());
                    Interface.this.out = new DataOutputStream(Interface.this.server.getOutputStream());
                }
                catch (Exception e) {
                    System.out.println("ERROR STATUS");
                }
            }
        }).start();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jPanel1 = new JPanel();
        this.jSlider1 = new JSlider();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jLabel2 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setPreferredSize(new Dimension(250, 250));
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                Interface.this.formWindowClosing(evt);
            }
        });
        this.jLabel1.setFocusable(false);
        this.jLabel1.setText("Internet of Things");
        this.getContentPane().add((Component)this.jLabel1, "Last");
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel1.setLayout(null);
        this.jSlider1.setFocusable(false);
        this.jSlider1.setMinimum(0);
        this.jSlider1.setMaximum(180);
        this.jSlider1.setValue(90);
        this.jSlider1.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)), "Set Servo Angle"));
        this.jSlider1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                int angle = Interface.this.jSlider1.getValue();
                String command = "SetAngle " + Integer.toString(angle) + "\n";
                try {
                    Interface.this.out.write(command.getBytes());
                    Thread.sleep(100L);
                }
                catch (Exception e) {
                    System.out.println("NOT SEND!");
                    System.out.println(e);
                }
                Interface.this.jLabel2.setText(Integer.toString(angle) + "\u00b0");
                System.out.println(command);
            }
        });
        this.jPanel1.add(this.jSlider1);
        this.jSlider1.setBounds(10, 20, 220, 60);
        this.jButton1.setFocusable(false);
        this.jButton1.setText("CLOSE TCP");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String command = "CloseConnection\n";
                try {
                    Interface.this.out.write(command.getBytes());
                    Interface.this.out.close();
                    Interface.this.server.close();
                    Interface.this.serverSocket.close();
                    Thread.sleep(100L);
                }
                catch (Exception e) {
                    System.out.println("NOT SEND!");
                    System.out.println(e);
                }
            }
        });
        this.jPanel1.add(this.jButton1);
        this.jButton1.setBounds(10, 90, 108, 40);
        this.jButton2.setFocusable(false);
        this.jButton2.setText("IoT(!)");
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Interface.this.OpenServer();
                Interface.this.jSlider1.setValue(90);
            }
        });
        this.jPanel1.add(this.jButton2);
        this.jButton2.setBounds(124, 90, 108, 40);
        this.jLabel2.setFocusable(false);
        this.jLabel2.setFont(new Font("Courier New", 0, 36));
        this.jLabel2.setText(Integer.toString(90) + "\u00b0");
        this.jLabel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)), "Servo Angle"));
        this.jLabel2.setHorizontalTextPosition(0);
        this.jPanel1.add(this.jLabel2);
        this.jLabel2.setBounds(10, 130, 100, 60);
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.pack();
    }

    private void formWindowClosing(WindowEvent evt) {
        String command = "CloseConnection\n";
        try {
            this.out.write(command.getBytes());
            this.out.close();
            this.server.close();
            this.serverSocket.close();
            Thread.sleep(100L);
        }
        catch (Exception e) {
            System.out.println("NOT SEND!");
            System.out.println(e);
        }
        System.exit(0);
    }
}

