#include <./inc/tm4c123gh6pm.h>
#include <driverlib/pin_map.h>
#include <stdint.h>
#include <stdlib.h>
#include <stdio.h>
#include "GPIO.h"

// Function to initialize Ports A and B
void Init_PortAB(void)
{
    SYSCTL_RCGC2_R |= 0x00000023;
    GPIO_PORTA_CR_R = 0xF0;
    GPIO_PORTB_CR_R = 0xFF;

    GPIO_PORTA_AMSEL_R = 0x00;
    GPIO_PORTB_AMSEL_R = 0x00;

    GPIO_PORTB_DIR_R = 0xFF;
    GPIO_PORTA_DIR_R = 0xF0;

    GPIO_PORTB_AFSEL_R = 0x00;
    GPIO_PORTA_AFSEL_R = 0x00;

    GPIO_PORTB_DEN_R = 0xFF;
    GPIO_PORTA_DEN_R = 0xF0;
}

void Init_PortC(void)
{
    // Initializing PORT C for 4x4  KeyPad Interfacing
    SYSCTL_RCGC2_R    |= 0x00000004 ;       /* Enable clock to GPIO_C_ at clock gating control register */
    SYSCTL_RCGCGPIO_R |= 0x00000004 ;       /* Enable and provide a clock to GPIO Port_C_ in Run mode */
    GPIO_PORTC_DIR_R  &= ~ 0xF0 ;           /*  GPIO Direction | 0 -> INPUT | 1 -> OUTPUT (We are configuring PORTC as input and connecting it to columns of 4x4 Keypad)*/
    GPIO_PORTC_ODR_R |= 0xF0 ;              /* 1 -> The corresponding pin is configured as open drain */
    GPIO_PORTC_DEN_R |= 0xF0;               /* enable the GPIO pins for digital function */
    GPIO_PORTC_PUR_R |= 0xF0 ;              /* 1 -> The corresponding pin's weak pull-up resistor is enabled */

    // Interrupt setup for 4x4 keypad in  PORTC
    // Interrupt sense register sets value for bits PC7 - PC4. (1 - level triggered, 0 - edge triggered)
    GPIO_PORTC_IS_R &= ~(0xF0);
    // Interrupt Both Edges is not set
    GPIO_PORTC_IBE_R &= ~(0xF0);

    // If both edges not set then
    // Trigger controlled by IEV (Interrupt Even Register) for negative/positive or rising/falling
    GPIO_PORTC_IEV_R &= ~(0xF0);

    // Clearing previous interrupts if any
    // For edge triggered interrupts, writing a 1 clears the interrupts
    GPIO_PORTC_ICR_R |= (0xF0);

    // Unmask interrupt for PC7 - PC4 (Setting a bit in the GPIOIM register allows interrupts that are generated by the corresponding pin to be sent to the interrupt controller on the combined interrupt signal)
    GPIO_PORTC_IM_R |= 0xF0;

    // set interrupt priority = 2 for PORTC
    NVIC_PRI0_R = (NVIC_PRI0_R & 0xFF00FFFF) | 0x00400000;
    NVIC_EN0_R = 0x00000004;        // NVIC enabled for PORTC (IRQ number = 2)
}

// Function to initialize Port E
void Init_PortE(void)
{
    // Initializing PORT E  for 4x4 Keypad Interfacing
    SYSCTL_RCGC2_R    |= 0x00000010 ;       /* Enable clock to GPIO_E_ at clock gating control register */
    SYSCTL_RCGCGPIO_R |= 0x00000010 ;       /* Enable and provide a clock to GPIO Port_E_ in Run mode */
    GPIO_PORTE_DIR_R  |= 0x0F ;             /*  GPIO Direction | 0 -> INPUT | 1 -> OUTPUT  (We are configuring PORTE as output and connecting it to rows of 4x4 Keypad)*/
    GPIO_PORTE_DEN_R  |= 0x0F;              /* enable the GPIO pins for digital function */
    GPIO_PORTE_DATA_R  = 0x00 ;             /* Initializing PORTE Data to all 0s*/
}

void Init_PortF(void)
{
    SYSCTL_RCGC2_R |= 0x00000020; /* Activate Clock for PORTF */
//    delay = SYSCTL_RCGC2_R; /* Allow time for clock to start*/
    GPIO_PORTF_DIR_R =  0x0E;  /* enable the GPIO pins for the LED (PF3, 2 1) as output */
    GPIO_PORTF_LOCK_R = 0x4C4F434B;   /* unlock commit register GPIOCR */
    GPIO_PORTF_CR_R = 0x0E;
    GPIO_PORTF_AMSEL_R = 0x00; /* disable analog on PF*/
    GPIO_PORTF_PCTL_R = 0x00000000; /* PCTL GPIO on PF4 - PF0*/
    GPIO_PORTF_DIR_R = 0x0E; /* PF4, PF0 as inputs and (PF3, PF2 ,PF1) as input pins*/
    GPIO_PORTF_AFSEL_R = 0x00; /* disable alternate function on PF7 - PF0*/
    GPIO_PORTF_PUR_R = 0x00; /* enable pull up on PF0 and PF4*/
    GPIO_PORTF_DEN_R = 0x0E;
}
