import serial
import csv
from time import sleep

ser = serial.Serial('/dev/ttyACM0', 115200, timeout=1)
ser_write = serial.Serial('/dev/ttyACM1', 115200, timeout=1)

sleep(2)

# Function to check UART input and print parts of the message
def UART_input_check(input, source_MAC):
    index = 0
    TLV_length = 0

    # Extract Source MAC Address
    source_MAC_address = input[12:24]

    # Extract Goose AppID
    goose_app_id = input[28:32]

    # Extract goCBref
    goCBref = input[48:52]

    # Extract data
    data = input[94:]

    print(f"Source MAC Address: {source_MAC_address}")
    print(f"Goose AppID: {goose_app_id}")
    print(f"goCBref: {goCBref}")
    print(f"Data: {data}")


def remove_null_characters(data):
    return data.replace('\0', '')

def process_uart_input(line):
    segments = line.split('\r')
    processed_segments = [remove_null_characters(segment) for segment in segments]
    return processed_segments

with open('data.csv', mode='w', newline='') as file:
    writer = csv.writer(file)
    try:
        while True:
            if ser.in_waiting > 0:
                line = ser.readline().decode('utf-8').strip()
                if line:
                    segments = process_uart_input(line)
                    for segment in segments:
                        print(f"Data written to CSV: {'IDE1',segment}")
                        writer.writerow(['IDE1',segment])
                        ser_write.write((segment + '\r').encode('utf-8'))
                        UART_input_check(segment, 'IDE1')
            elif ser_write.in_waiting > 0:
                line = ser_write.readline().decode('utf-8').strip()
                if line:
                    segments = process_uart_input(line)
                    for segment in segments:
                        print(f"Data written to CSV: {'IDE2',segment}")
                        writer.writerow(['IDE2',segment])
                        ser.write((segment + '\r').encode('utf-8'))
                        UART_input_check(segment, 'IDE2')

    except KeyboardInterrupt:
        print("Program terminated by user")
    finally:
        ser.close()
