#include <stdint.h>

#include "inc/tm4c123gh6pm.h"

#include <stdlib.h>

#include <stdbool.h>

#include <inc/hw_memmap.h>

#include <inc/hw_types.h>

#include <driverlib/gpio.h>

#include <driverlib/pin_map.h>

#include <driverlib/sysctl.h>

#include <driverlib/uart.h>

#include "UART.h"

//#include "Uart1.c"

#include "keypad.h"

#include "LCD.h"

#include "ADC.h"

#include "IDE.h"

#include "Misc.h"

void sel_channel(int n);

//************************************************************************************************************

//                        ||||||||||||           MAIN       |||||||

//************************************************************************************************************


int main()

{

    ADC_Init();                  // Initialize ADC for analog input

    LCD_Init();                  // Initialize LCD

    keypad_init();

//  EnableInterrupts ();

    GPIO_setup();

    UARTInit();

    LCD_Clear();

    unsigned int trig_out = 0;

    void sel_channel(int n)

    {

        ADC0_SSMUX3_R = n;           // Set the analog input channel to AIN8

    }

    while (1)

    {

        trig_out++;

        int enst = change_IDE();

        if (enst)

            change_seq();

        disp_stopwatch_time();

        // voltage data is being send

        if (trig_out == 9999)

        {

            unsigned char *out_ptr;

            int output_length;

            unsigned int randomNumber = (unsigned int) (rand() % 50001);

            sel_channel(8);

            int voltage =ADC_Read();

            voltage = (voltage*3.3*10000)/4095;      // voltage  have scalled with 10kv from power station


            out_ptr = UART_output_IDE(select_IDE, ethertype, appid, 0xAAAA,

                                      ttl, time_stamp, randomNumber, 12345,

                                      voltage, &output_length);

            unsigned char UART_binary[output_length];

            for (int k = 0; k < output_length; k++)

            {

                UART_binary[k] = out_ptr[k];

            }

            if (incomplete == 'Y')

                output_length = output_length - 5;

            for (int k = 0; k < output_length; k++)

            {

                char hexString[3];

                sprintf(hexString, "%02X", UART_binary[k]);

                UARTCharPut(UART0_BASE, hexString[0]); // Transmit each character of the string

                UARTCharPut(UART0_BASE, hexString[1]);

            }

            UARTCharPut(UART0_BASE, '\r');

            UARTCharPut(UART0_BASE, '\n');

        }

        // current data is being send

        if (trig_out == 19999)

        {

            unsigned char *out_ptr;

            int output_length;

            unsigned int randomNumber = (unsigned int) (rand() % 50001);

            sel_channel(9);

            int current = ADC_Read();

            current = (current*3.3*100)/4095;      //current have scalled with 100

            out_ptr = UART_output_IDE(select_IDE, ethertype, appid, 0xDDDD,

                                      ttl, time_stamp, randomNumber, 54321,

                                      current, &output_length);

            unsigned char UART_binary[output_length];

            for (int k = 0; k < output_length; k++)

            {

                UART_binary[k] = out_ptr[k];

            }

            if (incomplete == 'Y')

                output_length = output_length - 5;

            for (int k = 0; k < output_length; k++)

            {

                char hexString[3];

                sprintf(hexString, "%02X", UART_binary[k]);

                UARTCharPut(UART0_BASE, hexString[0]); // Transmit each character of the string

                UARTCharPut(UART0_BASE, hexString[1]);

            }

            UARTCharPut(UART0_BASE, '\r');

            UARTCharPut(UART0_BASE, '\n');

        }

        // current data is being send

        if (trig_out == 29999)

        {

            trig_out = 0;

            unsigned char *out_ptr;

            int output_length;

            unsigned int randomNumber = (unsigned int) (rand() % 50001);

            sel_channel(4);

            int load = ADC_Read();

           //calculation of unknown resistance in integer

            load = load*10000/(4096 - load);          // load have scalled with 10kohm

            out_ptr = UART_output_IDE(select_IDE, ethertype, appid, 0xFFFF,

                                      ttl, time_stamp, randomNumber, 54321,

                                      load, &output_length);

            unsigned char UART_binary[output_length];

            for (int k = 0; k < output_length; k++)

            {

                UART_binary[k] = out_ptr[k];

            }

            if (incomplete == 'Y')

                output_length = output_length - 5;

            for (int k = 0; k < output_length; k++)

            {

                char hexString[3];

                sprintf(hexString, "%02X", UART_binary[k]);

                UARTCharPut(UART0_BASE, hexString[0]); // Transmit each character of the string

                UARTCharPut(UART0_BASE, hexString[1]);

            }

            UARTCharPut(UART0_BASE, '\r');

            UARTCharPut(UART0_BASE, '\n');

        }

        int input_length = UART_read();

        if (input_length > 20)

        {

            APDU buffer;

            UART_input_check(hex_input, input_length, &buffer);

        }

    }

}
