#include <stdint.h>
#include <stdio.h>
#include <stdbool.h>

#include <./inc/tm4c123gh6pm.h>

void UARTInit();
void UARTStringPut(const char *str);
void UARTPrintf(const char *format, ...);

// Function to initialize UART
void UARTInit(){
    ////////UART -------->

        SysCtlPeripheralEnable(SYSCTL_PERIPH_UART0);
        SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOA);

        GPIOPinConfigure(GPIO_PA0_U0RX);
        GPIOPinConfigure(GPIO_PA1_U0TX);
        GPIOPinTypeUART(GPIO_PORTA_BASE, GPIO_PIN_0 | GPIO_PIN_1);

        UARTConfigSetExpClk(UART0_BASE, SysCtlClockGet(), 115200, (UART_CONFIG_WLEN_8 | UART_CONFIG_STOP_ONE | UART_CONFIG_PAR_NONE));
}

void UARTStringPut(const char *str) {
    while (*str != '\0') {
        UARTCharPut(UART0_BASE,*str++);// Transmit each character of the string
    }
}



