#include <stdint.h>
#include <stdio.h>
#include <stdbool.h>

#include <./inc/tm4c123gh6pm.h>

extern int state ;
extern int seqNum;

//int cnt;





// hex values of digits for 7 segment display
int disp_digits[] =
  { 0x3F, 0x06, 0x5B, 0x4F, 0x66, 0x6D, 0x7D, 0x07, 0x7F, 0x6F };


void GPIO_setup ()
{
  SYSCTL_RCGC2_R |= 0x00000023;   /* enable clock to GPIOA, GPIOB and GPIOF at clock gating control register */
  GPIO_PORTF_LOCK_R = 0x4C4F434B; /* unlock commit register GPIOCR */
  GPIO_PORTF_CR_R = 0x01;     /* make PORTF0 configurable */
  // Enable the GPIO pins
  // For PORTF the LED (PF3, 2 1) as output
  // For PORTB, all pins are used to set 7 segment display
  // For PORTA, pins 7 to 4 are used for selecting one of the four 7 segment display
  GPIO_PORTA_DIR_R |= 0xF0;   //Enabled Seven segment display
  GPIO_PORTB_DIR_R |= 0xFF;   //Enabled Seven segment display
  // X X X SW1 G B R SW2 -> bits in PORTF
  GPIO_PORTF_DIR_R |= 0x0E;   //Enable LED port Direction
  // enable the GPIO pins for digital function
  GPIO_PORTA_DEN_R = 0xF0;
  GPIO_PORTB_DEN_R = 0xFF;
  GPIO_PORTF_DEN_R = 0x1F;    //Enable Digital functionality
  GPIO_PORTF_PUR_R = 0x11;    //Enable pull up for SW1 and SW2 only


}




void set_7_seg (int position, int index)
{

      GPIO_PORTA_DATA_R = position;
      if (position == 0x20)   // to display dot in 7 segment
        {
          GPIO_PORTB_DATA_R = disp_digits[index] + 0x00;
        }
      else
        {
          GPIO_PORTB_DATA_R = disp_digits[index];
        }

}

//Display which timer at which 7 segment
void disp_stopwatch_time ()
{if(seqNum == 599)
    seqNum =0;
int seg_out = seqNum;
for(int i=0;i<50;i++);
set_7_seg (0x10, seg_out%10);

  seg_out = seg_out / 10;
  for(int i=0;i<50;i++);
  set_7_seg (0x20, seg_out%10);
  for(int i=0;i<50;i++);
  seg_out = seg_out / 10;
  set_7_seg (0x40, seg_out%10);
//  seg_out = seg_out / 10;
//  set_7_seg (0x80, seg_out);
}
//Enable 7 segment led for given integer value



void change_seq ()
{

  int color;

  switch(state) {

  case 0 :color = 0x00;
  GPIO_PORTF_DATA_R = 0x00;
  seqNum = (unsigned int)(rand() % 599);
  break;
  case 1 :color = 0x02;
  GPIO_PORTF_DATA_R = 0x02;
  seqNum = (unsigned int)(rand() % 599);
    break;
  case 2 :color = 0x4;
  GPIO_PORTF_DATA_R = 0x04;
  seqNum = (unsigned int)(rand() % 599);
    break;
  case 3 :color = 0x08;
  GPIO_PORTF_DATA_R = 0x08;
  seqNum = (unsigned int)(rand() % 599);
    break;
  case 4 :color = 0x0A;
  GPIO_PORTF_DATA_R = 0x0A;
  seqNum = (unsigned int)(rand() % 599);
    break;
  default :color = 0x08;
  GPIO_PORTF_DATA_R = 0x08;
  seqNum = (unsigned int)(rand() % 599);
    break;

    GPIO_PORTF_DATA_R = color;
  }

}


