#include <stdint.h>
#include <stdio.h>
#include <stdbool.h>

#include <./inc/tm4c123gh6pm.h>


// LCD Control Signals
#define RS_PIN  0x40    // PA6
#define EN_PIN  0x80    // PA7
//#define R1 1000;        //  r1 is 1Kohm in vollt divider circuit
//#define Vin 3 ;       //   input voltage is 3.3v from tiva
// Function prototypes
void LCD_Init();
void LCD_Command(uint8_t command);
void LCD_Data(uint8_t data);
void LCD_Clear();
void LCD_SetCursor(uint8_t row, uint8_t column);
void LCD_PrintInteger(int value);
void LCD_WriteString(char *string);

void delay_ms(uint32_t milliseconds);
//
//------------------------------------------------Main------------------------------------
//---------------------------------------------------------------------------------------
//

// Function to initialize LCD
void LCD_Init() {
    SYSCTL_RCGCGPIO_R |= 0x03;   // Enable clock for Port A and Port B

    GPIO_PORTB_DIR_R |= 0xFF;    // Set Port B as output for data bus
    GPIO_PORTB_DEN_R |= 0xFF;    // Enable digital function on Port B

    GPIO_PORTA_DIR_R |= RS_PIN | EN_PIN;   // Set PA6 and PA7 as output for control signals
    GPIO_PORTA_DEN_R |= RS_PIN | EN_PIN;   // Enable digital function on PA6 and PA7

    LCD_Command(0x38);    // 8-bit mode, 2 lines, 5x7 font
    LCD_Command(0x0E);    // Display on, cursor on, blinking off
  //  LCD_Command(0x80);    // cursor on, starting position.
    LCD_Command(0x01);    // Clear display
    delay_ms(1);          // Delay for Clear Display command to complete
}

// Function to send command to LCD
void LCD_Command(uint8_t command) {
    GPIO_PORTA_DATA_R &= ~RS_PIN;      // RS = 0 for command mode
    GPIO_PORTB_DATA_R = command;       // Send command to data bus
    //  LCD_Command(0x80);    // cursor on, 1 ROW starting position.
    //  LCD_Command(0xc0);    // cursor on, 2 ROW starting position.
    GPIO_PORTA_DATA_R |= EN_PIN;       // Enable pulse
    // RW = 0
    delay_ms(2);                       // Delay for EN pulse width
    GPIO_PORTA_DATA_R &= ~EN_PIN;      // Disable pulse

}

// Function to send data to LCD
void LCD_Data(uint8_t data) {
    GPIO_PORTA_DATA_R |= RS_PIN;       // RS = 1 for data mode
    GPIO_PORTB_DATA_R = data;          // Send data to data bus
    GPIO_PORTA_DATA_R |= EN_PIN;       // Enable pulse
    // RW  =0
    delay_ms(2);                       // Delay for EN pulse width
    GPIO_PORTA_DATA_R &= ~EN_PIN;      // Disable pulse
//    delay_ms(2);                       // Delay before next data
}

// Function to clear LCD
void LCD_Clear() {
    LCD_Command(0x01);    // Clear display command
    delay_ms(2);          // Delay for Clear Display command to complete
}

// Function to set cursor position on LCD
void LCD_SetCursor(uint8_t row, uint8_t column) {
    uint8_t position = 0;
    switch(row) {
        case 1:
            position = 0x80 + column - 1; // Set cursor to first row
            break;
        case 2:
            position = 0xC0 + column - 1; // Set cursor to second row
            break;
        default:
            break;
    }
    LCD_Command(position);  // Send command to set cursor position
}


// Function to print an integer value on LCD
//void LCD_PrintInteger(int value) {
//    char buffer[16];  // Buffer to hold the string representation of the integer
//
//    // Convert integer to string
//    sprintf(buffer, "%d", value);
//    delay_ms(2);
//
//    // Print string on LCD
//    LCD_WriteString(buffer);
//}



// Function to write string to LCD
void LCD_WriteString(char *string) {
    while(*string != '\0') {
        LCD_Data(*string);
         string++;
//        delay_ms(2);
    }
}

// Function for software delay in milliseconds
void delay_ms(uint32_t milliseconds) {
    uint32_t count = 0;
    while(count < (milliseconds * 8000)) {  // 1ms delay loop (16MHz CPU Clock)
        count++;
    }
}
