#include <stdint.h>
#include <stdio.h>
#include <stdbool.h>

#include <./inc/tm4c123gh6pm.h>


unsigned char dest_MAC[6] = { 0x35, 0x78, 0x45, 0x58, 0x68, 0x45};
unsigned char IDE1_MAC[6] = { 0x00, 0x1A, 0xC6, 0x1B, 0x7E, 0x6E};
unsigned char IDE2_MAC[6] = { 0x12, 0x34, 0x56, 0x78, 0x9A, 0xBC};
unsigned char IDE3_MAC[6] = { 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0};
unsigned char My_MAC[6] = { 0xA0, 0x1A, 0xC6, 0x1B, 0x7E, 0x6C };
unsigned char EtherType[2] = { 0x88, 0xBA };
unsigned char My_subscribed_GOOSE_App_ID[2] = { 0xCB, 0xA3 };
unsigned char hex_input [1500];
int select_IDE =0;
int state =0;
//int time_stamp = 0x12002A;
int time_stamp = 0x120025;
int seqNum = 123;
int ttl = 20;
int ethertype = 0x88BA;
int appid = 0xCBA3;
char incomplete = 'o';
int colour ;
typedef struct APDU
{
  int GoCBRef;                  //Tag 80
  int TTL;                      // Tag 81
  int goID;                     // Tag 83
  int timestamp;                // Tag 84
  int stNum;                    // Tag 85
  int sqNum;                    // Tag 86
  int data;                     // Tag 87
} APDU;


typedef struct ether_layer
{

  int GoCBRef;                  //Tag 80
  int TTL;                      // Tag 81
  int goID;                     // Tag 83
  int timestamp;                // Tag 84
  int stNum;                    // Tag 85
  int sqNum;                    // Tag 86
  int data;                     // Tag 87
  unsigned char destination_MAC[6];
  unsigned char source_MAC[6];
} ether_layer;



//Function to change char to integer
int
char_to_int (unsigned char c1, unsigned char c0)
{
  return ((c0 << 8) | c1);
}

// Function to get string size from integer given
int
data_to_length (int num)
{
  int size = num == 0 ? 1 : 0;
  int temp = num;
  while (temp != 0)
    {
      size++;
      temp >>= 8;
    }

  size = size + 2;              //1 for tag and 1 for length information

  return size;
}

//Function to convert integer to string with format LENGRH[1],LENGTH[0], DATA
unsigned char *
int_to_data_out (int num)
{
  int size = num == 0 ? 1 : 0;
  int temp = num;
  while (temp != 0)
    {
      size++;
      temp >>= 8;
    }

  int output_size = size + 2;
  // Allocate memory for the character array
  unsigned char *ptr = (unsigned char *) malloc (output_size * sizeof (char));

  // Convert integer to character array
  for (int i = output_size - 1; i > 1; i--)
    {
      ptr[i] = num & 0xFF;
      num >>= 8;
    }

  ptr[1] = size & 0xFF;         //At max data can be 256 bits

  return ptr;
}


//Function for concatanating 2 binary character array
int
bincat (unsigned char *c, unsigned const char *b, int c_end, int b_end)
{
  unsigned int i = c_end;
  // Append each byte of b to c
  while (b_end > 0)
    {
      c[i] = *b++;
      b_end--;
      ++i;
    }
  return (i);                   // Return the length of the concatenated data
}

//Should be called only after atleast size of input is >= 36
//Will return do message for you or not
void
UART_input_check (unsigned char *input, int input_length, APDU * buffer)
{
  int index = 0;
  int TLV_length = 0;
//For checking destination MAC address

  // for(int i =index; i< 7; i++)
  // {
  //     if(input[i]!=My_MAC[i]){
  //         return 0;

  //     }
  // }
//For checking source MAC address
  index = 6;
   char source_MAC[13];

   int o = 0;
       for(int i =6; i< 12; i++,o++)
   {

       char hexString[3];

       sprintf(hexString, "%02X", hex_input[i]);
       source_MAC[o]=hexString[0];// Transmit each character of the string
       o++;
       source_MAC[o]=hexString[1];


   }
  source_MAC[12]='\0';
  LCD_Clear();
  LCD_SetCursor(2, 0);LCD_WriteString(source_MAC);

  index = 12;
for (int i = index; i < 14; i++)
{
  if (input[i] != EtherType[i - 12])
    {
      LCD_Clear();LCD_WriteString("FailEthrTyp");LCD_SetCursor(2, 0);LCD_WriteString(source_MAC);
      return;
    }
  index++;
}

for (int i = index, k = 0; i < index + 2; i++, k++)
{
  if (input[i] != My_subscribed_GOOSE_App_ID[k])
    {LCD_Clear();LCD_WriteString("FailGseApID");LCD_SetCursor(2, 0);LCD_WriteString(source_MAC);
      return;
    }
}
  index = index + 2;
  int length = char_to_int (input[index+1], input[index]);
  index++;
  index++;

if (length != (input_length - index - 3))
{LCD_Clear();LCD_WriteString("FailLength");LCD_SetCursor(2, 0);LCD_WriteString(source_MAC);
  return;
}
index = index + 4;

//  int GoCBRef;                    //Tag 80
if (input[index] != 0x80)
{LCD_Clear();LCD_WriteString("FailGoCBR");LCD_SetCursor(2, 0);LCD_WriteString(source_MAC);
  return;
}
else
{
  index++;

  TLV_length = 0xFF & input[index];

  buffer->GoCBRef = 0;

  index++;
  for (int i = 0; i < TLV_length; i++)
    {

      buffer->GoCBRef = (buffer->GoCBRef << 8) | (0xFF & input[index]);
      index++;
    }

}

//  int TTL;                        // Tag 81
if (input[index] != 0x81){LCD_Clear();LCD_WriteString("FailTTL");LCD_SetCursor(2, 0);LCD_WriteString(source_MAC);
return;}
else
{
  index++;
  TLV_length = 0xFF & input[index];
  buffer->TTL = 0;
  index++;
  for (int i = 0; i < TLV_length; i++)
    {
      buffer->TTL = (buffer->TTL << 8) | (0xFF & input[index]);
      index++;
    }

}
//  int goID;                       // Tag 83
if (input[index] != 0x83){LCD_Clear();LCD_WriteString("FailgoID");LCD_SetCursor(2, 0);LCD_WriteString(source_MAC);
return;}
else
{
  index++;
  TLV_length = 0xFF & input[index];
  buffer->goID = 0;
  index++;
  for (int i = 0; i < TLV_length; i++)
    {
      buffer->goID = (buffer->goID << 8) | (0xFF & input[index]);
      index++;
    }

}
//  int timestamp;              // Tag 84
if (input[index] != 0x84){
    LCD_Clear();LCD_WriteString("FailTimestamp");LCD_SetCursor(2, 0);LCD_WriteString(source_MAC);
    return;}
else
{
  index++;
  TLV_length = 0xFF & input[index];
  buffer->timestamp = 0;
  index++;
  for (int i = 0; i < TLV_length; i++)
    {
      buffer->timestamp = (buffer->timestamp << 8) | (0xFF & input[index]);
      index++;
    }

// Will check after getting timestamp if(buffer->TTL >  )
  if ((buffer->TTL) < (buffer->timestamp - time_stamp))
    {
      //Show LCD unsync with source_MAC
      LCD_Clear();
      LCD_WriteString ("OutOfSync");LCD_SetCursor(2, 0);
      LCD_WriteString(source_MAC);
      //Send message to computer this source is out of sync
      return;
    }

}
//  int stNum;                  // Tag 85
if (input[index] != 0x85){LCD_Clear();LCD_WriteString("FailStateNo");LCD_SetCursor(2, 0);LCD_WriteString(source_MAC);
return;}
else
{
  index++;
  TLV_length = 0xFF & input[index];
  buffer->stNum = 0;
  index++;
  for (int i = 0; i < TLV_length; i++)
    {
      buffer->stNum = (buffer->stNum << 8) | (0xFF & input[index]);
      index++;
    }
}

//  int sqNum;                  // Tag 86
if (input[index] != 0x86){LCD_Clear();LCD_WriteString("FailSeqNo");LCD_SetCursor(2, 0);LCD_WriteString(source_MAC);
return;}
else
{
  index++;
  TLV_length = 0xFF & input[index];
  buffer->sqNum = 0;
  index++;
  for (int i = 0; i < TLV_length; i++)
    {
      buffer->sqNum = (buffer->sqNum << 8) | (0xFF & input[index]);
      index++;
    }
}


//  int data;                     // Tag 87
  if (input[index] != 0x87){LCD_Clear();LCD_WriteString("FailData");LCD_SetCursor(2, 0);LCD_WriteString(source_MAC);
    return;}
  else
    {
      index++;
      TLV_length = 0xFF & input[index];
      buffer->data = 0;
      index++;
      for (int i = 0; i < TLV_length; i++)
        {
          buffer->data = (buffer->data << 8) | (0xFF & input[index]);
          index++;
        }
    }
  LCD_Clear();LCD_WriteString("PassDataRCVD");LCD_SetCursor(2, 0);
  LCD_WriteString(source_MAC);


}


//Function for sending data //Tag Addition is left
unsigned char * UART_output_IDE (int IDE_no, int ether, int GOOSE_AppID, int GoCBRef, int TTL,int time_st,
             int goID, int stateNum, int data, int *total_length)
{


  seqNum++;
  int index = 0;

  unsigned char output_ether[322] = "";

  //For keypad source MAC address change

  index = bincat (output_ether, dest_MAC, 0, sizeof (dest_MAC));
  switch (IDE_no){
  case 0 :
  index = bincat (output_ether, My_MAC, index, sizeof (My_MAC));
  break;
  case 1 :
  index = bincat (output_ether, IDE1_MAC, index, sizeof (My_MAC));
  break;
  case 2 :
  index = bincat (output_ether, IDE2_MAC, index, sizeof (My_MAC));
  break;
  case 3 :
  index = bincat (output_ether, IDE3_MAC, index, sizeof (My_MAC));
  break;
  default :
  index = bincat (output_ether, My_MAC, index, sizeof (My_MAC));
  break;
  }
  unsigned char EtherType_out[2];

  //Addition of ether

  for (int i = 1; i >= 0; i--)
    {
      EtherType_out[i] = ether & 0xFF;
      ether >>= 8;
    }
  index = bincat (output_ether, EtherType_out, index, 2);

  unsigned char GOOSE_AppID_out[2];

  for (int i = 1; i >= 0; i--)
    {
      GOOSE_AppID_out[i] = GOOSE_AppID & 0xFF;
      GOOSE_AppID >>= 8;
    }


  index = bincat (output_ether, GOOSE_AppID_out, index, 2);

  unsigned char GOOSEAPDU[300] = "";
  int index2 = 0;

  int size_GoCBRef_out = data_to_length (GoCBRef);
  unsigned char *GoCBRef_out = (unsigned char *) malloc (size_GoCBRef_out * sizeof (char));
  GoCBRef_out = int_to_data_out (GoCBRef);
  GoCBRef_out[0] = 0x80;        //Tag
  index2 = bincat (GOOSEAPDU, GoCBRef_out, index2, size_GoCBRef_out);
  //TTL


  int size_TTL_out = data_to_length (TTL);
  unsigned char *TTL_out = (unsigned char *) malloc (size_TTL_out * sizeof (char));
  TTL_out = int_to_data_out (TTL);
  TTL_out[0] = 0x81;            //Tag
  index2 = bincat (GOOSEAPDU, TTL_out, index2, size_TTL_out);
  //goID


  int size_goID_out = data_to_length (goID);
  unsigned char *goID_out = (unsigned char *) malloc (size_goID_out * sizeof (char));
  goID_out = int_to_data_out (goID);
  goID_out[0] = 0x83;           //Tag
  index2 = bincat (GOOSEAPDU, goID_out, index2, size_goID_out);
  //Time

  int size_time_out = data_to_length (time_st);
  unsigned char *time_out = (unsigned char *) malloc (size_time_out * sizeof (char));
  time_out = int_to_data_out (time_st);
  time_out[0] = 0x84;           //Tag
  index2 = bincat (GOOSEAPDU, time_out, index2, size_time_out);
  //State number

  int size_State_num = data_to_length (stateNum);
  unsigned char *stateNum_out = (unsigned char *) malloc (size_State_num * sizeof (char));
  stateNum_out = int_to_data_out (stateNum);
  stateNum_out[0] = 0x85;       //Tag
  index2 = bincat (GOOSEAPDU, stateNum_out, index2, size_State_num);
//Sequence no

  int size_seqNum_out = data_to_length (seqNum);
  unsigned char *seqNum_out = (unsigned char *) malloc (size_seqNum_out * sizeof (char));
  seqNum_out = int_to_data_out (seqNum);
  seqNum_out[0] = 0x86;         //Tag
  index2 = bincat (GOOSEAPDU, seqNum_out, index2, size_seqNum_out);

//Data
  int size_Data_out = data_to_length (data);
  unsigned char *Data_out = (unsigned char *) malloc (size_Data_out * sizeof (char));
  Data_out = int_to_data_out (data);
  Data_out[0] = 0x87;           //Tag
  index2 = bincat (GOOSEAPDU, Data_out, index2, size_Data_out);
  //GOOSEAPDU Length is now known

  int len = index2 + 1;         // 1 added because index2 started from 0
  unsigned char length_out[2];

  for (int i = 1; i >= 0; i--)
    {
      length_out[i] = len & 0xFF;
      len >>= 8;
    }


  index = bincat (output_ether, length_out, index, 2);



  unsigned char Reserved1[2] = { 0x00, 0x00 };   //Reserved for future use

  index = bincat (output_ether, Reserved1, index, 2);

  unsigned char Reserved2[2] = { 0x00, 0x00 };

  index = bincat (output_ether, Reserved2, index, 2);

  index = bincat (output_ether, GOOSEAPDU, index, index2);

  *total_length = index;
  unsigned char *out = output_ether;
  return (out);
}

int UART_read()
{
    int count = 0;
    // Read characters until ENTER is received
if ( UARTCharsAvail(UART0_BASE)) {

    char check0 = UARTCharGet(UART0_BASE);
    char val0;
    char val1;
    while(check0 != '\r'){
 //       UARTCharPut(UART0_BASE,check0);
        if(count %2 ==0)
        {
            val0 = check0;
        }
        else if(count %2 ==1)
        {
            val1 = check0;
            unsigned char hex0,hex1;
            if(val0 >= '0' && '9' >= val0 )
            {
                hex0 = val0 -'0';
            }
            else if(val0 >= 'A' && 'F' >= val0 )
            {
                hex0 = val0 - 'A' + 10;
            }
            if(val1 >= '0' && '9' >= val1 )
            {
                hex1 = val1 -'0' ;

                //input to buffer
                hex_input[count/2] = (hex0<<4) | hex1 ;
            }
            else if(val1 >= 'A' && 'F' >= val1 )
            {
                hex1 = val1 -'A' + 10;
                //input to buffer
                hex_input[count/2] = (hex0<<4) | hex1 ;
            }
        }
        check0 = UARTCharGet(UART0_BASE);
        count++;

    }

    count = count /2;

}
return (count);

}

int change_IDE ()
  {

    int k = readkey ();

    if (k != 0)
      {

        switch(k) {
            case 1:
                state = 0;
                select_IDE = 0;
                incomplete = 'o';
                appid = 0xCBA3;
                ethertype = 0x88BA;
                time_stamp = 0x120025;
                return 0;
                break;
            case 2:
                state = 0;
                select_IDE = 1;
                incomplete = 'o';
                appid = 0xCBA3;
                ethertype = 0x88BA;
                time_stamp = 0x120025;
                return 0;
                break;
            case 3:
                state = 0;
                select_IDE = 2;
                incomplete = 'o';
                appid = 0xCBA3;
                ethertype = 0x88BA;
                time_stamp = 0x120025;
                return 0;
                break;
            case 4:
                state = 0;
                select_IDE = 3;
                incomplete = 'o';
                appid = 0xCBA3;
                ethertype = 0x88BA;
                time_stamp = 0x120025;
                return 0;
                break;
            case 5:
                state = 0;
                incomplete = 'Y';
                appid = 0xCBA3;
                ethertype = 0x88BA;
                time_stamp = 0x120025;
                return 0;
                break;
            case 6:
                state = 0;
                time_stamp = 0x1F00FF;
                incomplete = 'o';
                appid = 0xCBA3;
                ethertype = 0x88BA;
                return 0;
                break;
            case 7:
                state = 0;
                ethertype = 0xAAAA;
                time_stamp = 0x120025;
                incomplete = 'o';
                appid = 0xCBA3;
                return 0;
                break;
            case 8:
                state = 0;
                appid = 0xBBBB;
                ethertype = 0x88BA;
                time_stamp = 0x120025;
                incomplete = 'o';
                return 0;
                break;
            case 9:
                state = 1;
                appid = 0xCBA3;
                ethertype = 0x88BA;
                time_stamp = 0x120025;
                incomplete = 'o';
                return 1;
                break;
            case 10:
                state = 2;
                appid = 0xCBA3;
                ethertype = 0x88BA;
                time_stamp = 0x120025;
                incomplete = 'o';
                return 1;
                break;
            case 11:
                state = 3;
                appid = 0xCBA3;
                ethertype = 0x88BA;
                time_stamp = 0x120025;
                incomplete = 'o';
                return 1;
                break;
            case 12:
                state = 4;
                appid = 0xCBA3;
                ethertype = 0x88BA;
                time_stamp = 0x120025;
                incomplete = 'o';
                return 1;
                break;
            default : ethertype = 0x88BA;return 0;break;


        }

      }
return 0;

  }

