/*

* ADC.c

*ADC_Init_Volt()ADC_Init_Curr()ADC_Init_Load()

*  Created on: 01-May-2024

*      Author: rahul

*/

#include <stdint.h>

#include <stdio.h>

#include <stdbool.h>


#include <./inc/tm4c123gh6pm.h>

void ADC_Init();

uint16_t ADC_Read();

// Function to initialize ADC

void ADC_Init() {

        SYSCTL_RCGCADC_R |= 0x01;    // Enable clock for ADC0

        SYSCTL_RCGCGPIO_R |= 0x10;   // Enable clock for Port E

        SYSCTL_RCGCGPIO_R |= 0x08;   // Enable clock for Port D

        GPIO_PORTE_AFSEL_R |= 0x20;  // Enable alternate function on PE5

        GPIO_PORTE_DEN_R &= ~0x20;   // Disable digital function on PE5

        GPIO_PORTE_AMSEL_R |= 0x20;  // Enable analog function on PE5


        GPIO_PORTE_AFSEL_R |= 0x10;  // Enable alternate function on PE4

        GPIO_PORTE_DEN_R &= ~0x10;   // Disable digital function on PE4

        GPIO_PORTE_AMSEL_R |= 0x10;  // Enable analog function on PE4

        GPIO_PORTD_AFSEL_R |= 0x08;  // Enable alternate function on PD3

        GPIO_PORTD_DEN_R &= ~0x08;   // Disable digital function on PD3

        GPIO_PORTD_AMSEL_R |= 0x08;  // Enable analog function on PD3

        ADC0_ACTSS_R &= ~0x0008;     // Disable sample sequencer 3

        ADC0_EMUX_R &= ~0xF000;      // Software trigger conversion

    //    ADC0_SSMUX3_R = 8;           // Set the analog input channel to AIN8

        ADC0_SSCTL3_R |= 0x06;       // Take one sample at a time, set flag at 1st sample

        ADC0_ACTSS_R |= 0x0008;      // Enable sample sequencer 3

}


// Function to read analog input from ADC

uint16_t ADC_Read() {

    ADC0_PSSI_R |= 0x0008;       // Initiate SS3 conversion

    while((ADC0_RIS_R & 0x08) == 0);  // Wait for conversion to complete

    uint16_t result = ADC0_SSFIFO3_R & 0xFFF; // Read 12-bit ADC result

    ADC0_ISC_R = 0x0008;         // Clear SS3 Interrupt flag

    return result;

}
