#include <stdint.h>
#include "inc/tm4c123gh6pm.h"

//GLOBAL VARIABLES
unsigned int servo_angle = 4400;   //SHOLD BE BETWEEN 4400 AND 4895

void servo_init(){
    SYSCTL_RCGCPWM_R |= 2;
    GPIO_PORTB_AFSEL_R |= (1<<6);  //GPIO INITIALISATION FOR PWM0_0
    GPIO_PORTB_PCTL_R &= ~0x0F000000; /* make PB6 PWM output pin */
    GPIO_PORTB_PCTL_R |= 0x04000000;
    GPIO_PORTB_DEN_R |= 0xFF; //CONNECT TOP PB6 SERVO

    PWM0_0_CTL_R &= ~(1<<0); /* stop counter */
    PWM0_0_CTL_R &= ~(1<<1);
    PWM0_0_GENA_R = 0x0000008C; /* M1PWM6 output set when reload, r*/
    /* clear when match PWMCMPA */
    PWM0_0_LOAD_R = 5000; /* set load value for 1kHz (16MHz/16000) */
    PWM0_0_CMPA_R = 4895; /* set duty cycle to min */
    PWM0_0_CTL_R = 1; /* start timer */
    PWM0_ENABLE_R = 0x01; /* start PWM0 ch1 */

    // //////////////////////////////////////////////////////////////////////////////////////////////

    // NEED TO BE UNCOMMENTED AND CHECK IF IT IS WORKING
//    SYSCTL_RCGCPWM_R |= 2;
//    GPIO_PORTB_AFSEL_R |= (1<<4);  //GPIO INITIALISATION FOR PWM0_0
//    GPIO_PORTB_PCTL_R &= ~0x000F0000; /* make PB4 PWM output pin */
//    GPIO_PORTB_PCTL_R |= 0x00040000;
//    GPIO_PORTB_DEN_R |= 0xFF; //CONNECT TOP PB4 SERVO
//
//    PWM0_1_CTL_R &= ~(1<<0); /* stop counter */
//    PWM0_1_CTL_R &= ~(1<<1);
//    PWM0_1_GENA_R = 0x0000008C; /* M1PWM6 output set when reload, r*/
//    /* clear when match PWMCMPA */
//    PWM0_1_LOAD_R = 5000; /* set load value for 1kHz (16MHz/16000) */
//    PWM0_1_CMPA_R = 4895; /* set duty cycle to min */
//    PWM0_1_CTL_R = 1; /* start timer */
//    PWM0_ENABLE_R = 0x02; /* start PWM0 ch1 */

}

void servo_angle_change(){
    PWM0_0_CMPA_R = servo_angle;
}
