/*
 * initialise.h
 *
 *  Created on: 01-Mar-2023
 *      Author: ravigt
 */

#ifndef INITIALISE_H_
#define INITIALISE_H_

#define BAUD_RATE   115200

#define FREQ_CPU    16000000      //16MHz
#define PWM_FREQ    50           // PWM output frequency in Hz
#define PWM_PERIOD  ((FREQ_CPU)/(PWM_FREQ)/8)   //prescaler 8

#define PWM_MIN     6900
#define PWM_MAX     39000

//#define PWM_MIN     6700
//#define PWM_MAX     39600
#define PWM_PERCENT(i) ((PWM_MIN)+((PWM_MAX)-(PWM_MIN)) * i)

#define ADC_CHANNEL 0
#define ADC_PIN     GPIO_PIN_3

/*define useful symbolic names for LCD commands */
#define CLEAR_DISPLAY     0x01
#define RETURNHOME        0x02
#define MOVECURSORRIGHT   0x06
#define MOVECURSORLIFT    0x08
#define SHIFTDISPLAYRIGHT 0x1C
#define SHIFTDISPLAYLEFT  0x18
#define CURSORBLINK       0x0F
#define CURSOROFF         0x0C
#define CURSORON          0x0E
#define FUNCTION_SET_4BIT 0x28
#define FUNCTION_SET_8BIT 0x38
#define ENTRY_MODE        0x06
#define FUNCTION_8_BIT    0x32
#define SET5X7FONTSIZE    0x20
#define FIRSTROW          0x80
#define SECONDROW         0xC0

#define RS                0x40
#define EN                0x80

//#define TIMER_BASE      TIMER3_BASE
//#define TIMER_CHANNEL   TIMER_A
//#define TIMER_TIMEOUT   (16000000 / 10) // timer timeout value, in this example 100ms

extern void PWM_init(void);
extern void uart_init(void);
extern void ADC_init(void);
extern uint32_t ADC_Read(void);
extern void LCD_init(void);
extern void LCD_Cmd(unsigned char command);
extern void LCD_Write_Char(unsigned char data);
extern void LCD_String(char addr, char *str);
extern void LCD_update(unsigned short decodeValue);
extern void delay_ms(int n);
extern void delay_us(int n);
extern void Captureinit(void);
extern void GPIOD_Handler(void);

#endif /* INITIALISE_H_ */
