#include <stdint.h>
#include <./inc/tm4c123gh6pm.h>

extern void delayUs(int n);

void HC_SR04_setup(void)
{
    SYSCTL_RCGCGPIO_R |= 0x08;      // Enable clock to GPIO PORTD
    GPIO_PORTD_DIR_R |= 0x04;       // Set PD2 as output (trigger) and PD3 as input (echo)
//    GPIO_PORTD_DIR_R &= ~(0x08);
    GPIO_PORTD_DEN_R |= 0x0C;       // Enable bit 2 and 3 of PORTD
    GPIO_PORTD_AFSEL_R = 0x08;      // Set alternate function WTIMER3CCP1
    GPIO_PORTD_PCTL_R &= ~0x0000F000;
    GPIO_PORTD_PCTL_R |= 0x00007000;// PORTD bit 3 selected for alternate function
    // Set up timer WT3CCP1
    SYSCTL_RCGCWTIMER_R |= 8;       // Enable clock to to timer 3
    WTIMER3_CTL_R &= ~0x0100;       // Disable timer during setup
    WTIMER3_CFG_R = 0x00000004;     // 32 bit mode
    WTIMER3_TBILR_R = (608000);     // Timer LOAD REG value = 38 ms
    // Configure TIMER_B
    // bits 1:0 = [11] Capture Mode
    // bit 2    = 1    Capture Mode - Edge Time
    // bit 3    = 0    Capture Mode enabled
    // bit 4    = 0    Count down
    WTIMER3_TBMR_R = 0x07;          // Configure TIMER_B
    WTIMER3_CTL_R |= 0x0C00;        // Detect both edges
    WTIMER3_CTL_R |= 0x0100;        // Enable Timer
    WTIMER3_ICR_R = 0x0400;         // Clear event interrupt flags
    WTIMER3_IMR_R |= 0x0400;        // Unmask interrupt for capture event mode

    NVIC_EN3_R |= 0x00000020;       // NVIC enabled (IRQ number = 102)
    //NVIC_PRI25_R |= 0x00600000;     // Set priority = 3
}

void timer_disengage(){
    WTIMER3_CTL_R &= ~0x0100;
}
void timer_engage(){
    WTIMER3_CTL_R &= ~0x0100;       // Disable timer during setup
    WTIMER3_TBILR_R = (608000);     // Timer LOAD REG value = 38 ms
    WTIMER3_TBMR_R = 0x07;          // Configure TIMER_B
    WTIMER3_CTL_R |= 0x0C00;        // Detect both edges
    WTIMER3_CTL_R |= 0x0100;        // Enable Timer
    WTIMER3_ICR_R = 0x0400;         // Clear event interrupt flags
    WTIMER3_IMR_R |= 0x0400;        // Unmask interrupt for capture event mode
}

void ultra_sonic_trig(){
    GPIO_PORTF_DATA_R |= (1<<4);
    delayUs(10);
    GPIO_PORTF_DATA_R &= ~(1<<4);
}

void PORTF_HANDLER(){
    TIMER0_CTL_R |= (1<<0);

}
