#include <stdint.h>

//External variables
extern int lane_reading;

//Variables
int set_point = 0;
int error = -3;
float derivative_err = 0;
float proportional_err = 0;
float integral_err = 0;
float prev_err = 0;
float Kp = 1;
float Ki = 0;
float Kd = 0;
float res = 0;


void error_calc(){
    error = set_point - lane_reading;
}

void controller(){
    derivative_err = prev_err - error; //proportional error implementation dx = x(t) - x(t-to)
    integral_err = integral_err + error;  //integral error sum(error)
    proportional_err = error;   //error
    prev_err = error;

    res = (Kp * proportional_err) + (Ki * integral_err) + (Kd * derivative_err);
}
