#include <stdint.h>
#include <stdlib.h>
#include <math.h>
#include <./inc/tm4c123gh6pm.h>

extern void delay(int n);
extern void delayUs(int n);

int x = 4999;

void adc_pwm_init(){
    SYSCTL_RCGCPWM_R |= 3; /* enable clock to PWM1 */
    SYSCTL_RCGCGPIO_R |= 0x2A; /* enable clock to PORTF */
    SYSCTL_RCC_R &= ~0x00100000; /* no pre-divide for PWM clock */
    SYSCTL_RCC_R |= 0x001E0000; //divide by 64 for PWM
    /* Enable port PF2 for PWM1 M1PWM7 */
    GPIO_PORTF_AFSEL_R |= (1<<2); /* PF2 uses alternate function */
    GPIO_PORTF_PCTL_R &= ~0x00000F00; /* make PF2 PWM output pin */
    GPIO_PORTF_PCTL_R |= 0x00000500;
    GPIO_PORTF_DEN_R |= (1<<2); /* pin digital */

    GPIO_PORTB_AFSEL_R |= (1<<6);
    GPIO_PORTB_PCTL_R &= ~0x0F000000; /* make PB6 PWM output pin */
    GPIO_PORTB_PCTL_R |= 0x04000000;
    GPIO_PORTB_DEN_R |= 0xFF;

    PWM1_3_CTL_R &= ~(1<<0); /* stop counter */
    PWM1_3_CTL_R &= ~(1<<1);
    PWM1_3_GENA_R = 0x0000008C; /* M1PWM6 output set when reload, r*/
    /* clear when match PWMCMPA */
    PWM1_3_LOAD_R = 5000; /* set load value for 1kHz (16MHz/16000) */
    PWM1_3_CMPA_R = 4999; /* set duty cycle to min */
    PWM1_3_CTL_R = 1; /* start timer */
    PWM1_ENABLE_R = 0x40; /* start PWM1 ch6 */

    PWM0_0_CTL_R &= ~(1<<0); /* stop counter */
    PWM0_0_CTL_R &= ~(1<<1);
    PWM0_0_GENA_R = 0x0000008C; /* M1PWM6 output set when reload, r*/
    /* clear when match PWMCMPA */
    PWM0_0_LOAD_R = 5000; /* set load value for 1kHz (16MHz/16000) */
    PWM0_0_CMPA_R = 4950; /* set duty cycle to min */
    PWM0_0_CTL_R = 1; /* start timer */
    PWM0_ENABLE_R = 0x01; /* start PWM0 ch1 */


    SYSCTL_RCGCGPIO_R |= 0x01;
    GPIO_PORTA_DIR_R |= (1<<3)|(1<<2)|(1<<5)|(1<<6);
    GPIO_PORTA_DEN_R |= (1<<3)|(1<<2)|(1<<5)|(1<<6);
    GPIO_PORTA_DATA_R |= (1<<3)|(1<<5);
    GPIO_PORTA_DATA_R &= ~(1<<2);
    GPIO_PORTA_DATA_R &= ~(1<<6);
    //GPIO_PORTA_DATA_R &= ~(1<<3);
    //GPIO_PORTA_DATA_R |= (1<<2);

    SYSCTL_RCGCADC_R |= 0x00000001; /* enable clock to ADC0 */
    SYSCTL_RCGCGPIO_R |= 0x10; /* enable clock to PE (AIN0 is on PE3) */

}

void drive_reverse(void)
{
GPIO_PORTA_DATA_R |= (1<<3)|(1<<5);
GPIO_PORTA_DATA_R &= ~(1<<2);
GPIO_PORTA_DATA_R &= ~(1<<6);

x = 3500;       //NEED TO BE ERASED LATER
PWM1_3_CMPA_R=x;
//PWM0_0_CMPA_R=x;
delay(10);
return;

}

void drive_left(void)
{
x = 3500;       //NEED TO BE ERASED LATER

GPIO_PORTA_DATA_R |= (1<<2)|(1<<5);
GPIO_PORTA_DATA_R &= ~(1<<3);
GPIO_PORTA_DATA_R &= ~(1<<6);
PWM1_3_CMPA_R=x;
//PWM0_0_CMPA_R=x;
delay(10);
return;

}

void drive_right(void)
{

x = 3500;       //NEED TO BE ERASED LATER

GPIO_PORTA_DATA_R |= (1<<3)|(1<<6);
GPIO_PORTA_DATA_R &= ~(1<<2);
GPIO_PORTA_DATA_R &= ~(1<<5);
PWM1_3_CMPA_R=x;
//PWM0_0_CMPA_R=x;
delay(10);
return;

}

void drive_straight(void)
{
x = 3500;       //NEED TO BE ERASED LATER

GPIO_PORTA_DATA_R |= (1<<2)|(1<<6);
GPIO_PORTA_DATA_R &= ~(1<<3);
GPIO_PORTA_DATA_R &= ~(1<<5);
PWM1_3_CMPA_R=x;
//PWM0_0_CMPA_R=x;
delay(10);
return;

}

void drive_right_shift(){
    x = 2800;       //NEED TO BE ERASED LATER

    GPIO_PORTA_DATA_R |= (1<<3)|(1<<6);
    GPIO_PORTA_DATA_R &= ~(1<<2);
    GPIO_PORTA_DATA_R &= ~(1<<5);
    PWM1_3_CMPA_R=x;
    delay(3000);
    GPIO_PORTA_DATA_R |= (1<<2)|(1<<6);
    GPIO_PORTA_DATA_R &= ~(1<<3);
    GPIO_PORTA_DATA_R &= ~(1<<5);
    PWM1_3_CMPA_R=x;
    delay(500);
    GPIO_PORTA_DATA_R |= (1<<2)|(1<<5);
    GPIO_PORTA_DATA_R &= ~(1<<3);
    GPIO_PORTA_DATA_R &= ~(1<<6);
    PWM1_3_CMPA_R=x;
    delay(3000);
    GPIO_PORTA_DATA_R |= (1<<2)|(1<<6);
    GPIO_PORTA_DATA_R &= ~(1<<3);
    GPIO_PORTA_DATA_R &= ~(1<<5);
    PWM1_3_CMPA_R=x;
    return;
}

void drive_left_shift(){
    x = 2800;       //NEED TO BE ERASED LATER

    GPIO_PORTA_DATA_R |= (1<<2)|(1<<5);
    GPIO_PORTA_DATA_R &= ~(1<<3);
    GPIO_PORTA_DATA_R &= ~(1<<6);
    PWM1_3_CMPA_R=x;
    delay(3000);
    GPIO_PORTA_DATA_R |= (1<<2)|(1<<6);
    GPIO_PORTA_DATA_R &= ~(1<<3);
    GPIO_PORTA_DATA_R &= ~(1<<5);
    PWM1_3_CMPA_R=x;
    delay(500);
    GPIO_PORTA_DATA_R |= (1<<3)|(1<<6);
    GPIO_PORTA_DATA_R &= ~(1<<2);
    GPIO_PORTA_DATA_R &= ~(1<<5);
    PWM1_3_CMPA_R=x;
    delay(3000);
    GPIO_PORTA_DATA_R |= (1<<2)|(1<<6);
    GPIO_PORTA_DATA_R &= ~(1<<3);
    GPIO_PORTA_DATA_R &= ~(1<<5);
    PWM1_3_CMPA_R=x;
    return;
}

void drive_stop(){
    PWM1_3_CMPA_R=4999;
}

