#include <stdint.h>
#include "inc/tm4c123gh6pm.h"

void light_init(){
    SYSCTL_RCGCGPIO_R |= 0x2A; //GPIO CLOCK TO PB AND PD
    GPIO_PORTB_DEN_R |= (1<<0);
    GPIO_PORTB_DIR_R |= (1<<0); //GPIO PB0
    GPIO_PORTD_DEN_R |= (1<<0)|(1<<1);
    GPIO_PORTD_DIR_R |= (1<<0)|(1<<1)|(1<<7); //GPIO PD0 AND PD1 AND PD7
    /*
     * PB0 = HEADLIGHT
     * PD0 = LEFT INDICATOR
     * PD1 = RIGHT INDICATOR
     * PF1 = STOP LIGHT
     */
}

void stop_light(){
    GPIO_PORTD_DATA_R ^= (1<<7);
}

void head_light(){
    GPIO_PORTB_DATA_R ^= (1<<0);
}

void left_indicator(){
    GPIO_PORTD_DATA_R ^= (1<<0);
}

void right_indicator(){
    GPIO_PORTD_DATA_R ^= (1<<1);
}
