#include <stdint.h>
#include "inc/tm4c123gh6pm.h"

//Extern functions
extern void watchdog_timer();

unsigned int right_obstacle = 0;
unsigned int left_obstacle = 0;
//int debug_ckeck;
int lane_reading = 0;


void ir_sensor_init(){
    SYSCTL_RCGCGPIO_R |= (1<<5)|(1<<0);
    GPIO_PORTF_LOCK_R = 0x4C4F434B;
    GPIO_PORTA_LOCK_R = 0x4C4F434B;
    GPIO_PORTF_CR_R |= (1<<0)|(1<<1)|(1<<3)|(1<<4);     //
    GPIO_PORTF_DIR_R &= (0<<0)&(0<<1)&(0<<4)&(0<<4);    //
    GPIO_PORTF_DEN_R |= (1<<0)|(1<<1)|(1<<3)|(1<<4);    //
    GPIO_PORTF_ODR_R |= (1<<0)|(1<<1)|(1<<3)|(1<<4);    //PORTF IRs

    GPIO_PORTA_CR_R |= (1<<4);  //
    GPIO_PORTA_DIR_R &= ~(0x10); //
    GPIO_PORTA_DEN_R |= (1<<4); //
    GPIO_PORTA_ODR_R |= (1<<4); //PORTA IRs

    /*
     * LANE_READING VALUES
     * ASSUMED BLACK STREET AND WHITE LINES
     *
     PORTF0 = -2
     PORTF1 = -1
     PORTF3 = 0
     PORTF4 = 1
     PORTA4 = 2
     */

}


void lane_check(){
    if((GPIO_PORTF_DATA_R & (1<<0)) == (0<<0)){
        lane_reading = -2;
    }
    else if((GPIO_PORTF_DATA_R & (1<<1)) == (0<<1)){
        lane_reading = -1;
    }
    else if((GPIO_PORTF_DATA_R & (1<<3)) == (0<<3)){
        lane_reading = 0;
    }
    else if((GPIO_PORTF_DATA_R & (1<<4)) == (0<<4)){
        lane_reading = 1;
    }
    else if((GPIO_PORTA_DATA_R & (1<<4)) == (0<<4)){
        lane_reading = 2;
    }
    else {
        watchdog_timer();
    }
}



void ir_right_check(){
    if((GPIO_PORTF_DATA_R & (1<<0)) == (0<<0)){
        right_obstacle = 1;
    }
    else{
        right_obstacle = 0;
    }
}

void ir_left_check(){

    //debug_ckeck = GPIO_PORTF_DATA_R & 0x10;
    if((GPIO_PORTF_DATA_R & 0x10) == 0){
        left_obstacle = 1;
    }
    else{
        left_obstacle = 0;
    }
}


