#include <stdint.h>
#include "inc/tm4c123gh6pm.h"

//MACROS
#define airbag_deploy 1000
#define servo_left 4400
#define servo_right 4895
#define servo_front 4650


//EXTERN FUNCTIONS
extern void drive_straight(void);
extern void drive_left(void);
extern void drive_right(void);
extern void drive_reverse(void);
extern void drive_stop(void);
extern void adc_pwm_init(void);
extern void HC_SR04_setup(void);
extern void ir_sensor_init(void);
extern void ir_right_check(void);
extern void ir_left_check(void);
extern void servo_init(void);
extern void servo_angle_change(void);
extern void adc_init(void);
extern void pressure_read(void);
extern void airbag_on(void);
extern void airbag_off(void);
extern void airbag_init(void);
extern void drive_left_shift(void);
extern void drive_right_shift(void);
extern void ResetISR(void);
extern void light_init();
extern void stop_light();
extern void head_light();
extern void left_indicator();
extern void right_indicator();
extern void line_follow();
extern void timer_engage();
extern void timer_disengage();
extern void AC_init();
extern void AC_switch();
extern void oled_init(void);
extern void oled_write();

//EXTERNAL VARIABLES
extern unsigned int right_obstacle;
extern unsigned int left_obstacle;
extern unsigned int servo_angle;
extern unsigned int pressure_val;
extern int reset_flag;
extern float res;

//FUNCTIONS
unsigned int calculate_distance(void);
void send_trigger_pulse(void);

//GLOBAL VARIABLES
unsigned int proximity_distance = 0;
unsigned int left_distance = 100;
unsigned int right_distance = 100;
unsigned int time_value1 = 0;
unsigned int time_value2 = 1;


void delay(int n)           //Empty delay function
{
int i, j;
for(i = 0 ; i < n; i++)

    for(j = 0; j < 1590; j++) {
}    /* do nothing for 1 ms */
}

void delayUs(int n)           //Empty delay function
{
int i, j;
for(i = 0 ; i < n; i++)
for(j = 0; j < 3; j++) {
}    /* do nothing for 1 us */
}

int main(void)
{
    adc_pwm_init();
    HC_SR04_setup();
    ir_sensor_init();
    servo_init();
    adc_init();
    airbag_init();
    light_init();
//    oled_init();
    while(1){
        pressure_read();
//        oled_write();
        servo_angle = servo_front;
        servo_angle_change();
        delay(50);
        send_trigger_pulse();
        proximity_distance = calculate_distance();
        if(pressure_val < airbag_deploy){
            airbag_on();
            drive_stop();
            delay(1000);
        }
        else if(proximity_distance < 20){
            stop_light();
            drive_stop();
            servo_angle = servo_left;
            servo_angle_change();
            delay(500);
            send_trigger_pulse();
            delay(10);
            left_distance = calculate_distance();
            delay(100);
            servo_angle = servo_right;
            servo_angle_change();
            delay(500);
            send_trigger_pulse();
            delay(10);
            right_distance = calculate_distance();
            delay(500);
            servo_angle = servo_front;
            servo_angle_change();
            if((left_distance < 20) && (right_distance < 20)){
                drive_stop();
                delay(1000);
            }
            else if(left_distance > right_distance) {
                left_indicator();
                drive_left_shift();
//                delay(500);
//                drive_right_shift();
//                delay(50);
                left_indicator();
            }
            else if(right_distance > left_distance){
                right_indicator();
                drive_right_shift();
//                delay(500);
//                drive_left_shift();
//                delay(50);
                right_indicator();
            }

            stop_light();

        }
        else if(proximity_distance > 10){
            airbag_off();
            drive_straight();
            delay(10);
        }
//        line_follow();
        servo_angle_change();
        send_trigger_pulse();
//        if(reset_flag == 1){
//            reset_flag = 0;
//            ResetISR();
//        }
    }

	return 0;
}

unsigned int calculate_distance(void)
{
    unsigned int distance;
    int time;
    if(time_value1 < time_value2)
    {
        time = time_value1 + (608000) - time_value2;
    }
    else
    {
        time = time_value1 - time_value2;
    }
    time = (time)/(16*2);
    distance = (34000*time)/1000000;
    return distance;
}



void send_trigger_pulse(void)
{
    GPIO_PORTD_DATA_R = 0x00;
    delayUs(10);
    GPIO_PORTD_DATA_R = 0x04;
    delayUs(10);
    GPIO_PORTD_DATA_R = 0x00;
}

void WTIMER3B_Handler(void)
{
    if((WTIMER3_MIS_R & 0x0400) && (GPIO_PORTD_DATA_R & 0x08))
    {
        time_value1 = WTIMER3_TBR_R;
    }
    if((WTIMER3_MIS_R & 0x0400) && !(GPIO_PORTD_DATA_R & 0x08))
    {
        time_value2 = (WTIMER3_TBR_R);
    }
    WTIMER3_ICR_R = 0x0400;

}

