#include <stdint.h>
#include <stdlib.h>
#include <math.h>
#include <./inc/tm4c123gh6pm.h>

extern void delayUs();
int airbag_status = 0;

unsigned int pressure_val = 0;

void adc_init(){
    SYSCTL_RCGCADC_R |= 0x00000001; /* enable clock to ADC0 */
    SYSCTL_RCGCGPIO_R |= 0x10; /* enable clock to PE (AIN0 is on PE3) */

    ADC0_ACTSS_R |= 0x00000008; /* enable ADC0 sequencer 3 */
    ADC0_EMUX_R &= ~0xF000; /* software trigger conversion */
    ADC0_SSMUX3_R = 0; /* get input from channel 0 */
    /* initialize PE3 for AIN0 input */
    GPIO_PORTE_AFSEL_R |= 8; /* enable alternate function */
    GPIO_PORTE_DEN_R &= ~8; /* disable digital function */
    GPIO_PORTE_AMSEL_R |= 8; /* enable analog function */
    ADC0_SSCTL3_R |= 6; /* take one sample at a time, set flag at 1st sample */
    ADC0_ACTSS_R |= 8; /* enable ADC0 sequencer 3 */
}

void airbag_init(){
    SYSCTL_RCGCGPIO_R |= (1<<1);
    GPIO_PORTB_DIR_R |= (1<<1);
    GPIO_PORTB_DEN_R |= (1<<1);
}

void pressure_read(){
    float temp;
    int temp2;

    volatile int result;

    ADC0_PSSI_R |= 8; /* start a conversion sequence 3 */
    while((ADC0_RIS_R & 8) != 0){ /* wait for conversion complete */
        result = ADC0_SSFIFO3_R; /* read conversion result */
        ADC0_ISC_R = 8; /* clear completion flag */
    }
    temp=(((result)/4095.0)*4999.0);
    temp2=(int)temp;
    pressure_val=4999-temp2;
}

void airbag_on(){
    airbag_status = GPIO_PORTB_DATA_R & (0x02);
    GPIO_PORTB_DATA_R |= (1<<1);
    delayUs(100);
}

void airbag_off(){
    airbag_status = GPIO_PORTB_DATA_R & (0x02);
    GPIO_PORTB_DATA_R &= (0<<1);
    delayUs(100);
}
