#include <stdint.h>
#include "inc/tm4c123gh6pm.h"
#include <stdio.h>
#include <stdlib.h>
#include <systick.h>


//      initializing systick timer
void init_systick_timer(uint32_t tick_hz){
    uint32_t *pSRVR = (uint32_t *) 0xE000E014;
    uint32_t *pSCSR = (uint32_t *) 0xE000E010;
    uint32_t count_value = CLOCK_MHZ/TICK_HZ;

    //clear the value of SVR
    *pSRVR &= ~(0x00FFFFFFFF);

    //load the value into SVR
    *pSRVR |= count_value;

    //setting the systick
    *pSCSR |= (1<<1); //enables systick exception request
    *pSCSR |= (1<<2); //enables the clock source

    //enabling the systick
    *pSCSR |= (1<<0); //enables the counter
}



//      systick handler
void systick_handler(){
    uint32_t *pICSR = (uint32_t *) 0xE000ED04;

    update_global_tick_count();
    unblock_tasks();

    *pICSR |= (1<<28);

}
