//      stack definitions for tasks
#define STACK_TASK_SIZE      1024U
#define SCHED_STACK_SIZE     1024U
#define SRAM_START_ADDRESS   0x20000000U
#define SRAM_SIZE            ((32) * (1024))
#define SRAM_END_ADDRESS     ((SRAM_START_ADDRESS) + (SRAM_SIZE))
#define IDLE_STACK_START     SRAM_END_ADDRESS
#define TASK1_STACK_START    ((SRAM_END_ADDRESS) - (STACK_TASK_SIZE))
#define TASK2_STACK_START    ((SRAM_END_ADDRESS) - (2*STACK_TASK_SIZE))
#define TASK3_STACK_START    ((SRAM_END_ADDRESS) - (3*STACK_TASK_SIZE))
#define TASK4_STACK_START    ((SRAM_END_ADDRESS) - (4*STACK_TASK_SIZE))
#define SCHED_STACK_START    ((SRAM_END_ADDRESS) - (5*STACK_TASK_SIZE))
#define MAX_TASKS            5
#define DUMMY_XPSR           0x01000000
#define MAX_PRIORITY         1
#define TASK_READY_STATE 0X00
#define TASK_BLOCKED_STATE 0XFF



//      function prototypes
__attribute__((naked)) void init_sched_stack(uint32_t sched_stack_top);
void init_tasks_stack(void);
__attribute__((naked)) void switch_sp_psp(void);
uint32_t get_psp_value(void);
void update_next_task(void);
void save_psp_value(uint32_t);
void task1_handler(void); //this is task 1
void task2_handler(void); //this is task 2
void task3_handler(void); //this is task 3
void task4_handler(void);
void task5_handler(void);
void idletask(void);
void task_delay(uint32_t tick_count);
__attribute__((naked)) void pendsv_Handler();
void start_scheduler();
void launchScheduler(void);
void create_task(void (*task_handler)(void), uint32_t priority);



//      structure of task
typedef struct {
    uint32_t psp_value;
    uint32_t block_count;
    uint32_t current_state;
    uint32_t priority;         // Task priority
    uint32_t base_priority;    // Base priority (for priority inheritance)
    uint32_t mutexids[5];
    uint32_t seamaphoreids[5];
    uint32_t id;
    void (*task_handler)(void);
} TCB_t;



//      Mutex Control Block
typedef struct osRtxMutex_s {
  uint32_t                          id;  ///< Object Identifier
  uint32_t              reserved_state;  ///< Object State (not used)
  uint32_t                       flags;  ///< Object Flags
  uint32_t                        attr;  ///< Object Attributes
  const char                    *name;  ///< Object Name
  uint32_t                        lock;  ///< Lock counter
  uint32_t                  padding[3];
} osRtxMutex_t;



/// Semaphore Control Block
typedef struct {
  uint32_t                          id;  ///< Object Identifier
  uint32_t              reserved_state;  ///< Object State (not used)
  uint32_t                       flags;  ///< Object Flags
  uint32_t                    reserved;
  const char                    *name;  ///< Object Name
  uint32_t                     tokens;  ///< Current number of tokens
  uint32_t                 max_tokens;  ///< Maximum number of tokens
} osRtxSemaphore_t;



//      user tasks array
TCB_t user_tasks[MAX_TASKS];
